<?php
#-------------------------------------------------------------------------
# Module: Cart Made Simple - An Order Intake module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/cartms/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

// Based upon the status, the orders will be shown. Default the confirmed orders are shown
if (isset($params['orderstatus'])) {
	$orderstatus = $params['orderstatus'];
}
else {
	$orderstatus = 'CNF';
}

$alloweddeletion = $this->CheckPermission('Modify CartMadeSimple');
if (isset($params['submit_massdelete']) ) {
	if (!$alloweddeletion) {
		echo $this->ShowErrors($this->Lang('needpermission', array('Delete Order')));
	}
	else if( isset($params['sel']) && is_array($params['sel']) && count($params['sel']) > 0 ) {
		foreach( $params['sel'] as $order_id ) {
			$this->orders->DeleteOrder( $order_id );
		}
	}
}

// Show for each status the orders by order number, but on invoiced orders eldest at bottom
$orderby = ' ORDER BY order_id';
if ($orderstatus == 'INV') {
	$orderby = ' ORDER BY modified_date DESC';
}

$listorders = array();
$query = 'SELECT * FROM '.cms_db_prefix().'module_cartms_orders, '.cms_db_prefix().'module_feusers_users 
	WHERE customer_id = id and status = ?'
	.$orderby;
$dbresult = $db->Execute($query, array($orderstatus) );

$rowclass = 'row1';
$entryarray = array();

while ($dbresult && $row = $dbresult->FetchRow())
{
	$onerow = new stdClass();

	$onerow->order_id = $this->CreateLink($id, 'ordershowdetail', $returnid, $row['order_id'], array('order_id'=>$row['order_id'], 'orderstatus'=>$orderstatus));
	$onerow->shipmode = $this->CreateLink($id, 'ordershowdetail', $returnid, $row['shipmode'], array('order_id'=>$row['order_id'], 'orderstatus'=>$orderstatus));
	$onerow->customername = $this->CreateLink($id, 'ordershowdetail', $returnid, $row['username'], array('order_id'=>$row['order_id'], 'orderstatus'=>$orderstatus));
	if ($orderstatus == 'INT') {
		$onerow->modificationdate = $row['create_date'];
	} else {
		$onerow->modificationdate = $row['modified_date'];
	}
	// Show the icons needed for editing, deleting
	$onerow->viewlink = $this->CreateLink($id, 'ordershowdetail', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/view.gif', $this->Lang('ordershowdetail'),'','','systemicon'), 
		array('order_id'=>$row['order_id'], 'orderstatus'=>$orderstatus));
	if ( $orderstatus != 'INT' && $orderstatus != 'INV' ) {
		$onerow->switchlink = $this->CreateLink($id, 'switchstatus', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/accept.gif', 
			$this->Lang('statusorderfrom'.$orderstatus),'','','systemicon'), array('oldstatus'=>$orderstatus, 'order_id'=>$row['order_id'], 'active_tab'=>'order'));
	}
	// Only allow deletion on entered and invoiced orders and of course if allowed
	if ( $alloweddeletion ) {
		if ( $orderstatus == 'INT' || $orderstatus == 'INV') {
			$onerow->deletelink = $this->CreateLink($id, 'deleterow', $returnid, 
				$gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), 
				array('table'=>'Orders','order_id'=>$row['order_id'],'orderstatus'=>$orderstatus), $this->Lang('areyousureorder'));
			$onerow->checked = $this->CreateInputCheckbox($id,'sel[]',$row['order_id']);
		}
	}
	if ( $orderstatus == 'INV' ) {
		// Check if the invoice exists
		$create_date = 'I'.substr($row['create_date'],0,4).substr($row['create_date'],5,2)
			.substr($row['create_date'],8,2);
		$invoicepath = cms_join_path($this->config['uploads_path'],$this->getName(), $row['invoiceno'].'.pdf');
		if (file_exists( $invoicepath ) ) {
			// Invoice available, allow to mail it or preview it
			$onerow->extdocsend = $this->CreateLink($id, 'externaldocument', $returnid, 
				'<img src="'.$gCms->config['root_url'].DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.
				$this->GetName().DIRECTORY_SEPARATOR.'images'.DIRECTORY_SEPARATOR.'mail.gif" 
				class="systemicon" alt="'.$this->Lang('sendexternaldocument', 'invoice').
				'" title="'.$this->Lang('sendinvoice').'" />', 
				array('type'=>'invoice_send', 'order_id'=>$row['order_id'], 'orderstatus'=>$orderstatus));
			$thefile = cms_join_path($gCms->config['root_url'],'uploads',$this->GetName(),
				 $row['invoiceno'].'.pdf');
			$theimage = cms_join_path($gCms->config['root_url'],'modules',$this->GetName(),'images','pdf.jpg'); 
			$onerow->extdocpreview = '<a href="'.$thefile.'" target="_blank" /><img src="'.
				$theimage.'" class="systemicon" alt="'.$this->Lang('previewinvoice').
				'" title="'.$this->Lang('previewinvoice').'" /></a>';
			$image = cms_join_path($gCms->config['root_url'],'modules',$this->getName(),'images','pdfprep.gif'); 
			$onerow->extdocprep = $this->CreateLink($id, 'externaldocument', $returnid, 
				'<img src="'.$image.'" class="systemicon" alt="'.$this->Lang('prepareinvoice').
				'" title="'.$this->Lang('prepareinvoice').'" />', 
				array('type'=>'invoice_prep', 'order_id'=>$row['order_id'], 
				'create_date'=>$create_date));
		}
		else {
			// Invoice never generated, have the user generate it
			$onerow->extdocsend = '';
			$onerow->extdocpreview = '';
			$image = cms_join_path($gCms->config['root_url'],'modules',$this->getName(),'images','pdfprep.gif'); 
			$onerow->extdocprep = $this->CreateLink($id, 'externaldocument', $returnid, 
				'<img src="'.$image.'" class="systemicon" alt="'.$this->Lang('prepareinvoice').
				'" title="'.$this->Lang('prepareinvoice').'" />', 
				array('type'=>'invoice_prep', 'order_id'=>$row['order_id'], 
				'create_date'=>$create_date));
		}
	}

	$onerow->rowclass = $rowclass;

	$entryarray[] = $onerow;

	($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
}
$this->smarty->assign_by_ref('orders', $entryarray);

$this->smarty->assign('title_ordercount', $this->Lang('title_ordercountstat'.$orderstatus));
$this->smarty->assign('ordercount', count($entryarray));

// Prepare the links to see the orders per status
$this->smarty->assign('selectINTorderslink', $this->CreateLink($id, 'defaultadmin', $returnid, $this->Lang('showenteredorders'), 
	array('active_tab'=>'order', 'orderstatus'=>'INT'), '', false, false, 'class="pageoptions"'));
$this->smarty->assign('selectCNForderslink', $this->CreateLink($id, 'defaultadmin', $returnid, $this->Lang('showconfirmedorders'), 
	array('active_tab'=>'order', 'orderstatus'=>'CNF'), '', false, false, 'class="pageoptions"'));
$this->smarty->assign('selectPAYorderslink', $this->CreateLink($id, 'defaultadmin', $returnid, $this->Lang('showpaidorders'), 
	array('active_tab'=>'order', 'orderstatus'=>'PAY'), '', false, false, 'class="pageoptions"'));
$this->smarty->assign('selectSHPorderslink', $this->CreateLink($id, 'defaultadmin', $returnid, $this->Lang('showshippedorders'), 
	array('active_tab'=>'order', 'orderstatus'=>'SHP'), '', false, false, 'class="pageoptions"'));
$this->smarty->assign('selectINVorderslink', $this->CreateLink($id, 'defaultadmin', $returnid, $this->Lang('showinvoicedorders'), 
	array('active_tab'=>'order', 'orderstatus'=>'INV'), '', false, false, 'class="pageoptions"'));

$this->smarty->assign('form2start',$this->CreateFormStart($id,'defaultadmin',$returnid));
$this->smarty->assign('form2end',$this->CreateFormEnd());
$this->smarty->assign('ordertext', $this->Lang('title_orders'));
$this->smarty->assign('shipmodetext', $this->Lang('title_shipmode'));
$this->smarty->assign('customernametext', $this->Lang('title_customername'));

// Don't show column header modification date on only entered orders
if ( $orderstatus == 'INT') {
	$this->smarty->assign('moddatetext', $this->Lang('title_creationdate'));
} else {
	$this->smarty->assign('moddatetext', $this->Lang('title_modificationdate'));
}

$this->smarty->assign('orderstatus', $orderstatus);
// Allow deletion for those that are authorized
if ( $alloweddeletion ) {
	if ( $orderstatus == 'INT' || $orderstatus == 'INV') {
		$this->smarty->assign('selecttext', $this->Lang('title_selectallorders'));
		$this->smarty->assign('inputselectall', $this->CreateInputCheckBox($id,"tagall","tagall","","onclick='selectall();'"));
		$this->smarty->assign('submit_massdelete', $this->CreateInputSubmit($id,'submit_massdelete',$this->Lang('deleteselected'),
					     '','',$this->Lang('areyousuredeletemultipleorders')));
	}
}

// Display template
echo $this->ProcessTemplate('listorders.tpl');
?>