<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGRapLeaf (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for interfacing with personalization data available
#  from rapleaf.com
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class cgrapleaf_task
{
  private static $outcolumns = array('email','age','gender','location','state','country','education','occupation','children','household_income','marital_status','home_owner_status');

  protected function __construct() {}

  protected static function process_outline($data,$delimiter = ',')
  {
    if( !is_object($data) ) return;

    $tmp = get_object_vars($data);
    $out = array();
    foreach( self::$outcolumns as $fld )
      {
	$out[$fld] = '';
      }
    foreach( $tmp as $column => $value )
      {
	switch( $column )
	  {
	  case 'location':
	    if( isset($out[$column]) )
	      {
		$out[$column] = $value;
	      }
	    $parts = explode(', ',$value);
	    if( count($parts) >= 2 )
	      {
		$out['state'] = trim($parts[1]);
	      }
	    if( count($parts) >= 3 )
	      {
		$out['country'] = trim($parts[2]);
	      }
	    break;

	  default:
	    if( isset($out[$column]) )
	      {
		$out[$column] = trim($value);
	      }
	    break;
	  }
      }

    $outline = cge_array::implode_quoted($out,$delimiter)."\n";
    return $outline;
  }


  public static function process_task(cgjobmgr_task& $task)
  {
    // setup to process the line.
    $filename = $task->get_persistent_data('input_file');
    $pos = $task->get_persistent_data('filepos',0);
    $linenum = $task->get_persistent_data('linenum',0);
    $column = $task->get_persistent_data('column',0);
    $delimeter = $task->get_persistent_data('delimeter',',');
    $linecount = $task->get_persistent_data('linecount',1);
    $logfile = $task->get_persistent_data('logfile','');
    $outfile = $task->get_persistent_data('output_file','');
    if( !$logfile || !$outfile )
      {
	audit('',get_class(),'logfile or outfile not configured');
	return cgjobmgr_task::STATUS_ERROR;
      }
    
    // validate the data
    if( !file_exists($filename) ) 
    {
      audit('',get_class(),'File not found: '.$filename);
      return cgjobmgr_task::STATUS_ERROR;
    }

    // open the file
    $fh = fopen($filename,'r');
    if( !$fh ) 
    {
      audit('',get_class(),'could not open file: '.$filename);
      return cgjobmgr_task::STATUS_ERROR;
    }

    if( $linenum == 0 )
      {
	// output file headers
	$outline = cge_array::implode_quoted(self::$outcolumns,$delimeter)."\n";
	error_log($outline,3,$outfile);
      }

    // seek to where we left off.
    fseek($fh,$pos);

    $nlines = 0;
    while (!feof($fh) && $nlines < $linecount)
    {
      // get the line
      $line = cge_utils::fgets($fh);

      // update some stats (including current position)
      $newpos = ftell($fh);
      $linenum++;
      $task->set_persistent_data('filepos',$newpos);
      $task->set_persistent_data('linenum',$linenum);
      
      // ignore empty lines.
      if( trim($line) == '' ) continue;
      
      // parse the line.
      $parts = cge_array::smart_explode($line,$delimeter);
      if( !is_array($parts) )
	{
	  audit('',get_class(),'problem parsing file: '.$filename." at line $linenum");
	  return cgjobmgr_task::STATUS_ERROR;
	}
      if( count($parts) < ($column + 1) )
        {
	  audit('',get_class(),'problem parsing line parts: '.$filename." at line $linenum");
	  return cgjobmgr_task::STATUS_ERROR;
	}      
      $email = trim($parts[$column]);
      if( !$email ) 
	{
	  // couldn't get an email address... silently ignore.
	  continue;
	}
      
      // get the data about thsi email address.
      $data = cgrapleaf_request::by_email($email);
      if( !is_object($data) )
	{
	  error_log('Rapleaf data retrieval for '.$email." failed\n",3,$logfile);
	  continue;
	}
      
      // convert into output format.
      $data->email = $email;
      $outline = self::process_outline($data,$delimeter);
      if( $outline )
	{
	  // write it to the output file.
	  error_log($outline,3,$outfile);
	}

      // update some stats.
      $linessout = $task->get_persistent_data('linesout',0);
      $linesout++;
      $task->set_persistent_data('linesout',$linesout);
      $nlines++;
    }

    // we're done... for this round (either we're completely finished, or we've processed enough csv flines)
    if( feof($fh) )
      {
	fclose($fh);
	return cgjobmgr_task::STATUS_COMPLETE;
      }
    else
      {
	fclose($fh);
	return cgjobmgr_task::STATUS_INCOMPLETE;
      }
  }


  public static function notify(cgjobmgr_task& $task)
  {
    $dest_email = $task->get_persistent_data('dest_email');
    $outfile = $task->get_persistent_data('output_file');
    $logfile = $task->get_persistent_data('logput_file');

    if( !$dest_email )
      {
	audit('','cgrapleaf_task','No destination email specified');
	return cgjobmgr_task::STATUS_ERROR;
      }
    $to_addrs = cge_array::smart_explode($dest_email);
    if( !is_array($to_addrs) || count($to_addrs) == 0 )
      {
	audit('','cgrapleaf_task','Could not find a destination email address');
	return cgjobmgr_task::STATUS_ERROR;
      }

    if( !$outfile || !file_exists($outfile) )
      {
	audit('','cgrapleaf_task','Could not find output file');
	return cgjobmgr_task::STATUS_ERROR;
      }
    $outtype = cge_utils::get_mime_type($outfile);

    // prepare our email
    $rapleaf = cms_utils::get_module('CGRapLeaf');
    $cmsmailer = cms_utils::get_module('CMSMailer');
    $cmsmailer->reset();
    $num_to = 0;
    foreach( $to_addrs as $one )
      {
	if( !is_email($one) ) continue;
	$num_to++;
	$cmsmailer->AddAddress($one);
      }
    $cmsmailer->SetSubject($rapleaf->Lang('bulkemail_subject'));
    $cmsmailer->AddAttachment( $outfile, 'rapleaf.csv', 'base64', $outtype );
    if( $logfile && file_exists($logfile) )
      {
	$cmsmailer->AddAttachment( $logfile, 'rapleaf.log', 'base64', cge_utils::get_mime_type($logfile));
      }
    // now the body.
    $body = 'Your CGRapLeaf Job has completed.  The output file(s) are attached to this email';
    $cmsmailer->SetBody($body);
    $cmsmailer->Send();

    audit('','cgrapleaf_task',sprintf('Sent email to %d addresses',count($num_to)));
    return cgjobmgr_task::STATUS_COMPLETE;
  }

} // end of class

#
# EOF
#
?>