<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGRapLeaf (c) 2011 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for interfacing with personalization data available
#  from rapleaf.com
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !$this->CheckPermission('Retrieve Personalization Info') ) exit;

$email = '';
$delimiter = '';
$filename = '';
$column = -1;

$this->SetCurrentTab('bulksubmit');
$email = trim($params['email']);
if( $email == '' || !is_email($email) )
  {
    $this->SetError($this->Lang('error_invalidemail'));
    $this->RedirectToTab($id);
  }
$delimiter = trim($params['delimeter']);
if( $delimiter == '' )
  {
    $this->SetError($this->Lang('error_invalidparam'));
    $this->RedirectToTab($id);
  }
$column = (int)$params['column'];
if( $column < 0 || $column > 1000 )
  {
    $this->SetError($this->Lang('error_invalidparam'));
    $this->RedirectToTab($id);
  }

$uploader = new cg_fileupload($id,TMP_CACHE_LOCATION);
$uploader->set_accepted_filetypes('txt,csv');
$uploader->set_allow_overwrite();
$res = $uploader->handle_upload('file');
if( !$res )
  {
    $err = $uploader->get_error();
    $this->SetError($this->GetUploadErrorMessage($err));
    $this->RedirectToTab($id);
  }

// verify the file format
$infile = cms_join_path(TMP_CACHE_LOCATION,$res);
$outfile = cms_join_path(tempnam(TMP_CACHE_LOCATION,'rapleaf_out'));
$logfile = cms_join_path(tempnam(TMP_CACHE_LOCATION,'rapleaf_log'));


// create the job
$job = new cgjobmgr_job($this->GetName().' bulk submission',get_userid(FALSE));
$task = new cgjobmgr_iterativetask('process email address');
$task->set_function(array('cgrapleaf_task','process_task'));
$task->set_persistent_data('input_file',$infile);
$task->set_persistent_data('output_file',$outfile);
$task->set_persistent_data('logfile',$logfile);
$task->set_persistent_data('column',$column);
$task->set_persistent_data('delimeter',$delimiter);
$job->add_task($task);

$task = new cgjobmgr_simpletask('send result');
$task->set_function(array('cgrapleaf_task','notify'));
$task->set_persistent_data('input_file',$infile);
$task->set_persistent_data('output_file',$outfile);
$task->set_persistent_data('logfile',$logfile);
$task->set_persistent_data('dest_email',$email);
$job->add_task($task);
$job->save();

// display a message
$this->SetMessage($this->Lang('msg_jobsubmitted'));
$this->RedirectToTab($id);

#
# EOF
#
?>