<?php
$lang["friendlyname"] = "Personal Messages";
$lang["moddescription"] = "Provides a personal messages system for the FrontEndUsers module.";
$lang["admindescription"] = "Administer PM for the FrontEndUsers module.";

// GENERAL
$lang["delete"] = "Delete";
$lang["from"] = "From";
$lang["to"] = "To";
$lang["subject"] = "Subject";
$lang["message"] = "Message";
$lang["inbox"] = "Inbox";
$lang["outbox"] = "Outbox";
$lang["newmsg"] = "New message";
$lang["reply"] = "Reply";
$lang["new"] = "New";
$lang["nonew"] = "No new message";
$lang["nomsg"] = "No message.";
$lang["gotoinbox"] = "Go to inbox";
$lang["nbnewmessages"] = "You have %s new messages.";
$lang["quote"] = "%s wrote:";
$lang["re"] = "RE: ";
$lang["nosubject"] = "(no subject)";
$lang["submit"] = "Submit";
$lang["cancel"] = "Cancel";
$lang["date_sent"] = "Sent";
$lang["page_next"] = "&gt;";
$lang["page_previous"] = "&lt;";

// TEMPLATES
$lang["templates"] = "Templates";
$lang["template"] = "Template";
$lang["name"] = "Name";
$lang["sent_tpl"] = "Message sent template";
$lang["inbox_tpl"] = "Inbox/outbox template";
$lang["view_tpl"] = "Message view template";
$lang["sendform_tpl"] = "Send message form template";
$lang["summary_tpl"] = "Default summary template";
$lang["email_tpl"] = "Notification email (body) template";
$lang["defaulttemplates"] = "Default templates";
$lang["templatevars"] = "Template variables";
$lang["edittemplate"] = "Edit template";
$lang["addtemplate"] = "Add template";

// MESSAGES AND ERRORS
$lang["message_deleted"] = "Element deleted";
$lang["message_sent"] = "Message sent.";
$lang["message_modified"] = "Modification saved";
$lang["message_selectgroup"] = "No FEU group selected! Please select below the FEU group for which the personal messages should be enabled.";
$lang["error_missginvalue"] = "One or more necessary values have not been entered.";
$lang["error_notfound"] = "Not found.";
$lang["error_FEUnotfound"] = "The FEU module was not found!";
$lang["error_notsent"] = "The message could not be sent.";
$lang["error_wronguser"] = "The user you have entered either does not exist or does not have personal messages enabled.";
$lang["error_emptymsg"] = "You cannot send an empty message.";

// MODULE INTERACTION
$lang["postinstall"] = "Module version %s installed. Before you can use this module, you must select a FEU group in Users and Groups -&gt; Personal messages.";
$lang["postuninstall"] = "Module uninstalled.";
$lang["really_uninstall"] = "All personal messages will be lost. Continue?";
$lang["help"] = "<h3>What Does This Do?</h3>
				<p>It provides a personal messages system for the FrontEndUsers module.</p>
			<br/><h3>How Do I Use It?</h3>
				<br/><h4>How do I use it?</h4>
					<p>You must first go into Users and Groups -&gt; Personal messages and choose a FEU group for which the PM should be enabled (you can create a new group and add everyone in it).</p>
					<p>Once this is done, you can simply place the following tag in your template:<br/>
					{cms_module module=\"FEmessages\"}</p>
					<p>Provided you are logged in, this will display the PM summary (which typically means: number of new messages and link to the inbox). The logical thing would be to place the tag in the FEU logout template, so that personal messages are with logout and settings link...</p>
					<p>Upon installation, a new stylesheet should have been created. You can attach it to the templates in which the inbox will be displayed to use the default styles.</p>
			<br/><h3>Copyright and License</h3>
				<p>This module has been created by Pierre-Luc Germain and is released under the GNU Public License.</p><br/><br/>";

//EVENTS
$lang["event_femessages_read"] = "Called when a personal message is read for the first time. Params: \"fromid\"=>id of the user who sent the message, \"toid\"=>id of the user who reads it, \"msgid\"=>message id.";
$lang["event_femessages_sent"] = "Called after a personal message is sent. Params: \"fromid\"=>id of the user who sent the message, \"toid\"=>id of the user who reads it, \"msgid\"=>message id.";

//PREFERENCES
$lang["settings"] = "Settings";
$lang["pref_fe_nbperpage"] = "Number of messages per page in the inbox/outbox (0 or empty for no pagination):";
$lang["pref_max_messages"] = "Maximum number of messages allowed in inbox and outbox (after which older messages will be deleted):";
$lang["pref_usercombo"] = "Use a dropdown list to choose recipient (otherwise they'll have to type the username themselves):";
$lang["pref_namefield"] = "User property to be used as the user name (leave empty to use FEU's basic username/email):";
$lang["pref_notifyfield"] = "User property that determines whether the user wish to be notified by mail of new messages (leave empty to disable email notification):";
$lang["pref_emailfield"] = "When email notification is enabled, user property to use as email address (leave empty to use FEU's basic username/email):";
$lang["pref_notifyhtml"] = "Send email notifications in html format (instead of basic text):";
$lang["pref_emailsubject"] = "Template for email notification subject:";
$lang["pref_use_wysiwyg"] = "Activate wysiwyg for personal messages (this must also be activated in the site's global settings):";
$lang["pref_linebreaks"] = "When the wysiwyg is disabled, add line breaks to message display.";
$lang["pref_pmgroup"] = "FEU group for which the personal messages should be enabled.";
$lang["pref_decode_entities"] = "Decode html entities in messages provided through the frontend.";

//PARAMETERS
$lang["phelp_show"] = "What to display... possible values are: summary, inbox, outbox, send.";
$lang["phelp_detailpage"] = "When displaying a summary, this specify the alias or id of the page to which links should point (when you wish to display the inbox on a specific page, for instance).";
$lang["phelp_template"] = "When displaying a summary, this specify the template to use (otherwise the default template is used).";
$lang["phelp_inline"] = "Makes the links inline.";



// TEMPLATE HELP
$lang["templatehelp"] = '<div><h3 style="cursor: pointer;" onclick="tplhelp_displaytoggle(this);">&gt; Smarty variables common to all templates</h3><div class="tplvars_hide"><ul>
<li>$modtitle</li>
<li>$notice_new</li>
<li>$nbnew</li>
<li>$inbox_label</li>
<li>$inbox_link</li>
<li>$inbox_url</li>
<li>$outbox_label</li>
<li>$outbox_link</li>
<li>$outbox_url</li>
<li>$newmsg_label</li>
<li>$newmsg_link</li>
<li>$newmsg_url</li>
</ul><br/><br/></div></div><div><h3 style="cursor: pointer;" onclick="tplhelp_displaytoggle(this);">&gt; Smarty variables for the "message sent" page</h3><div class="tplvars_hide"><ul>
<li>$notification</li>
</ul><br/><br/></div></div><div><h3 style="cursor: pointer;" onclick="tplhelp_displaytoggle(this);">&gt; Smarty variables for inbox/outbox</h3><div class="tplvars_hide"><ul>
<li>$show (inbox/outbox)</li>
<li>$itemcount</li>
<li>$itemlist (array of $item)</li>
<li>$item</li>
</ul><ul>
<li>$item-&gt;fromid</li>
<li>$item-&gt;from_name</li>
<li>$item-&gt;toid</li>
<li>$item-&gt;to_name</li>
<li>$item-&gt;delete_link</li>
<li>$item-&gt;delete_url</li>
<li>$item-&gt;reply_link</li>
<li>$item-&gt;reply_url</li>
<li>$item-&gt;view_link</li>
<li>$item-&gt;view_url</li>
<li>$item-&gt;is_new</li>
<li>$item-&gt;subject</li>
<li>$item-&gt;date_sent</li>
<li>$item-&gt;message</li>
</ul><ul>
<li>$labels-&gt;from</li>
<li>$labels-&gt;to</li>
<li>$labels-&gt;date_sent</li>
<li>$labels-&gt;subject</li>
<li>$labels-&gt;message</li>
<li>$labels-&gt;new</li>
<li>$message_empty</li>
</ul><br/><br/></div></div><div><h3 style="cursor: pointer;" onclick="tplhelp_displaytoggle(this);">&gt; Smarty variables for message view</h3><div class="tplvars_hide"><ul>
<li>$item</li>
<li>$item-&gt;fromid</li>
<li>$item-&gt;from_name</li>
<li>$item-&gt;toid</li>
<li>$item-&gt;to_name</li>
<li>$item-&gt;delete_link</li>
<li>$item-&gt;delete_url</li>
<li>$item-&gt;reply_link</li>
<li>$item-&gt;reply_url</li>
<li>$item-&gt;is_new</li>
<li>$item-&gt;subject</li>
<li>$item-&gt;date_sent</li>
<li>$item-&gt;message</li>
</ul><ul>
<li>$labels-&gt;from</li>
<li>$labels-&gt;to</li>
<li>$labels-&gt;date_sent</li>
<li>$labels-&gt;subject</li>
<li>$labels-&gt;message</li>
<li>$labels-&gt;new</li>
</ul><br/><br/></div></div>
<div><h3 style="cursor: pointer;" onclick="tplhelp_displaytoggle(this);">&gt; Smarty variables for the send form</h3><div class="tplvars_hide">
<ul>
<li>$notification</li>
<li>$formstart</li>
<li>$formend</li>
<li>$to_label</li>
<li>$to_input</li>
<li>$subject_label</li>
<li>$subject_input</li>
<li>$message_label</li>
<li>$message_input</li>
<li>$submit</li>
</ul><br/><br/></div></div>
<div><h3 style="cursor: pointer;" onclick="tplhelp_displaytoggle(this);">&gt; Smarty variables for the "message sent" template</h3><div class="tplvars_hide">
<ul>
<li>$notification</li>
</ul><br/><br/></div></div>
<div><h3 style="cursor: pointer;" onclick="tplhelp_displaytoggle(this);">&gt; Smarty variables for notification email (and email subject)</h3><div class="tplvars_hide">
<ul>
<li>$from_id</li>
<li>$from_name</li>
<li>$to_id</li>
<li>$to_name</li>
<li>$date_sent</li>
<li>$subject</li>
<li>$message</li>
</ul><br/><br/></div></div>';

?>
