<?php
#-------------------------------------------------------------------------
# Module: FEmessages (Frontend Personal Messages)
# by Pierre-Luc Germain
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project"s homepage is: http://www.cmsmadesimple.org
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class FEmessages extends CMSModule
{

	var $userlist = false;
	var $nbnew = array();

	function GetName(){					return "FEmessages";					}
	function GetFriendlyName(){			return $this->Lang("friendlyname");		}
	function GetVersion(){				return "1.2";							}
	function GetHelp(){					return $this->Lang("help");				}
	function GetAuthor(){				return "Pierre-Luc Germain (plger)";	}

	function IsPluginModule(){			return true;	}

	function HasAdmin(){				return true;	}
	function GetAdminSection(){			return "usersgroups";					}
	function GetAdminDescription(){		return $this->Lang("admindescription");	}

	function InstallPostMessage(){		return $this->Lang("postinstall",$this->GetVersion());	}
	function UninstallPostMessage(){	return $this->Lang("postuninstall");	}
	function UninstallPreMessage(){		return $this->Lang("really_uninstall");	}

	function VisibleToAdminUser(){
		return ($this->CheckPermission("messages_admin"));
	}
	
	function GetEventDescription($eventname){
		return $this->Lang("event_".$eventname);
	}

	function Install(){
		global $gCms;
		require "method.install.php";
	}

	function Uninstall(){
		global $gCms;
		require "method.uninstall.php";
	}

	function GetDependencies(){
		return array('FrontEndUsers'=>'1.12.4', 'CMSMailer' => '1.73.3');
		/*	
		 * 	The versions are the oldest tested version... which is to say, I did not bother with testing.
		 *	CMSMailer is optional. If you disable the email notification function, you can remove it.
		 */		
	}
	
	
	/*---------------------------------------------------------
	   SetParameters()
	   This function enables you to create mappings for
	   your module when using "Pretty Urls".
	   
	   Typically, modules create internal links that have
	   big ugly strings along the lines of:
	   index.php?mact=ModName,cntnt01,actionName,0&cntnt01param1=1&cntnt01param2=2&cntnt01returnid=3
	   
	   You might prefer these to look like:
	   /ModuleFunction/2/3
	   
	   To do this, you have to register routes and map
	   your parameters in a way that the API will be able
	   to understand.

	   Also note that any calls to CreateLink will need to
	   be updated to pass the pretty url parameter.
	   
	   Since the Skeleton doesn"t really create any links,
	   the section below is commented out, but you can
	   use it to figure out pretty urls.
	   
	   ---------------------------------------------------------*/
	function SetParameters(){
		$defparams = array("action"=>"default");
		$this->RegisterRoute("/[mM]essages\/(?P<show>[^\/]+)\/(?P<returnid>[0-9]+)$/", $defparams);
		$this->RegisterRoute("/[mM]essages\/(?P<show>inbox|outbox)\/(?P<pageindex>[0-9]+)\/(?P<returnid>[0-9]+)$/", $defparams);
		$this->RegisterRoute("/[mM]essages\/(?P<show>[^\/]+)\/(?P<msgid>[0-9]+)\/(?P<returnid>[0-9]+)$/", $defparams);
		// Any change to the registered routes should also be made in function BuildPrettyUrls below
		
		$this->RestrictUnknownParams();

		$this->CreateParameter("show", "summary", $this->Lang("phelp_show"));
		$this->SetParameterType("show",CLEAN_STRING);
		$this->CreateParameter("detailpage", "", $this->Lang("phelp_detailpage"));
		$this->SetParameterType("detailpage",CLEAN_STRING);
		$this->CreateParameter("template", "", $this->lang("phelp_template"));
		$this->CreateParameter("inline", 0, $this->lang("phelp_inline"));
		$this->SetParameterType("inline",CLEAN_STRING);
		
		$this->SetParameterType("submit",CLEAN_STRING);
		$this->SetParameterType("msgid",CLEAN_INT);
		$this->SetParameterType("to",CLEAN_STRING);
		$this->SetParameterType("subject",CLEAN_STRING);
		$this->SetParameterType("message",CLEAN_STRING);
		$this->SetParameterType("pageindex",CLEAN_INT);
	}


	function getFileContent($filename){
		// returns the content of a file in the templates folder
		$filepath = dirname(__FILE__).DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$filename;
		if(file_exists($filepath)){
			$fhandle = fopen($filepath, 'r');
			$content = fread($fhandle, filesize($filepath));
			fclose($fhandle);
			return $content;
		}else{
			return false;
		}
	}

	function getSettings(){
		// returns preferences
		// array of array(pref_name, pref_type, default_value)
		$settings = array(
			array( "fe_nbperpage", "number", 10 ),
			array( "max_messages", "number", 25 ),
			array( "usercombo", "checkbox", true ),
			array( "decode_entities", "checkbox", false),
			array( "namefield", "text", "" ),
			array( "notifyfield", "text", "" ),
			array( "emailfield", "text", "" ),
			array( "notifyhtml", "checkbox", false ),
			array( "emailsubject", "text", "{sitename}: New personal message" ),
			array( "use_wysiwyg", "checkbox", false),
			array( "linebreaks", "checkbox", true)
		);
		return $settings;
	}

    function getDefaultTemplates(){
    	// returns an array of the templates that are selected as default (just so that we don't delete them)
	   $tplnames = array('inbox','view','sendform','sent','summary','email');
	   $result = array();
	   foreach($tplnames as $onetpl)	$result[$onetpl] = $this->GetPreference($onetpl.'_tpl');
	   return $result;
    }

	function BuildPrettyUrls($params, $returnid=-1){
		// transforms given params into a pretty url
		$prettyurl = "messages/".$params["show"]."/";
		if(isset($params["msgid"])){
			$prettyurl .= $params["msgid"]."/";
		}elseif(isset($params["pageindex"])){
			$prettyurl .= $params["pageindex"]."/";
		}
		$prettyurl .= $returnid;
		return $prettyurl;
	}

	function DoAction($action, $id, $params, $returnid=-1){
		global $gCms;
		
		switch($action){
			case "defaultadmin":
				require "action.defaultadmin.php";
				break;
			case "changedeftemplates":
				foreach($params as $key=>$value){
				    if($key != "submit")	   $this->SetPreference($key, $value);
				}
				$this->Redirect($id, "defaultadmin", $returnid, array("active_tab"=>"templates", "module_message"=>$this->Lang("message_modified")));
				break;
			case "editTemplate":
				require "action.editTemplate.php";
				break;
			case "deletetpl":
				$newparams = array("active_tab"=>"templates");
				$deftemplates = $this->getDefaultTemplates();
			    if(isset($params["tplname"]) && !in_array($params["tplname"], $deftemplates)){
				    if($this->DeleteTemplate($params["tplname"]))	   $newparams["module_message>"] = $this->Lang("message_modified");
				}
				$this->Redirect($id, "defaultadmin", $returnid, $newparams);
				break;
			case "default":
			default:
				// all frontend action go through here	
				$FEU = $this->GetModuleInstance('FrontEndUsers');
				if(!$FEU){
					echo $this->Lang('error_FEUnotfound');
					return false;
				}
				$groupid = $this->GetPreference('pmgroup',false);
				if(!$groupid)	return false;
				$inline = (isset($params['inline']) && $params['inline']);
				if($FEU->LoggedIn()){
					$userid = $FEU->LoggedInId();
					if($FEU->MemberOfGroup($userid, $groupid)){
						$db = $this->GetDb();
						$show = isset($params['show'])?$params['show']:'summary';
						if($show == 'view' && !isset($params['msgid']))	$show = 'inbox';
						switch($show){
							case 'view':
								require 'action.fe_view.php';
								break;
							case 'reply':
							case 'send':
								require 'action.fe_send.php';
								break;
							case 'delete':
								require 'action.fe_delete.php';
							case 'outbox':
							case 'inbox':
								require 'action.fe_inbox.php';
								break;
							case 'summary':
							default:
								$linkreturnid = (isset($params['detailpage']))?$this->get_pageid($params['detailpage']):$returnid;
								$this->assign_basics($userid, $id, $linkreturnid, $inline);
								if(isset($params['template']) && $template = $this->GetTemplate($params['template'])){
									echo $this->ProcessTemplateFromData($template);
								}else{
									echo $this->ProcessTemplateFromDatabase($this->GetPreference('summary_tpl'));
								}
								break;
						}
					}
				}
				break;			
				
		} // end switch($action)


	}

	function get_pageid($alias){
		// returns the page id from an alias
		// this is used for the detailpage parameter
		global $gCms;
		$manager =& $gCms->GetHierarchyManager();
		$node =& $manager->sureGetNodeByAlias($alias);
		if (isset($node)) {
			$content =& $node->GetContent();	
			if (isset($content))	return $content->Id();
		}else{
			$node =& $manager->sureGetNodeById($alias);
			if (isset($node)) return $alias;
		}
	}

	function getGroupsCombo(){
		// returns the list (groupname => groupid) of FEU groups
		// this is used to make the dropdown in settings
		$FEU = $this->GetModuleInstance('FrontEndUsers');
		$groups = array();
		if($FEU)	$groups = $FEU->GetGroupList();
		return $groups;
	}
	
	function get_userlist(){
		// returns the list (userid => username) of users within the pm-group
		if($this->userlist)	return $this->userlist;
		$FEU = $this->GetModuleInstance('FrontEndUsers');
		$groupid = $this->GetPreference("pmgroup",false);
		$namefield = strtolower($this->GetPreference("namefield",""));
		if(!$FEU || !$groupid){
			$this->userlist = array();
		}else{
			$users = array();
			if($namefield == ""){
				foreach($FEU->GetUsersInGroup($groupid) as $user){
					$users[$user['id']] = $user['username'];
				}
			}else{
				foreach($FEU->GetFullUsersInGroup($groupid) as $user){
					$username = $user['username'];
					foreach($user['props'] as $pname=>$pvalue){
						if(strtolower($pname) == $namefield)	$username = $pvalue;
					}
					$users[$user['id']] = $username;
				}
			}
			asort($users);
			$this->userlist = $users;
		}
		return $this->userlist;
	}
	
	function get_nbnew($userid){
		// returns the number of new/unread messages for the user
		$nbnew = 0;
		if(isset($this->nbnew[$userid])){
			$nbnew = $this->nbnew[$userid];
		}else{
			$db = $this->GetDb();
			$query = "SELECT count(msgid) nbnew FROM ".cms_db_prefix()."module_femessages WHERE toid=? AND inbox_deleted=0 AND `read`=0";
			$dbresult = $db->Execute($query,array($userid));
			if($dbresult && $row = $dbresult->FetchRow()){
				$nbnew = $row["nbnew"];
				$this->nbnew[$userid] = $nbnew;
			}
		}
		return $nbnew;
	}

	function paginate($nbperpage,$total,$params,$id,$returnid){
		// for frontend usage
		// this assigns the different parts of the page menu
		
		if($nbperpage == 0 || $nbperpage >= $total){
			// we're not using pagination
			$this->smarty->assign(array("page_showing"=>false,"page_totalitems"=>false,"page_next"=>false,"page_previous"=>false));
			return false;
		}
		
		if(!isset($params["show"]) || $params["show"] == "delete")	$params["show"] = "inbox";
		
		// we're using pagination
		$curpage = isset($params["pageindex"])?$params["pageindex"]:1;
		$nbpages = ceil($total/$nbperpage);
		$showing = ((($curpage -1) * $nbperpage) + 1);
		$tmpend = $showing + $nbperpage - 1;
		if($tmpend > $total)	$tmpend = $total;
		if($tmpend != $showing)	$showing .= "-".$tmpend;
		$this->smarty->assign("page_showing",$showing);

		$newparams = $params;
		$previouslink = false;
		$nextlink = false;
		if($curpage > 1){
			// we create the link to the previous page
			$newparams["pageindex"] = $curpage - 1;
			$previouslink = $this->CreateLink($id, "default", $returnid, $this->Lang("page_previous"), $newparams, "", false, true, " class=\"previouslink\"", false, $this->BuildPrettyUrls($newparams, $returnid));
		}
		if($curpage < $nbpages){
			// we create the link to the next page
			$newparams["pageindex"] = $curpage + 1;
			$nextlink = $this->CreateLink($id, "default", $returnid, $this->Lang("page_next"), $newparams, "", false, true, " class=\"nextlink\"", false, $this->BuildPrettyUrls($newparams, $returnid));
		}
		$this->smarty->assign("page_next",$nextlink);
		$this->smarty->assign("page_previous",$previouslink);	
	}
	
	
	function assign_basics($userid, $id, $returnid, $inline=true){
		// basic smarty variables for all frontend actions
		$nbnew = $this->get_nbnew($userid);
		$this->smarty->assign("nbnew",$nbnew);
		$this->smarty->assign("notice_new", $nbnew>0?$this->Lang("nbnewmessages",$nbnew):$this->Lang("nonew"));
		
		$this->smarty->assign("modtitle",$this->Lang("friendlyname"));
		
		$this->smarty->assign("inbox_label", $this->Lang("inbox"));
		$newparams = array("show"=>"inbox");
		$prettyurl = $this->BuildPrettyUrls($newparams, $returnid);
		$this->smarty->assign("inbox_link",$this->CreateLink($id, "default", $returnid, $this->Lang("inbox"), $newparams, "", false, $inline, "", false, $prettyurl));
		$this->smarty->assign("inbox_url",$this->CreateLink($id, "default", $returnid, "", $newparams, "", true, $inline, "", false, $prettyurl));

		$this->smarty->assign("outbox_label", $this->Lang("outbox"));
		$newparams = array("show"=>"outbox");
		$prettyurl = $this->BuildPrettyUrls($newparams, $returnid);
		$this->smarty->assign("outbox_link",$this->CreateLink($id, "default", $returnid, $this->Lang("outbox"), $newparams, "", false, $inline, "", false, $prettyurl));
		$this->smarty->assign("outbox_url",$this->CreateLink($id, "default", $returnid, "", $newparams, "", true, $inline, "", false, $prettyurl));

		$this->smarty->assign("newmsg_label", $this->Lang("newmsg"));
		$newparams = array("show"=>"send");
		$prettyurl = $this->BuildPrettyUrls($newparams, $returnid);
		$this->smarty->assign("newmsg_link",$this->CreateLink($id, "default", $returnid, $this->Lang("newmsg"), $newparams, "", false, $inline, "", false, $prettyurl));
		$this->smarty->assign("newmsg_url",$this->CreateLink($id, "default", $returnid, "", $newparams, "", true, $inline, "", false, $prettyurl));		
	}
	
	function user_clean($userid){
		// checks whether a user has more than the allowed amount of messages in his inbox/outbox
		// and deletes the older messages if there are too many
		$max_msg = $this->GetPreference("max_messages",20);
		if(!$max_msg || $max_msg == 0)	return false;
		$db = $this->GetDb();
		$query = "SELECT count(msgid) thecount FROM ".cms_db_prefix()."module_femessages WHERE (toid=? AND inbox_deleted=0) OR (fromid=? AND outbox_deleted=0)";
		$dbresult = $db->Execute($query,array($userid,$userid));
		if($dbresult && $row = $dbresult->FetchRow()){
			if($row["thecount"] > $max_msg){
				$query = "SELECT msgid, toid, fromid, outbox_deleted, inbox_deleted FROM ".cms_db_prefix()."module_femessages WHERE ";
				$query .= "(toid=? AND inbox_deleted=0) OR (fromid=? AND outbox_deleted=0) ORDER BY date_sent ASC LIMIT ".($row["thecount"] - $max_msg);
				$res = $db->Execute($query, array($userid,$userid));
				while($res && $row = $res->FetchRow()){
					// we delete the messages
					if($row["toid"] == $userid){
						$change = $row["outbox_deleted"]?false:"inbox";
					}elseif($row["fromid"] == $userid){
						$change = $row["inbox_deleted"]?false:"outbox";
					}
					if($change){
						$query = "UPDATE ".cms_db_prefix()."module_femessages SET ".$change."_deleted=1 WHERE msgid=? LIMIT 1";
					}else{
						$query = "DELETE FROM ".cms_db_prefix()."module_femessages WHERE msgid=? LIMIT 1";
					}
					$db->Execute($query,array($row["msgid"]));
				}
			}
		}
	}
	
	function do_notification($userid, $fromid, $subject, $message, $date_sent){
		// if the user has notification enabled, email the user to notify of new PM
		$field = $this->GetPreference("notifyfield","");
		if($field == "")	return false;
		
		$FEU = $this->GetModuleInstance('FrontEndUsers');
		$cmsmailer = $this->GetModuleInstance('CMSMailer');
		if(!$FEU || !$cmsmailer)	return false;
		
		$emailfield = $this->GetPreference("emailfield","");
		$name_field = $this->GetPreference("namefield","");
		
		$props = $FEU->GetUserProperties($userid);
		$notify = false;
		$email = false;
		foreach($props as $oneprop){
			if(strtolower($oneprop['title'])==strtolower($field) && $oneprop['data'] != "" && $oneprop['data'])	$notify = true;
			if(strtolower($oneprop['title'])==strtolower($emailfield) && $FEU->IsValidEmailAddress($oneprop['data']))	$email = $oneprop['data'];
		}
		if(!$notify)	return false;
		
		// we do send a notification
		
		if(!$email)	$email = $FEU->GetEmail($userid);
		$cmsmailer->AddAddress($email);
		$cmsmailer->IsHTML($this->GetPreference("notifyhtml",false));
		
		$userlist = $this->get_userlist();
		$from_name = isset($userlist[$fromid])?$userlist[$fromid]:"?";
		$to_name = isset($userlist[$userid])?$userlist[$userid]:"?";
		$this->smarty->assign("to_id", $userid);
		$this->smarty->assign("to_name", $to_name);
		$this->smarty->assign("from_id", $fromid);
		$this->smarty->assign("from_name", $from_name);
		$this->smarty->assign("subject", $subject);
		$this->smarty->assign("message", $message);
		$this->smarty->assign("date_sent", $date_sent);
		
		$mailsubject = $this->GetPreference("emailsubject","");
		$mailsubject = $this->ProcessTemplateFromData($mailsubject);
		$cmsmailer->SetSubject($mailsubject);
		
		$body = $this->ProcessTemplateFromDatabase($this->GetPreference("email_tpl",""));
		$cmsmailer->SetBody($body);
		
		$cmsmailer->Send();
	}

}

?>
