<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: AuthNetAim (c) 2009 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide the ability to process
#  Payments made using the E-commerce suite through the AuthNet payment
#  gateway.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

// restore state information
if( !isset($params['key']) ) exit; 
$res = $this->RestoreState(trim($params['key']));
if( $res === FALSE )
  {
    $this->SetError($this->Lang('error_restoring_state'));
    $this->FinishTransaction();
    return;
  }


// check for missing data
$test = 0;
if( !isset($this->_data['ccinfo']) ||
    !isset($this->_data['destination']) ||
    !isset($this->_data['items']) ||
    !isset($this->_data['orderid']) ||
    !isset($this->_data['invoice']) )
  {
    $this->SetError($this->Lang('error_missing_data'));
    $this->FinishTransaction();
    return;
  }

$billing = $this->_data['billing_address'];
$shipping = $this->_data['shipping_address'];
if( !is_object($billing) || !is_object($shipping) )
  {
    $this->SetError($this->Lang('error_missing_data'));
    $this->FinishTransaction();
    return;
  }

//  
// setup
//
$feu =& $this->GetModuleInstance('FrontEndUsers');
$loginid = $this->GetPreference('loginid');
$transactionkey = $this->GetPreference('transactionkey');
$testmode = $this->GetPreference('testmode',1);
if( $testmode && check_login(FALSE) )
  {
    $testmode = 'TRUE';
  }
else
  {
    $testmode = 'FALSE';
  }

$now = time();
$fingerprint = $params['key'];
$post_url = $this->GetPreference('post_url','');
if( !$post_url )
  $post_url = AUTHNETAIM_SECURE_POST_URL;

if( $this->GetPreference('usetesturl') )
  {
    $post_url = $this->GetPreference('test_post_url','');
    if( !$post_url )
      $post_url = AUTHNETAIM_TEST_POST_URL;
  }

//
// build our data
//

// a) calculate total amount of order
if( isset($this->_data['ordertax']) && isset($this->_data['ordershipping']) )
  $amount = $this->_data['ordertax'] + $this->_data['ordershipping'];

foreach( $this->_data['items'] as $item )
{
  $amount += $item['amount']*$item['quantity'];
}

// b) fill in the parameters array
$parms = array();
$parms['x_first_name'] = $billing->get_firstname();
$parms['x_last_name'] = $billing->get_lastname();
$parms['x_email'] = $billing->get_email();
$parms['x_address'] =  $billing->get_address1();
$parms['x_city'] = $billing->get_city();
$parms['x_state'] = $billing->get_state();
$parms['x_country'] = $billing->get_country();
$parms['x_zip'] = $billing->get_postal();

$parms['x_ship_to_first_name'] = $shipping->get_firstname();
$parms['x_ship_to_last_name'] = $shipping->get_lastname();
$parms['x_ship_to_address'] =  $shipping->get_address1();
$parms['x_ship_to_city'] = $shipping->get_city();
$parms['x_ship_to_state'] = $shipping->get_state();
$parms['x_ship_to_country'] = $shipping->get_country();
$parms['x_ship_to_zip'] = $shipping->get_postal();

$parms['transaction_code'] = $fingerprint;
$parms['x_version'] = '3.1';
$parms['x_test_request'] = $testmode;
$parms['x_delim_data'] = "TRUE";
$parms['x_delim_char'] = '|';
$parms['x_relay_response'] = 'FALSE';
$parms['x_login'] = $loginid;
$parms['x_tran_key'] = $transactionkey;
$parms['x_type'] = 'AUTH_CAPTURE';  // todo
$parms['x_method'] = 'CC'; // todo
$parms['x_duplicate_window'] = 30*60; // todo
$parms['x_cust_id'] = $feu->LoggedInId();
$parms['x_invoice_num'] = $this->_data['invoice'];
$parms['x_amount'] = $amount;
if( isset($this->_data['description']) )
  {
    $parms['x_description'] = $this->_data['description'];
  }

// add credit card info
foreach( $this->_data['ccinfo'] as $key => $value )
{
  $parms[$key] = $value;
}

// maybe add billing info

// and maybe shipping info

// build our output post string
$post_string = '';
foreach( $parms as $key => $value )
{
  $value = urlencode($value);
  $post_string .= "{$key}={$value}&";
}

// get the items
$items = array();
$count = 1;
$has_negative = false;
foreach( $this->_data['items'] as $name => $data )
{
  if( $data['amount'] < 0.00 )
    {
      $has_negative = true;
      break;
    }
}
if( $has_negative )
  {
    // there's at least one negative amount
    // so munge everything together in one line item.
    $count = 1;
    $this->_data['items'] = array();
    $desc = trim($this->_data['description']);
    if( !$desc )
      {
	$desc = get_site_preference('sitename','CMSMS Site');
      }
    $this->_data['items'][$desc] = array('name'=>$desc,'quantity'=>1,'amount'=>$amount,'tax'=>0);
  }

foreach( $this->_data['items'] as $key => $item )
{
  $tmp = array($count++,substr($item['name'],0,31),$item['name'],
	       $item['quantity'],sprintf("%.2f",$item['amount']),
	       (isset($item['tax']))?'1':'0');
  $str = urlencode(implode('<|>',$tmp));
  $post_string .= "x_line_item={$str}&";
}
$post_string = rtrim($post_string,"& ");


//
// do our post
//
//$post_response = $this->http_post($post_url,$post_string);
$request = curl_init($post_url); // initiate curl object
curl_setopt($request, CURLOPT_HEADER, 0); // set to 0 to eliminate header info from response
curl_setopt($request, CURLOPT_RETURNTRANSFER, 1); // Returns response data instead of TRUE(1)
curl_setopt($request, CURLOPT_POSTFIELDS, $post_string); // use HTTP POST to send form data
curl_setopt($request, CURLOPT_SSL_VERIFYPEER, FALSE); // uncomment this line if you get no gateway response.
$post_response = curl_exec($request); // execute curl post and store results in $post_response
curl_close ($request); // close curl object

// get the results
$response_array = explode($parms["x_delim_char"],$post_response);
$this->_data['response_data'] = $response_array;

// following information taken from:  http://developer.authorize.net/guides/AIM/
// parse result information
$trans_response_code    = $response_array[0];
$trans_response_subcode = $response_array[1];
$trans_response_reason  = $response_array[2];
$trans_response_text    = $response_array[3];
$trans_auth_code        = $response_array[4];
$trans_avs_response     = $response_array[5];
$trans_transaction_id   = $response_array[6];
$trans_invoice_num      = $response_array[7];
$trans_amount           = $response_array[9];
$trans_cust_id          = $response_array[12];
$trans_ccv_response     = $response_array[38];

// handle the results.
switch($trans_response_code)
  {
  case '1':
    $this->SetTransactionStatus(PAYMENT_STATUS_APPROVED);
    $this->SetTransactionId($trans_transaction_id);
    $this->SetTransactionAmount($trans_amount);
    break;
  case '2':
    $this->SetDeclined();
    break;
  case '3':
    // english only atm.
    $this->SetError($trans_response_text.' ('.$trans_response_reason.')');
    break;
  case '4':
    $this->SetError($this->Lang('error_held_for_review'));
    break;
  default:
    $this->SetError($this->Lang('error_unknown_data'));
    break;
  }
$this->FinishTransaction();

#
# EOF
#
?>
