<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: AuthNetAim (c) 2009 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide the ability to process
#  Payments made using the E-commerce suite through the AuthNet payment
#  gateway.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

$cgpaymentgatewaybase = cms_join_path($gCms->config['root_path'],'modules',
	'CGPaymentGatewayBase','CGPaymentGatewayBase.module.php');
if( !is_readable( $cgpaymentgatewaybase ) )
{
	echo '<h1><font color="red">ERROR: The CGPaymentGatewayBase module could not be found.  Please install it</font></h1>';
	return;
}
if( !class_exists('CGPaymentGatewayBase') )
{
  require_once($cgpaymentgatewaybase);
}


define('AUTHNETAIM_SECURE_POST_URL','https://secure.authorize.net/gateway/transact.dll');
define('AUTHNETAIM_TEST_POST_URL','https://test.authorize.net/gateway/transact.dll');

class AuthNetAim extends CGPaymentGatewayBase
{

  protected $_data;

  /*---------------------------------------------------------
   Constructor()
   ---------------------------------------------------------*/
  public function __construct()
  {
    parent::__construct();
    $this->_data = array();
  }


  /*---------------------------------------------------------
   GetName()
   ---------------------------------------------------------*/
  public function GetName()
  {
    return get_class();
  }

  
  /*---------------------------------------------------------
   GetFriendlyName()
   ---------------------------------------------------------*/
  public function GetFriendlyName()
  {
    return $this->Lang('friendlyname');
  }


  /*---------------------------------------------------------
   GetVersion()
   ---------------------------------------------------------*/
  public function GetVersion()
  {
    return '1.2.6';
  }


  /*---------------------------------------------------------
   GetHelp()
   ---------------------------------------------------------*/
  public function GetHelp()
  {
    return $this->Lang('help');
  }


  /*---------------------------------------------------------
   GetAuthor()
   ---------------------------------------------------------*/
  public function GetAuthor()
  {
    return 'Robert Campbell';
  }


  /*---------------------------------------------------------
   GetAuthorEmail()
   ---------------------------------------------------------*/
  public function GetAuthorEmail()
  {
    return 'calguy1000@cmsmadesimple.org';
  }


  /*---------------------------------------------------------
   GetChangeLog()
   ---------------------------------------------------------*/
  public function GetChangeLog()
  {
    return @file_get_contents(dirname(__FILE__).'/changelog.inc');
  }


  /*---------------------------------------------------------
   IsPluginModule()
   ---------------------------------------------------------*/
  public function IsPluginModule()
  {
    return true;
  }


  /*---------------------------------------------------------
   HasAdmin()
   ---------------------------------------------------------*/
  public function HasAdmin()
  {
    return true;
  }


  /*---------------------------------------------------------
   GetAdminSection()
   ---------------------------------------------------------*/
  public function GetAdminSection()
  {
    global $CMS_VERSION;
    if( version_compare($CMS_VERSION,'1.8','<') ) return 'extensions';
    return 'ecommerce';
  }


  /*---------------------------------------------------------
   GetAdminDescription()
   ---------------------------------------------------------*/
  public function GetAdminDescription()
  {
    return $this->Lang('moddescription');
  }


  /*---------------------------------------------------------
   VisibleToAdminUser()
   ---------------------------------------------------------*/
  public function VisibleToAdminUser()
  {
    return $this->CheckPermission('Modify Templates') ||
      $this->CheckPermission('Modify Site Preferences');
  }


  /*---------------------------------------------------------
   GetDependencies()
   ---------------------------------------------------------*/
  public function GetDependencies()
  {
    return array('CGPaymentGatewayBase'=>'1.0.5',
		 'CGExtensions'=>'1.18.3');
  }


  /*---------------------------------------------------------
   MinimumCMSVersion()
   ---------------------------------------------------------*/
  public function MinimumCMSVersion()
  {
    return "1.8.2";
  }


  /*---------------------------------------------------------
   InstallPostMessage()
   ---------------------------------------------------------*/
  public function InstallPostMessage()
  {
    return $this->Lang('postinstall');
  }


  /*---------------------------------------------------------
   UninstallPostMessage()
   ---------------------------------------------------------*/
  public function UninstallPostMessage()
  {
    return $this->Lang('postuninstall');
  }


  /*---------------------------------------------------------
   UninstallPreMessage()
   ---------------------------------------------------------*/
  public function UninstallPreMessage()
  {
    return $this->Lang('really_uninstall');
  }

	
  /*---------------------------------------------------------
   RequiresCreditCardInfo()
   ---------------------------------------------------------*/
  public function RequiresCreditCardInfo()
  {
    return true;
  }


  /*---------------------------------------------------------
   RequiresSSL()
   ---------------------------------------------------------*/
  public function RequiresSSL()
  {
    return true;
  }


  /*---------------------------------------------------------
   RequiresShippingInfo()
   ---------------------------------------------------------*/
  public function RequiresShippingInfo()
  {
    return false;
  }


  /*---------------------------------------------------------
   RequiresBillingInfo()
   ---------------------------------------------------------*/
  public function RequiresBillingInfo()
  {
    return false;
  }


  /*---------------------------------------------------------
   SetParameters()
   ---------------------------------------------------------*/
  public function SetParameters()
  {
    $this->RegisterModulePlugin();
    $this->RestrictUnknownParams();

    $this->SetParameterType('key', CLEAN_STRING);
    $this->SetParameterType('order_id', CLEAN_INT);
  }


  /*---------------------------------------------------------
   SaveState()
   ---------------------------------------------------------*/
  public function SaveState($encrypt = false,$key = '')
  {
    if( $encrypt )
      {
	if( !$key ) $key = str_shuffle(md5(session_id().time()));
	$raw = serialize($this->_data);
	$enc = $this->encrypt($key,$raw);
	$_SESSION['authnetaim'] = base64_encode($enc);
	return $key;
      }
    else
      {
	$raw = serialize($this->_data);
	$_SESSION['authnetaim'] = base64_encode($raw);
      }
  }


  /*---------------------------------------------------------
   RestoreState()
   ---------------------------------------------------------*/
  public function RestoreState($key = '')
  {
    if( !isset($_SESSION['authnetaim']) ) return FALSE;
    if( empty($key) )
      {
	$raw = base64_decode($_SESSION['authnetaim']);
      }
    else
      {
	$enc = base64_decode($_SESSION['authnetaim']);
	$raw = $this->decrypt($key,$enc);
	if( $raw === FALSE ) return FALSE;
      }
    $this->_data = unserialize($raw);
    unset($_SESSION['authnetaim']);
    return TRUE;
  }


  /*---------------------------------------------------------
   SetPaymentId()
   ---------------------------------------------------------*/
  public function SetPaymentId($payment_id)
  {
    $this->_data['payment_id'] = $payment_id;
  }


  /*---------------------------------------------------------
   GetPaymentId()
   ---------------------------------------------------------*/
  public function GetPaymentId()
  {
    if( !isset($this->_data['payment_id']) ) return FALSE;
    return $this->_data['payment_id'];
  }


  /*---------------------------------------------------------
   SetCreditCardInfo()
   ---------------------------------------------------------*/
  public function SetCreditCardInfo($ccnumber,$ccexp,$ccvcode)
  {
    $_ccinfo = array();
    $_ccinfo['x_card_num'] = preg_replace('([^0-9])','',$ccnumber);
    $_ccinfo['x_exp_date'] = date('m',$ccexp).'/'.date('Y',$ccexp);
    if( !empty($ccvcode) )
      {
	$_ccinfo['x_card_code'] = preg_replace('([^0-9])','',$ccvcode);
      }
    $this->_data['ccinfo'] = $_ccinfo;
  }


  /*---------------------------------------------------------
   SetCurrencyCode()
   ---------------------------------------------------------*/
  public function SetCurrencyCode($code = 'USD')
  {
    $this->_data['currencycode'] = strtoupper($code);
  }


  /*---------------------------------------------------------
   SetWeightUnits()
   ---------------------------------------------------------*/
  public function SetWeightUnits($units = 'lbs')
  {
    $this->_data['weightunits'] = $units;
  }


  /*---------------------------------------------------------
   SetDestination()
   ---------------------------------------------------------*/
  public function SetDestination($url)
  {
    $this->_data['destination'] = $url;
  }
    

  /*---------------------------------------------------------
   AddItem()
   ---------------------------------------------------------*/
  public function AddItem($name,$number,$quantity,$weight,$amount,$tax = '')
  {
    $name = strip_tags($name);
    $name = preg_replace('/\&.*\;\"\'\/','',$name);
    $name = trim($name);

    if( !isset($this->_data['items']) )
      {
	$this->_data['items'] = array();
      }

    $num = 1;
    $tmp = $name;
    while( isset($this->_data['items'][$tmp]) && ($num < 100) )
      {
	$num = (int)$num + 1;
	$tmp = $name . $num;
      }
    $this->_data['items'][$tmp] = 
      array('name'=>$name,
	    'number'=>$number,
	    'quantity'=>$quantity,
	    'weight'=>$weight,
	    'amount'=>$amount);
    if(!empty($tax))
      {
	$this->_data['items'][$tmp]['tax'] = $tax;
      }
  }


  /*---------------------------------------------------------
   SetOrderDescription()
   ---------------------------------------------------------*/
  public function SetOrderDescription($txt)
  {
    $this->_data['description'] = substr($txt,0,255);
  }


  /*---------------------------------------------------------
   SetOrderTaxAmount()
   ---------------------------------------------------------*/
  public function SetOrderTaxAmount($tax)
  {
    $this->_data['ordertax'] = $tax;
  }


  /*---------------------------------------------------------
   SetOrderShipping()
   ---------------------------------------------------------*/
  public function SetOrderShipping($shipping)
  {
    $this->_data['ordershipping'] = $shipping;
  }



  /*---------------------------------------------------------
   SetInvoice()
   ---------------------------------------------------------*/
  public function SetInvoice($invoice)
  {
    $len = min(strlen($invoice),20)*-1;
    $this->_data['invoice'] = substr($invoice,$len);
  }


  /*---------------------------------------------------------
   SetOrderID()
   ---------------------------------------------------------*/
  public function SetOrderID($orderid)
  {
    $this->_data['orderid'] = $orderid;
  }


  /*---------------------------------------------------------
   GetOrderID()
   ---------------------------------------------------------*/
  public function GetOrderID()
  {
    if( isset($this->_data['orderid']) )
      return $this->_data['orderid'];
  }


  /*---------------------------------------------------------
   SetTransactionId()
   ---------------------------------------------------------*/
  public function SetTransactionId($tid)
  {
    $this->_data['transaction_id'] = $tid;
  }


  /*---------------------------------------------------------
   SetTransactionStatus()
   ---------------------------------------------------------*/
  public function SetTransactionStatus($status)
  {
    $this->_data['status'] = $status;
  }


  /*---------------------------------------------------------
   SetTransactionAmount()
   ---------------------------------------------------------*/
  public function SetTransactionAmount($tid)
  {
    $this->_data['amount'] = $tid;
  }


  /*---------------------------------------------------------
   SetError()
   ---------------------------------------------------------*/
  public function SetError($message)
  {
    $this->_data['status'] = PAYMENT_STATUS_ERROR;
    $this->_data['error_message'] = $message;
  }


  /*---------------------------------------------------------
   SetCancelled()
   ---------------------------------------------------------*/
  public function SetCancelled($message)
  {
    $this->_data['status'] = PAYMENT_STATUS_CANCELLED;
  }


  /*---------------------------------------------------------
   Reset()
   ---------------------------------------------------------*/
  public function Reset()
  {
    $this->_data = array();
  }


  /*---------------------------------------------------------
   SetDeclined()
   ---------------------------------------------------------*/
  public function SetDeclined($message)
  {
    $this->_data['status'] = PAYMENT_STATUS_DECLINED;
    $this->_data['error_message'] = $this->Lang('error_payment_declined');
  }


  /*---------------------------------------------------------
   GetTransactionStatus()
   ---------------------------------------------------------*/
  public function GetTransactionStatus()
  {
    if( isset($this->_data['status']) )
      return $this->_data['status'];
    return FALSE;
  }


  /*---------------------------------------------------------
   GetTransactionId()
   ---------------------------------------------------------*/
  public function GetTransactionId()
  {
    if( isset($this->_data['transaction_id']) )
      return $this->_data['transaction_id'];
    return FALSE;
  }


  /*---------------------------------------------------------
   GetTransactionAmount()
   ---------------------------------------------------------*/
  public function GetTransactionAmount()
  {
    if( isset($this->_data['amount']) )
      return $this->_data['amount'];
    return FALSE;
  }


  /*---------------------------------------------------------
   GetMessage()
   ---------------------------------------------------------*/
  public function GetMessage()
  {
    if( isset($this->_data['error_message']) )
      return $this->_data['error_message'];
    return FALSE;
  }


  /*---------------------------------------------------------
   FinishTransaction()
   ---------------------------------------------------------*/
  public function FinishTransaction()
  {
    if( !isset($this->_data['destination']) ) return FALSE;
    $key = $this->SaveState();
    $url = $this->_data['destination'];
    $url = html_entity_decode($url);
    $url .= "&cntnt01datakey=$key";
    redirect($url);
  }


  /*---------------------------------------------------------
   CheckInfo()
   ---------------------------------------------------------*/
  public function CheckInfo()
  {
    // TODO: fill this in.
    return TRUE;
  }


  /*---------------------------------------------------------
   GetForm()
   ---------------------------------------------------------*/
  public function GetForm($returnid)
  {
    if( !$this->CheckInfo() ) return FALSE;
    $loginid = $this->GetPreference('loginid');
    $transactionkey = $this->GetPreference('transactionkey');
    if( empty($loginid) || empty($transactionkey) )
      {
	return $this->DisplayErrorMessage($this->GetName().': '.$this->Lang('error_configuration'));
      }
    
    $key = $this->SaveState(true);

    $config = cmsms()->GetConfig();
    $smarty = cmsms()->GetSmarty();
    $smarty->assign('formstart',
		    $this->CGCreateFormStart('cntnt01','process_payment',$returnid,
					     array('key'=>$key)));
    $smarty->assign('formend',$this->CreateFormEnd());
    $smarty->assign('image_url',
		    $config['root_url'].'/modules/'.$this->GetName().'/images/icon.gif');
    $smarty->assign('image_alt',$this->GetName());
		    
					     
    // and process the template.
    return $this->ProcessTemplateFromDatabase('form_template');
  }


  /*---------------------------------------------------------
   SetBillingAddress()
   ---------------------------------------------------------*/
  public function SetBillingAddress(orders_address& $billing_addy)
  {
    if( !$billing_addy instanceof cge_address )
      {
	return FALSE;
      }
    $this->_data['billing_address'] = $billing_addy;
  }


  /*---------------------------------------------------------
   SetShippingAddress()
   ---------------------------------------------------------*/
  public function SetShippingAddress(orders_address& $shipping_addy)
  {
    if( !$shipping_addy instanceof cge_address )
      {
	return FALSE;
      }
    $this->_data['shipping_address'] = $shipping_addy;
  }


  /*---------------------------------------------------------
   ProcessTransaction()
   ---------------------------------------------------------*/
  public function ProcessTransaction()
  {
    $key = $this->SaveState(true);
    $params = array();
    $params['key'] = $key;
    return $this->DoAction('process_payment','cntnt01',$params);
  }


  function GetNotificationOutput($priority=2)
  {
    global $CMS_ADMIN_PAGE;
    $testmode = $this->GetPreference('testmode',1);
    if( $testmode && check_login(FALSE) )
      {
	$data = new stdClass;
	$data->priority = 1;
	$data->html = $this->ShowErrors($this->Lang('msg_testmode'));
	return $data;
      }
  }
} // class
