<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFeedMaker - A flexible tool for the creation and management
#         of RSS Feeds
# Version: 1.0, calguy1000 <calguy1000@cmsmadesimple.org>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;
if( !isset($params['feed']) ) return;
$feed = trim($params['feed']);

$config =& $gCms->GetConfig();
$pos = strrpos($feed,'.');
if( $pos !== FALSE )
  {
    $ext = substr($feed,strrpos($feed,'.'));
    $feed = substr($feed,0,strlen($feed)-strlen($ext));
  }

# Get the feed
$query = 'SELECT * FROM '.cms_db_prefix().'module_cgfeedmaker WHERE name = ?';
$row = $db->GetRow($query,array($feed));
if( !$row )
{ 
  // could not find the feed.
  return; 
}

// Grab the user object for the first admin
// with a valid email.
$userops =& $gCms->GetUserOperations();
$admins = $userops->LoadUsersInGroup(1);
$userobj = '';
foreach($admins as $one) 
{
  if( !empty($one->email) ) 
    {
      $userobj = $one;
      break;
    }
}

# Give stuff to smarty
if( !empty($userobj) && is_object($userobj) )
{
  $smarty->assign('admin_email',$userobj->email);
  $smarty->assign('admin_user',$userobj);
}

$url = $this->CreateFeedURL($id,$feed,$row['extension']);
$smarty->assign('feed_url',$url);
$smarty->assign('file_location',$config['uploads_url'].'/'.$this->GetName());
$smarty->assign('generator',sprintf('%s %s on CMS Made Simple',$this->GetName(),$this->GetVersion()));
$smarty->assign('feed',$row);

# Display The Template
$variables =& $gCms->variables;
if( preg_match( '/Mozilla/', $_SERVER["HTTP_USER_AGENT"] ) )
{
  $variables['content-type'] = 'text/xml';
}
else 
{
  $variables['content-type'] = 'application/rss+xml';
}

// temporary hack
if (isset($gCms->variables['pageinfo']) && isset($gCms->variables['pageinfo']->content_id))
{
  $gCms->variables['pageinfo']->content_id = $row['pageid'];
}

echo trim($this->ProcessTemplateFromData($row['template']));

#
# EOF
#
?>
