/* Support for DecisionTree Module */
function setVisibilty(id,setting)
	{
    var elem = document.getElementById(id);
    if (elem)
		{
		elem.style.display=setting;
		}
	}

function hide(id)
	{
	setVisibilty(id,"none");
	}

function show(id)
	{
	setVisibilty(id,"");
	}

function update_dec(ldepth)
	{
	hide('results');
	hide('alternate');
	hide('suggestion');
        for( i = ldepth + 1; i < 1000; i++ )
	  {
	    var el = document.getElementById('dts_'+i);
            if( !el ) break;
	    resetSelect('dts_'+i);
	    hide('dts_'+i);
	  }
	sel = -1;

	if (ldepth > -1)
		{
		sel = getSelectionValue('dts_'+ldepth);
		}

	depth = ldepth + 1;
	ajaxRequest(base_url.replace('DID',sel), populate_next);		
	}
	
function populate_next(datareq)
	{
	// only if req shows "loaded"
	if (datareq.readyState == 4)
		{
		// only if "OK"
		if (datareq.status == 200) 
			{
			subdec = datareq.responseXML.getElementsByTagName('decision');
			if (subdec.length == 0)
				{
				sel = getSelectionValue('dts_'+(depth-1));
				ajaxRequest(base_url.replace('DID',sel).replace('get_dec','get_outcome'), populate_last);
				}
			else
				{
				populateFromDOM('dts_'+depth, subdec);
				show('dts_'+depth);
				}
			} 
		else
			{
			alert("There was a problem retrieving the XML data:\n" + datareq.statusText);
			}
		}
	}

function populate_last(datareq)
	{
	req = datareq;

	// only if req shows "loaded"
	if (req.readyState == 4)
		{
		// only if "OK"
		if (req.status == 200) 
			{
			subdec = req.responseXML.getElementsByTagName('decision');
			var returns = subdec[0].getElementsByTagName('returns')[0].childNodes[0].data;
			if (returns && returns != '')
				{
				fillElement('results_val',returns);
				show('results');
				}
			var alt = subdec[0].getElementsByTagName('alternate')[0].childNodes[0].data;
			if (alt && alt != '')
				{
				fillElement('alternate_val',alt);
				show('alternate');
				}
			var sug = subdec[0].getElementsByTagName('suggestion')[0].childNodes[0].data;
			if (sug && sug != '')
				{
				fillElement('suggestion_val',sug);
				show('suggestion');
				}
			} 
		else
			{
			alert("There was a problem retrieving the XML data:\n" + req.statusText);
			}
		}
	}

function fillElement(id,string)
	{
	var item = document.getElementById(id);
	if (item)
		{
		item.innerHTML = string;
		}
	}
	
function appendToSelect(select, value, content, selected)
	{
    var opt;
    opt = document.createElement("option");
	if (selected)
		opt.selected = "true";
    opt.value = value;
    opt.appendChild(document.createTextNode(content));
    select.appendChild(opt);
	}


function ajaxSetResult()
{
  // get the selected tree.
  var results = getSelections();
  var data = {'tree':alias,'options':results};

  // encode it to json
  var json = json_encode(data);

  // do the ajax request
  ajaxRequest(treeresults_url.replace(/amp;/g,'')+'&cntnt01data='+json,cb_ajaxSetResult);
}

function cb_ajaxSetResult(datareq)
{
  if( datareq.readyState == 4 )
    {
      if( datareq.status != 200 || datareq.responseText != 1)
	{
	  alert("There was a problem sending selected values to the receiving action:\n"+datareq.statusText + ' ' + datareq.responseText);
	}
    }
}

function getSelections()
{
  var results = new Array();
  for( var i = 0; i < 1000; i++ )
    {
      var el = document.getElementById('dts_'+i);
      if( !el ) break;
      
      var tmp = getSelectionText('dts_'+i);
      if( !tmp ) continue;

      results.push(getSelectionText('dts_'+i));
    }
  return results;
}

function getSelectionText(id)
	{
    var select = document.getElementById(id);
	if (select.selectedIndex >= 0)
		return select.options[select.selectedIndex].text;
	return "";
	}

function getSelectionValue(id)
	{
	var select = document.getElementById(id);
	if (select.options.length == 0 || typeof(select.selectedIndex) == 'undefined')
		{
		return false;
		}
	return select.options[select.selectedIndex].value;
	}

function resetSelect(id)
	{
    var sel = document.getElementById(id);
	while (typeof(sel.length) != "undefined" && sel.length > 0)
		{
		try {
			sel.remove(0);
			} catch (IEBug)
				{
				}
    	}
	}

function resetRadio(id)
{
	setRadio(formFields[id]["radioname"], -1);
	formFields[id]["filled"] = 0;
}

function populateFromDOM(id, dom)
{
	//console.debug(dom);
    var select = document.getElementById(id);
    for (var i = 0; i < dom.length; i++) 
	{
       if (i == 0)
          {
          var prompt = dom[i].getElementsByTagName('prompt');
          if (prompt && prompt.length > 0)
              {
              appendToSelect(select,'',prompt[0].childNodes[0].data);
              }
          else
              {
              appendToSelect(select,'',dprompt);
              }
          }
        appendToSelect(select, dom[i].getElementsByTagName('decision_id')[0].childNodes[0].data,
			dom[i].getElementsByTagName('name')[0].childNodes[0].data);
    }
}

function ajaxRequest(url, callback)
	{
	var the_var = null;
    if (window.XMLHttpRequest)
	{
        the_var = new XMLHttpRequest();
        the_var.onreadystatechange = function () {callback(the_var)};
        the_var.open("GET", url, true);
		// send referer header
		the_var.setRequestHeader("Referer", document.location);
        the_var.send(null);
    // branch for IE/Windows ActiveX version
    }
	else if (window.ActiveXObject) 
		{
        isIE = true;
        the_var = new ActiveXObject("Microsoft.XMLHTTP");
        if (the_var) 
			{
			the_var.onreadystatechange = function () {callback(the_var)};
            the_var.open("GET", url, true);
            the_var.send();
        	}
    	}
	return the_var;
	}


/**
 * Converts the given data structure to a JSON string.
 * Argument: arr - The data structure that must be converted to JSON
 * Example: var json_string = array2json(['e', {pluribus: 'unum'}]);
 * 			var json = array2json({"success":"Sweet","failure":false,"empty_array":[],"numbers":[1,2,3],"info":{"name":"Binny","site":"http:\/\/www.openjs.com\/"}});
 * http://www.openjs.com/scripts/data/json_encode.php
 */
function array2json(arr) 
{
  var parts = [];
  var is_list = (Object.prototype.toString.apply(arr) === '[object Array]');

  for(var key in arr) {
    var value = arr[key];
    if(typeof value == "object") { //Custom handling for arrays
      if(is_list) parts.push(array2json(value)); /* :RECURSION: */
      else parts[key] = array2json(value); /* :RECURSION: */
    } else {
      var str = "";
      if(!is_list) str = '"' + key + '":';
      
      //Custom handling for multiple data types
      if(typeof value == "number") str += value; //Numbers
      else if(value === false) str += 'false'; //The booleans
      else if(value === true) str += 'true';
      else str += '"' + value + '"'; //All other things
      // :TODO: Is there any more datatype we should be in the lookout for? (Functions?)
      
      parts.push(str);
    }
  }
  var json = parts.join(",");
  
  if(is_list) return '[' + json + ']';//Return numerical JSON
  return '{' + json + '}';//Return associative JSON
}


function json_encode (mixed_val) {
    // Returns the JSON representation of a value  
    // 
    // version: 1103.1210
    // discuss at: http://phpjs.org/functions/json_encode
    // +      original by: Public Domain (http://www.json.org/json2.js)
    // + reimplemented by: Kevin van Zonneveld (http://kevin.vanzonneveld.net)
    // +      improved by: Michael White
    // +      input by: felix
    // +      bugfixed by: Brett Zamir (http://brett-zamir.me)
    // *        example 1: json_encode(['e', {pluribus: 'unum'}]);
    // *        returns 1: '[\n    "e",\n    {\n    "pluribus": "unum"\n}\n]'
/*
        http://www.JSON.org/json2.js
        2008-11-19
        Public Domain.
        NO WARRANTY EXPRESSED OR IMPLIED. USE AT YOUR OWN RISK.
        See http://www.JSON.org/js.html
    */
    var retVal, json = this.window.JSON;
    try {
        if (typeof json === 'object' && typeof json.stringify === 'function') {
            retVal = json.stringify(mixed_val); // Errors will not be caught here if our own equivalent to resource
            //  (an instance of PHPJS_Resource) is used
            if (retVal === undefined) {
                throw new SyntaxError('json_encode');
            }
            return retVal;
        }
 
        var value = mixed_val;
 
        var quote = function (string) {
            var escapable = /[\\\"\u0000-\u001f\u007f-\u009f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g;
            var meta = { // table of character substitutions
                '\b': '\\b',
                '\t': '\\t',
                '\n': '\\n',
                '\f': '\\f',
                '\r': '\\r',
                '"': '\\"',
                '\\': '\\\\'
            };
 
            escapable.lastIndex = 0;
            return escapable.test(string) ? '"' + string.replace(escapable, function (a) {
                var c = meta[a];
                return typeof c === 'string' ? c : '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
            }) + '"' : '"' + string + '"';
        };
 
        var str = function (key, holder) {
            var gap = '';
            var indent = '    ';
            var i = 0; // The loop counter.
            var k = ''; // The member key.
            var v = ''; // The member value.
            var length = 0;
            var mind = gap;
            var partial = [];
            var value = holder[key];
 
            // If the value has a toJSON method, call it to obtain a replacement value.
            if (value && typeof value === 'object' && typeof value.toJSON === 'function') {
                value = value.toJSON(key);
            }
 
            // What happens next depends on the value's type.
            switch (typeof value) {
            case 'string':
                return quote(value);
 
            case 'number':
                // JSON numbers must be finite. Encode non-finite numbers as null.
                return isFinite(value) ? String(value) : 'null';
 
            case 'boolean':
            case 'null':
                // If the value is a boolean or null, convert it to a string. Note:
                // typeof null does not produce 'null'. The case is included here in
                // the remote chance that this gets fixed someday.
                return String(value);
 
            case 'object':
                // If the type is 'object', we might be dealing with an object or an array or
                // null.
                // Due to a specification blunder in ECMAScript, typeof null is 'object',
                // so watch out for that case.
                if (!value) {
                    return 'null';
                }
                if ((this.PHPJS_Resource && value instanceof this.PHPJS_Resource) || (window.PHPJS_Resource && value instanceof window.PHPJS_Resource)) {
                    throw new SyntaxError('json_encode');
                }
 
                // Make an array to hold the partial results of stringifying this object value.
                gap += indent;
                partial = [];
 
                // Is the value an array?
                if (Object.prototype.toString.apply(value) === '[object Array]') {
                    // The value is an array. Stringify every element. Use null as a placeholder
                    // for non-JSON values.
                    length = value.length;
                    for (i = 0; i < length; i += 1) {
                        partial[i] = str(i, value) || 'null';
                    }
 
                    // Join all of the elements together, separated with commas, and wrap them in
                    // brackets.
                    v = partial.length === 0 ? '[]' : gap ? '[\n' + gap + partial.join(',\n' + gap) + '\n' + mind + ']' : '[' + partial.join(',') + ']';
                    gap = mind;
                    return v;
                }
 
                // Iterate through all of the keys in the object.
                for (k in value) {
                    if (Object.hasOwnProperty.call(value, k)) {
                        v = str(k, value);
                        if (v) {
                            partial.push(quote(k) + (gap ? ': ' : ':') + v);
                        }
                    }
                }
 
                // Join all of the member texts together, separated with commas,
                // and wrap them in braces.
                v = partial.length === 0 ? '{}' : gap ? '{\n' + gap + partial.join(',\n' + gap) + '\n' + mind + '}' : '{' + partial.join(',') + '}';
                gap = mind;
                return v;
            case 'undefined':
                // Fall-through
            case 'function':
                // Fall-through
            default:
                throw new SyntaxError('json_encode');
            }
        };
 
        // Make a fake root object containing our value under the key of ''.
        // Return the result of stringifying the value.
        return str('', {
            '': value
        });
 
    } catch (err) { // Todo: ensure error handling above throws a SyntaxError in all cases where it could
        // (i.e., when the JSON global is not available and there is an error)
        if (!(err instanceof SyntaxError)) {
            throw new Error('Unexpected error type in json_encode()');
        }
        this.php_js = this.php_js || {};
        this.php_js.last_error_json = 4; // usable by json_last_error()
        return null;
    }
}

/* depth must be defined before we get here! */
update_dec(depth);
