<?php
if (!isset($gCms)) exit;
if (! $this->CheckPermission('Modify Any Page')) {
  return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
}

if( !function_exists('dt_import_node') )
  {
    function dt_import_get_node($obj,$tree_id,$parent_id,$idx)
    {
      $node = array('decision_id'=>'',
		    'tree_id'=>$tree_id,
		    'parent_id'=>$parent_id,
		    'is_result'=>0,
		    'decision'=>'',
		    'returns'=>'',
		    'alternate'=>'',
		    'prompt'=>'',
		    'suggestion'=>'',
		    'order_by'=>$idx);

      // get attributes first.
      foreach( $obj->attributes() as $k => $v )
	{
	  switch( $k )
	    {
	    case 'name':
	      $k = 'decision';
	    case 'prompt':
	    case 'suggestion':
	    case 'alternate':
	      $node[$k] = $v;
	      break;

	    case 'returns':
	      $node['is_result'] = 1;
	      $node[$k] = $v;
	      break;
	    }
	}

      foreach( $node as $k => &$v )
	{
	  if( $k == 'decision_id' ) continue;
	  if( $k == 'decision' ) $k = 'name';

	  if( isset($obj->$k) )
	    {
	      $v = $obj->$k;
	    }
	}
      return $node;
    }


    function dt_import_node($obj,$tree_id,$parent_id,$idx)
    {
      // get the node
      $rec = dt_import_get_node($obj,$tree_id,$parent_id,$idx);
      
      // save the node
      $db = cmsms()->GetDb();
      $query = 'INSERT INTO '.cms_db_prefix().'module_dectree_decs
                 (decision_id,tree_id,parent_id,is_result,decision,returns,alternate,prompt,suggestion,order_by)
                VALUES (?,?,?,?,?,?,?,?,?,?)';
      $rec['decision_id'] = $db->GenID(cms_db_prefix().'module_dectree_decs_seq');
      $dbr = $db->Execute($query,array((int)$rec['decision_id'],
				       (int)$rec['tree_id'],
				       (int)$rec['parent_id'],
				       (int)$rec['is_result'],
				       (string)$rec['decision'],
				       (string)$rec['returns'],
				       (string)$rec['alternate'],
				       (string)$rec['prompt'],
				       (string)$rec['suggestion'],
				       (int)$rec['order_by']));
      if( !$dbr )
	{
	  debug_display($db->ErrorMsg()); die();
	}

      // process children.
      if( isset($obj->decision) )
	{
	  for( $i = 0; $i < count($obj->decision); $i++ )
	    {
	      dt_import_node($obj->decision[$i],$tree_id,$rec['decision_id'],$i);
	    }
	}
    }
  }

$success = true;
$error = '';
$max_depth = -1;
$dec_id = -1;
if (isset($_FILES[$id.'tree_file']['tmp_name']) && !empty($_FILES[$id.'tree_file']['tmp_name']))
{
   
  $obj = simplexml_load_file($_FILES[$id.'tree_file']['tmp_name']);
  if( !is_object($obj) )
  {
    return $this->DisplayErrorPage($id,$params,$returnid,$this->Lang('error_loadxml'));
  }

  // erase old one if requested
  if (isset($params['overwrite']) && $params['overwrite'] == 1)
  {
    $exist_query = 'select tree_id from '.cms_db_prefix().'module_dectree_trees where alias=?';
    $dres = $db->GetOne($exist_query);
    if ($dres)
    {
      $this->deleteTreeById($dres);
    }
  }

  $tree_id = $db->GenID(cms_db_prefix().'module_dectree_trees_seq');
  $tree_query = 'insert into '.cms_db_prefix().'module_dectree_trees (tree_id,alias,description) values (?,?,?)';
  $dres = $db->Execute($tree_query,array($tree_id,$params['tree_alias'],$params['tree_description']));

  $parent_id = -1;
  if( isset($obj->decision) )
    {
      for( $i = 0; $i < count($obj->decision); $i++ )
	{
	  $node = dt_import_node($obj->decision[$i],$tree_id,-1,$i);
	}
    }

 }

if ($success)
  {
    $db->Execute('update '.cms_db_prefix().'module_dectree_trees set max_depth=? where tree_id=?',array($max_depth + 2,$tree_id));
    $params = array('tab_message'=> 'summary_imported', 'active_tab' => 'listing');
  }
 else
   {
     $params = array('tab_message'=> $error, 'active_tab' => 'listing');
   }

$this->Redirect($id,'defaultadmin',$returnid,$params);
?>