<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSmartImage (c) 2011 by Samuel Goldstein
# This file:  (c) 2011 by Robert Campbell (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if (!isset($gCms)) exit;
if (! $this->CheckPermission('Modify Any Page')) {
  echo $this->ShowErrors($this->Lang('accessdenied'));
  return;
}

if( !function_exists('dt_get_tree') )
  {
    function dt_edit_node_cb(&$mod,$tree_id,&$node,$index,$num_elements)
    {
      $gCms = cmsms();
      $id = 'm1_';
      $returnid = '';
      $node['edit_url'] = $mod->create_url($id,'admin_edit_node',$returnid,array('tree_id'=>$tree_id,'decision_id'=>$node['decision_id']));
      $node['edit_link'] = $mod->CreateLink($id,'admin_edit_node',$returnid,
					     $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif',$mod->Lang('edit_node'),
											  '','','systemicon specialicon'),
					     array('tree_id'=>$tree_id,'decision_id'=>$node['decision_id']));

      if( $node['is_result'] )
	{
	  $node['type'] = $mod->Lang('result');
	}
      else
	{
	  $node['type'] = $mod->Lang('option');
	}

      if( $num_elements > 1 )
	{
	  if( $index > 0 )
	    {
	      // move up.
	      $node['move_up'] = $mod->CreateLink($id,'admin_edit_node',$returnid,
						  $gCms->variables['admintheme']->DisplayImage('icons/system/arrow-u.gif',$mod->Lang('move_up'),
											       '','','systemicon'),
						  array('tree_id'=>$tree_id,'decision_id'=>$node['decision_id'],'move'=>'up'));
	    }
	  if( $index + 1 < $num_elements )
	    {
	      // move down.
	      $node['move_down'] = $mod->CreateLink($id,'admin_edit_node',$returnid,
						  $gCms->variables['admintheme']->DisplayImage('icons/system/arrow-d.gif',$mod->Lang('move_down'),
											       '','','systemicon'),
						  array('tree_id'=>$tree_id,'decision_id'=>$node['decision_id'],'move'=>'down'));
	    }
	}
      if( !isset($node['children']))
	{
	  $gCms = cmsms();
	  $id = 'm1_';
	  $returnid = '';
	  $node['delete_url'] = $mod->create_url($id,'admin_edit_node',$returnid,array('del'=>1,'tree_id'=>$tree_id,'decision_id'=>$node['decision_id']));
	  $node['delete_link'] = $mod->CreateLink($id,'admin_edit_node',$returnid,
						  $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif',$mod->Lang('delete_node'),
											       '','','systemicon specialicon'),
						  array('del'=>1,'tree_id'=>$tree_id,'decision_id'=>$node['decision_id']));
	  if( !$node['is_result'] )
	    {
	      $node['add_link'] = $mod->CreateLink($id,'admin_edit_node',$returnid,
						   $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif',$mod->Lang('delete_node'),
												 16,16,'systemicon specialicon'),
						    array('add'=>1,'tree_id'=>$tree_id,'parent_id'=>$node['decision_id']));
	    }
	}
      else
	{
	  // if the children are results... we can only add result children
	  // if the children are not results, we can only add that type of children
	  // if there are no children...we can decide what to put in there.
	  $node['wants_results'] = ($node['children'][0]['is_result'])?1:0;
	  $node['add_link'] = $mod->CreateLink($id,'admin_edit_node',$returnid,
					       $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif',$mod->Lang('delete_node'),
											    '','','systemicon specialicon'),
					       array('add'=>1,'tree_id'=>$tree_id,'parent_id'=>$node['decision_id']));
	}
    }

    function dt_get_tree(&$mod,$tree_id, $parent_id)
    {
      $db = cmsms()->GetDb();
      $query = 'SELECT * FROM '.cms_db_prefix().'module_dectree_decs WHERE tree_id = ? AND parent_id = ? ORDER BY order_by';
      $data = $db->GetArray($query,array($tree_id,$parent_id));
      if( !is_array($data) ) return;

      for( $i = 0; $i < count($data); $i++ )
	{
	  $tmp = dt_get_tree($mod, $tree_id, $data[$i]['decision_id']);
	  if( is_array($tmp) && count($tmp) )
	    {
	      $data[$i]['children'] = $tmp;
	    }
	  dt_edit_node_cb($mod, $tree_id, $data[$i], $i, count($data));
	}

      return $data;
    }
  }

$tree_id = -1;
$tree_info = array();
if( isset($params['tree_id']) )
  {
    $tree_id = (int)$params['tree_id'];
    if( $tree_id > 0 )
      {
	$query = 'SELECT tree_id,alias,description,allow_decision_wysiwyg FROM '.cms_db_prefix().'module_dectree_trees WHERE tree_id = ?';
	$tree_info = $db->GetRow($query,array($tree_id));
	if( !$tree_info )
	  {
	    die('could not find tree ... fix me');
	  }
      }
  }

if( isset($params['cancel']) )
  {
    $this->Redirect($id,'defaultadmin');
    return; // just in case.
  }
else if( isset($params['submit']) )
  {
    $tree_info['alias'] = trim($params['tree_alias']);
    $tree_info['description'] = trim($params['tree_description']);
    $tree_info['allow_decision_wysiwyg'] = (int)$params['tree_allow_decision_wysiwyg'];

    if( $tree_info['alias'] == '' )
      {
	echo $this->ShowError($this->Lang('error_aliasrequired'));
      }
    else
      {
	$dbr = '';
	if( $tree_id <= 0 )
	  {
	    $template = @file_get_contents(dirname(__FILE__).'/templates/stdtree.tpl');
	    $tree_id = $db->GenId(cms_db_prefix().'module_dectree_trees_seq');
	    $query = 'INSERT INTO '.cms_db_prefix().'module_dectree_trees
                      (tree_id,alias,description,max_depth,template,allow_decision_wysiwyg)
                      VALUES (?,?,?,?,?,?)';
	    $dbr = $db->Execute($query,array($tree_id,$tree_info['alias'],$tree_info['description'],0,
					     $template,$tree_info['allow_decision_wysiwyg']));
	  }
	else
	  {
	    // now do the update.
	    $query = 'UPDATE '.cms_db_prefix().'module_dectree_trees
                  SET alias = ?, description = ?, allow_decision_wysiwyg = ?
                  WHERE tree_id = ?';
	    $dbr = $db->Execute($query,
				array($tree_info['alias'],$tree_info['description'],
				      $tree_info['allow_decision_wysiwyg'],$tree_info['tree_id']));
	  }
	if( !$dbr )
	  {
	    die($db->sql.' -- '.$db->ErrorMsg());
	  }
	$this->Redirect($id,'defaultadmin',$returnid);
      }
  }


//
// give everything to smarty
//
$tree = '';
if( $tree_id > 0 )
  {
    $tree = dt_get_tree($this, $tree_id, -1);
    if( !is_array($tree) )
      {
	die('nothing to display... fix me');
      }
    $smarty->assign('tree',$tree);
  }

$smarty->assign('expand_all',$gCms->variables['admintheme']->DisplayImage('icons/system/expandall.gif',$this->Lang('expand_all'),
									  '','','systemicon expandall'));
$smarty->assign('collapse_all',$gCms->variables['admintheme']->DisplayImage('icons/system/contractall.gif',$this->Lang('collapse_all'),
									    '','','systemicon collapseall'));
$smarty->assign('newtopnode_link',
		$this->CreateLink($id,'admin_edit_node',$returnid,
				  $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif',$this->Lang('new_top_node'),
									       '','','systemicon').'&nbsp;'.$this->Lang('new_top_node'),
				  array('add'=>1,'tree_id'=>$tree_id,'parent_id'=>-1)));
$smarty->assign('formstart',$this->CreateFormStart($id,'admin_edit_tree',$returnid,'post','',false,'',array('tree_id'=>$tree_id)));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('mod',$this);
$smarty->assign('actionid',$id);
$smarty->assign('tree_info',$tree_info);
echo $this->ProcessTemplate('admin_edit_tree.tpl');

#
# EOF
#
?>