<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSmartImage (c) 2011 by Samuel Goldstein
# This file:  (c) 2011 by Robert Campbell (calguy1000@cmsmadesimple.org)
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if (!isset($gCms)) exit;
if (! $this->CheckPermission('Modify Any Page')) {
  return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
}
if( !isset($params['tree_id']) ) {
  return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('missingparam'));
}

// create an empty node.
$node = array('decision_id'=>'','tree_id'=>'','parent_id'=>'','is_result'=>'','decision'=>'','returns'=>'','alternate'=>'','prompt'=>'','suggestion'=>'',
              'order_by'=>'');
$error = '';
$do_add = 0;
$accepted_type = '-1';

if( isset($params['move']) )
  {
    // doing a move.
    switch(strtolower($params['move']))
      {
      case 'up':
	{
	  // get our current row
	  $query = 'SELECT * FROM '.cms_db_prefix().'module_dectree_decs WHERE tree_id = ? AND decision_id = ?';
	  $cur_node = $db->GetRow($query,array((int)$params['tree_id'],(int)$params['decision_id']));

	  // get the previous item in the list
	  $query = 'SELECT * FROM '.cms_db_prefix().'module_dectree_decs WHERE tree_id = ? AND parent_id = ? AND order_by = ?';
	  $prev_node = $db->GetRow($query,array((int)$params['tree_id'],(int)$cur_node['parent_id'],(int)$cur_node['order_by'] - 1));

	  // swap the 2 order_by values
	  $tmp = $cur_node['order_by'];
	  $cur_node['order_by'] = $prev_node['order_by'];
	  $prev_node['order_by'] =  $tmp;

	  // update
	  $query = 'UPDATE '.cms_db_prefix().'module_dectree_decs SET order_by = ? WHERE tree_id = ? AND decision_id = ? ';
	  $dbr = $db->Execute($query,array((int)$cur_node['order_by'],(int)$cur_node['tree_id'],(int)$cur_node['decision_id']));
	  $dbr = $db->Execute($query,array((int)$prev_node['order_by'],(int)$prev_node['tree_id'],(int)$prev_node['decision_id']));

	  $this->Redirect($id,'admin_edit_tree',$returnid,array('tree_id'=>(int)$params['tree_id']));
	}
	break;

      case 'down':
	{
	  // get our current row
	  $query = 'SELECT * FROM '.cms_db_prefix().'module_dectree_decs WHERE tree_id = ? AND decision_id = ?';
	  $cur_node = $db->GetRow($query,array((int)$params['tree_id'],(int)$params['decision_id']));

	  // get the next item in the list
	  $query = 'SELECT * FROM '.cms_db_prefix().'module_dectree_decs WHERE tree_id = ? AND parent_id = ? AND order_by = ?';
	  $next_node = $db->GetRow($query,array((int)$params['tree_id'],(int)$cur_node['parent_id'],(int)$cur_node['order_by'] + 1));

	  // swap the 2 order_by values
	  $tmp = $cur_node['order_by'];
	  $cur_node['order_by'] = $next_node['order_by'];
	  $next_node['order_by'] =  $tmp;

	  // update
	  $query = 'UPDATE '.cms_db_prefix().'module_dectree_decs SET order_by = ? WHERE tree_id = ? AND decision_id = ? ';
	  $dbr = $db->Execute($query,array((int)$cur_node['order_by'],(int)$cur_node['tree_id'],(int)$cur_node['decision_id']));
	  $dbr = $db->Execute($query,array((int)$next_node['order_by'],(int)$next_node['tree_id'],(int)$next_node['decision_id']));

	  $this->Redirect($id,'admin_edit_tree',$returnid,array('tree_id'=>(int)$params['tree_id']));
	}
	break;

      default:
	$error = $this->Lang('error_move');
      }
  }
else if( isset($params['del']) )
  {
    // doing a delete
    // double check that this thing doesn't have children
    $query = 'SELECT decision_id FROM '.cms_db_prefix().'module_dectree_decs WHERE tree_id = ? AND parent_id = ?';
    $tmp = $db->GetRow($query,array((int)$params['tree_id'],(int)$params['decision_id']));
    if( is_array($tmp) && count($tmp) )
      {
	$error = $this->Lang('error_deleteparent');
      }
    else
      {
	// and delete it.
	$query = 'DELETE FROM '.cms_db_prefix().'module_dectree_decs WHERE tree_id = ? AND decision_id = ?';
	$dbr = $db->Execute($query,array((int)$params['tree_id'],(int)$params['decision_id']));
	$this->Redirect($id,'admin_edit_tree',$returnid,array('tree_id'=>(int)$params['tree_id']));
      }
  }
else if( isset($params['decision_id']) )
  {
    // doing an edit ... gotta load it.
    $query = 'SELECT * FROM '.cms_db_prefix().'module_dectree_decs WHERE tree_id = ? AND decision_id = ?';
    $node = $db->GetRow($query,array((int)$params['tree_id'],(int)$params['decision_id']));

    $accepted_type = ($node['is_result'])?'result':'decision';
  }
else if( isset($params['parent_id']) )
  {
    // doing an add
    $do_add = 1;
    $node['tree_id'] = (int)$params['tree_id'];
    $node['parent_id'] = (int)$params['parent_id'];

    if( $node['parent_id'] == -1 )
      {
	$accepted_type = 'decision';
      }

    // gotta get a peer (if there are any)
    $query = 'SELECT * FROM '.cms_db_prefix().'module_dectree_decs WHERE tree_id = ? AND parent_id = ?';
    $tmp = $db->GetRow($query,array((int)$params['tree_id'],(int)$params['parent_id']));
    if( $tmp )
      {
	$accepted_type = ($tmp['is_result'])?'result':'decision';
      }
  }
else
  {
    die('missing parameters... dont know what Im supposed to do');
    // don't know what is happening.
  }

if( isset($params['cancel']) )
  {
    $this->Redirect($id,'admin_edit_tree',$returnid,array('tree_id'=>(int)$params['tree_id']));
  }
else if( isset($params['submit']) )
  {
    $node['decision'] = trim($params['decision']);
    $node['returns'] = trim($params['returns']);
    $node['alternate'] = trim($params['alternate']);
    $node['suggestion'] = trim($params['suggestion']);
    $node['prompt'] = trim($params['prompt']);
    $node['is_result'] = ($node['returns']!='')?1:0;

    // do data validation here.
    if( $node['decision'] == '' )
      {
	// that's the only required field.
	$error = $this->Lang('error_decision_required');
      }

    if( !$error )
      {
	if( !$do_add )
	  {
	    $query = 'UPDATE '.cms_db_prefix().'module_dectree_decs
                     SET decision = ?, returns = ?, alternate = ?, suggestion = ?, prompt = ?, is_result = ?
                   WHERE tree_id = ? AND decision_id = ?';
	    $dbr = $db->Execute($query,array($node['decision'],$node['returns'],$node['alternate'],$node['suggestion'],$node['prompt'],
					     $node['is_result'],$node['tree_id'],$node['decision_id']));
	  }
	else
	  {
	    $query = 'SELECT max(order_by) FROM '.cms_db_prefix().'module_dectree_decs WHERE tree_id = ? AND parent_id = ?';
	    $order_by = $db->GetOne($query,array($node['tree_id'],$node['parent_id']));
	    $node['order_by'] = ($order_by == '')?0:$order_by+1;
	    
	    $query = 'INSERT INTO '.cms_db_prefix().'module_dectree_decs
                    (decision_id,tree_id,parent_id,is_result,decision,returns,alternate,prompt,suggestion,order_by)
                  VALUES (?,?,?,?,?,?,?,?,?,?)';
	    $node['decision_id'] = $db->GenId(cms_db_prefix().'module_dectree_decs_seq');
	    $dbr = $db->Execute($query,array($node['decision_id'],$node['tree_id'],$node['parent_id'],
					     $node['is_result'],$node['decision'],$node['returns'],$node['alternate'],
					     $node['prompt'],$node['suggestion'],$node['order_by']));
	  }

	// and done.
	$this->Redirect($id,'admin_edit_tree',$returnid,array('tree_id'=>(int)$params['tree_id']));
      }
  }


function dt_build_parent_dropdown($tree,$children_type,$prepend = '')
{
  function __dt_build_parent_dropdown($tree,$depth = 0)
  {
    $tmp = array();
    for( $i = 0; $i < count($tree); $i++ )
      {
	$node =& $tree[$i];
	if( $node['is_result'] ) continue;
	$tmp[$node['decision_id']] = str_repeat('&nbsp;',$depth).$node['decision'];
	if( isset($node['children']) )
	  {
	    $tmp2 = __dt_build_parent_dropdown($node['children'],$depth+1);
	    if( count($tmp2) ) 
	      {
		$tmp = $tmp + $tmp2;
	      }
	  }
      }
    return $tmp;
  }

  $tmp = array();
  if( is_array($prepend) )
    {
      $keys = array_keys($prepend);
      $values = array_values($prepend);
      $tmp[$keys[0]] = $values[0];
    }

  $tmp2 = __dt_build_parent_dropdown($tree);
  $tmp = $tmp + $tmp2;
  return $tmp;
}

function find_node($tree,$decision_id)
{
  for( $i = 0; $i < count($tree); $i++ )
    {
      $node = $tree[$i];
      if( $node['decisision_id'] == $decision_id )
	{
	  return $node;
	}
      if( isset($node['children']) )
	{
	  $res = find_node($node['children']);
	  if( $res ) return $res;
	}
    }
  return FALSE;
}

function find_node_accepts($tree,$decision_id)
{
  $node = find_node($tree,$decision_id);
  if( $node )
    {
      if( isset($node['children']) )
	{
	  // get the first child.
	  $child = $node['children'][0];
	  if( $child['is_result'] ) return 'result';
	  return 'decision';
	}
    }
  return FALSE;
}

if( $error )
  {
    echo $this->ShowErrors($error);
    return;
  }

if( $accepted_type == 'result' )
  {
    $node['is_result'] = 1;
  }

$query = 'SELECT tree_id,alias,description,allow_decision_wysiwyg FROM '.cms_db_prefix().'module_dectree_trees WHERE tree_id = ?';
$tree_info = $db->GetRow($query,array((int)$node['tree_id']));
if( !is_array($tree_info) ) die('no tree -- fix me');
$smarty->assign('tree_info',$tree_info);

$node['returns_wysiwyg'] = $this->CreateTextArea(TRUE,$id,$node['returns'],'returns');
if( $tree_info['allow_decision_wysiwyg'] )
  {
    $node['decision_wysiwyg'] = $this->CreateTextArea(TRUE,$id,$node['decision'],'decision');
  }
$node['alternate_wysiwyg'] = $this->CreateTextArea(TRUE,$id,$node['alternate'],'alternate');
$node['suggestion_wysiwyg'] = $this->CreateTextArea(TRUE,$id,$node['suggestion'],'suggestion');

$tree = $this->get_raw_tree((int)$node['tree_id']);
$smarty->assign('accepted_type',$accepted_type);
$smarty->assign('type_options',array(0=>$this->Lang('decision'),1=>$this->Lang('result')));
$smarty->assign('adding',$do_add);
$smarty->assign('mod',$this);
$smarty->assign('actionid',$id);
$smarty->assign('node',$node);
$smarty->assign('formstart',$this->CreateFormStart($id,'admin_edit_node',$returnid,'post','',true,'',$params));
$smarty->assign('formend',$this->CreateFormEnd());
echo $this->ProcessTemplate('admin_edit_node.tpl');

#
# EOF
#
?>