<?php
#-------------------------------------------------------------------------
# Module: Decision Tree
# Version: 0.2, SjG
#  (with modifications by calguy1000)
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2009 by Ted Kulp (ted@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/decisiontree/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class DecisionTree extends CMSModule
{
  
  function GetName()
  {
    return 'DecisionTree';
  }
  
  function GetFriendlyName()
  {
    return $this->Lang('friendlyname');
  }
  function GetVersion()
  {
    return '0.2.2';
  }
  function GetHelp()
  {
    return $this->Lang('help');
  }
  function GetAuthor()
  {
    return 'SjG';
  }
  function GetAuthorEmail()
  {
    return 'sjg@cmsmodules.com';
  }
  function GetChangeLog()
  {
    return $this->Lang('changelog');
  }
  function IsPluginModule()
  {
    return true;
  }
  function HasAdmin()
  {
    return true;
  }
  function GetAdminSection()
  {
    return 'content';
  }
  function GetAdminDescription()
  {
    return $this->Lang('moddescription');
  }
  function VisibleToAdminUser()
  {
    return $this->CheckPermission('Modify Any Page') || $this->CheckPermission('Modify Templates');
  }
  function GetDependencies()
  {
    return array();
  }
  function MinimumCMSVersion()
  {
    return "1.5";
  }
  function SetParameters()
  {
  $this->RegisterModulePlugin(); 
  $this->RestrictUnknownParams();
  
  $this->CreateParameter('tree','',$this->Lang('help_tree'));
  $this->SetParameterType('tree',CLEAN_STRING);
  $this->SetParameterType('data',CLEAN_STRING);
  $this->CreateParameter('tree_id','',$this->Lang('help_tree_id'));
  $this->SetParameterType('tree_id',CLEAN_INT);
  $this->CreateParameter('dec_id','',$this->Lang('help_dec_id'));
  $this->SetParameterType('dec_id',CLEAN_INT);
  }
  function InstallPostMessage()
  {
    return $this->Lang('postinstall');
  }
  function UninstallPostMessage()
  {
    return $this->Lang('postuninstall');
  }
  function GetHeaderHtml()
  {
    $str = '<script type="text/javascript" src="'.$this->GetModuleUrlPath().'/treeTable/src/javascripts/jquery.treeTable.min.js"></script>'."\n";
    $str .= '<link rel="stylesheet" type="text/css" href="'.$this->GetModuleUrlPath().'/treeTable/src/stylesheets/jquery.treeTable.css" />'."\n";
    return $str;
  }

  function deleteTreeById($tree_id)
  {
	global $gCms;
	$db = &$gCms->GetDb();
   $query = 'DELETE from '.cms_db_prefix().
      'module_dectree_decs where tree_id = ?';
   $result = $db->Execute($query,array($tree_id));
   $query = 'DELETE from '.cms_db_prefix().
      'module_dectree_trees where tree_id = ?';
   $result = $db->Execute($query,array($tree_id));
  }

  protected function emit_xml_node($row,$sparse = FALSE)
  {
    $xmlstr = '';
    $xmlstr .= "<decision>\n";
    $xmlstr .= "<name><![CDATA[".$row['decision']."]]></name>\n";
    if (!empty($row['prompt']))
      {
	$xmlstr .= "<prompt><![CDATA[".$row['prompt']."]]></prompt>\n";
      }
    $xmlstr .= "<is_result>".$row['is_result']."</is_result>\n";
    if( !$sparse )  $xmlstr .= "<decision_id>".$row['decision_id']."</decision_id>\n";
    if( !$sparse || $row['returns'] )  $xmlstr .= "<returns><![CDATA[".$row['returns']."]]></returns>\n";
    if( !$sparse || $row['suggestion'] )$xmlstr .= "<suggestion><![CDATA[".$row['suggestion']."]]></suggestion>\n";
    if( !$sparse || $row['alternate'] )$xmlstr .= "<alternate><![CDATA[".$row['alternate']."]]></alternate>\n";
    if( isset($row['children']) )
      {
	for( $i = 0; $i < count($row['children']); $i++ )
	  {
	    $xmlstr .= $this->emit_xml_node($row['children'][$i]);
	  }
      }
    $xmlstr .= "</decision>\n";

    return $xmlstr;
  }


  function emit_xml(&$params)
  {
	global $gCms;
	$db = &$gCms->GetDb();
	
	$xmlstr = '<?xml version="1.0"?>';
	$xmlstr .= "\n<decisions>\n";

	if (isset($params['final']))
		{
		$query = 'SELECT * from '.cms_db_prefix().
			'module_dectree_decs where decision_id=? and tree_id=?';
		}
	else
		{
		$query = 'SELECT * from '.cms_db_prefix().
			'module_dectree_decs where parent_id=? and tree_id=? order by order_by';
		}

	$result = $db->Execute($query,array($params['dec_id'],$params['tree_id']));
	while ($result !== false && $row=$result->FetchRow())
	   {
	     $xmlstr .= $this->emit_xml_node($row);
	   }
	$xmlstr .= '</decisions>';
	$this->SetContentType('text/xml');
	return $xmlstr;
  }


  protected function get_raw_tree($tree_id, $parent_id = -1)
  {
    $db = cmsms()->GetDb();
    $query = 'SELECT * FROM '.cms_db_prefix().'module_dectree_decs WHERE tree_id = ? AND parent_id = ? ORDER BY order_by';
    $data = $db->GetArray($query,array($tree_id,$parent_id));
    if( !is_array($data) ) return;

    for( $i = 0; $i < count($data); $i++ )
      {
	$tmp = $this->get_raw_tree($tree_id, $data[$i]['decision_id']);
	if( is_array($tmp) && count($tmp) )
	  {
	    $data[$i]['children'] = $tmp;
	  }
      }

    return $data;
  }

} //end class
?>
