<?php
if (isset($params['submit'])) {
	$doubleitem = $this->products->CheckDoubleItemNumber($params['itemnumber'], -1); 
	if (!$this->GetPreference('allowdoubleitem', 0) && $doubleitem != false) {
		$smarty->assign('message', $this->Lang ('message_doubleitemnumberfound', $doubleitem));
	}
	else {
		// User pressed continue so save the product information and after that the connection to the category
		$this->products->Create($params);
		$this->products->CreateCategoryMap($params['category_id'], $params['product_id']);
		
		$params = array('active_tab'=>'categories', 'current_category_id'=>$params['current_category_id']);
		$this->Redirect( $id, 'defaultadmin', $returnid, $params );
	}
}

if (isset($params['cancel'])) {
	$params = array('active_tab'=>'categories', 'current_category_id'=>$params['current_category_id']);
	$this->Redirect( $id, 'defaultadmin', $returnid, $params );
}

$product = array();
$product['startform'] = $this->CreateFormStart( $id, 'product_add', $returnid, 'post');
$product['submit'] = $this->CreateInputSubmit ($id, 'submit', $this->Lang('continue'));
$product['cancel'] = $this->CreateInputSubmit ($id, 'cancel', $this->Lang('cancel'));
$product['endform'] = $this->CreateFormEnd();

$product['current_category_id'] = array(
	'label'=>'',
	'input'=>$this->CreateInputHidden( $id, 'current_category_id', $params['current_category_id'])
);

$categorydropdown = $this->categories->BuildList($params['current_category_id'], '', 0);
$product['category_id'] = array(
	'label'=>$this->Lang('label_product_category_id'),
	'input'=>$this->CreateInputDropdown( $id, 'category_id', $categorydropdown, -1, intval($params['current_category_id']))
);

$product['name'] = array(
	'label'=>$this->Lang('label_product_name'),
	'input'=>$this->CreateInputText( $id, 'name', $params['name'], 40, 40)
);
$product['description'] = array(
	'label'=>$this->Lang('label_product_description'),
	'input'=>$this->CreateTextArea(true, $id, '', 'description', 'pagesmalltextarea', '', '', '', 40, 40)
);
$product['price'] = array(
	'label'=>$this->Lang('label_product_price'),
	'input'=>$this->CreateInputText( $id, 'price', '', 40, 40)
);
$product['active'] = array(
	'label'=>$this->Lang('label_product_active'),
	'input'=>$this->CreateInputCheckbox( $id, 'active', true)
);
$product['featured'] = array(
	'label'=>$this->Lang('label_product_featured'),
	'input'=>$this->CreateInputCheckbox( $id, 'featured', true)
);
$product['netweight'] = array(
	'label'=>$this->Lang('label_product_netweight'),
	'input'=>$this->CreateInputText( $id, 'netweight', '', 10, 20),
	'unit'=>$this->GetPreference('weightunitmeasure', 'Kg')
);
// Prepare list of possible VAT codes as set up in Cart Made Simple
$cartms =& $this->GetModuleInstance('CartMadeSimple');
if( $cartms ) { 
	$vatcode = '';
	$listvatcode[$cartms->GetPreference('vat0name', '')] = '0';
	$listvatcode[$cartms->GetPreference('vat1name', '')] = '1';
	$listvatcode[$cartms->GetPreference('vat2name', '')] = '2';
	$listvatcode[$cartms->GetPreference('vat3name', '')] = '3';
	$listvatcode[$cartms->GetPreference('vat4name', '')] = '4';
	$product['vatcode'] = array(
		'label'=>$this->Lang('label_product_vatcode'),
		'input'=>$this->CreateInputDropdown( $id, 'vatcode', $listvatcode, -1, $vatcode)
	);
}
else {
	$product['vatcode'] = array(
		'label'=>$this->Lang('label_product_vatcode'),
		'input'=>$this->CreateInputText( $id, 'vatcode', '', 1, 1)
	);
}

$skudropdown = $this->BuildListSKU();
$product['sku'] = array(
	'label'=>$this->Lang('label_product_sku'),
	'input'=>$this->CreateInputDropdown( $id, 'sku', $skudropdown, -1, $this->GetPreference('default_sku', ''))
);

$product['itemnumber'] = array(
	'label'=>$this->Lang('label_product_itemnumber'),
	'input'=>$this->CreateInputText( $id, 'itemnumber', '', 30, 30)
);

$product['position'] = array(
	'label'=>$this->Lang('label_product_position'),
	'input'=>$this->CreateInputText( $id, 'position', '', 10, 10)
);
// Check if inventory in place. If so use different label
$inventorytype = $this->GetPreference('inventorytype');
if ($inventorytype == 'prod') {
	$label_product_maxattributes = $this->Lang('label_quantity_onstock');
}
else {
	$label_product_maxattributes = $this->Lang('label_product_maxattributes');
}
$product['maxattributes'] = array(
	'label'=>$label_product_maxattributes,
	'input'=>$this->CreateInputText( $id, 'maxattributes', $this->GetPreference('default_maxattributes', 1), 10, 10)
);

$smarty->assign('product', $product);
echo $this->ProcessTemplate('product_add.tpl');

?>