<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFBApp (c) 2010 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  A toolbox of conveniences to build facebook integration into a website
#  for CMS modules and website designers.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

/**
 *
 */
class cgfb_smarty
{
  /**
   * Get a preference
   */
  private static function get_preference($name)
  {
    $mod = cge_utils::get_module('CGFBApp');
    return $mod->GetPreference($name);
  }

  /**
   * Get an image from the module directory.
   */
  private static function get_image($name)
  {
    $mod = cge_utils::get_module('CGFBApp');
    $url = $mod->GetModuleURLPath()."/images/$name";
    return $url;
  }


  /**
   * Initialize the smarty plugins.
   */
  public static function init()
  {
    $smarty = cmsms()->GetSmarty();

    $smarty->register_function('cgfb_login',array('cgfb_smarty','login_button'));
    $smarty->register_function('cgfb_logout',array('cgfb_smarty','logout_button'));
    $smarty->register_function('cgfb_api',array('cgfb_smarty','api'));
    $smarty->register_function('cgfb_me',array('cgfb_smarty','me'));
    $smarty->register_function('cgfb_uid',array('cgfb_smarty','uid'));
    $smarty->register_function('cgfb_app',array('cgfb_smarty','app'));
    $smarty->register_function('cgfb_comments',array('cgfb_smarty','comments'));
    $smarty->register_function('cgfb_send',array('cgfb_smarty','send'));
    $smarty->register_function('cgfb_wallpost',array('cgfb_smarty','wallpost'));
    $smarty->register_function('cgfb_status',array('cgfb_smarty','status'));
    $smarty->register_function('cgfb_like',array('cgfb_smarty','likebtn'));
    $smarty->register_function('cgfb_invite',array('cgfb_smarty','invite'));
    $smarty->register_function('cgfb_init',array('cgfb_smarty','init_fb'));
    $smarty->register_function('cgfb_fql',array('cgfb_smarty','fql'));
    $smarty->register_function('cgfb_fql_multi',array('cgfb_smarty','fql'));
  }


  /**
   * A smarty plugin to perform an api call using the users access token.
   *
   * special paramters:
   * call: string - contains the URL to call
   * assign: string - assign the results to the specified smarty variable.
   */
  public static function api($params,&$smarty)
  {
    if( !isset($params['call']) ) return;

    $call = trim($params['call']);
    unset($params['call']);

    $res = cgfb::api($call,'GET',$params);
    if( !$res ) return;

    if( isset($params['assign']) )
      {
	$smarty->assign($params['assign'],$res);
	return;
      }

    return $res;
  }


  /**
   * A smarty plugin to display a login button if the user is not currently
   * logged into facebook.
   *
   * special params:
   * width: int
   * height: int
   * faces: boolean
   * max_rows: int
   * fb_perms: string
   *
   * url_only: bool
   * image: string
   * assign: string
   */
  public static function login_button($params, &$smarty)
  {
    $output = '';

    // static html
    if( cgfb::uid() ) return;

    $url = cgfb::get_login_url();
    $url = str_replace('&','&amp;',$url);
    if( isset($params['urlonly']) )
      {
	$output = $url;
      }
    else
      {
	$params['url'] = $url;
	if( !isset($params['image']) )
	  {
	    $params['image'] = self::get_image('fb_login.gif');
	  }
	$output = cge_tags::link_tag($params);
      }

    // handle assign
    if( isset($params['assign']) )
      {
	$smarty->assign($params['assign'],$output);
	return;
      }
    return $output;
  }


  /**
   * Create a facebook logout button if the user is already logged in
   *
   * special params:
   * urlonly: string
   * image: string
   * assign: string
   */
  static public function logout_button($params,&$smarty)
  {
    if( !self::use_xfbml() )
      {
	if( !cgfb::uid() ) return;

	$url = cgfb::get_logout_url();
	$output = '';
	if( isset($params['urlonly']) )
	  {
	    $output = $url;
	  }
	else
	  {
	    $params['url'] = $url;
	    if( !isset($params['image']) )
	      {
		$params['image'] = self::get_image('fb_logout.gif');
	      }
	    $output = cge_tags::link_tag($params);
	  }

	// handle assign
	if( isset($params['assign']) )
	  {
	    $smarty->assign($params['assign'],$output);
	    return;
	  }

	return $output;
      }
  }


  /**
   * Retrieve the information about the currently logged in user
   *
   * special params:
   * assign: string
   */
  public static function me($params,&$smarty)
  {
    $me = cgfb::me();
    if( !is_array($me) ) return;

    if( isset($params['assign']) )
      {
	$smarty->assign($params['assign'],$me);
	return;
      }
    return $me;
  }


  /**
   * Retrieve the currently logged in users facebook user id.
   *
   * special params:
   * assign: string
   */
  public static function uid($params,&$smarty)
  {
    $uid = cgfb::uid();
    if( !$uid ) return;

    if( isset($params['assign']) )
      {
	$smarty->assign($params['assign'],$uid);
	return;
      }
    return $uid;
  }


  /**
   * Retrieve information about the current application.
   *
   * special params:
   * assign: string
   * call:   string url portion to call (see facebook graph API)
   */
  public static function app($params,&$smarty)
  {
    $mod = cge_utils::get_module('CGFBApp');
    $appid = $mod->GetPreference('fb_appid');

    $call = $appid;
    if( isset($params['call']) )
      {
	$call .= '/'.trim($params['call']);
	unset($params['call']);
      }

    $res = cgfb::api($call);
    if( !$res ) return;

    if( isset($params['assign']) )
      {
	$smarty->assign($params['assign'],$res);
	return;
      }

    return $res;
  }


  /**
   * Display a box allowing users to comment on an object
   *
   * special params:
   * uniqueid: string
   * width: int
   * ncomments: int
   * publish: bool
   * assign: string
   */
  public static function comments($params,&$smarty)
  {
    $uniqueid = 'r'.md5(cge_url::current_url());
    $width = 425;
    $ncomments = 10;
    $publish = 1;

    if( isset($params['uniqueid']) ) 
      {
	$uniqueid = trim($params['uniqueid']);
      }
    if( isset($params['width']) ) 
      {
	$width = (int)$params['width'];
      }
    if( isset($params['ncomments']) ) 
      {
	$ncomments = (int)$params['ncomments'];
      }
    if( isset($params['publish']) ) 
      {
	$publish = (int)$params['publish'];
      }

    if( $publish )
      {
	$publish = 'true';
      }
    else
      {
	$publish = 'false';
      }

    $opts = array();
    if( $uniqueid ) $opts[] = 'xid="'.$uniqueid.'"';
    $opts[] = 'publish="'.$publish.'"';
    $opts[] = 'width="'.$width.'"';
    $opts[] = 'numposts="'.$ncomments.'"';
    $output = '<fb:comments '.implode(' ',$opts).'></fb:comments>';
    
    if( isset($params['assign']) )
      {
	$smarty->assign($params['assign'],$output);
	return;
      }

    return $output;
  }


  /**
   * A smarty plugin to display a like button
   *
   * special params:
   * href: string
   * layout: string (standard,button_count,box_count)
   * show_faces: bool
   * action: string (like|recommend)
   * width: int
   * font: string (arial|licida grande|segos ul|tahoma|trebuchet ms|verdana)
   * colorscheme: string (light|dark)
   * ref: string
   * assign: string
   */
  public static function likebtn($params,&$smarty)
  {
    $parms = array();
    $parms['href'] = cge_url::current_url();

    foreach( $params as $key => $value )
      {
	switch( $key )
	  {
	  case 'href':
	    $parms['href'] = trim($value);
	    break;

	  case 'layout':
	    $value = strtolower($value);
	    switch( $value )
	      {
	      case 'standard':
	      case 'button_count':
	      case 'box_count':
		$parms[$key] = $value;
		break;
	      }
	    break;

	  case 'show_faces':
	    if( $value ) $value = 'true';
	    else $value = 'false';
	    $parms[$key] = $value;
	    break;

	  case 'action':
	    $value = strtolower($value);
	    if( $value == 'like' || $value == 'recommend' )
	      $parms[$key] = $value;
	    break;

	  case 'width':
	    $parms[$key] = (int)$value;
	    break;

	  case 'font':
	    $value = strtolower($value);
	    switch( $value )
	      {
	      case 'arial':
	      case 'lucida grande':
	      case 'segoe ui':
	      case 'tahoma':
	      case 'trebuchet ms':
	      case 'verdana':
		$parms[$key] = $value;
		break;
	      }
	    break;

	  case 'colorscheme':
	    $value = strtolower($value);
	    if( $value == 'light' || $value == 'dark' )
	      {
		$parms[$key] = $value;
	      }
	    break;

	  case 'ref':
	    $parms[$key] = $value;
	    break;
	  }
      }

    $output = '<fb:like ';
    foreach( $parms as $key => $value )
      {
	$output .= ' '.$key.'="'.$value.'"';
      }
    $output .= '></fb:like>';

    if( isset($params['assign']) )
      {
	$smarty->assign($params['assign'],$output);
	return;
      }

    return $output;
  }


  /**
   * Generic function to do an API POST call
   *
   * special params:
   * this method accepts misc parameters, see the graph API
   * call:  string: URL portion for graph API
   * as_app: bool - should api call happen as the application or as the user.
   * assign: string
   */
  public static function send($params,&$smarty)
  {
    if( !isset($params['uri']) ) return;

    $uri = trim($params['uri']);
    if( !startswith($uri,'/') ) $uri = '/'.$uri;
    unset($params['uri']);

    $res = null;
    if( isset($params['as_app']) && $params['as_app'] )
      {
	unset($params['as_app']);
	$res = cgfb::app_api($uri,'POST',$params);
      }
    else
      {
	$res = cgfb::api($uri,'POST',$params);
      }

    if( isset($params['assign']) )
      {
	$smarty->assign($params['assign'],$res);
	return;
      }

    return $res;
  }


  /**
   * A function to create a wall post
   *
   * special params:
   * to:   string -- optional (me is assumed)
   * msg:  string -- required
   * name: string -- required
   * href: string -- required
   * caption: string
   * desc: string
   * xid:  string
   * prop: string name,value[,href]
   * data: string name,value
   * action1: string name::href
   * action2: string name::href
   * action3: string name::href
   * image1: string src:::href
   * image2: string src:::href
   * image3: string src:::href
   * image4: string src:::href
   * image5: string src:::href
   * images: (hash) of src=href ... replaces image1-5
   */
  public static function wallpost($params,&$smarty)
  {
    $to = trim(get_parameter_value($params,'to','me'));
    $msg = trim(get_parameter_value($params,'msg'));
    $name = trim(get_parameter_value($params,'name'));
    $href = trim(get_parameter_value($params,'href'));
    $caption = trim(get_parameter_value($params,'caption'));
    $description = trim(strip_tags(get_parameter_value($params,'desc')));

    if( !$msg ) return;
    try
      {
	$post = new cgfb_post($msg,$to);

	$att = null;
	if( $name )
	  {
	    $att = new cgfb_post_attachment($name,$href,$caption,$description);
	    $have_image = FALSE;
	    foreach( $params as $key => $value )
	      {
		if( $key == 'xid' )
		  {
		    $att->comments_xid = $value;
		    continue;
		  }
		else if( $key == 'images' && !$have_image )
		  {
		    if( is_array($value) )
		      {
			foreach( $value as $k => $v )
			  {
			    $att->add_media('image',$k,$v);
			  }
		      }
		    $have_image = TRUE;
		  }
		else if( startswith($key,'prop') )
		  {
		    list($k,$v,$h) = explode(',',$value,3);
		    if( $k && $v )
		      {
			$att->add_property($k,$v,$h);
		      }
		  }
		else if( startswith($key,'data') )
		  {
		    list($k,$v) = explode(',',$value,2);
		    $att->add_data($k,$v);
		  }
		else if( startswith($key,'image') && !$have_image )
		  {
		    list($s,$h) = explode(':::',$value,2);
		    $att->add_media('image',$s,$h);
		  }
                else if( startswith($key,'action') )
                  {
                    list($n,$h) = explode(':::',$value,2);
                    if( empty($h) )
                      list($n,$h) = explode(',',$value,2);
                    $tmp = (int)substr($key,strlen('action'));
                    if( $tmp < 1 || $tmp > 3 ) continue;
		    $post->add_action($n,$h);
                  }
	      }

	    $post->set_attachment($att);
	  }

	$data = array_merge(array('method'=>'stream.publish'),$post->to_array());
	$res = cgfb::rest($data);
	if( isset($params['assign']) )
	  {
	    $smarty->assign($params['assign'],$res);
	    return;
	  }
	return $res;
      }
    catch( Exception $e )
      {
	// nothing to do here.
        die('ERROR: '.$e->getMessage());
      }
  }


  /**
   * A function to POST on a users wall
   *
   * special params:
   * to: string - uid of the user, wall, or page to send to
   * msg: string - the message to send
   * action1: string - name=link for sending links
   * action2: string - name=link for sending links
   * action3: string - name=link for sending links
   */
  public static function status($params,&$smarty)
  {
    $to = get_parameter_value($params,'to','me');
    $msg = get_parameter_value($params,'msg');    
    if( !$msg ) return;

    try
      {
	$obj = new cgfb_post($msg,$to);
	$data = $obj->to_array();
	$args = array('as_app','action1','action2','action3');
	$argmap = array('desc'=>'description');
	foreach( $params as $key => $value )
	  {
	    if( in_array($key,$args) )
	      {
		// translate our name to facebooks param name.
		if( isset($argmap[$key]) )
		  {
		    $key = $argmap[$key];
		  }

		// special cases for certain params
		if( $key == 'to' )
		  {
		    $uri = $params['to'].'/feed';
		    unset($params['to']);
		    $data['uri'] = $uri;
		    continue;
		  }

		$data[$key] = $value;
	      }
	  }

	$data = array_merge(array('method'=>'stream.publish'),$data);
	$res = cgfb::rest($data);
      }
    catch( Exception $e )
      {
	// nothing to do here.
        die('ERROR: '.$e->getMessage());
      }

    return $res;
  }


  /**
   * A smarty function to display an invite form
   *
   * special params:
   * assign: string
   * dest_url: string
   * app_name: string
   * exclude_ids: string
   * content: string
   * border: bool
   * email_invite: bool
   * import_external_friends: bool
   * condensed: bool
   * rows: int (1 to 10)
   * cols: int (2|3|5)
   * max: int (1 to 35)
   * bypass: string (step|skip|cancel)
   * template: string
   */
  public static function invite($params,&$smarty)
  {
    static $cnt = 0;
    $mod = cge_utils::get_module('CGFBApp');
    $vars = array();
    $vars['as_app'] = 1;
    $vars['method'] = 'GET';
    $vars['dest_url'] = cge_url::page_url();
    $vars['app_name'] = get_site_preference('sitename','CMSMS Site');
    $vars['action_text'] = $mod->Lang('dflt_action_text');
    $vars['border'] = 'true';
    
    foreach( $params as $key => $value )
      {
	switch( $key )
	  {
	  case 'assign':
	    // nothing to do here.
	    break;

	  case 'method':
	    $value = strtoupper($value);
	    if( $value == 'GET' || $value == 'POST' )
	      {
		$vars[$key] = trim($value);
	      }
	    break;

	  case 'dest_url':
	  case 'app_name':
	  case 'action_text':
	  case 'exclude_ids':
	  case 'content':
	    $vars[$key] = trim($value);
	    break;

	  case 'border':
	  case 'email_invite':
	  case 'import_external_friends':
	  case 'condensed':
	    $value = cge_utils::to_bool($value);
	    $value = ($value?'true':'false');
	    $vars[$key] = $value;
	    break;
	    
	  case 'rows':
	    $value = (int)$value;
	    $value = max($value,3);
	    $value = min($value,10);
	    $vars[$key] = $value;
	    break;

	  case 'cols':
	    $value = (int)$value;
	    if( $value == 2 || $value == 3 || $value == 5 )
	      {
		$vars[$key] = $value;
	      }
	    break;

	  case 'max':
	    $value = (int)$value;
	    $value = max($value,1);
	    $value = min($value,35);
	    $vars[$key] = $value;
	    break;

	  case 'bypass':
	    $value = strtolower($value);
	    if( $value == 'step' || $value == 'skip' || $value == 'cancel' )
	      {
		$vars[$key] = trim($value);
	      }
	    break;
	  }
      }

    // do final checks
    $vars['dest_url'] = cms_htmlentities($vars['dest_url']);
    $vars['content'] = cms_htmlentities($vars['content']);
    $vars['app_name'] = cms_htmlentities($vars['app_name']);

    // get the output.
    $hash = md5('invite'.$cnt++.serialize($params));
    $smarty->assign('hash',$hash);
    foreach( $vars as $key => $value )
      {
	$smarty->assign($key,$value);
      }

    $thetemplate = $mod->GetPreference(CGFBApp::PREF_INVITE_TEMPLATE);
    if( isset($params['template']) )
      {
	$thetemplate = trim($params['template']);
      }
    $output = $mod->ProcessTemplateFromDatabase('invite_'.$thetemplate);

    if( isset($params['assign']) )
      {
	$smarty->assign($params['assign'],$output);
	return;
      }
    return $output;
  }


  /**
   * A smarty function to output the javascript for initializing the Facebook Javascript SDK
   */
  public static function init_fb($params,&$smarty)
  {
    $async = false;
    if( isset($params['async']) )
      {
	$async = cge_utils::to_bool(trim($params['async']));
      }

    $output = '';
    $mod = cge_utils::get_module('CGFBApp');
    $appid = $mod->GetPreference('fb_appid');
    $smarty->assign('fb_appid',$appid);
    if( $async )
      {
	$output = $mod->ProcessTemplateFromDatabase('fbinit_async');
      }
    else
      {
	$output = $mod->ProcessTemplateFromDatabase('fbinit_sync');
      }
    
    if( !$output ) return;

    if( isset($params['assign']) )
      {
	$smarty->assign(trim($params['assign']),$output);
	return;
      }

    return $output;
  }


  /**
   * A smarty function to execute an arbitrary FQL query
   */
  public static function fql($params,&$smarty)
  {
    if( !isset($params['fql']) ) return;

    $fql = trim($params['fql']);
    unset($params['fql']);

    $res = cgfb::fql($fql);

    if( isset($params['assign']) )
      {
	$smarty->assign($params['assign'],$res);
	return;
      }
    return $res;
  }

  
  /**
   * A smarty function to execute fql_multiquery
   */
  public static function fql_multiquery($params,&$smarty)
  {
    $q = array();
    foreach($params as $k => $v)
      {
	if( startswith($k,'query') )
	  {
	    $q[] = $v;
	  }
      }

    $res = cgfb::fql_multi($q);
    if( isset($params['assign']) )
      {
	$smarty->assign($params['assign'],$res);
	return;
      }
    return $res;
  }
} // end of class


#
# EOF
#
?>
