<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFBApp (c) 2010 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  A toolbox of conveniences to build facebook integration into a website
#  for CMS modules and website designers.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class cgfb_og_smarty
{
  static private $_initialized;

  public static function init()
  {
    $smarty = cmsms()->GetSmarty();

    $smarty->register_function('cgfb_og_value',array('cgfb_og_smarty','og_value'));
    $smarty->register_function('cgfb_og_title',array('cgfb_og_smarty','og_title'));
    $smarty->register_function('cgfb_og_type',array('cgfb_og_smarty','og_type'));
    $smarty->register_function('cgfb_og_url',array('cgfb_og_smarty','og_url'));
    $smarty->register_function('cgfb_og_image',array('cgfb_og_smarty','og_image'));
    $smarty->register_function('cgfb_og_sitename',array('cgfb_og_smarty','og_sitename'));
    $smarty->register_function('cgfb_og_desc',array('cgfb_og_smarty','og_desc'));
    $smarty->register_function('cgfb_og_admins',array('cgfb_og_smarty','og_admins'));
    $smarty->register_function('cgfb_og_meta',array('cgfb_og_smarty','og_meta'));
  }


  protected static function og_setvalue($key,$value)
  {
    if( !$key ) return;

    $data = array();
    if( cge_tmpdata::exists('cgfb_og') )
      {
	$data = cge_tmpdata::get('cgfb_og');
      }
    $data[$key] = $value;
    cge_tmpdata::set('cgfb_og',$data);
  }


  public static function og_value($params,&$smarty)
  {
    if( !isset($params['name']) || !isset($params['value']) ) return;

    $key = $params['name'];
    $val = $params['value'];
    self::og_setvalue($key,$val);
  }


  public static function og_title($params,&$smarty)
  {
    if( isset($params['title']) )
      {
	self::og_setvalue('og:title',trim($params['title']));
      }
  }


  public static function og_type($params,&$smarty)
  {
    if( isset($params['type']) )
      {
	self::og_setvalue('og:type',trim($params['type']));
      }
  }


  public static function og_url($params,&$smarty)
  {
    if( isset($params['url']) )
      {
	self::og_setvalue('og:url',trim($params['url']));
      }
  }


  public static function og_image($params,&$smarty)
  {
    if( isset($params['image']) )
      {
	self::og_setvalue('og:image',trim($params['image']));
      }
  }


  public static function og_sitename($params,&$smarty)
  {
    if( isset($params['sitename']) )
      {
	self::og_setvalue('og:site_name',trim($params['sitename']));
      }
  }


  public static function og_desc($params,&$smarty)
  {
    if( isset($params['desc']) )
      {
	self::og_setvalue('og:description',trim($params['desc']));
      }
  }


  public static function og_admins($params,&$smarty)
  {
    if( isset($params['admins']) )
      {
	self::og_setvalue('fb:admins',trim($params['admins']));
      }
  }


  public static function og_meta($params,&$smarty)
  {
    // render the tags.
    $data = cge_tmpdata::get('cgfb_og');
    $data['fb:app_id'] = cgfb::appid();
    if( !isset($data['og:site_name']) )
      {
	$data['og:site_name'] = get_site_preference('sitenae','CMSMS Site');
      }

    $output = '';
    foreach( $data as $key => $value )
      {
	$output .= '<meta property="'.$key.'" content="'.$value.'"/>';
      }

    // done.
    if( isset($params['assign']) )
      {
	$smarty->assign($params['assign'],$output);
	return;
      }

    return $output;
  }

} // end of class

#
# EOF
#
?>