<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGSmartImage (c) 2011 by Robert Campbell (calguy1000@cmsmadesimple.org)
#  
#  An addon module for CMS Made Simple to allow creating image tags in a smart
#  way to optimize performance.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005-2010 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class CGImage_Croptofit_Filter extends CGImageFilterBase
{
  private $_dest_w = 0;
  private $_dest_h = 0;

    
  public function __construct($input)
  {
    if( cge_array::is_hash($input) )
      {
	if( isset($input['width']) )
	  {
	    $this->_dest_w = (int)$input['width'];
	    $this->_dest_h = (int)$input['height'];
	  }
	else if ( isset($input['w']) )
	  {
	    $this->_dest_w = (int)$input['w'];
	    $this->_dest_h = (int)$input['h'];
	  }
      }
    else if( is_array($input)  )
      {
	if( count($input) == 2 )
	  {
	    $this->_dest_w = (int)trim($input[0]);
	    $this->_dest_h = (int)trim($input[1]);
	  }
      }

    if( $this->_dest_h <= 0 || $this->_dest_w <= 0 )
      {
	throw new Exception('Invalid values specified for Croptofit filter constructor');
      }
  }


  public function transform(CGImageBase $src)
  {
    $src_ratio = (float)$src['width'] / (float)$src['height'];
    $dest_ratio = (float)$this->_dest_w / (float)$this->_dest_h;

    $new_h = '';
    $new_w = '';
    if( $src_ratio > $dest_ratio )
      {
	$new_h = (int) $this->_dest_h;
	$new_w = (int) ($this->_dest_w * $src_ratio);
      }
    else if( $src_ratio < $dest_ratio )
      {
	$new_w = (int) $this->_dest_w;
	$new_h = (int) ($this->_dest_h / $src_ratio );
      }
    
    $tmp_rsrc = imagecreatetruecolor($new_w,$new_h);
    imagesavealpha($tmp_rsrc, true);
    $transparent = imagecolorallocatealpha($tmp_rsrc, 0, 0, 0, 127);
    imagefill($tmp_rsrc, 0, 0, $transparent);

    $res = imagecopyresampled($tmp_rsrc,$src['rsrc'],0,0,0,0,$new_w,$new_h,$src['width'],$src['height']);
    if( $res === FALSE )
      {
	throw new Exception('Croptofit - stage 1 - failed');
      }

    $x0 = (int)( $new_w - $this->_dest_w ) / 2;
    $y0 = (int)( $new_h - $this->_dest_h ) / 2;

    $_dest = new CGImageBase(array($src['type'],$this->_dest_w,$this->_dest_h));
    $res = imagecopy($_dest['rsrc'],$tmp_rsrc,0,0,$x0,$y0,$this->_dest_w,$this->_dest_h);
    if( $res === FALSE )
      {
	throw new Exception('Croptofit - stage 2 - failed');
      }
    
    return $_dest;
  }

} // end of class

#
# EOF
#
?>