<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Banners (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow management, display,
#  and tracking of banner images.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

// test if we are excluding this IP from the counting
$exclude = 0;
if( $this->GetPreference('hide_from_bots',0) )
  {
    // see if we can reasonably detect if this request is from a bot.
    $browser = cge_utils::get_browser();
    if( $browser->isRobot() )
      {
	$exclude = 1;
      }
  }
if( $exclude == 0 )
  {
    // it's not a bot (or we're allowing bots... so we gotta check for subnets
    $subnets = explode(",",$this->GetPreference("subnet_exclusions"));
    $test = 0;
    foreach($subnets as $subnet)
      {
	$test = $this->_testip( $subnet, cge_utils::get_real_ip() );
	if( $test )
	  {
	    // don't allow any more processing
	    $exclude = 1;
	  }
      }
  }


    // test if we are excluding the REMOTE_ADDR from statistics gathering
    if( !isset( $params['category'] ) ) 
      {
	$this->_DisplayErrorPage ($id, $params, $returnid,
				  $this->Lang ('error_insufficientparams'));
	return;
      }

    $category_id=-1;
    $category="";
    {
      // lookup the category name and get the id
      $q2 = "SELECT * FROM ".cms_db_prefix()."module_banners_categories WHERE name = ?";
      $dbresult = $db->Execute( $q2, array( $params['category'] ) );
      if( !$dbresult ) 
	{
	  $this->_DisplayErrorPage ($id, $params, $returnid,
				    "ERROR: Could not find category ".
				    $this->Lang ('error_dberror'));
	  return;
	}
      $category = $dbresult->FetchRow();
      if( !$category ) 
	{
	  $this->_DisplayErrorPage ($id, $params, $returnid,
				    "ERROR: Could not find category (no rows) ".
				    $this->Lang ('error_dberror'));
	  return;
	}
      $category_id = $category['category_id'];
      $smarty->assign('category',$category);
    }

    $now = $db->DbTimeStamp(time());
    $from = "SELECT * FROM ".cms_db_prefix()."module_banners WHERE (category_id = \"$category_id\") AND";
    $where .= "(start_date <= $now) AND (expires > $now or isnull(expires)) AND (max_impressions = 0 OR num_impressions < max_impressions)";
    $order = "ORDER BY RAND()";
    $limit = "LIMIT 0,1";

    // do we want a specific banner
    if( isset( $params['mode'] ) && $params['mode'] == 'sequential' )
      {
	$order = "ORDER BY last_impression ASC";
      }

    if( isset( $params['name'] ) )
      {
	$where .= " AND NAME = \"".$params['name']."\"";
      }

    $query = $from . " " . $where . " " . $order . " " . $limit;

    $row = $db->GetRow( $query );
    if( !$row ) 
      {
	// nothing to display...
	$exclude = 1;
	if( isset($category['dflt_image']) )
	  {
	    // the default image.
	    $row = array();
	    $row['image'] = $category['dflt_image'];
	    if( $category['dflt_url'] )  $row['clickthrough'] = $category['dflt_url'];
	    $row['name'] = $this->Lang('your_ad_here');
	  }
	else
	  {
	    echo '<!-- '.$this->GetName().': Could not find an image to display ('.$db->ErrorMsg().')-->';
	    return;
	  }
      }

    // image,url or text may be set here.
    // gotta figure out which
    if( is_array($row) && isset( $row['image'] ) )
      {
	if( empty($row['text']) )
	  {
	    $row['text'] = 'Banner';
	  }

	$row['clickthrough'] = $this->CreateLink($id,'link',$returnid,'',
 			         array('banner_id'=>$row['banner_id'],
				     'category_id'=>$category_id),
					'', true);

	$smarty->assign('banner',$row);
      }
    
$smarty->assign('action_params',$params);
echo $this->ProcessTemplateFromData($category['template']);

    // update the impressions
    if( $exclude == 0 ) {
      $impressions = $row["num_impressions"] + 1;
      $query = "UPDATE ".cms_db_prefix()."module_banners 
                   SET num_impressions = $impressions, last_impression = NOW() 
                 WHERE banner_id=".$row["banner_id"]; 
      $dbresult = $db->Execute( $query ); 
    }

?>
