<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Banners (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow management, display,
#  and tracking of banner images.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

if( !$this->CheckPermission('Manage Banners') )
  {
    return;
  }

    if( !isset($params['category_id']) ) 
      {
	$this->_DisplayErrorPage ($id, $params, $returnid,
				  $this->Lang ('error_insufficientparams'));
	return;
      }
  
    $smarty->assign ('title', $this->Lang ('addbanner'));
    $smarty->assign ('startform',
			   $this->CreateFormStart ($id,
						   'do_addbanner',
						   $returnid));
    $smarty->assign ('endform', $this->CreateFormEnd ());
    $smarty->assign ('submit',
			   $this->CreateInputSubmit ($id, 'submit',
						     'Submit'));
    $smarty->assign ('cancel',
			   $this->CreateInputSubmit ($id, 'cancel',
						     'Cancel'));
  
    $smarty->assign ('prompt_bannername',
			   $this->Lang ('name'));
    $smarty->assign ('input_bannername',
			   $this->CreateInputText ($id, 'input_bannername',
						   "", 20, 80));
    $smarty->assign ('prompt_bannerdesc',
			   $this->Lang ('description'));
    $smarty->assign ('input_bannerdesc',
			   $this->CreateInputText ($id, 'input_bannerdesc',
						   "", 80, 255));
  
    $smarty->assign ('prompt_image',
			   $this->Lang ('image'));
    $smarty->assign ('input_image',
			   $this->CreateInputText ($id, 'input_image',
						   "", 50, 255));
    $smarty->assign ('info_image',
			   $this->Lang ('info_image'));
  
    $smarty->assign ('prompt_url',
			   $this->Lang ('url'));
    $smarty->assign ('input_url',
			   $this->CreateInputText ($id, 'input_url',
						   "", 50, 255));
  
    $smarty->assign ('prompt_href_text',
			   $this->Lang ('href_text'));
    $smarty->assign ('input_href_text',
			   $this->CreateInputText ($id, 'input_href_text',
						   '', 80, 255));
    $smarty->assign ('info_href_text',
			   $this->Lang ('info_href_text'));
  
    $smarty->assign ('prompt_image_text',
			   $this->Lang ('image_text'));
    $smarty->assign ('input_image_text',
			   $this->CreateInputText ($id, 'input_image_text',
						   "", 80, 255));
    $smarty->assign ('info_image_text',
			   $this->Lang ('info_image_text'));
  
  
    $smarty->assign ('prompt_max_impressions',
			   $this->Lang ('max_impressions'));
    $smarty->assign ('input_max_impressions',
			   $this->CreateInputText ($id, 'input_max_impressions',
						   "0", 3, 5));
    $smarty->assign ('info_max_impressions',
			   $this->Lang ('info_max_impressions'));
  
$smarty->assign('atttext',$this->Lang('at'));
    $smarty->assign ('prompt_expires',
			   $this->Lang ('expires'));
    $expiresdate = strtotime('+6 months', time());
    $smarty->assign ('expiresdateprefix', $id.'expiresdate_');
    $smarty->assign ('expiresdate', $expiresdate );

    $smarty->assign ('prompt_start',
			   $this->Lang ('start_date'));
    $startdate = strtotime('-3 months', time());
    $smarty->assign ('startdateprefix', $id.'startdate_');
    $smarty->assign ('startdate', $startdate );
  
    $smarty->assign('neverexpires',
			  $this->CreateInputCheckbox($id,'input_neverexpires',0,1).$this->Lang('never'));

    $module =& $this->_getUploadsModule();
    if( $module )
      {
	// get the category info, and find the upload category id
	$query = "SELECT uploads_category_id FROM ".cms_db_prefix()."module_banners_categories ".
	  "WHERE category_id = ?";
	$uploads_category_id = $db->GetOne($query, array($params['category_id']));
	if( $uploads_category_id > 0 )
	  // now get a list of all of the files in that category
	  {
	    $filelist = $module->getCategoryFiles( $uploads_category_id );
	    if( $filelist )
	      {
		$filelist = cge_array::hash_prepend($filelist,-1,$this->Lang('none'));
		$smarty->assign('prompt_upload_file',
				$this->Lang('prompt_upload_file'));
		$smarty->assign('filelist',$filelist);
	      }
	  }
      }

    $smarty->assign('hidden',
			  $this->CreateInputHidden($id,'input_category_id',$params['category_id']));

    // Display the populated template
    echo $this->ProcessTemplate ('addbanner.tpl');

?>