<?php
#-------------------------------------------------------------------------
# Module: Payment Made Simple - A module for handling payments with CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/pms/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
if (!isset($gCms)) exit;

$detailpage = '';
if (isset($params['detailpage'])) {
  $manager =& $gCms->GetHierarchyManager();
  $node =& $manager->sureGetNodeByAlias($params['detailpage']);
  if (isset($node))
    {
    	$content =& $node->GetContent();
    	if (isset($content))
    	{
    		$detailpage = $content->Id();
    	}
    }
  else
  {
  	$node =& $manager->sureGetNodeById($params['detailpage']);
  	if (isset($node))
  	{
  		$detailpage = $params['detailpage'];
  	}
  }
}

if (!$this->CheckPermission('Modify PaymentMadeSimple')) {
	echo $this->ShowErrors($this->Lang('needpermission', array('Modify PaymentMadeSimple')));
	return;
}

$gateway_id = '';
if (isset($params['gateway_id'])) {
	$gateway_id = $params['gateway_id'];
}

// Remove the gateway (might have to check if all payments have been received first)
$query = 'SELECT * FROM '.cms_db_prefix().'module_pms_gateways WHERE gateway_id = ?';
$row = $db->GetRow( $query, array($gateway_id) );
if ($row) {
	// First delete all the attributes
	$query = 'DELETE FROM '.cms_db_prefix().'module_pms_gwattributes WHERE gwgateway_id = ?';
	$db->Execute($query, array($gateway_id) );

	$query = 'DELETE FROM '.cms_db_prefix().'module_pms_gateways WHERE gateway_id = ?';
	$db->Execute($query, array($gateway_id) );
}

// Remove the template now it is no longer needed
$this->DeleteTemplate( 'pms_gateway_' . $row['gateway_code'], $this->GetName());

$params = array('tab_message'=> 'gatewaydeleted', 'active_tab' => 'gateways');
$this->Redirect($id, 'defaultadmin', $returnid, $params);

?>