<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Promotions (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow creating, interfacing with
#  and managing promotions or sales in the E-comemrce suite.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

define('PROMOTIONS_DISCOUNT_PRODUCT','PROMOTIONS_DISCOUNT_PRODUCT');
define('PROMOTIONS_DISCOUNT_AMOUNT','PROMOTIONS_DISCOUNT_PRODUCT');

class promotion_discount
{
  private $_type;
  private $_amt;
  private $_desc;
  private $_promo_id;

  public function get_type()
  {
    return $this->_type;
  }

  public function set_type($type)
  {
    if( $type == PROMOTIONS_DISCOUNT_PRODUCT ||
	$type == PROMOTIONS_DISCOUNT_AMOUNT )
      {
	$this->_type = $type;
      }
  }


  public function get_amount()
  {
    return $this-_amt;
  }


  public function set_amount($amount)
  {
    $this->_amt = $amount;
  }


  public function get_description()
  {
    return $this->_desc;
  }


  public function set_description($description)
  {
    $this->_desc = $description;
  }


  public function get_promo_id()
  {
    return $this->_promo_id;
  }


  public function set_promo_id($id)
  {
    $this->_promo_id = $id;
  }


  public function is_valid()
  {
    if( is_null($this->_type) ||
	is_null($this->_desc) ||
	is_null($this->_amt) || (floatval($this->_amt) <= 0.0) ||
	is_null($this->_promo_id) )
      {
	return FALSE;
      }
    return TRUE;
  }
} // class

#
# EOF
#
?>