<?php
#A
$lang['addcategory'] = 'Add A New Category';
$lang['addedit_feed'] = 'Add/Edit RSS Feed';
$lang['addfeed'] = 'Add A New Feed';
$lang['areyousure_delete'] = 'Are you sure you want to delete this item?';

#B

#C
$lang['cancel'] = 'Cancel';
$lang['categories'] = 'Categories';
$lang['current_value'] = 'Current Value';

#D
$lang['delete'] = 'Delete';
$lang['details'] = 'Details';

#E
$lang['edit'] = 'Edit';
$lang['error_missingparam'] = 'A Required parameter or value could not be found';
$lang['error_nameexists'] = 'An item with that name already exists';
$lang['error_nocatname'] = 'Please specify a category name';
$lang['error_nonamegiven'] = 'You must supply a feed name/alias';
$lang['error_nopermission'] = 'Permission Denied';
$lang['error_notemplate'] = 'No Template Supplied';

#F
$lang['feeds'] = 'Feeds';
$lang['feed_copyright'] = 'Feed Copyright';
$lang['feed_description'] = 'Feed Description';
$lang['feed_editor'] = 'Feed Editor';
$lang['feed_extension'] = 'Feed Extension';
$lang['feed_image'] = 'Feed Image';
$lang['feed_link'] = 'Feed Link';
$lang['feed_namealias'] = 'Feed Name/Alias';
$lang['feed_pageid'] = 'Use this page for links';
$lang['feed_title'] = 'Feed Title';
$lang['feed_ttl'] = 'Time To Live';
$lang['friendlyname'] = 'Calguys Feed Maker';

#G

#H
$lang['help'] = <<<EOT
<h3>What Does This Do?</h3>
<p>This module provides the ability to build and manage RSS Feeds consisting of data from any CMS Made Simple module that supports a summary view.</p>
<p>It supports categorizing the feeds, generating auto-discovery links, and standalone links to rss feeds.</p>
<p>Pretty URL's are supported if your site has them enabled. - <em>ex:</em> http://www.yoursite.com/feeds/Feed-Name</p>
<h3>How Do I Use It?</h3>
<ul>
<li>-First you must create a new feed, and fill in the parameters supplied.
  <p>A template is associated with each feed.  The default template illustrates how to generate an RSS feed from the News module</p>
  <p>To generate templates from other feeds you will need to use the template variables from that module. Put {get_template_vars} in a page that uses that module to see which variables you can call into your Feed Template. To control the output of your feed you need to use a combination of these template variables and modify your module call in the template.</p>
</li>
<li>-Secondly you should place an auto-discovery tag in the appropriate place.
  <p>This will create auto-discovery links in your output.  You can place this tag in the head section of the page template, or the metadata section of specific pages to generate autodiscovery.  Various parameters can be specified to control which feeds auto-discovery links are generated for.<br /></p>
<p>  
<em>ex1:</em> <strong>{CGFeedMaker action='autodiscovery' feed='myFeed1,myFeed2 '}</strong> - This creates autodiscovery links for all specified feeds<br />
<em>ex2:</em> <strong>{CGFeedMaker action='autodiscovery' category='myCategory1,myCategory2'}</strong> - This creates autodiscovery links for all feeds in the specified category or categories</p>
</li>
  <li>-Thirdly, you can place links to specific feeds in your content.  using the action=rsslink parameter.<p>This will create a link to the specified feed in the location you put the call.</p>
  <p><em>ex1:</em> <strong>{CGFeedMaker action='rsslink' feed='myfeed'}</strong> - Generic "rsslink" call
  <br/>
  <em>ex2:</em> <strong>{CGFeedMaker action='rsslink' feed='myfeed' imageonly='' image='uploads/images/rssNew.jpg' imageclass='rssImage'}</strong> - This call displays a link that shows only an Image for the link, it specifies a different image that was uploaded to use for the link than the default image and it uses a different CSS class to format the image (specified in one of your stylesheets)  
  <br />
   <em>ex3:</em> <strong>{CGFeedMaker action='rsslink' feed='myfeed' text='RSS News Feed' image='uploads/images/rssNew.jpg' imageclass='rssImage' linkclass="rssLink"}</strong> - This call specifies different text for the link to the feed, specifies a new image to be used and uses different CSS classes to format the Image and Link (specified in one of your stylesheets)   </p> 
  </ul>
<h3>Notes:</h3>
<ul>
<li>This module will work best, and the default feeds will validate if you have configured pretty urls properly.   Otherwise, atom links seem to have problems with some of our URLS.</li>
</ul>
<h3>Support</h3>
<p>This module does not include commercial support. However, there are a number of resources available to help you with it:</p>
<ul>
<li>For the latest version of this module, FAQs, or to file a Bug Report or buy commercial support, please visit calguy's
homepage at <a href="http://calguy1000.com">calguy1000.com</a>.</li>
<li>Additional discussion of this module may also be found in the <a href="http://forum.cmsmadesimple.org">CMS Made Simple Forums</a>.</li>
<li>The author, calguy1000, can often be found in the <a href="irc://irc.freenode.net/#cms">CMS IRC Channel</a>.</li>
<li>Lastly, you may have some success emailing the author directly.</li>  
</ul>
<h3>Copyright and License</h3>
<p>Copyright &copy; 2008, Robert Campbel <a href="mailto:calguy1000@cmsmadesimple.org">&lt;calguy1000@cmsmadesimple.org&gt;</a>. All Rights Are Reserved.</p>
<p>This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.</p>
<p>However, as a special exception to the GPL, this software is distributed
as an addon module to CMS Made Simple.  You may not use this software
in any Non GPL version of CMS Made simple, or in any version of CMS
Made simple that does not indicate clearly and obviously in its admin 
section that the site was built with CMS Made simple.</p>
<p>This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
Or read it <a href="http://www.gnu.org/licenses/licenses.html#GPL">online</a></p>

EOT;

#I
$lang['info_alias'] = 'This feed must contain only characters that are suitable in a URL';
$lang['info_copyright'] = 'Copyright notice for content in this channel';
$lang['info_description'] = 'A phrase or sentence describing this channel';
$lang['info_editor'] = 'Email address of the managing editor for this channel';
$lang['info_extension'] = 'Feed Extension (specify an extension for this feed, i.e xml,rss,kml... if not specified the default rss extension will be used';
$lang['info_feed_extension'] = 'When using mod_rewrite to form pretty urls this parameter can be used to specify the extension of the feeds generated.';
$lang['info_image'] = 'Specifies a GIF, JPEG or PNG image that can be displayed with the channel';
$lang['info_link'] = 'The URL to the HTML website corresponding to the channel';
$lang['info_pageid'] = 'The page that should be used for all links in this feed';
$lang['info_ttl'] = 'number of minutes that indicates how long a channel can be cached before refreshing from the source';

#J

#K

#L

#M
$lang['moddescription'] = 'A flexible tool for the creation and management of RSS feeds';

#N
$lang['name'] = 'Name';

#O

#P
$lang['param_action'] = 'Specify the behaviour of the module.  There are two possible values for this parameter &quot;autodiscovery&quot; &amp; &quot;rsslink&quot;.  The autodiscovery action will generate auto discovery links, and should be used in a place that would result in the resulting content appearing in the head section of your output.  The rsslink action can be used to create a link to a specific feed, and can be placed in your page content';
$lang['param_category'] = 'Useful only with the autodiscovery action, this parameter allows you to specify a comma separated list of feed categoryes that will control which feeds links are generated for';
$lang['param_feed'] = 'Useful in the rsslink and autodiscovery action, this parameter allows you to specify which feed to generate a link for.  When in the autodiscovery action, a comma separated list of feed names can be supplied.';
$lang['param_image'] = 'Useful in the rsslink action this parameter allows you to specify a different image for the rss feed link';
$lang['param_imageclass'] = 'Specify a CSS class to be output in the image tag of an rss feed link';
$lang['param_imageonly'] ='Useful in the rsslink action, this parameter allows you to specify that no text should be output with the link';
$lang['param_linkclass'] = 'Specify a CSS class to be output in the link tag of an rss feed link';
$lang['param_urlonly'] = 'Applicable only to the rsslink action, this parameter requests that the code only output the url to the RSS feed';
$lang['param_text'] = 'Useful in the rsslink action, this parameter allows you to specify the text that should be associated with the link.  If this parameter is not specified, the feed title will be used';
$lang['postinstall'] = 'The CGFeedMaker Module has been successfully installed';
$lang['postuninstall'] = 'The CGFeedMaker Module, and all associated data has been removed';

#Q

#R
$lang['really_uninstall'] = 'Are you sure you want to remove this module.  All data associated with this module will be removed';
$lang['reset_to_factory'] = 'Reset To Factory Default';

#S
$lang['settings'] = 'Settings';
$lang['submit'] = 'Submit';

#T
$lang['template'] = 'Template';
$lang['template_source'] = 'Template Source';

#U

#V

#W

#X

#Y

#Z

?>
