<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Banners (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to allow management, display,
#  and tracking of banner images.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

if (!$this->CheckPermission ('Manage Banners'))
  {
    return;
  }

    $db =& $this->GetDb();
    $smarty->assign ('title', $this->Lang ('editcategory'));

    // check things out
    if (!isset ($params['category_id']))
      {
	$smarty->assign ('message', $this->Lang ('error_nocategory'));
	$smarty->assign ('error', 1);
	echo $this->ProcessTemplate ('addcategory.tpl');
	return;
      }

    // get the category info from the database (for this category)
    $query =
      "SELECT * FROM ".cms_db_prefix ().
      "module_banners_categories WHERE category_id = ?";
    $dbresult = $db->Execute ($query, array($params['category_id']));
    if (!$dbresult)
      {
	$smarty->assign ('message', $this->Lang ('error_dberror'));
	$smarty->assign ('error', 1);
	echo $this->ProcessTemplate ('addcategory.tpl');
	return;
      }
    $row = $dbresult->FetchRow ();
    if (!$row)
      {
	$smarty->assign ('message', $this->Lang ('error_dberror'));
	$smarty->assign ('error', 1);
	echo $this->ProcessTemplate ('addcategory.tpl');
	return;
      }

    // populate the template
    $smarty->assign ("startform",
			   $this->CreateFormStart ($id, 'do_editcategory', $returnid));
    $smarty->assign ('submit',
			   $this->CreateInputSubmit ($id, 'submit', 'Submit'));
    $smarty->assign ('cancel',
			   $this->CreateInputSubmit ($id, 'cancel', 'Cancel'));
    $smarty->assign ('endform', $this->CreateFormEnd ());

    $smarty->assign ('prompt_categoryname', $this->Lang ('prompt_categoryname'));
    $smarty->assign ('input_categoryname', $this->CreateInputText ($id, 'input_categoryname',
									 $row['name'], 20, 80));
    $smarty->assign ('prompt_categorydesc', $this->Lang ('prompt_categorydesc'));
    $smarty->assign ('input_categorydesc',
			   $this->CreateInputText ($id, 'input_categorydesc',
						   $row['description'], 80, 255));

$smarty->assign('prompt_template',$this->Lang('template'));
$smarty->assign('input_template',
		$this->CreateSyntaxArea($id,$row['template'],'input_template'));

    $uploads =& $this->_getUploadsModule();
    if( $uploads )
      {
	$categorylist = $uploads->getCategoryList();
	$smarty->assign('prompt_upload_category',
			      $this->Lang('prompt_upload_category'));
	$smarty->assign('input_upload_category',
			      $this->CreateInputDropDown ($id, "input_upload_category", $categorylist, -1));
      }

    $smarty->assign ('hidden',
			   $this->CreateInputHidden ($id, 'category_id',
						     $params['category_id']));

    echo $this->ProcessTemplate ('addcategory.tpl');

?>