<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: CGFBApp (c) 2010 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  A toolbox of conveniences to build facebook integration into a website
#  for CMS modules and website designers.
# 
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class cgfb_post
{
  private $_data = array('to'=>'me');
  private $_actions = array();
  private $_attachment;
  private $_keys = array('to','message');

  
  public function __construct($msg,$to='me')
  {
    $this->message = $msg;
    if( $to ) $this->to = $to;
  }


  public function __get($key)
  {
    if( !in_array($key,$this->_keys) )
      {
	throw new Exception('Attempt to retrieve invalid value of post object');
      }

    if( !isset($this->_data[$key]) )
      {
	return;
      }

    return $this->_data[$key];
  }


  public function __set($key,$value)
  {
    if( !in_array($key,$this->_keys) )
      {
	throw new Exception('Attempt to set invalid value of post object');
      }

    $this->_data[$key] = $value;
  }


  public function add_action($name,$link)
  {
    if( !$name || !$link )
      {
	return;
      }

    $this->_actions[] = array('text'=>$name,'link'=>$link);
  }


  public function set_attachment(cgfb_post_attachment $attachment)
  {
    $this->_attachment = $attachment;
  }


  public function to_array()
  {
    $output = array();
    $output['target_id'] = ($this->to == 'me')?cgfb::uid():$this->to;
    $output['message'] = $this->message;
    if( count($this->_actions) )
      {
	$output['action_links'] = $this->_actions;
      }
    if( is_object($this->_attachment) )
      {
	$output['attachment'] = $this->_attachment->to_array();
      }
    return $output;
  }
} // class

#
# EOF
#
?>