<?php
#A
$lang['advanced_settings'] = 'Advanced';

#B

#C

#D
$lang['dflt_action_text'] = 'Invite your friends to use this App';
$lang['dflt_templates'] = 'Default Templates';

#E

#E

#F
$lang['facebook_settings'] = 'Facebook Settings';
$lang['fb_appid'] = 'Facebook Application ID';
$lang['fb_appsecret'] = 'Facebook Application Secret';
$lang['fb_perms'] = 'Facebook Permissions';
$lang['fbinitasync_template'] = 'Facebook Async Initialization';
$lang['fbinitsync_template'] = 'Facebook Synchronous Initialization';
$lang['friendlyname'] = 'Calguys Facebook Toolkit';

#G

#H
$lang['help'] = <<<EOT
<h3>What Does This Do?</h3>
<p>This module provides some tools (via an API and various smarty plugins) to allow easily integrating facebook into your application using smarty logic, or building a simple facebook application using simple smarty plugins or user defined tags.  This is useful when building E-commerce, tourism, event or social websites.</p>
<h3>Features</h3>
<p>This module provides smarty utilities for integrating Facebook into your website, and some smarty utilities and a simple API for building facebook applications. Including:<br/>
 <ul>
 <li>Initializing the Facebook Javascript API (synchronously or asynchornously)</li>
 <li>Display a box allowing users to comment on any obect within your website (no Facebook APPID Required)
 <li>Display a Facebook Like Button for any item</li>
 <li>Create a Wall Post for the currently logged in user.</li>
 <li>Create a Status post for the currently logged in user.</li>
 <li>Display an invite form to invite users to your website</li>
 <li>
 </ul>
</p><br/>
<p>You have access to numerous smarty utilities for creating various OpenGraph Objects:
 <ul>
 <li>Set the OpenGraph URL</li>
 <li>Set the OpenGraph Title</li>
 <li>Set the OpenGraph Object Type</li>
 <li>Set the OpenGraph Image Attribute</li>
 <li>Set the OpenGraph Title Attribute</li>
 <li>Set the OpenGraph Sitename Attribute</li>
 <li>Set the OpenGraph Description Attribute</li>
 <li>Set the OpenGraph admins attribute.</li>
 </ul>
</p><br/>
<p>You have access to numerous smarty utilities for building a Facebook Application on a page of your website:
 <ul>
 <li>Initializing the Facebook Javascript API (synchronously or asynchornously)</li>
 <li>Entering your Facebook Application ID, and App Secret</li>
 <li>Selecting which Facebook permissions your App Requires (if any)</li>
 <li>Displaying a login button allowing users to login to your app or website using their Facebook credentials</li>
 <li>Displaying a logout button allowing users to logout from your application.</li>
 <li>Initializing the Facebook Javascript API (synchronously or asynchornously)</li>
 <li>Calling any function in the Facebook Graph API</li>
 <li>Retrieve all information about the currently logged in user that he has authorized to share with you</li>
 <li>Retrieve Facebook UID for the currently logged in user.</li>
 <li>Send a POST command to the Facebook GRAPH API</li>
 </ul>
</p><br/>
<p>This module provides some limited smarty utilities for storing and retrieving data for creating simple applications:
 <ul>
   <li>Retrieve application specific information specific to the Facebook user.</li>
   <li>Store application information specific to the Facebook user to the database.</li>
   <li>Erase user related application information.</li>
   <li>Retrieve a list of the users friends that are also using the application.</li>
 </ul>
</p><br/>
<div class="pageoverflow" style="color:black;padding:5px;background-color:white;border:2px dotted orange">
  <p>This module is not a replacement for learning the Facebook APIS for writing applications with Facebook.  It provides some wrappers and conveniences for smarty for retrieving data from and submitting data to Facebook.</p>
  <p><span style="color: green;">Please</span> read the facebook application tutorials and reference documentation.</p>
</div>
<h3>How do I use it</h3>
<p>There are two primary ways to use this module.  First, and most importantly, to add social attributes to your existing CMSMS Website.  Secondly you can use this module to query data from and submit information to Facebook.  Additionally some plugins are provided for storing and retrieving app specific information for a facebook user.</p>
<h4><u>Facebook Social Plugins:</u></h4>
   <p>The following section describes the smarty functions to allow integrating Facebook into your website.  See the &quot;Smarty Functions&quot; section below for a detailed reference of each plugin. For a reference you should read this page about <a href="http://developers.facebook.com/plugins">Facebook Social Plugins</a></p>
<ul>
 <li><code>{cgfb_like}</code> Will display a Facebook like button to allow users to &quot;Like&quot; The current Page.<br/><u>Note:</u> you should turn yoru web pages and other items into &quot;Graph Objects&quot; for optimal behaviour.</li>
 <li><code>{cgfb_comments}</code> Will display a form allowing users to add a comment to the current page, or an item on the page, and to view the comments of others.</li>
</ul><br/>
 <p>The simplest way to add facebook integration into your site is just to add <code style="color: blue;">{cgfb_like}</code> into the page template of your site.  Now any page that uses this page template will have a facebook &quot;Like&quot; button attached to it.  You do not need to create a facebook application, or even to call {cgfb_init} to use this function.</p>
 <p>The next most common way to add facebook integration into your site is to allow visitors to enter comments.  You can do this by adding the <code style="color: blue;">{cgfb_comments}</code> tag into your page template.</p>
 <p>Adding a &quot;like&quot; button beside each entry on your Product summary views you can simply pass the detail url value for each product displayed in the summary view as the <em>href</em> parameter to the {cgfb_like} tag.  i.e:<br/>
 <pre>{foreach from=\$items item=entry}<br/>{* your other summary template stuff *}<br/><span style="color: green;">{cgfb_like href=\$entry->detail_url}</span><br/>{/foreach}</pre>
 <p>

<br/><h4><u>Integrating with OpenGraph:</u></h4>
<p>Integrating with OpenGraph will allow facebook to better understand what type of data is on the page (a video, image, personal information, company information, etc).  It is advised that you integrate with OpenGraph as much as possible for maximum effectiveness, and for viewing information about facebook &quot;insights&quot;.</p>
   <p>Reference: <a href="http://developers.facebook.com/docs/opengraph">The Open Graph Protocol</a></p>
<ul>
<li><code>{cgfb_og_value}</code> Is used to create a simple name/value pair for your OpenGraph Object.</li>
<li><code>{cgfb_og_title}</code> Is used to set the &quot;og:title&quot; attribute.</li>
<li><code>{cgfb_og_type}</code> Is used to set the &quot;og:type&quot; attribute.</li>
<li><code>{cgfb_og_image}</code> Is used to se the &quot;og:image&quot; attribute.</li>
<li><code>{cgfb_og_sitename}</code> Is used to set the &quot;og:sitename&quot; attribute.</li>
<li><code>{cgfb_og_admins}</code> Is used to set the &quot;fb:admins&quot; attribute.</li>
<li><code>{cgfb_og_meta}</code> Gathers all the opengraph attributes that have been set, and applies some inteligent defaults to those that have not been set, and outputs the appropriate meta tags.</li>
</ul><br/>
<p>The <a href="http://www.opengraphprotocol.org">Open Graph Protocol</a> essentially allows you to describe real world objects using meta tags and HTML content.  When the Open Graph Protocol Facebook will essentially treat your web page as a &quot;Facebook Page&quot; and the structured data you provide defines how your page will be presented to facebook.</p>
<p>Implementing the Open Graph Protocol in your page is <em>usually</em> as simple as adding {cgfb_og_meta} into the head section of your page template, and then adding the appropriate attributes to describe your object in the appropriate module template, GCB or page content block.  The following example will create opengraph objects on each product detail page.</p>
<ul>
<li>1.  Ensure that &quot;process_whole_template&quot; is set to &quot;false&quot; in your config.php</li>
<li>2.  Add the {cgfg_og_meta} tag somewhere in the &lt;head&gt; section of your page template.  Optionally, you may add it in the &quot;Page Specific Metadata&quot; section of the page that you use for a Products Detail View.</li>
<li>3.  In the default Products detail template add the following lines:
<br/>
<pre><span style="color:green;">{cgfb_og_title title=\$entry->product_name}<br/>{cgfb_og_type type='product'}</span></pre>
</pre>
</li>
</ul>
<br/><p>Once you browse to a detail view of a product, and view the source, you should now see the Open Graph meta tags in the page header.  Now when combined with a like button as described above, your website integration is nearly done.</p>

<br/><h4><u>Simple Facebook Applications:</u></h4>
<ul>
 <li><code>{cgfb_init}</code> Will output the javascript to initialize the Facebook Javascript API</li>
 <li><code>{cgfb_login}</code> Will display a Facebook login button.</li>
 <li><code>{cgfb_logout}</code> Will display a Facebook logout button.</li>
 <li><code>{cgfb_uid}</code> Will display the users Facebook User ID.</li>
 <li><code>{cgfb_invite}</code> Will display an advanced form allowing your users to invite their friends to your application.</li>
 <li><code>{cgfb_me}</code> Will return all of the information about the current Facebook User that he has allowed you to see.</li>
 <li><code>{cgfb_api}</code> Can make any request to the javascript GRAPH API.</li>
 <li><code>{cgfb_app}</code> Will retrieve the information about your facebook application.</li>
 <li><code>{cgfb_send}</code> Can send a command to the Facebook Graph API via POST.</li>
 <li><code>{cgfb_wallpost}</code> Uses the Facebook REST API to create a wall post for the current Facebook User.</li>
 <li><code>{cgfb_status}</code> Uses the Facebook REST API to create a status post for the current Facebook User.</li>
 <li><code>{cgfb_fql}</code> Using the Facebook REST API send to send an FQL query.</li>
 <li><code>{cgfb_fql_multi}</code> Using the Facebook REST API send to multiple FQL queries in a single request <em>(because FQL does not support joins)</em>.</li>
 <li><code>{cgfbuserdata_get}</code> Will retrieve the information you have stored about this user from the database.</li>
 <li><code>{cgfbuserdata_set}</code> Will store selected information for this facebook user into the database.</li>
 <li><code>{cgfbuserdata_erase}</code> Will erase a portion of the gathered information for this facebook user from the database.</li>
 <li><code>{cgfbuserdata_eraseuser}</code> Will erase all information for this facebook user from the database.</li>
 <li><code>{cgfbuserdata_appfriends}</code> Will retrieve a list of the users friends that also have information in the database.</li>
</ul><br/>
 <p>Creating a facebook application involves numerous steps:</p>
<ul>
 <li>1.  Create a CMSMS page template that displays correctly in a width fo 760 pixels.  (For future reference I will refer to this template as the <span style="color: blue;">fb_canvas</span> template.)</li>
 <li>2.  Create a new page in your CMSMS page hierarchy that uses the <span style="color: blue;">fb_canvas</span> template.  For reference purposes lets call this the <span style="color: blue;">my_app</span> page.</li>
 <li>3.  Registering a facebook application at: <a href="http://www.facebook.com/developers/createapp.php">http://www.facebook.com/developers/createapp.php</a></li>
 <li>4.  Setting up your facebook application for compatibility, and easy integration with CMSMS.  I will not go through the detail of all of the settings you should change.  However you should give your canvas page a name, and specify the full url to the <span style="color: blue;">my_app</span> page that will represent your canvas page.  You also should specify the &quot;Canvas Type&quot; as &quot;Iframe&quot;<br/><strong>Note:</strong> It appears that facebook requires a &quot;folder&quot; be specified for the Canvas URL, you may have to edit your settings in the config.php file (i.e enable pretty urls, and remove a page extension) for facebook to be happy.</li>
 <li>5.  In the &quot;Calguys Facebook Toolkit&quot; admin panel fill in the &quot;Application ID&quot; and the &quot;App Secret&quot; as specified by facebook.  You should also select the permissions that your application will need as defined <a href="http://developers.facebook.com/docs/authentication/permissions">here</a>.<br/><strong>Note:</strong> It is probably a good idea to restrict the number of permissions you select to as little as possible in order to get wider acceptance for your application.</li>
 <li>6.  When editing your <span style="color: blue;">fb_canvas</span> page template, add the <span style="color: blue;">{cgfb_init}</span> tag directly after the opening &lt;body&gt; tag.   You may also add the <span style="color: blue;">{cgfb_login}</span> tag into an appropriate section of the template (in the header bar or a sidebar etc).  This will both initialize the Facebook API and provide a login button.  When visitors click on the login button they will be asked to approve the permissions you have requested.</li>
 <li>7.  Now we are ready to start with the functionality for our facebook application.  You will use a combination of smarty logic, the plugins provided below, and your own code, or other modules to build your application. A small example application is below.</li>
</ul><br/>

<h3>Sample Application:</h3>
<p>The sample application illustrated below needs the publish_stream,user_location, and friends_location permissions.  You can select these in the administration panel for the module.  You will also need to registar a facebook application and fill in your application id, and app secret into the admin panel.</p>
<pre>
<span style="color: blue;">{cgfb_init}</span>{* initialize facebook javascript SDK *}
<span style="color: blue;">{cgfb_login}</span>{* provide a login button to facebook *} <br/>
<span style="color: blue;">{cgfb_uid assign='fb_uid'}</span>{* get the facebook user id *}
{if \$fb_uid}
  {* user is logged in *}

  {* get his or her friends friends list *}
  <span style="color: blue;">{cgfb_api call='/me/friends' assign='friends'}</span>

  {* create an FQL query *}
  {capture assign=&quot;fql&quot;}select name, birthday_date, current_location, sex, pic_square from user where uid IN (SELECT uid2 FROM friend WHERE uid1={\$me.id}){/capture}

  {* execute an FQL query *}
  <span style="color: blue;">{cgfb_fql fql=\$fql assign='res'}</span>

  {* process the results from the query *}
  {if is_array(\$res)}
     {assign var=&quot;num_points&quot; value=0}
       
     {* for each friend *}
     {foreach from=\$res item=&quot;friend&quot;}

     {* if we have a location *}
     {if isset(\$friend.current_location)}

        {* build a location string *}
        {assign var=&quot;num_points&quot; value="`\$num_points+1`"}
        {capture assign=&quot;loc&quot;}{strip}
           {if \$friend.current_location.country == &quot;Canada&quot; or \$friend.current_location.country == &quot;United States&quot;}
               {\$friend.current_location.city}, {\$friend.current_location.state} {\$friend.current_location.country}
           {else}
               {\$friend.current_location.city} {\$friend.current_location.country}
           {/if}
        {/strip}{/capture}

        {* add a point to our map *}
        {cggm_add_dynpoint name=\$friend.name address=\$loc desc=\$friend.sex}
     {/if}
  {/foreach}

  {if \$num_points gt 0}
     {* display the map *}
     {CGGoogleMaps}
  {/if}

  {/if}
{/if}</pre>

<h3>Smarty Function Reference:</h3>
<ul>
 <li>Social Plugins:
 <ul>
 <li><code style="color: blue;">{cgfb_like [params]]</code>
 <p>Create a &quot;Like&quot; Button for a URL.<br/>Parameters:
   <ul>
   <li>href - (string) The URL to allow people to like.  (default is the current page URL.)</li>
   <li>layout - (string) The layout of button.  Possible values are standard,button_count,box_count.</li>
   <li>show_faces - (boolean) Wether to show faces of the others that have liked the item.</li>
   <li>action - (string) The beaviour of the button, Possible values are like,recommend.</li>
   <li>width - (int) The width of the like button in pixels.</li>
   <li>font - (string) The string to use for the form or display.  Values are arial,lucide grande,segoe ul,tahoma,verdana</li>
   <li>colorscheme - (string) The color scheme for the form.  Values are light,dark</li>
   <li>ref - (string) An optional reference value to use for statistics purposes.</li>
   <li>assign - (string)  Assign the output to a smarty variable.</li>
   </ul>
   </p><br/>
 </li>      

 <li><code style="color: blue;">{cgfb_comments [params]}</code>
 <p>Create a form allowing facebook users to leave comments on a page, or on an item.<br/>Parameters:
 <ul>
   <li>uniqueid - (string) A unique identifier to use to identify the item that is being commented on. (default is a hash of the current page url).</li>
   <li>width - (int) The maximum width of the form in pixels. (default is 425)</li>
   <li>ncomments - (int) The maximum number of comments to display at one time.  (default is 10)</li>
   <li>publish - (boolean) Wether the &quot;public comment&quot; checkbox should be displayed.</li>
   <li>assign - (string)  Assign the output to a smarty variable.</li>
 </ul>
 </p><br/>
 </li>

</ul>
</li>

<li>OpenGraph Plugins:
<ul>
  <li><code style="color: blue;">{cgfb_og_value name=&lt;string&gt; value=&lt;string&gt;}</code>
  <p>Create a name/value pair to output with information for the OpenGraph API.  These name/value pairs will be collected and output with the {cgfb_og_meta} tag.  If the name has already been set, then this operation will overwrite its value. This tag is normally called from within the body of a page template (using the default template conditions in CMSMS).<br/>Parameters:
   <ul>
      <li>name - (string) The name of the variable.</li>
      <li>value - (string) The value of the variable.</li>
   </ul>
  </p><br/>
  </li>

  <li><code style="color: blue;">{cgfb_og_title title=&lt;string&gt;}</code>
  <p>Set the og:title attribute, this plugin is essentially a specialized version of the {cgfb_og_value} plugin.<br/>Parameters:
  <ul>
  <li>title - (string) The title of the object being described.</li>
  </ul>
  </p><br/>
  </li>

  <li><code style="color: blue;">{cgfb_og_type type=&lt;string&gt;}</code>
  <p>Set the og:type attribute, this plugin is essentially a specialized version of the {cgfb_og_value} plugin.<br/>Parameters:
  <ul>
  <li>type - (string) The object type.  One of: activity, sport, bar, company, cafe, hotel, restaraunt, cause, sports_league, sports_team, band, government, non_profit, school, university, actor, athlete, author, director, musician, politician, public_figure, city, country, landmark, state_province, album, drink, food, game, product, song, movie, tv_show, blog, website, article</li>
  </ul>
  </p><br/>
  </li>

  <li><code style="color: blue;">{cgfb_og_url url=&lt;string&gt;}</code>
  <p>Set the canonical url to the object (og:url).  The default value for this parameter is the current page url.</p>
  <ul>
  <li>url - (string) The canonical URL to the object.</li>
  </ul>
  </p><br/>
  </li>

  <li><code style="color: blue;">{cgfb_og_image image=&lt;string&gt;}</code>
  <p>Set the url of an image which should represent the object in the graph.</p>
  <ul>
  <li>image - (string) A URL to an image (JPG,PNG, and GIF are supported)
  </ul>
  </p><br/>
  </li>

  <li><code style="color: blue;">{cgfb_og_sitename sitename=&lt;string&gt;}</code>
  <p>Set a human readable name for your website.   i.e: &quot;Freds Products&quot;.  If no value is specified for this property the current web site name will be used..
  <ul>
  <li>sitename - (string) The Site name.</li>
  </ul>
  </p><br/>
  </li>

  <li><code style="color: blue;">{cgfb_og_desc desc=&lt;string&gt;}</code>
  <p>(og:description) Set a brief description for the object.  One or two sentences.
  <ul>
  <li>desc - (string) The Description.
  </ul>
  </p><br/>
  </li>

  <li><code style="color: blue;">{cgfb_og_admins admins=&lt;string&gt;}</code>
  <p>(fb:admins) Set the list of facebook admins for this object.
  <ul>
  <li>admins - (string) A comma saparated list of facebook user ids or a  Facebook Platform application id.
  </ul>
  </p><br/>
  </li>

  <li><code style="color: blue;">{cgfb_meta [params]}</code>
  <p>This plugin will gather all of the preset OpenGraph variables, apply some intelligent default values for parameters not specified, and generate the appropriate meta tags.  This plugin is typically called within the head section of the page template.  The other cgfb_og* plugins are called from within the body of the page template (wither within the page template itself, or inside of a content block, or even inside of a GCB or module template.  Then because (by default) process_whole_template is FALSE in the config.php file of CMSMS this function is processed AFTER the body of the template.<br/>Parameters:
  <ul>
  <li>assign - (string) A smarty variable name to assign the output to.
  </ul>
  </p><br/>
  </li>

</ul>
</li>

<li>Application Building Plugins:
<ul>
 <li><code style="color: blue;">{cgfb_init [params]}</code>
   <p>Initializes the Facebook Javascript API<br/>
       Parameters:
       <ul>
       <li>async - (boolean) Enable Asynchronous API Initialization (default = false)</li>
       <li>assign - (string)  Assign the output to a smarty variable.</li>
       </ul>
   </p><br/>
 </li>

 <li><code style="color: blue;">{cgfb_uid}</code>
 <p>Return the UID  of the currently logged in Facebook User.<br/>Parameters:
 <ul>
    <li>assign - (string)  Assign the output to a smarty variable.</li>
 </ul>
 </p><br/>
 </li>

 <li><code style="color: blue;">{cgfb_me assign=&lt;string&gt;}</code>
 <p>Return all of the information that the facebook user has shared with the application.<br/>Parameters:
 <ul>
    <li>assign - (string)  Assign the output to a smarty variable.</li>
 </ul>
 </p><br/>
 <pre>Example: <code>{cgfb_me assign=&quot;me&quot;}{\$me|@print_r}</code></pre><br/>
 </li>

 <li><code style="color: blue;">{cgfb_api call=&lt;string&gt; assign=&lt;string&gt;}</code>
 <p>Perform a GET request to the Facebook Graph API, and assign the results to a smarty variable.<br/>Parameters:
 <ul>
    <li>call - (string)  The facebook GRAPH API method to call.</li>
    <li>assign - (string)  Assign the output to a smarty variable.</li>
 </ul>
 </p><br/>
 <pre>Example: <code>{cgfb_api call=&quot;/me/friends&quot; assign=&quot;friends&quot;}{\$friends|@print_r}</code></pre><br/>
 </li>

 <li><code style="color: blue;">{cgfb_send url=&lt;string&gt; assign=&lt;string&gt; ...}</code>
 <p>Performa POST request to the Facebook Graph API to Create a new record (event, like, image, etc) within Facebook.<u>Note:</u> this is a non-standard smarty plugin as it is not a display level element, instead it may not return any output at all.  This method should only be used inside conditionals that are triggered by user actions.<br/>Parameters:
 <ul>
    <li>uri - (string)  The Graph API to put to..</li>
    <li>assign - (string)  Assign the output to a smarty variable.</li>
    <li><em>Other Parameters</li> - (mixed) Specify the data to send to the facebook graph API.
 </ul>
 </p><br/>
 <pre>Example:<br/><code>{if isset(\$smarty.get.tell_my_friends)}<br/>{cgfb_api call=&quot;/me/friends&quot; assign=&quot;friends&quot;}<br/>{foreach from=\$friends item=&quot;friend&quot;}<br/>{capture assign=uri}{\$friend}/links{/capture}<br/><span style="color: green;">{cgfb_send uri=\$uri link=&quot;http://www.cmsmadesimple.org&quot; message=&quot;Check out this award winning CMS Package&quot;}</span><br/>{/foreach}<br/>{/if}</code></pre><br/>
 </li>

 <li><code style="color: blue;">{cgfb_wallpost msg=&lt;string&gt; name=&lt;string&gt; href=&lt;string&gt; ...}</code>
 <p>Create a wall post on a users wall. Allows up to 5 images, additional links, and allows associating data with the wall post for tracking purposes.  Wall posts allow for a single &quot;attachment&quot; with an image, a video, etc. and up to 5 images with associated URLS.<br/>Parameters:
 <ul>
    <li>to - (string) The Facebook UID to send the wall post to.  (default is &quot;me&quot;)</li>
    <li>msg - (string) The message to send (keep it to 140 characters or less)</li>
    <li>name - (string) The name of attachment.</li>  
    <li>href - (string) A URL to associate with the attachment</li>
    <li>caption - (string) A caption for the attachment</li>
    <li>description - (string) A description for the attachment.</li>
    <li>xid - (string) comments xid</li>
    <li>images - (string) hash of src=href pairs providing up to 5 images for the post attachment.
    <li>image1 through image5 - (string) a string of the format src:::href describing an image for the attachment.</li>
    <li>prop1 through prop5 - (string) a comma separated string of name,value,and href to specify additional options/properties for the bottom of the wall post.
    <li>data1 through data5 - (string) a comma separated string of name/value pairs used to associate data with the post.
    <li>
 </ul>
 </p><br/>
 <pre>Example: <code>{cgfb_wallpost to=me msg=&quot;This is a Test&quot; href=&quot;http://www.cmsmadesimple.org&quot;}</code></pre><br/>
 </li>

 <li><code style="color: blue;">{cgfb_status to=&lt;string&gt; msg=&lt;string&gt; ...}</code>
 <p>Create a status post on a users feed. Allows for a link, a picture, a name, a caption, and a description. As well as for up to 3 additional actions.  This method uses the Facebook GRAPH API.<br/>Parameters:
 <ul>
    <li>to - (string) The Facebook UID to send the wall post to.  (default is &quot;me&quot;)</li>
    <li>msg - (string) The message to send (keep it to 140 characters or less)</li>
    <li>link - (string) A URL to associate with this post.</li>
    <li>picture - (string) a URL to a picture to associate with this post.</li>
    <li>caption - (string) A caption for the picture.</li>
    <li>description - (string) A description for the picture..</li>
    <li>actions - (mixed) Either a comma separated string of key value pairs, or a hash of key/value pairs specifying button names and URLS to associate with the post.</li>
 </ul>
 </p><br/>
 <pre>Example: <code>{cgfb_status to=&quot;me&quot;  msg=&quot;I really like this app&quot;<br/>actions=&quot;View store=http://www.mysite.com/store,View Events=http://www.mysite.com/events&quot;}</code></pre><br/>
 </li>

 <li><code style="color: blue;">{cgfb_invite ...}</code>
 <p>Create a form to invite your users facebook friends, and others to use your facebook application.  This is just a wrapper around the facebook social plugin for inviting people.  This plugin uses the default invite template as specified in this modules admin panel unless a different template is specified.<br/>Parameters:
 <ul>
    <li>dest_url - (string) The url to redirect to after the form has been submitted.  If not specified, the current page URL will be used.</li>
    <li>app_name - (string) The name of your application.  If not specified, the current site name will be used.</li>
    <li>exclude_ids - (string) A comma separated string of facebook UIDs that should be excluded from the friends to invite list.</li>
    <li>content - (string) An instructional message to display to users at the top of the form.</li>
    <li>border - (boolean) Should the form have a border.</li>
    <li>email_invite - (boolean) Enable an email invite section to the form.</li>
    <li>email_invite - (boolean) Enable the email contact importer.</li>
    <li>condensed - (boolean) enable the condensed form.</li>
    <li>cols - (int) either 2,3, or 5 - the number of columns to display by default, this influences the size of the form.</li>
    <li>max - (int) The maximum number of friends to invite at one time.  (min 1, max 35)</li>
    <li>bypass - (string) The Version of the &quot;bypass&quot; button on the form. options are step,skip,or cancel. The default value is skip.
    <li>template - (string) The name of a non-default invite form template to use.</li>
    <li>assign - (string) Assign the output to a smarty variable.</li>
 </ul>
 </p><br/>
 <pre>Example: <code>{cgfb_invite content=&quot;Invite your friends to use this funky app&quot;}</code></pre><br/>
 </li>

 <li><code style="color: blue;">{cgfb_fql fql=&lt;string&gt; assign=&lt;string&gt;}</code>
 <p>Send an FQL Request to Facebook.</p>
 <ul>
    <li>fql - (string - required)  The facebook FQL request string</li>
    <li>assign - (string)  Assign the output to a smarty variable.</li>
 </ul>
 </p><br/>
 <pre>Example: <code>{cgfb_fql fql==&quot;SELECT name FROM user WHERE uid = me()&quot; assign=&quot;my_name&quot;}</code></pre><br/>
 </li>

 <li><code style="color: blue;">{cgfb_fql_multi ...}</code>
 <p>Send up to 5 FQL queries Facebook in a single request.</p>
 <ul>
    <li>query1 through query5 - (string - required)  The facebook FQL request strings</li>
    <li>assign - (string)  Assign the output to a smarty variable.</li>
 </ul>
 </p><br/>
 </li>

 <li><code style="color: blue;">{cgfbuserdata_get uid=&lt;string&gt; assign=&lt;string&gt;}</code>
 <p>Retrieve the data related to the specified  user from the database.</p>
 <p><span style="color: red;">Note:</span> This code is still in development.</p>
 <ul>
    <li>uid - (string)  The facebook User ID</li>
    <li>assign - (string)  Assign the output to a smarty variable.</li>
 </ul>
 </p><br/>
 <pre>Example: <code>{cgfbuserdata_get uid=\$fb_uid assign=&quot;mydata&quot;}</code></pre><br/>
 </li>

 <li><code style="color: blue;">{cgfbuserdata_set uid=&lt;string&gt;  key=&lt;string&gt;  val=mixed}</code>
 <p>Store some data in the user object for the specified facebook user.  This method can be used to create advanced hierarchical data structures with data for a user.</p>
 <p><span style="color: red;">Note:</span> This code is still in development.</p>
 <ul>
    <li>uid - (string)  The facebook User ID</li>
    <li>key - (string)  A string indicating the hierarchical location to store the data in.  Hierarchy levels are separated with a ..</li>
    <li>val - (mixed) The data to store.</li>
 </ul>
 </p><br/>
 <pre>Example: <code>{cgfbuserdata_set uid=\$fb_uid assign='scores.lastscore' val=5}</code><br/>
      Example: <code>{cgfbuserdata_set uid=\$fb_uid assign='scores.numgames' val=&quot;\$mydata.scores.numgames+1&quot;}</code>
 </pre><br/>
 </li>

 <li><code style="color: blue;">{cgfbuserdata_erase uid=&lt;string&gt;  key=&lt;string&gt;}</code>
 <p>Erase a portion of the data that is stored in the database for the specified facebook user id.</p>
 <p><span style="color: red;">Note:</span> This code is still in development.</p>
 <ul>
    <li>uid - (string)  The facebook User ID</li>
    <li>key - (string)  A string indicating the hierarchical location to erase.  Hierarchy levels are separated with a ..</li>
 </ul>
 </p><br/>
 <pre>Example: <code>{cgfbuserdata_erase uid=\$fb_uid assign='scores.lastscore' val=5}</code><br/></pre><br/>
 </li>

 <li><code style="color: blue;">{cgfbuserdata_eraseuser uid=&lt;string&gt;}</code>
 <p>Erase all of the data associated with a facebook user.</p>
 <p><span style="color: red;">Note:</span> This code is still in development.</p>
 <ul>
    <li>uid - (string)  The facebook User ID</li>
 </ul>
 </p><br/>
 <pre>Example: <code>{cgfbuserdata_eraseuser uid=\$fb_uid}</code><br/></pre><br/>
 </li>

 <li><code style="color: blue;">{cgfbuserdata_appfriends uid=&lt;string&gt;}</code>
 <p>Return a list of the friends of the specified facebook user that also have data stored in the database for this application.</p>
 <p><span style="color: red;">Note:</span> This code is still in development.</p>
 <ul>
    <li>uid - (string)  The facebook User ID</li>
    <li>assign - (string)  Assign the output to a smarty variable.</li>
 </ul>
 </p><br/>
    <pre>Example: <code>{cgfbuserdata_appfriends uid=\$fb_uid assign=&quot;alsousing&quot;}{\$alsousing|@print_r}</code><br/></pre><br/>
 </li>



</ul>
<li>
</ul>
<h3>Requirements</h3>
<h3>References</h3>
<h3>Support</h3>
<p>This module does not include commercial support. However, there are a number of resources available to help you with it:</p>
<ul>
<li>For the latest version of this module, FAQs, or to file a Bug Report or buy commercial support, please visit calguys
homepage at <a href="http://calguy1000.com">calguy1000.com</a>.</li>
<li>Additional discussion of this module may also be found in the <a href="http://forum.cmsmadesimple.org">CMS Made Simple Forums</a>.</li>
<li>The author, calguy1000, can often be found in the <a href="irc://irc.freenode.net/#cms">CMS IRC Channel</a>.</li>
<li>Lastly, you may have some success emailing the author directly.</li>  
</ul>
<h3>Copyright and License</h3>
<p>Copyright &copy; 2008, Robert Campbel <a href="mailto:calguy1000@cmsmadesimple.org">&lt;calguy1000@cmsmadesimple.org&gt;</a>. All Rights Are Reserved.</p>
<p>This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.</p>
<p>However, as a special exception to the GPL, this software is distributed
as an addon module to CMS Made Simple.  You may not use this software
in any Non GPL version of CMS Made simple, or in any version of CMS
Made simple that does not indicate clearly and obviously in its admin 
section that the site was built with CMS Made simple.</p>
<p>This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
Or read it <a href="http://www.gnu.org/licenses/licenses.html#GPL">online</a></p>
EOT;

#I
$lang['info_init_on_event'] = 'This option enables an event handler to insert the appropriate javascript calls into the code to initialize facebook when the page is rendered.';
$lang['info_use_async_init'] = 'Perform Facebook initialization asynchrounously for improved performance <em>(note some scripts may require synchronous initialization)</em>';
$lang['info_fbinitasync_tpl'] = 'This template contains the javascript and other code that is inserted intot he generated code to enable Facebook APIs Asynchronously';
$lang['info_fbinitsync_tpl'] = 'This template contains the javascript and other code that is inserted intot he generated code to enable Facebook APIs';
$lang['info_fb_perms'] = 'Which permissions does your facebook application request from the user';
$lang['invite_template'] = 'Invite Templates';

#J

#K

#L

#M
$lang['moddescription'] = 'A set of utilities allowing you to easily integrate Facebook into your application, or build simple facebook applications.';

#N

#O

#P
$lang['postinstall'] = 'Module successfully installed, please check the modules admin panel';
$lang['postuninstall'] = 'Module removed.';
$lang['preunintall'] = 'Are you sure you want to uninstall this module?';
$lang['prompt_init_on_event'] = 'Use an event handler to automatically initialize facebook';
$lang['prompt_use_async_init'] = 'Initialize Facebook APIs Asynchronously';

#Q

#R

#S
$lang['submit'] = 'Submit';

#T
$lang['title_fbinitasync_tpl'] = 'Asynchrounous Facebook Initialization Template';
$lang['title_fbinitsync_tpl'] = 'Facebook Initialization Template';
$lang['title_invite_template'] = 'Template that controls the format of the fbml used for creating an invite form';
$lang['title_sysdflt_invite'] = 'System Default Invite Template';

#U

#V

#W

#X

#Y

#Z

?>