<?php
class SFacebook extends CGExtensions
{
	function GetName()
	{
		return 'SFacebook';
	}
	function GetFriendlyName()
	{
		return $this->Lang('friendlyname');
	}
	function GetVersion()
	{
		return '0.1';
	}
	function MinimumCMSVersion()
	{
		return '1.7';
	}
	function GetHelp()
	{
		return $this->Lang('help');
	}
	function GetAuthor()
	{
		return 'AribTajuddin';
	}
	function GetAuthorEmail()
	{
		return 'cun.operation@yahoo.com.my';
	}
	function GetChangeLog()
	{
		return $this->Lang('changelog');
	}
	function IsPluginModule()
	{
		return true;
	}
	function HasAdmin()
	{
		return true;
	}
	function GetAdminSection()
	{
		return 'content';
	}
	function GetAdminDescription()
	{
		return $this->Lang('moddescription');
	}
	function VisibleToAdminUser()
	{
		return ($this->CheckPermission('View SFacebook') || $this->CheckPermission('Administrate SFacebook'));
	}
	function GetDependencies()
	{
		return array();
	}
	/*---------------------------------------------------------
	DisplayErrorPage()
	This is a simple function for generating error pages.
	---------------------------------------------------------*/
	function DisplayErrorPage($id, &$params, $return_id, $message=''){
		$this->smarty->assign('title_error', $this->Lang('error'));
		$this->smarty->assign_by_ref('message', $message);

		// Display the populated template
		echo $this->ProcessTemplate('error_SFacebook.tpl');
	}

	function Install()
	{
		$this->SetPreference('SFacebook_id_input','');
        $this->SetPreference('SFacebook_width_input','250');
        $this->SetPreference('SFacebook_height_input','400');
        $this->SetPreference('SFacebook_stream_input','1');
        $this->SetPreference('SFacebook_friends_input','8');
        $this->SetPreference('SFacebook_header_input','0');
 		$this->CreatePermission('SFacebook Admin', 'Manage SFacebook');
	}


	function SetParameters()
	{
		$this->RestrictUnknownParams();
		$this->RegisterModulePlugin();

		$this->CreateParameter('SFacebook_input', "value", $this->Lang('SFacebook_id_input'));
		$this->SetParameterType('SFacebook_input',CLEAN_STRING);

        $this->CreateParameter('SFacebook_width_input', "value", $this->Lang('SFacebook_width_input'));
        $this->SetParameterType('SFacebook_width_input',CLEAN_STRING);

        $this->CreateParameter('SFacebook_height_input', "value", $this->Lang('SFacebook_height_input'));
        $this->SetParameterType('SFacebook_height_input',CLEAN_STRING);

        $this->CreateParameter('SFacebook_stream_input', "value", $this->Lang('SFacebook_stream_input'));
        $this->SetParameterType('SFacebook_stream_input',CLEAN_STRING);

        $this->CreateParameter('SFacebook_friends_input', "value", $this->Lang('SFacebook_friends_input'));
        $this->SetParameterType('SFacebook_friends_input',CLEAN_STRING);

        $this->CreateParameter('SFacebook_header_input', "value", $this->Lang('SFacebook_header_input'));
        $this->SetParameterType('SFacebook_header_input',CLEAN_STRING);
    }




	function InstallPostMessage()
	{
		return $this->Lang('postinstall');
	}

	function Uninstall()
	{
		$this->RemovePreference('SFacebook_id_input');
        $this->RemovePreference('SFacebook_width_input');
        $this->RemovePreference('SFacebook_height_input');
        $this->RemovePreference('SFacebook_stream_input');
        $this->RemovePreference('SFacebook_friends_input');
        $this->RemovePreference('SFacebook_header_input');

		$this->RemovePermission('SFacebook Admin');
	}

	function UninstallPreMessage()
	{
		return $this->Lang('uninstall_confirm');
	}

    function UninstallPostMessage()
	{
		return $this->Lang('postuninstall');
	}

	function saveXFSettings($id, &$params, $returnid )
	{
		if( !$this->CheckPermission('Modify Site Preferences') )
			return;
		if( isset( $params['SFacebook_id_input'] ) )
		{
			$this->SetPreference('SFacebook_id_input',$params['SFacebook_id_input']);
		}
        if( isset( $params['SFacebook_width_input'] ) )
		{
			$this->SetPreference('SFacebook_width_input',$params['SFacebook_width_input']);
		}
        if( isset( $params['SFacebook_height_input'] ) )
		{
			$this->SetPreference('SFacebook_height_input',$params['SFacebook_height_input']);
		}
        if( isset( $params['SFacebook_stream_input'] ) )
		{
			$this->SetPreference('SFacebook_stream_input',$params['SFacebook_stream_input']);
		}
        if( isset( $params['SFacebook_friends_input'] ) )
		{
			$this->SetPreference('SFacebook_friends_input',$params['SFacebook_friends_input']);
		}
        if( isset( $params['SFacebook_header_input'] ) )
		{
			$this->SetPreference('SFacebook_header_input',$params['SFacebook_header_input']);
		}



		$this->Redirect($id,"defaultadmin",$returnid,array("module_message"=>$this->Lang('params_save_ok')));
	}
}
?>