<?php
if(!isset($gCms)) exit;

// Typical Database Initialization
$db = &$this->cms->db;
$dict = NewDataDictionary($db);
		
// mysql-specific, but ignored by other database
$taboptarray = array("mysql" => "TYPE=MyISAM");
		

// Creates the streetview table
$flds = "
	latitude C(64),
	longitude C(64),
	yaw C(64),
	pov C(64),
	zoom C(10),
	id I KEY,
	name C(64),
	alias C(64),
	item_order I,
	active L,
	isdefault L,
    date_modified ".CMS_ADODB_DT.",
	date_created ".CMS_ADODB_DT."
	";

$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_streetview_streetview", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
$db->CreateSequence(cms_db_prefix()."module_streetview_streetview_seq");



// Creates the queries table
$flds = "
    id I,
	name C(64),
	what C(32),
	whereclause C(255),
	wherevalues C(255),
	queryorder C(32)
	";

$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_streetview_saved_queries", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
$db->CreateSequence(cms_db_prefix()."module_streetview_saved_queries_seq");


// INSERTING DEFAULT TEMPLATES
	$template = '<h2>{$leveltitle}</h2>
{if $itemcount > 0}
<ul>
{foreach from=$itemlist item="item"}
	<li {if $item->is_selected}class="active"{/if}>{$item->detaillink}</li>
{/foreach}
</ul>
{if $page_pagenumbers}
<div id="pagemenu" style="text-align: center;">
{$page_previous}&nbsp; {$page_showing}/{$page_totalitems} &nbsp;{$page_next}<br/>
{$page_pagenumbers}
</div>
{/if}
{else}
<p>{$error_msg}</p>
{/if}
';
$this->SetTemplate("list_default",$template,$this->GetName());
    $this->SetPreference("listtemplate_streetview","list_default");

$template = '{literal}
<script src="http://maps.google.com/maps?file=api&amp;v=2&amp;sensor=false&amp;key=YOUR KEY HERE" type="text/javascript"></script>
<script type="text/javascript">// <![CDATA[
    function initialize() {
      var myPano = new GStreetviewPanorama(document.getElementById("pano"));
      myLocation = new GLatLng({/literal}{$item->latitude},{$item->longitude});
      myPOV = {literal}{{/literal}yaw:{$item->yaw},pitch:{$item->pov},zoom:{$item->zoom}{literal}
};
      myPano.setLocationAndPOV(myLocation, myPOV);
      GEvent.addListener(myPano, "error", handleNoFlash);
    }
function handleNoFlash(errorCode) {
      if (errorCode == 603) {
        alert("Error: Flash does not appear to be supported by your browser");
        return;
      }
    }
// ]]></script>
{/literal}
 <body onload="initialize()" onunload="GUnload()" style="font-family: Arial;border: 0 none;">
    <div name="pano" id="pano" style="width: 500px; height: 300px"></div>
</div>';

$this->SetTemplate("final_default",$template,$this->GetName());
$this->SetPreference("finaltemplate","final_default");

$template = '<p>{$error_msg}</p>
{if $backlink}<p>{$backlink}</p>{/if}';
$this->SetTemplate("no_result",$template,$this->GetName());

// CREATING PERMISSIONS :

// permissions
$this->CreatePermission("streetview_normaluser", "streetview: Normal user");
$this->CreatePermission("streetview_advanced", "streetview: Advanced");
	$this->CreatePermission("streetview_manage_streetview", "streetview: Manage streetview");
// activating default preferences
	$defprefs = array("tabdisplay_streetview","searchmodule_index_streetview","restrict_permissions","orderbyname","display_filter","display_instantsearch","display_instantsort","showthumbnails","load_nbchildren","use_session");
	foreach($defprefs as $onepref)	$this->SetPreference($onepref,true);
	$this->SetPreference("emptytemplate","**");

// events
	$this->CreateEvent("streetview_added");
	$this->CreateEvent("streetview_modified");
	$this->CreateEvent("streetview_deleted");
	
// prepare information for an eventual upgrade
	$this->SetPreference("makerversion","1.8.9.3");

// put mention into the admin log
	$this->Audit( 0, $this->Lang("friendlyname"), $this->Lang("installed",$this->GetVersion()));

?>
