<?php

class cggm_address_lookup
{
  static private $_lookup_service;
  static private $_api_key;
  static private $_lookup_policy;


  static private function initialize()
  {
    if( self::$_lookup_service == '' )
      {
	$mod = cge_utils::get_module('CGGoogleMaps');
	if( $mod )
	  {
	    self::$_lookup_service = $mod->GetPreference('address_lookup_service','GOOGLE');
	    self::$_lookup_policy  = $mod->GetPreference('address_lookup_policy','CACHE');
	    self::$_api_key        = $mod->GetPreference('google_apikey','');
	  }
      }
  }


  static private function cache_lookup($address)
  {
    if( empty($address) ) return FALSE;

    $db = cmsms()->GetDb();
    $query = 'SELECT lon,lat FROM '.cms_db_prefix().'module_cggooglemaps_cache WHERE address = ?';
    $tmp = $db->GetRow($query,array($address));
    if( !$tmp || !is_array($tmp) ) return FALSE;

    return array($tmp['lat'],$tmp['lon']);
  }


  static private function cache_address($address,$coords)
  {
    if( !$address || !is_array($coords) || count($coords) != 2 ) return FALSE;

    $db = cmsms()->GetDb();
    $query = 'INSERT INTO '.cms_db_prefix().'module_cggooglemaps_cache
              (address,lat,lon) VALUES (?,?,?)';
    $dbr = $db->Execute($query,array($address,$coords[0],$coords[1]));
    if( !$dbr ) 
      {
	debug_display($db->sql); debug_display($db->ErrorMsg()); die();
	return FALSE;
      }
    return TRUE;
  }


  static public function geo_lookup($address)
  {
    switch( self::$_lookup_service )
      {
      case 'GOOGLE':
      default:
	$url = sprintf('http://maps.google.com/maps/geo?&q=%s&output=csv&key=%s',
		       rawurlencode($address),self::$_api_key);
	$res = cge_http::get($url);
	if( $res )
	  {
	    $parts = explode(',',$res);
	    if( $parts[0] != 200 ) return FALSE;

	    return array($parts[2],$parts[3]);
	  }
	break;
      }

    return FALSE;
  }


  static public function lookup($address)
  {
    self::initialize();
    $address = trim($address);
    if( empty($address) ) return FALSE;

    $coords = FALSE;
    switch( self::$_lookup_policy )
    {
    case 'NOCACHE':
      $coords = self::geo_lookup($address);
      break;

    case 'CACHEONLY':
      $coords = self::cache_lookup($address);
      break;

    case 'CACHEFIRST':
    default:
      $coords = self::cache_lookup($address);
      if( !$coords )
	{
	  $coords = self::geo_lookup($address);
	  if( !$coords ) return FALSE;

	  self::cache_address($address,$coords);
	}
      break;
    }

    return $coords;
  }

} // end of class

?>