<?php
#-------------------------------------------------------------------------
# Module: CGGoogleMaps - A simple module for creating google maps.
# Version: 1.0, calguy1000 <calguy1000@hotmail.com>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------


$cgextensions = cms_join_path($gCms->config['root_path'],'modules',
			      'CGExtensions','CGExtensions.module.php');
if( !is_readable( $cgextensions ) )
{
  echo '<h1><font color="red">ERROR: The CGExtensions module could not be found.</font></h1>';
  return;
}
require_once($cgextensions);

define('CGGM_PREF_NEWMAP_TEMPLATE','cggm_pref_newmap_template');
define('CGGM_PREF_NEWSIEBAR_TEMPLATE','cggm_pref_newsidebar_template');
define('CGGM_PREF_NEWCATEGORY_TEMPLATE','cggm_pref_newcategory_template');
define('CGGM_PREF_DFLTMAP_TEMPLATE','cggm_pref_dfltmap_template');
define('CGGM_NEWJS_TEMPLATE','cggm_newjs_template');
define('CGGM_NEWSIDEBAR_TEMPLATE','cggm_newsidebar_template');
define('CGGM_NEWCATEGORY_TEMPLATE','cggm_newcategory_template');
define('CGGM_NEWDIRFORM_TEMPLATE','cggm_newdirform_template');
define('CGGM_NEWBALOON_TEMPLATE','cggm_baloon_template');

/**
 * Add a category to the map.
 *
 * @ignore
 */
function cggm_add_category($params, &$smarty)
{
  $map = '';
  if( isset($params['map']) )
    {
      $map = $params['map'];
    }
  else
   {
      global $gCms;
      $mod =& $gCms->modules['CGGoogleMaps']['object'];
      $map = $mod->GetPreference('default_map',0);
   }

  if( !isset($params['name']) )
    {
      // name is required
      return; 
    }
  $name = $params['name'];
  
  $key = $name;
  if( isset($params['key']) )
    {
      $key = trim($params['name']);
    }

  $description = '';
  if( isset($params['desc']) )
    {
      $description = $params['desc'];
    }
  if( isset($params['description']) )
    {
      $description = $params['description'];
    }
  
  $icon = '';
  if( isset($params['icon']) )
    {
      $icon = $params['icon'];
    }

  $mod = cge_utils::get_module('CGGoogleMaps');
  $obj = new cggm_category($name,$key);
  $obj->set_description($description);
  $obj->set_icon($icon);
  $mod->add_map_category($map,$obj);
}


/*---------------------------------------------------------
 cggm_add_dynpoint()
 ---------------------------------------------------------*/
function cggm_add_dynpoint($params, &$smarty)
{
  $mod = cge_utils::get_module('CGGoogleMaps');
  if( !$mod ) return;
  $map = '';
  if( isset($params['map']) )
    {
      $map = $params['map'];
    }
  else
    {
      $map = $mod->GetPreference('default_map',0);
    }
  
  if( !isset($params['name']) )
    {
      // name is required
      return; 
    }
  $name = $params['name'];

  $description = '';
  if( isset($params['desc']) )
    {
      $description = $params['desc'];
    }
  if( isset($params['description']) )
    {
      $description = $params['description'];
    }
  
  $address = '';
  if( isset($params['address']) )
    {
      $address = $params['address'];
    }
  
  $lat = '';
  if( isset($params['lat']) )
    {
      $lat = $params['lat'];
    }
  
  $long = '';
  if( isset($params['long']) )
    {
      $long = $params['long'];
    }

  $icon = '';
  if( isset($params['icon']) )
    {
      $icon = $params['icon'];
    }

  $obj = new cggm_marker($name,$address,$lat,$long,$icon);
  $obj->set_description($description);
  if( isset($params['category']) )
    {
      $tmp = trim($params['category']);
      if( $tmp )
	{
	  $obj->add_category(trim($tmp));
	}
    }

  if( isset($params['tooltip']) )  $obj->set_tooltip($params['tooltip']);
  $mod->add_map_point($map,$obj);
}


/* ---- Begin Class --- */
class CGGoogleMaps extends CGExtensions
{
  var $_dynamic_points;
  var $_dyn_categories;

  /*---------------------------------------------------------
   CGGoogleMaps() -- Constructor
   ---------------------------------------------------------*/
  function CGGoogleMaps()
  {
    parent::CMSModule();
    $this->_dynamic_points = null;
    $this->AddImageDir('icons');

    global $gCms;
    $smarty =& $gCms->GetSmarty();
    $smarty->register_function('cggm_add_dynpoint','cggm_add_dynpoint');
  }

  /*---------------------------------------------------------
   GetName()
   ---------------------------------------------------------*/
  function GetName()
  {
    return 'CGGoogleMaps';
  }

  /*---------------------------------------------------------
   GetFriendlyName()
   ---------------------------------------------------------*/
  function GetFriendlyName()
  {
    return $this->Lang('friendlyname');
  }

	
  /*---------------------------------------------------------
   GetVersion()
   ---------------------------------------------------------*/
  function GetVersion()
  {
    return '2.1';
  }


  /*---------------------------------------------------------
   GetHelp()
   ---------------------------------------------------------*/
  function GetHelp()
  {
    return $this->Lang('help');
  }


  /*---------------------------------------------------------
   GetAuthor()
   ---------------------------------------------------------*/
  function GetAuthor()
  {
    return 'calguy1000';
  }


  /*---------------------------------------------------------
   GetAuthorEmail()
   ---------------------------------------------------------*/
  function GetAuthorEmail()
  {
    return 'calguy1000@hotmail.com';
  }


  /*---------------------------------------------------------
   GetChangeLog()
   ---------------------------------------------------------*/
  function GetChangeLog()
  {
    return file_get_contents(dirname(__FILE__).'/changelog.inc');
  }
  
  /*---------------------------------------------------------
   IsPluginModule()
   ---------------------------------------------------------*/
  function IsPluginModule()
  {
    return true;
  }


  /*---------------------------------------------------------
   HasAdmin()
   ---------------------------------------------------------*/
  function HasAdmin()
  {
    return true;
  }


  /*---------------------------------------------------------
   GetAdminSection()
   ---------------------------------------------------------*/
  function GetAdminSection()
  {
    return 'extensions';
  }


  /*---------------------------------------------------------
   GetAdminDescription()
   ---------------------------------------------------------*/
  function GetAdminDescription()
  {
    return $this->Lang('moddescription');
  }


  /*---------------------------------------------------------
   GetHeaderHTML()
   ---------------------------------------------------------*/
  function GetHeaderHTML()
  {
    $obj =& $this->GetModuleInstance('JQueryTools');
    if( is_object($obj) )
      {
$tmpl = <<<EOT
{JQueryTools action='incjs' exclude='form'}
{JQueryTools action='ready'}
EOT;
        return $this->ProcessTemplateFromData($tmpl);
      }
  }	


  /*---------------------------------------------------------
   VisibleToAdminUser()
   ---------------------------------------------------------*/
  function VisibleToAdminUser()
  {
    return $this->CheckPermission('Manage Maps') ||
      $this->CheckPermission('Modify Templates') ||
      $this->CheckPermission('Manage Map Locations') ||
      $this->CheckPermission('Modify Site Preferences');
  }


  /*---------------------------------------------------------
   GetDependencies()
   ---------------------------------------------------------*/
  function GetDependencies()
  {
    return array('CGExtensions'=>'1.22.2',
		 'CGSimpleSmarty'=>'1.4');
  }


  /*---------------------------------------------------------
   MinimumCMSVersion()
   ---------------------------------------------------------*/
  function MinimumCMSVersion()
  {
    return "1.9.1";
  }
	
	
  /*---------------------------------------------------------
   SetParameters()
   ---------------------------------------------------------*/
  function SetParameters()
  {
    $this->RegisterModulePlugin();
    $this->RestrictUnknownParams();

    $this->CreateParameter('map','',$this->Lang('help_param_map'));
    $this->SetParameterType('map',CLEAN_STRING);
    
    $this->CreateParameter('defer','0',$this->Lang('help_param_defer'));
    $this->SetParameterType('defer',CLEAN_INT);

    $this->CreateParameter('maptemplate','',$this->Lang('help_param_maptemplate'));
    $this->SetParameterType('maptemplate',CLEAN_STRING);
  }


  /*---------------------------------------------------------
   InstallPostMessage()
   ---------------------------------------------------------*/
  function InstallPostMessage()
  {
    return $this->Lang('postinstall');
  }


  /*---------------------------------------------------------
   UninstallPostMessage()
   ---------------------------------------------------------*/
  function UninstallPostMessage()
  {
    return $this->Lang('postuninstall');
  }


  /*---------------------------------------------------------
   UninstallPreMessage()
   ---------------------------------------------------------*/
  function UninstallPreMessage()
  {
    return $this->Lang('really_uninstall');
  }	


  /*---------------------------------------------------------
   AllowAutoInstall()
   ---------------------------------------------------------*/
  function AllowAutoInstall() {
    return FALSE;
  }


  /*---------------------------------------------------------
   AllowAutoUpgrade()
   ---------------------------------------------------------*/
  function AllowAutoUpgrade() {
    return FALSE;
  }


  /*---------------------------------------------------------
   GetCoordsFromAddress()
   ---------------------------------------------------------*/
  function GetCoordsFromAddress($address)
  {
    $tmp = cggm_address_lookup::lookup($address);
    if( is_array($tmp) )
      {
	$data = array();
	$data['lat'] = $tmp[0];
	$data['lon'] = $tmp[1];
	return $data;
      }
    return $tmp;
  }


  // getBoundingBox
  // hacked out by ben brown <ben@xoxco.com>
  // http://xoxco.com/clickable/php-getboundingbox
  // given a latitude and longitude in degrees (40.123123,-72.234234) and a distance in miles
  // calculates a bounding box with corners $distance_in_miles away from the point specified.
  // returns $min_lat,$max_lat,$min_lon,$max_lon 
  function GetBoundingBox($lat_degrees,$lon_degrees,$distance_in_miles) 
  {
	
    $radius = 3963.1; // of earth in miles
	
    // bearings	
    $due_north = 0;
    $due_south = 180;
    $due_east = 90;
    $due_west = 270;
	
    // convert latitude and longitude into radians 
    $lat_r = deg2rad($lat_degrees);
    $lon_r = deg2rad($lon_degrees);
			
    // find the northmost, southmost, eastmost and westmost corners $distance_in_miles away
    // original formula from
    // http://www.movable-type.co.uk/scripts/latlong.html
	
    $northmost  = asin(sin($lat_r) * cos($distance_in_miles/$radius) + cos($lat_r) * sin ($distance_in_miles/$radius) * cos($due_north));
    $southmost  = asin(sin($lat_r) * cos($distance_in_miles/$radius) + cos($lat_r) * sin ($distance_in_miles/$radius) * cos($due_south));
		
    $eastmost = $lon_r + atan2(sin($due_east)*sin($distance_in_miles/$radius)*cos($lat_r),cos($distance_in_miles/$radius)-sin($lat_r)*sin($lat_r));
    $westmost = $lon_r + atan2(sin($due_west)*sin($distance_in_miles/$radius)*cos($lat_r),cos($distance_in_miles/$radius)-sin($lat_r)*sin($lat_r));			
			
    $northmost = rad2deg($northmost);
    $southmost = rad2deg($southmost);
    $eastmost = rad2deg($eastmost);
    $westmost = rad2deg($westmost);
			
    // sort the lat and long so that we can use them for a between query		
    if ($northmost > $southmost) { 
      $lat1 = $southmost;
      $lat2 = $northmost;
		
    } else {
      $lat1 = $northmost;
      $lat2 = $southmost;
    }
	
	
    if ($eastmost > $westmost) { 
      $lon1 = $westmost;
      $lon2 = $eastmost;
		
    } else {
      $lon1 = $eastmost;
      $lon2 = $westmost;
    }
		
    return array($lat1,$lat2,$lon1,$lon2);
  }

function AddDynamicPoint($map,$name,$description,$address='',$lat='',$long='',$icon='',$tooltip = '',
			 $sidebar_class = '',$sidebar_html = '')
  {
    if( empty($map) ) return FALSE;
    if( empty($name) ) return FALSE;
    if( empty($address) && (empty($lat) || empty($long)) ) return FALSE;

    if( !is_array($this->_dynamic_points) )
      {
	$this->_dynamic_points = array();
      }
    if( !isset($this->_dynamic_points[$map]) )
      {
	$this->_dynamic_points[$map] = array();
      }

    // everything is good to go, build the point object.
    $obj = new cggm_marker($name,$address,$lat,$long,$icon);
    $obj->set_description($description);
    $this->add_map_point($map,$obj);
  }


  public function add_map_point($map,cggm_marker& $obj)
  {
    // todo, convert map name to a map id here.
    $map = (int)$map;
    if( !is_array($this->_dynamic_points) )
      {
	$this->_dynamic_points = array();
      }
    if( !isset($this->_dynamic_points[$map]) )
      {
	$this->_dynamic_points[$map] = array();
      }

    $this->_dynamic_points[$map][] = $obj;
  }


  public function add_map_category($map,cggm_category& $obj)
  {
    if( $map == '' ) return FALSE;
    if( !is_array($this->_dyn_categories) )
      {
	$this->_dyn_categories = array();
      }
    if( !isset($this->_dyn_categories[$map]) )
      {
	$this->_dyn_categories[$map] = array();
      }

    $this->_dyn_categories[$map][] = $obj;
  }
} // class

?>
