<?php
if (!isset($gCms)) exit;

if (! $this->CheckAccess())
    {
    return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
    }

/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

   Code for SEOTools "defaultadmin" admin action
   
   -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
   
   Typically, this will display something from a template
   or do some other task.
   
*/

// Do the action
if (isset($_GET['what']) && $_GET['what'] == 'toggle_index') {
    $db =& $gCms->db;
    $query = 'SELECT * FROM '.cms_db_prefix().'module_seotools WHERE content_id = '.$_GET['content_id'];
    $result =& $db->Execute($query);
    $info = $result->fetchRow();
    if ($info['indexable'] == "1") {
        $query = 'UPDATE '.cms_db_prefix().'module_seotools SET indexable = 0 WHERE content_id = '.$_GET['content_id'];
    }else{
        $query = 'INSERT INTO '.cms_db_prefix().'module_seotools SET content_id = '.$_GET['content_id'].', indexable = 0 ON DUPLICATE KEY UPDATE indexable = 1';
    }
    $db->Execute($query);
    if ($this->getPreference('create_robots','true') == 'true') {
        $this->createRobotsTXT();
    }
    if ($this->getPreference('create_sitemap','true') == 'true') {
        $this->createSitemap($this->getPreference('push_sitemap','true') == true);
    }
    $_GET['tab'] = 'pagedescriptions';
}   

if (isset($_GET['what']) && $_GET['what'] == 'set_priority') {
    $db =& $gCms->db;    
    $query = 'INSERT INTO '.cms_db_prefix().'module_seotools SET content_id = '.$_GET['content_id'].', priority = '.$_GET['priority'].' ON DUPLICATE KEY UPDATE priority = '.$_GET['priority'];    
    $db->Execute($query);
    $_GET['tab'] = 'pagedescriptions';
    if ($this->getPreference('create_sitemap','true') == 'true') {
        $this->createSitemap($this->getPreference('push_sitemap','true') == true);
    }
}

if (isset($_GET['what']) && $_GET['what'] == 'reset_priority') {
    $db =& $gCms->db;    
    $query = 'UPDATE '.cms_db_prefix().'module_seotools SET priority = NULL WHERE content_id = '.$_GET['content_id'];    
    $db->Execute($query);
    $_GET['tab'] = 'pagedescriptions';
    if ($this->getPreference('create_sitemap','true') == 'true') {
        $this->createSitemap($this->getPreference('push_sitemap','true') == true);
    }
}

if (isset($_GET['what']) && $_GET['what'] == 'reset_ogtype') {
    $db =& $gCms->db;    
    $query = 'UPDATE '.cms_db_prefix().'module_seotools SET ogtype = NULL WHERE content_id = '.$_GET['content_id'];    
    $db->Execute($query);
    $_GET['tab'] = 'pagedescriptions';
}

if (isset($_GET['what']) && $_GET['what'] == 'reset_keywords') {
    $db =& $gCms->db;    
    $query = 'UPDATE '.cms_db_prefix().'module_seotools SET keywords = NULL WHERE content_id = '.$_GET['content_id'];    
    $db->Execute($query);
    $_GET['tab'] = 'pagedescriptions';
}

if (isset($_GET['what']) && $_GET['what'] == 'edit_ogtype') {
    echo $this->Redirect(null, 'edit_ogtype', $this->returnid, Array('content_id'=>$_GET['content_id']));
}

if (isset($_GET['what']) && $_GET['what'] == 'edit_keywords') {
    echo $this->Redirect(null, 'edit_keywords', $this->returnid, Array('content_id'=>$_GET['content_id']));
}
    
    
$this->smarty->assign('tab_headers',$this->StartTabHeaders().
    $this->SetTabHeader('seoalerts',$this->Lang('title_seoalerts')).
    $this->SetTabHeader('pagedescriptions',$this->Lang('title_pagedescriptions'), (isset($_GET['tab']) && $_GET['tab'] == 'pagedescriptions')).  
    $this->SetTabHeader('metasettings',$this->Lang('title_metasettings'), (isset($_GET['tab']) && $_GET['tab'] == 'metasettings')).
    $this->SetTabHeader('sitemapsettings',$this->Lang('title_sitemapsettings'), (isset($_GET['tab']) && $_GET['tab'] == 'sitemapsettings')).
    $this->SetTabHeader('keywordsettings',$this->Lang('title_keywordsettings'), (isset($_GET['tab']) && $_GET['tab'] == 'keywordsettings')).
    $this->EndTabHeaders().$this->StartTabContent());
$this->smarty->assign('end_tab',$this->EndTab());
$this->smarty->assign('tab_footers',$this->EndTabContent());
$this->smarty->assign('start_seoalerts_tab',$this->StartTab('seoalerts'));
$this->smarty->assign('start_pagedescriptions_tab',$this->StartTab('pagedescriptions'));
$this->smarty->assign('start_metasettings_tab',$this->StartTab('metasettings'));
$this->smarty->assign('start_sitemapsettings_tab',$this->StartTab('sitemapsettings'));
$this->smarty->assign('start_keywordsettings_tab',$this->StartTab('keywordsettings'));
$this->smarty->assign('title_section','defaultadmin');

if (isset($_GET['message'])) {
  $this->smarty->assign('message',$this->showMessage($this->lang($_GET['message'])));
}

/* SEO Alerts Tab */

$alerts  = $this->createFieldsetStart(null, 'alerts_urgent', $this->Lang('title_alerts_urgent'));

$urgent_alerts = $this->getUrgentAlerts();

if (count($urgent_alerts) == 0) {
  $alerts .= '<img src="'.$gCms->config['root_url'].'/'.$gCms->config['admin_dir'].'/themes/'.$gCms->variables['admintheme']->themeName.'/images/icons/system/true.gif" align="absmiddle" /> '.$this->lang('nothing_to_be_fixed').'<br /><br />';
}else{
  $groups = Array();
  foreach ($urgent_alerts as $alert) {          
    $groups[$alert['group']][] = $alert;    
  }    
  foreach($groups as $group => $galerts) {
  	$count = count($galerts); 
    if (count($galerts) > 20) {
        $parts = array_chunk($galerts, 20);
        $galerts = $parts[0];
        $count = "> 20";
    }
    if (count($galerts) == 1) {
        $alerts .= '<img src="'.$gCms->config['root_url'].'/'.$gCms->config['admin_dir'].'/themes/'.$gCms->variables['admintheme']->themeName.'/images/Notifications/1.gif" align="absmiddle" /> <b>'.$galerts[0]['message'].'</b> ['.implode(' | ',$galerts[0]['links']).']<br /><br />';
    }else{
      $group_title = $this->lang('grouptitle_'.$group, Array($count));
      $alerts .= '<img src="'.$gCms->config['root_url'].'/'.$gCms->config['admin_dir'].'/themes/'.$gCms->variables['admintheme']->themeName.'/images/icons/Notifications/1.gif" align="absmiddle" /> <b>'.$group_title.'</b> [<a href="javascript:void(null)" onClick="document.getElementById(\'urgent_group_'.$group.'\').style.display = \'block\'">'.$this->lang('view_all').'</a>]<br /><br />';
      $alerts .= '<div id="urgent_group_'.$group.'" style="padding-left: 30px; display: none;">';
      foreach ($galerts as $alert) {
        $alerts .= '<img src="'.$gCms->config['root_url'].'/'.$gCms->config['admin_dir'].'/themes/'.$gCms->variables['admintheme']->themeName.'/images/Notifications/1.gif" align="absmiddle" /> <b>'.$alert['message'].'</b> ['.implode(' | ',$alert['links']).']<br /><br />';
      }
      $alerts .= '</div>';
    }
  }
}

$alerts .= $this->createFieldsetEnd(); 

$alerts .= $this->createFieldsetStart(null, 'alerts_important', $this->Lang('title_alerts_important'));

$important_alerts = $this->getImportantAlerts();
if (count($important_alerts) == 0) {
  $alerts .= '<img src="'.$gCms->config['root_url'].'/'.$gCms->config['admin_dir'].'/themes/'.$gCms->variables['admintheme']->themeName.'/images/icons/system/true.gif" align="absmiddle" /> '.$this->lang('nothing_to_be_fixed').'<br /><br />';
}else{
  $groups = Array();
  foreach ($important_alerts as $alert) {          
    $groups[$alert['group']][] = $alert;    
  }    
  foreach($groups as $group => $galerts) {
    $count = count($galerts); 
    if (count($galerts) > 20) {
        $parts = array_chunk($galerts, 20);
        $galerts = $parts[0];
        $count = "> 20";
    }
    if (count($galerts) == 1) {
        $alerts .= '<img src="'.$gCms->config['root_url'].'/'.$gCms->config['admin_dir'].'/themes/'.$gCms->variables['admintheme']->themeName.'/images/icons/Notifications/2.gif" align="absmiddle" /> <b>'.$galerts[0]['message'].'</b> ['.implode(' | ',$galerts[0]['links']).']<br /><br />';
    }else{
      $group_title = $this->lang('grouptitle_'.$group, Array($count));
      $alerts .= '<img src="'.$gCms->config['root_url'].'/'.$gCms->config['admin_dir'].'/themes/'.$gCms->variables['admintheme']->themeName.'/images/icons/Notifications/2.gif" align="absmiddle" /> <b>'.$group_title.'</b> [<a href="javascript:void(null)" onClick="document.getElementById(\'important_group_'.$group.'\').style.display = \'block\'">'.$this->lang('view_all').'</a>]<br /><br />';
      $alerts .= '<div id="important_group_'.$group.'" style="padding-left: 30px; display: none;">';
      foreach ($galerts as $alert) {
        $alerts .= '<img src="'.$gCms->config['root_url'].'/'.$gCms->config['admin_dir'].'/themes/'.$gCms->variables['admintheme']->themeName.'/images/icons/Notifications/2.gif" align="absmiddle" /> <b>'.$alert['message'].'</b> ['.implode(' | ',$alert['links']).']<br /><br />';
      }
      $alerts .= '</div>';
    }
  }
}

$alerts .= $this->createFieldsetEnd();

$alerts .= $this->createFieldsetStart(null, 'alerts_notices', $this->Lang('title_alerts_notices'));

$notice_alerts = $this->getNoticeAlerts();
if (count($notice_alerts) == 0) {
  $alerts .= '<img src="'.$gCms->config['root_url'].'/'.$gCms->config['admin_dir'].'/themes/'.$gCms->variables['admintheme']->themeName.'/images/icons/system/true.gif" align="absmiddle" /> '.$this->lang('nothing_to_be_fixed').'<br /><br />';
}else{
  foreach ($notice_alerts as $alert) {
    $alerts .= '<img src="'.$gCms->config['root_url'].'/'.$gCms->config['admin_dir'].'/themes/'.$gCms->variables['admintheme']->themeName.'/images/icons/Notifications/3.gif" align="absmiddle" /> <b>'.$alert['message'].'</b> ['.implode(' | ',$alert['links']).']<br /><br />';
  }  
}

$alerts .= $this->createFieldsetEnd();



/* Page settings Tab */

$pagesettings  = '<table class="pagetable">';
$pagesettings .= '<tr>';
$pagesettings .= '<th>'.$this->lang('page_id').'</th>';
$pagesettings .= '<th>'.$this->lang('page_name').'</th>';
$pagesettings .= '<th>'.$this->lang('priority').'</th>';
$pagesettings .= '<th>'.$this->lang('og_type').'</th>';
$pagesettings .= '<th>'.$this->lang('keywords').'</th>';
$pagesettings .= '<th>'.$this->lang('description').'</th>';
$pagesettings .= '<th>'.$this->lang('index').'</th>';
$pagesettings .= '</tr>';

$db =& $gCms->db;

$query = 'SELECT * FROM '.cms_db_prefix().'content ORDER BY hierarchy ASC';
$result =& $db->Execute($query);

$j = 0;
while ($page = $result->fetchRow()) {				
	
    $prefix = "";
    $auto_priority = 80;
    for ($i = 0; $i < substr_count($page['hierarchy'],'.'); $i++) {
        $prefix .= '&raquo; ';
        $auto_priority  = $auto_priority / 2;
    }
    if ($page['default_content'] == 1) {
        $auto_priority = 100;
    }
    $query = 'SELECT * FROM '.cms_db_prefix().'content_props WHERE content_id = '.$page['content_id'].' AND prop_name = "'.str_replace(' ','_',$this->getPreference('description_block','')).'"';         
    $result1 =& $db->Execute($query);
    $desc = $result1->fetchRow();   
    $description = $desc['content'];

    $kw = array_flip($this->getKeywordSuggestions($page['content_id']));
    
    $description_auto = false;
    if (($description == "") && ($this->getPreference('description_auto_generate','false') == 'true')) {
    	$last_keyword = array_pop($kw);
    	$keywords = implode(', ',$kw) . " " . $this->lang('and') . " " . $last_keyword;
    	$description = $this->lang('auto_generated').": ".str_replace('{keywords}',$keywords,$this->getPreference('description_auto',''));
    	$description = str_replace('{title}',$page['content_name'],$description);
    	$description_auto = true;
    }
    
    $default_ogtype = $this->getPreference('meta_opengraph_type','');

    $query = 'SELECT * FROM '.cms_db_prefix().'module_seotools WHERE content_id = '.$page['content_id'];
    $result2 =& $db->Execute($query);
    $info = $result2->fetchRow();       
        
    $priority = '(auto) '.$auto_priority.'% ';
    $ogtype = '(default) '.$default_ogtype.' '.$this->createTooltipLink(null, 'defaultadmin', '', '<img src="'.$gCms->config['root_url'].'/modules/SEOTools/img/edit.png" align="absmiddle" />', $this->lang('edit_value'), Array("what"=>"edit_ogtype","content_id"=>$page['content_id']));    
    $keywords = '(auto) '.count($kw).' '.$this->createTooltipLink(null, 'defaultadmin', '', '<img src="'.$gCms->config['root_url'].'/modules/SEOTools/img/edit.png" align="absmiddle" />', implode(', ',$kw).'; '.$this->lang('edit_value'), Array("what"=>"edit_keywords","content_id"=>$page['content_id']));
    $indexable = 'true';
    if ($info['content_id'] != "") {
        if ($info['priority'] != 0) {
          $priority = '<b>'.$info['priority'] . '% '.$this->createTooltipLink(null, 'defaultadmin', '', '<img src="'.$gCms->config['root_url'].'/modules/SEOTools/img/reset.png" align="absmiddle" />', $this->lang('reset_to_default'), Array("what"=>"reset_priority","content_id"=>$page['content_id'])) . '</b>';
          $auto_priority = $info['priority'];
        }
        if ($info['ogtype'] != "") {
          $ogtype = '<b>'.$info['ogtype'] . ' ' . $this->createTooltipLink(null, 'defaultadmin', '', '<img src="'.$gCms->config['root_url'].'/modules/SEOTools/img/reset.png" align="absmiddle" />', $this->lang('reset_to_default'), Array("what"=>"reset_ogtype","content_id"=>$page['content_id'])) . $this->createTooltipLink(null, 'defaultadmin', '', '<img src="'.$gCms->config['root_url'].'/modules/SEOTools/img/edit.png" align="absmiddle" />', $this->lang('edit_value'), Array("what"=>"edit_ogtype","content_id"=>$page['content_id'])).'</b>';
        }
        if ($info['keywords'] != "") {
            $keywords = '<b>'.count(explode(' ',$info['keywords'])) . $this->createTooltipLink(null, 'defaultadmin', '', '<img src="'.$gCms->config['root_url'].'/modules/SEOTools/img/reset.png" align="absmiddle" />', $this->lang('reset_to_default'), Array("what"=>"reset_keywords","content_id"=>$page['content_id'])) . $this->createTooltipLink(null, 'defaultadmin', '', '<img src="'.$gCms->config['root_url'].'/modules/SEOTools/img/edit.png" align="absmiddle" />', $this->lang('edit_value'), Array("what"=>"edit_keywords","content_id"=>$page['content_id'])).'</b>';
        }
        if ($info['indexable'] == 0) {        
          $indexable = 'false';
        }
    }
    
    $updown  = $this->createTooltipLink(null, 'defaultadmin', '', '<img src="'.$gCms->config['root_url'].'/'.$gCms->config['admin_dir'].'/themes/'.$gCms->variables['admintheme']->themeName.'/images/icons/system/arrow-d.gif" border="0" align="absmiddle" />', $this->lang('decrease_priority'), Array('what'=>'set_priority','priority'=>$auto_priority-10,'content_id'=>$page['content_id']));
    $updown .= $this->createTooltipLink(null, 'defaultadmin', '', '<img src="'.$gCms->config['root_url'].'/'.$gCms->config['admin_dir'].'/themes/'.$gCms->variables['admintheme']->themeName.'/images/icons/system/arrow-u.gif" border="0" align="absmiddle" />', $this->lang('increase_priority'), Array('what'=>'set_priority','priority'=>$auto_priority+10,'content_id'=>$page['content_id']));
    
    $pagesettings .= '<tr class="row'.($j % 2 + 1).'">';
    $pagesettings .= '<td>'.$page['content_id'].'</td>';
    $pagesettings .= '<td>'.$prefix .' '.$page['content_name'].'</td>';
    if ($page['type'] == 'content') {
      $pagesettings .= '<td>'.$updown.' '.$priority.'</td>';
      $pagesettings .= '<td>'.$ogtype.'</td>';
      $pagesettings .= '<td>'.$keywords.'</td>';
      if ($description != "") {
        if ($description_auto) {
      	  $pagesettings .= '<td><img src="'.$gCms->config['root_url'].'/'.$gCms->config['admin_dir'].'/themes/'.$gCms->variables['admintheme']->themeName.'/images/icons/system/warning.gif" title="'.strip_tags($description).'" /></td>';
        }else{
          $pagesettings .= '<td><img src="'.$gCms->config['root_url'].'/'.$gCms->config['admin_dir'].'/themes/'.$gCms->variables['admintheme']->themeName.'/images/icons/system/true.gif" title="'.strip_tags($description).'" /></td>';
        }
      }else{
        $pagesettings .= '<td><a href="editcontent.php?sp_='.$_GET['sp_'].'&content_id='.$page['content_id'].'"><img src="'.$gCms->config['root_url'].'/'.$gCms->config['admin_dir'].'/themes/'.$gCms->variables['admintheme']->themeName.'/images/icons/system/false.gif" border="0" title="'.$this->lang('click_to_add_description').'" /></a></td>';
      }
      $pagesettings .= '<td>'.$this->createTooltipLink(null, 'defaultadmin', '', '<img src="'.$gCms->config['root_url'].'/'.$gCms->config['admin_dir'].'/themes/'.$gCms->variables['admintheme']->themeName.'/images/icons/system/'.$indexable.'.gif" />', $this->lang('toggle'), Array('what'=>'toggle_index','content_id'=>$page['content_id'])).'</td>';
    }else{
    	$pagesettings .= '<td>---</td>';
    	$pagesettings .= '<td>---</td>';
    	$pagesettings .= '<td>---</td>';
    	$pagesettings .= '<td>---</td>';
    	$pagesettings .= '<td>---</td>';
    }
    $pagesettings .= '</tr>';
    $j++;
    
}

$pagesettings .= '</table>';

/* SEO Settings Tab */

// Get image files from /uploads/images
$files_list = Array($this->lang('none')=>"");
$dp = opendir($gCms->config['root_path'].'/uploads/images');
while ($file = readdir($dp)) {  
    if (strpos(substr($file, -5),'.gif') !== false) {
        $files_list[$file] = $file;
    }
    if (strpos(substr($file, -5),'.png') !== false) {
        $files_list[$file] = $file;
    }
    if (strpos(substr($file, -5),'.jpg') !== false) {
        $files_list[$file] = $file;
    }
    if (strpos(substr($file, -5),'.jpeg') !== false) {
        $files_list[$file] = $file;
    }
}
closedir($dp);

$settings  = $this->createFormStart(null, 'changesettings');

/* Page Title */
$settings .= $this->createFieldsetStart(null, 'title_description', $this->Lang('title_title_description'));
$settings .= '<p class="pagetext">'.$this->lang('title_title').':</p>';
$settings .= '<p class="pageinput">'.$this->createInputText(null, 'title', $this->getPreference('title','{title} | {$sitename} - {$title_keywords}'), 32).' '.$this->lang('title_title_help').'</p>';
$settings .= '<p class="pagetext">'.$this->lang('title_meta_title').':</p>';
$settings .= '<p class="pageinput">'.$this->createInputText(null, 'title_meta', $this->getPreference('title_meta','{title} | {$sitename}'), 32).' '.$this->lang('title_meta_help').'</p>';
$settings .= '<p class="pagetext">'.$this->lang('description_block_title').':</p>';
$settings .= '<p class="pageinput">'.$this->createInputText(null, 'description_block', $this->getPreference('description_block',''), 32).' '.$this->lang('description_block_help').'</p>';
$settings .= '<p class="pagetext">' . $this->Lang('description_auto_generate') . ': ' . $this->createInputCheckbox(null, 'description_auto_generate', 'true', $this->getPreference('description_auto_generate','false')) . '</p>';
$settings .= '<p class="pagetext">'.$this->lang('description_auto_title').':</p>';
$settings .= '<p class="pageinput">'.$this->createInputText(null, 'description_auto', $this->getPreference('description_auto','This page covers the topics {keywords}'), 32).' '.$this->lang('description_auto_help').'</p>';
$settings .= '<p class="pagetext">'.$this->lang('default_keywords_title').':</p>';
$settings .= '<p class="pageinput">'.$this->createInputText(null, 'default_keywords', $this->getPreference('default_keywords',''), 32).' '.$this->lang('default_keywords_help').'</p>';
$settings .= $this->createFieldsetEnd();

/* META Types */
$settings .= $this->createFieldsetStart(null, 'meta_type', $this->Lang('title_meta_type'));
$settings .= '<p class="pagetext">' . $this->Lang('meta_create_standard') . ': ' . $this->createInputCheckbox(null, 'meta_standard', 'true', $this->getPreference('meta_standard','true')) . '</p>';
$settings .= '<p class="pagetext">' . $this->Lang('meta_create_dublincore') . ': ' . $this->createInputCheckbox(null, 'meta_dublincore', 'true', $this->getPreference('meta_dublincore','false')) . '</p>';
$settings .= '<p class="pagetext">' . $this->Lang('meta_create_opengraph') . ': ' . $this->createInputCheckbox(null, 'meta_opengraph', 'true', $this->getPreference('meta_opengraph','false')) . '</p>';
$settings .= $this->createFieldsetEnd();

/* META Defaults */
$settings .= $this->createFieldsetStart(null, 'meta_defaults', $this->Lang('title_meta_defaults'));
$settings .= '<p class="pagetext">'.$this->lang('meta_publisher').':</p>';
$settings .= '<p class="pageinput">'.$this->createInputText(null, 'meta_publisher', $this->getPreference('meta_publisher',''), 32).' '.$this->lang('meta_publisher_help').'</p>';
$settings .= '<p class="pagetext">'.$this->lang('meta_contributor').':</p>';
$settings .= '<p class="pageinput">'.$this->createInputText(null, 'meta_contributor', $this->getPreference('meta_contributor',''), 32).' '.$this->lang('meta_contributor_help').'</p>';
$settings .= '<p class="pagetext">'.$this->lang('meta_copyright').':</p>';
$settings .= '<p class="pageinput">'.$this->createInputText(null, 'meta_copyright', $this->getPreference('meta_copyright','(C) '.date('Y').'. All rights reserved.'), 32).' '.$this->lang('meta_copyright_help').'</p><br />';

$settings .= '<p class="pagetext">&nbsp;</p>';
$settings .= '<p class="pageinput"><b>'.$this->lang('meta_location_description').'</b></p>';
$settings .= '<p class="pagetext">'.$this->lang('meta_location').':</p>';
$settings .= '<p class="pageinput">'.$this->createInputText(null, 'meta_location', $this->getPreference('meta_location',''), 32).' '.$this->lang('meta_location_help').'</p>';
$settings .= '<p class="pagetext">'.$this->lang('meta_region').':</p>';
$settings .= '<p class="pageinput">'.$this->createInputText(null, 'meta_region', $this->getPreference('meta_region',''), 5, 5).' '.$this->lang('meta_region_help').'</p>';
$settings .= '<p class="pagetext">'.$this->lang('meta_latitude').':</p>';
$settings .= '<p class="pageinput">'.$this->createInputText(null, 'meta_latitude', $this->getPreference('meta_latitude',''), 32).' '.$this->lang('meta_latitude_help').'</p>';
$settings .= '<p class="pagetext">'.$this->lang('meta_longitude').':</p>';
$settings .= '<p class="pageinput">'.$this->createInputText(null, 'meta_longitude', $this->getPreference('meta_longitude',''), 32).' '.$this->lang('meta_longitude_help').'</p><br />';

$settings .= '<p class="pagetext">&nbsp;</p>';
$settings .= '<p class="pageinput"><b>'.$this->lang('meta_opengraph_description').'</b></p>';
$settings .= '<p class="pagetext">'.$this->lang('meta_opengraph_title').':</p>';
$settings .= '<p class="pageinput">'.$this->createInputText(null, 'meta_opengraph_title', $this->getPreference('meta_opengraph_title','{title}'), 32).' '.$this->lang('meta_opengraph_title_help').'</p>';
$settings .= '<p class="pagetext">'.$this->lang('meta_opengraph_type').':</p>';
$settings .= '<p class="pageinput">'.$this->createInputText(null, 'meta_opengraph_type', $this->getPreference('meta_opengraph_type',''), 32).' '.$this->lang('meta_opengraph_type_help').'</p>';
$settings .= '<p class="pagetext">'.$this->lang('meta_opengraph_sitename').':</p>';
$settings .= '<p class="pageinput">'.$this->createInputText(null, 'meta_opengraph_sitename', $this->getPreference('meta_opengraph_sitename',''), 32).' '.$this->lang('meta_opengraph_sitename_help').'</p>';
$settings .= '<p class="pagetext">'.$this->lang('meta_opengraph_image').':</p>';
$settings .= '<p class="pageinput">'.$this->createInputDropdown(null, 'meta_opengraph_image', $files_list, null, $this->getPreference('meta_opengraph_image','')).' '.$this->lang('meta_opengraph_image_help').'</p>';
$settings .= '<p class="pagetext">'.$this->lang('meta_opengraph_admins').':</p>';
$settings .= '<p class="pageinput">'.$this->createInputText(null, 'meta_opengraph_admins', $this->getPreference('meta_opengraph_admins',''), 32).' '.$this->lang('meta_opengraph_admins_help').'</p>';
$settings .= '<p class="pagetext">'.$this->lang('meta_opengraph_application').':</p>';
$settings .= '<p class="pageinput">'.$this->createInputText(null, 'meta_opengraph_application', $this->getPreference('meta_opengraph_application',''), 32).' '.$this->lang('meta_opengraph_application_help').'</p>';
$settings .= $this->createFieldsetEnd();

/* Additional Meta Tags */
$settings .= $this->createFieldsetStart(null, 'additional_meta', $this->Lang('title_additional_meta_tags'));
$settings .= '<p class="pagetext">'.$this->lang('additional_meta_tags_title').':</p>';
$settings .= '<p class="pageinput">'.$this->createTextArea(false, null, $this->getPreference('additional_meta_tags',''), 'additional_meta_tags').' '.$this->lang('additional_meta_tags_help').'</p>';
$settings .= $this->createFieldsetEnd();

$settings .= '<p class="pageinput">'.$this->createInputSubmit(null, 'save_meta_settings', $this->lang('save')).'</p>';
$settings .= $this->createFormEnd(); 

$settings .= '<br /><br />'.$this->lang('help_description_content');

/* SITEMAP Settings */

$ssettings  = $this->createFormStart(null, 'changesettings');

$ssettings .= $this->createFieldsetStart(null, 'sitemap_description', $this->Lang('title_sitemap_description'));
$ssettings .= '<p class="pagetext">' . $this->Lang('create_sitemap_title') . ': ' . $this->createInputCheckbox(null, 'create_sitemap', 'true', $this->getPreference('create_sitemap','false')) . '</p>';
if (ini_get('allow_url_fopen')) {
  $ssettings .= '<p class="pagetext">' . $this->Lang('push_sitemap_title') . ': ' . $this->createInputCheckbox(null, 'push_sitemap', 'true', $this->getPreference('push_sitemap','false')) . '</p>';
}else{
  $ssettings .= '<p class="pagetext">' . $this->Lang('push_sitemap_title') . ': ' . $this->Lang('no_url_fopen') . '</p>';
}
$ssettings .= '<p class="pagetext">' . $this->Lang('create_robots_title') . ': ' . $this->createInputCheckbox(null, 'create_robots', 'true', $this->getPreference('create_robots','false')) . '</p>';
$ssettings .= '<p class="pagetext">'.$this->lang('verification_title').':</p>';
$ssettings .= '<p class="pageinput">'.$this->createInputText(null, 'verification', $this->getPreference('verification',''), 32).' '.$this->lang('verification_help').'</p>';
$ssettings .= $this->createFieldsetEnd();

$ssettings .= '<p class="pageinput">'.$this->createInputSubmit(null, 'save_sitemap_settings', $this->lang('save')).'</p>';

$ssettings .= $this->createFormEnd(); 

$ssettings .= $this->createFormStart(null, 'changesettings');
$ssettings .= $this->createFieldsetStart(null, 'regenerate_sitemap', $this->Lang('title_regenerate_sitemap'));
$ssettings .= '<p class="pagetext">&nbsp;</p>';
$ssettings .= '<p class="pageinput">'.$this->createInputSubmit(null, 'do_regenerate', $this->lang('button_regenerate_sitemap')).'</p>';
$ssettings .= '<p class="pagetext">&nbsp;</p>';
$ssettings .= '<p class="pageinput">'.$this->lang('text_regenerate_sitemap').'</p>';
$ssettings .= $this->createFieldsetEnd();
$ssettings .= $this->createFormEnd();

$ssettings .= '<br /><br />'.$this->lang('help_sitemap_robots');

/* KEYWORD Settings */

$ksettings  = $this->createFormStart(null, 'changesettings');

$ksettings .= $this->createFieldsetStart(null, 'keyword_weight_description', $this->Lang('title_keyword_weight'));
$ksettings .= '<p class="pagetext">'.$this->lang('keyword_minlength_title').':</p>';
$ksettings .= '<p class="pageinput">'.$this->createInputText(null, 'keyword_minlength', $this->getPreference('keyword_minlength','6'), 2).' '.$this->lang('keyword_minlength_help').'</p>';
$ksettings .= '<p class="pagetext">'.$this->lang('keyword_title_weight_title').':</p>';
$ksettings .= '<p class="pageinput">'.$this->createInputText(null, 'keyword_title_weight', $this->getPreference('keyword_title_weight','6'), 2).' '.$this->lang('keyword_title_weight_help').'</p>';
$ksettings .= '<p class="pagetext">'.$this->lang('keyword_description_weight_title').':</p>';
$ksettings .= '<p class="pageinput">'.$this->createInputText(null, 'keyword_description_weight', $this->getPreference('keyword_description_weight','4'), 2).' '.$this->lang('keyword_description_weight_help').'</p>';
$ksettings .= '<p class="pagetext">'.$this->lang('keyword_headline_weight_title').':</p>';
$ksettings .= '<p class="pageinput">'.$this->createInputText(null, 'keyword_headline_weight', $this->getPreference('keyword_headline_weight','2'), 2).' '.$this->lang('keyword_headline_weight_help').'</p>';
$ksettings .= '<p class="pagetext">'.$this->lang('keyword_content_weight_title').':</p>';
$ksettings .= '<p class="pageinput">'.$this->createInputText(null, 'keyword_content_weight', $this->getPreference('keyword_content_weight','1'), 2).' '.$this->lang('keyword_content_weight_help').'</p>';
$ksettings .= '<p class="pagetext">'.$this->lang('keyword_minimum_weight_title').':</p>';
$ksettings .= '<p class="pageinput">'.$this->createInputText(null, 'keyword_minimum_weight', $this->getPreference('keyword_minimum_weight','7'), 2).' '.$this->lang('keyword_minimum_weight_help').'</p>';
$ksettings .= $this->createFieldsetEnd();

$ksettings .= $this->createFieldsetStart(null, 'keyword_exclude_description', $this->Lang('title_keyword_exclude'));
$ksettings .= '<p class="pagetext">'.$this->lang('keyword_exclude_title').':</p>';
$ksettings .= '<p class="pageinput">'.$this->createTextArea(false, null, $this->getPreference('keyword_exclude',''), 'keyword_exclude').' '.$this->lang('keyword_exclude_help').'</p>';
$ksettings .= $this->createFieldsetEnd();

$ksettings .= '<p class="pageinput">'.$this->createInputSubmit(null, 'save_keyword_settings', $this->lang('save')).'</p>';
$ksettings .= $this->createFormEnd();

$ksettings .= '<br /><br />'.$this->lang('help_keyword_generator');


$this->smarty->assign('alerts',$alerts);
$this->smarty->assign('pagesettings',$pagesettings);
$this->smarty->assign('meta_form',$settings);
$this->smarty->assign('sitemap_form',$ssettings);
$this->smarty->assign('keyword_form',$ksettings);

echo $this->ProcessTemplate('adminpanel.tpl');


?>