<?php
if (!isset($gCms)) exit;

if (! $this->CheckAccess("Edit SEO Settings"))
	{
	return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
	}

/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

   Code for SEOTools "changesettings" admin action
   
   -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
   
   Typically, this will display something from a template
   or do some other task.
   
*/

// Regenerate Sitemap and robots.txt
if (isset($_POST['do_regenerate'])) {
	$this->createSitemap($this->getPreference('push_sitemap','true') == true);
    if ($this->getPreference('create_robots','true') == 'true') {
        $this->createRobotsTXT();
    }
	$this->audit("Test","SEO Tools","Manually regenerated sitemap.xml and robots.txt");
    $this->Redirect($this->id, 'defaultadmin', '', Array('message'=>'sitemap_regenerated','tab'=>'sitemapsettings'));
}	
	
if (isset($_POST['save_meta_settings'])) {	
	
$this->setPreference('meta_standard',$_POST['meta_standard']);
$this->setPreference('meta_dublincore',$_POST['meta_dublincore']);
$this->setPreference('meta_opengraph',$_POST['meta_opengraph']);
$this->setPreference('additional_meta_tags',$_POST['additional_meta_tags']);

$this->setPreference('meta_publisher',$_POST['meta_publisher']);
$this->setPreference('meta_contributor',$_POST['meta_contributor']);
$this->setPreference('meta_copyright',$_POST['meta_copyright']);

$this->setPreference('meta_location',$_POST['meta_location']);
$this->setPreference('meta_region',$_POST['meta_region']);
$this->setPreference('meta_latitude',$_POST['meta_latitude']);
$this->setPreference('meta_longitude',$_POST['meta_longitude']);

$this->setPreference('meta_opengraph_title',$_POST['meta_opengraph_title']);
$this->setPreference('meta_opengraph_type',$_POST['meta_opengraph_type']);
$this->setPreference('meta_opengraph_sitename',$_POST['meta_opengraph_sitename']);
$this->setPreference('meta_opengraph_image',$_POST['meta_opengraph_image']);
$this->setPreference('meta_opengraph_admins',$_POST['meta_opengraph_admins']);
$this->setPreference('meta_opengraph_application',$_POST['meta_opengraph_application']);

$this->setPreference('title',$_POST['title']);
$this->setPreference('title_meta',$_POST['title_meta']);
$this->setPreference('description_block',$_POST['description_block']);
$this->setPreference('description_auto_generate',$_POST['description_auto_generate']);
$this->setPreference('description_auto',$_POST['description_auto']);
$this->setPreference('default_keywords',$_POST['default_keywords']);

$this->audit("Test","SEO Tools","Edited Meta settings");
$this->Redirect($this->id, 'defaultadmin', '', Array('message'=>'settings_updated','tab'=>'metasettings'));
}

if (isset($_POST['save_sitemap_settings'])) {

$this->setPreference('create_sitemap',$_POST['create_sitemap']);
$this->setPreference('push_sitemap',$_POST['push_sitemap']);
$this->setPreference('create_robots',$_POST['create_robots']);
$this->setPreference('verification',$_POST['verification']);

$this->audit("Test","SEO Tools","Edited Sitemap settings");
$this->Redirect($this->id, 'defaultadmin', '', Array('message'=>'settings_updated','tab'=>'sitemapsettings'));
}

if (isset($_POST['save_keyword_settings'])) {

$this->setPreference('keyword_minlength',$_POST['keyword_minlength']);
$this->setPreference('keyword_title_weight',$_POST['keyword_title_weight']);
$this->setPreference('keyword_description_weight',$_POST['keyword_description_weight']);
$this->setPreference('keyword_headline_weight',$_POST['keyword_headline_weight']);
$this->setPreference('keyword_content_weight',$_POST['keyword_content_weight']);
$this->setPreference('keyword_minimum_weight',$_POST['keyword_minimum_weight']);

$this->setPreference('keyword_exclude',$_POST['keyword_exclude']);


$this->audit("Test","SEO Tools","Edited Keyword settings");
$this->Redirect($this->id, 'defaultadmin', '', Array('message'=>'settings_updated','tab'=>'keywordsettings'));
}


?>