<?php
class GAMadeSimple extends CMSModule
{
	function GetName()
	{
		return 'GAMadeSimple';
	}
	function GetFriendlyName()
	{
		return $this->Lang('friendlyname');
	}
	function GetVersion()
	{
		return '0.1';
	}
	function MinimumCMSVersion()
	{
		return '1.7';
	}
	function GetHelp()
	{
		return $this->Lang('help');
	}
	function GetAuthor()
	{
		return 'Nicoss01';
	}
	function GetAuthorEmail()
	{
		return 'contact@erreurs404.net';
	}
	function GetChangeLog()
	{
		return $this->Lang('changelog');
	}
	function IsPluginModule()
	{
		return true;
	}
	function HasAdmin()
	{
		return true;
	}
	function GetAdminSection()
	{
		return 'extensions';
	}
	function GetAdminDescription()
	{
		return $this->Lang('moddescription');
	}
	function VisibleToAdminUser() 
	{
		return ($this->CheckPermission('View GAMadeSimple') || $this->CheckPermission('Administrate GAMadeSimple'));
	}	
	function GetDependencies()
	{
		return array();
	}
	function Install()
	{
		$this->SetPreference('input_code_ga','');
		$this->CreatePermission('GAMadeSimple Admin', 'Manage GAMadeSimple');
	}
	function SetParameters() 
	{
		$this->RestrictUnknownParams();
		$this->RegisterModulePlugin();
		$this->CreateParameter('input_code_ga', "", $this->Lang('input_code_ga'));
		$this->SetParameterType('input_code_ga',CLEAN_STRING);
	}
	function InstallPostMessage()
	{
		return $this->Lang('postinstall');
	}
	function Uninstall()
	{
		$this->RemovePreference('input_code_ga');
		$this->RemovePermission('GAMadeSimple Admin');
	}
	function UninstallPreMessage()
	{
		return $this->Lang('uninstall_confirm');
	}
	function UninstallPostMessage()
	{
		return $this->Lang('postuninstall');
	}
	function saveGASettings($id, &$params, $returnid )
	{
		if( !$this->CheckPermission('Modify Site Preferences') )
			return;
		if( isset( $params['input_code_ga'] ) )
		{
			$this->SetPreference('input_code_ga',$params['input_code_ga']);
		}
		$this->Redirect($id,"defaultadmin",$returnid,array("module_message"=>$this->Lang('params_save_ok')));
	}
}
?>