<?php
$lang['friendlyname'] = 'OpenID Module';
$lang['postinstall'] = 'Post Install Message';
$lang['postuninstall'] = 'Post Uninstall Message"';
$lang['really_uninstall'] = 'Are you sure you want to uninstall the OpenID module?';
$lang['uninstalled'] = 'Module Uninstalled.';
$lang['installed'] = 'Module version %s installed.';
$lang['upgraded'] = 'Module upgraded to version %s.';
$lang['moddescription'] = 'This module adds OpenID login capabilities to CMS Made Simple and FrontEndUsers.';
$lang['changelog'] = '<ul>
<li>Version 1.0.0 First public release with support for OpenID and Facebook authentication</li>
</ul>';
$lang['help'] = '<h3>What Does This Do?</h3>
<p>The OpenID module provides functionality to add an OpenID or Facebook account to a registered frontend user. That user can then log in using that identity instead of the ordinary frontend account.</p>
<h3>How Do I Use It</h3>
<p><ol>
    <li>Make sure that FrontEndUsers is installed</li>
    <li>Install the OpenID module</li>
    <li>Check out the settings page if you want to use Facebook as a provider</li>
    <li>Add the tag <i>{OpenID}</i> to a new or an existing page</li>
    <li>Log in as an already registered frontend user</li>
    <li>Visit the page with the OpenID tag and register a provider</li>
    <li>Logout</li>
    <li>Revisit the page with the OpenID tag, select the same provider you just registered, authenticate and behold: You are now logged in</li>
</ol></p>
<h3>Support</h3>
<p>Getting OpenID to work properly can be a bit of a struggle if you are not
fortunate enough to have an environment that already has all the bits and pieces in place.
<br/>Some places to check before asking for help:<br/>
<ul>
    <li>The janrain README file in the /modules/OpenID/openid-php-openid-*version* directory</li>
    <li>Run the detect.php file in /modules/OpenID/openid-php-openid-*version*/examples/</li>
    <li>Try different OpenID providers in order to determine if all are broken or just some.
    A rule of thumb is that Facebook is a separate thing compared to the OpenID providers.
    Providers that use discovery (like Google) is different from the simpler ones like myOpenID</li>
    <li>Check your php error logs for any exceptions or error messages. Google any output for clues about how to solve them</li>
    <li>Set openid.debug to true in your config.php. This will output a ton of messages to the php error log</li>
</ul>
</p>
<h3>Credits</h3>
<p>The OpenID library is standing on the shoulders of giants, namely:
<ul>
    <li><a href="http://github.com/openid/php-openid/" target="_blank">PHP OpenID library by JanRain, Inc.</a></li>
    <li><a href="http://jvance.com/pages/JQueryOpenIDPlugin.xhtml" target="_blank">OpenID jQuery plugin by Jarret Vance</a></li>
    <li><a href="https://github.com/facebook/php-sdk/" target="_blank">Facebook PHP SDK</a></li>
    <li><a href="http://www.jquery.com" target="_blank">jQuery</a></li>
</ul>
</p>

<h3>Copyright and License</h3>
<p>Copyright &copy; 2010, <a href="mailto:openid@lennartssons.net">Henrik Lennartsson</a>. All Rights Are Reserved.</p>
<p>This module has been released under the <a href="http://www.apache.org/licenses/LICENSE-2.0.html">Apache License Version 2.0</a>. You must agree to this license before using the module.</p>
';
$lang['openid_providers'] = 'Enabled providers';
$lang['settings'] = 'Settings';
$lang['users'] = 'Users';
$lang['submit'] = 'Submit';
$lang['cancel'] = 'Cancel';
$lang['openid.fail'] = 'Your provided identity is <a href="%s">%s</a> but the login failed';
$lang['openid.success'] = 'Your provided identity is <a href="%s">%s</a> and you have been logged in as user %s';
$lang['openid.unknown'] = 'Your provided identity is <a href="%s">%s</a> but is not registered with any user.';
$lang['openid.redirecting'] = 'Please wait, redirecting to your selected OpenID provider';
?>
