<?php

/*
 *      Copyright 2010 Henrik Lennartsson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

/* @var $this OpenID */
/* @var $gCms CmsObject */

$smarty->assign('startform',
		$this->CreateFormStart( $id, 'admin_updatesettings'));
$smarty->assign('endform', $this->CreateFormEnd());

global $gCms;
$config = $gCms->GetConfig();

$smarty->assign('buggy_gmp_status', OpenID::GetConfigBool('openid.buggy.gmp') ? 'Enabled' : 'Disabled');

$smarty->assign('insecure_rand_status', OpenID::GetConfigBool('openid.insecure.rand') ? 'Enabled' : 'Disabled');

$smarty->assign('ca_file_override_status', OpenID::GetConfigBool('openid.ca.override') ? 'Enabled' : 'Disabled');

$smarty->assign('input_facebook_app_id',
        $this->CreateInputText($id,'input_facebook_app_id', $this->GetPreference('facebook_app_id'), 30));

$smarty->assign('input_facebook_app_secret',
        $this->CreateInputText($id,'input_facebook_app_secret', $this->GetPreference('facebook_app_secret'), 50));


$smarty->assign('debug_status', OpenID::GetConfigBool('openid.debug') ? 'Enabled' : 'Disabled');

$smarty->assign('submit',
		$this->CreateInputSubmit ($id, 'submit',
					  $this->Lang('submit'),'',''));
$smarty->assign ('cancel',
		 $this->CreateInputSubmit ($id, 'cancel',
					   $this->Lang('cancel')));

echo $this->ProcessTemplate('admin_tab_settings.tpl');
?>
