<?php

/*
 *      Copyright 2010 Henrik Lennartsson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

/* @var $this OpenID */
if (!isset($gCms)) exit;
global $params;
$this->Log("********************************");
$this->Log(" *** action.facebook.php");


global $gCms;
$smarty =& $gCms->GetSmarty();;

require_once dirname(__FILE__)."/facebook_2_1_2/facebook.php";

/* @var facebook Facebook */
$facebook = new Facebook(array(
  'appId'  => $this->GetPreference('facebook_app_id',''),
  'secret' => $this->GetPreference('facebook_app_secret',''),
  'cookie' => true,
));

$session = $facebook->getSession();

$me = null;

if ($session) {
  try {
    $facebookUid = $facebook->getUser();
    $me = $facebook->api('/me');
    $url = $me['link'];

    /* @var $feu FrontEndUsers */
    $feu = $this->GetModuleInstance('FrontEndUsers');
    if ($feu->LoggedIn()) {
        $this->Log("Registering user ".$facebookUid." as Facebook-identity");
        // User is logged in: Add Facebook identifer as user identity
        $this->RegisterOpenID($feu->LoggedInId(), 'facebook:'.$facebookUid, $url);

    } else {
        $this->Log("Logging in facebook user ".$facebookUid);
        // User is not logged in: Try to login user
        $uid = $this->GetUserId('facebook:'.$facebookUid);
        $this->Log("UID = ".$uid);
        $userinfo = $feu->GetUserInfo($uid);
        if ($userinfo[0]) {
            $username = $userinfo[1]['username'];
            $password = $userinfo[1]['password'];
            $this->Log("username/password : ".$username." ".$password);
            $result = $feu->Login($username, $password, '', true, true);
            $this->Log('Login message : '.$result[1]);
            if (!$result) {
                print $this->Lang('openid.fail', $url, $url);
            } else {
                print $this->Lang('openid.success', $url, $url, $username);
            }
        } else {
            $this->Log("Error while fetching userinfo for ".$uid." : ".$userinfo[1]);
            print $this->Lang('openid.unknown', $url, $url);
        }

    }

  } catch (FacebookApiException $e) {
    error_log($e);
  }
}

?>