<?php

/*
 *      Copyright 2010 Henrik Lennartsson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

if (!isset($gCms)) exit;
/* @var $this OpenID */
/* @var $gCms CmsObject */
global $gCms;

$smarty =& $gCms->GetSmarty();
$startform = $this->CreateFormStart($id, 'login', $returnid, 'post');
$startform = str_replace('class="', 'class="openid ', $startform);
$smarty->assign('startform', $startform);

$smarty->assign('facebookLoginUrl', $this->FacebookLoginUrl($id, 'facebook', $returnid));
$config = $gCms->GetConfig();
$smarty->assign('root_path', $config['root_path']);

/* @var $feu FrontEndUsers */
$feu = $this->GetModuleInstance('FrontEndUsers');
if (!$feu->LoggedIn()) {
    echo $this->ProcessTemplate('login_form.tpl');
} else {
    $registeredOpenIDs = $this->GetRegisteredOpenIDs();
    if (empty($registeredOpenIDs)) {
        echo $this->ProcessTemplate('register_provider.tpl');
    } else {
        echo $this->ProcessTemplate('list_providers.tpl');
    }
}

?>