<?php

/*
 *      Copyright 2010 Henrik Lennartsson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

/* @var $this OpenID */

if (!isset($gCms)) exit;
global $params;
global $gCms;
$smarty =& $gCms->GetSmarty();;

$this->Log("********************************");
$this->Log(" *** STEP 2 *** action.authenticate.php");

    $consumer = $this->GetConsumer();

    // Create consumer and complete authentication process
    $this->Log("before page");
    $returnPageId = $params['page'];
    $this->Log("page = ".$returnPageId);
    $returnUrl = $this->CreateLink($id, 'authenticate', $returnPageId, '', $params, '', true, true);
    $response = $consumer->complete($returnUrl);
    $this->Log("Response identiy URL : ".$response->identity_url);

// Check the response status.
    if ($response->status == Auth_OpenID_CANCEL) {
        // This means the authentication was cancelled.
        print 'Verification cancelled.';
    } else if ($response->status == Auth_OpenID_FAILURE) {
        // Authentication failed; display the error message.
        print "OpenID authentication failed: " . $response->message;
    } else if ($response->status == Auth_OpenID_SUCCESS) {

        /* @var $axresponse Auth_OpenID_AX_FetchResponse */
        $axresponse = Auth_OpenID_AX_FetchResponse::fromSuccessResponse($response);
        if ($axresponse) {
            $email = $axresponse->getSingle('http://axschema.org/contact/email');
            $this->Log('Got user email '.$email.' using attribute exchange');
            /*
            $sreg_resp = Auth_OpenID_SRegResponse::fromSuccessResponse($response);
            $sreg = $sreg_resp->contents();
            if (@$sreg['email']) {
                $success .= "  You also returned '".htmlentities($sreg['email']).
                    "' as your email.";
            }
            if (@$sreg['nickname']) {
                $success .= "  Your nickname is '".htmlentities($sreg['nickname']).
                    "'.";
            }
            if (@$sreg['fullname']) {
                $success .= "  Your fullname is '".htmlentities($sreg['fullname']).
                    "'.";
            }
            */
        }
        /* @var $feu FrontEndUsers */
        $feu = $this->GetModuleInstance('FrontEndUsers');
        if ($feu->LoggedIn()) {
            $this->Log("Registering user ".$response->identity_url." as OpenID-identity");
            // User is logged in: Add OpenID identifer and provider as user identity
            $this->RegisterOpenID($feu->LoggedInId(), $response->identity_url, $email);

        } else {
            $this->Log("Logging in user ".$response->identity_url);
            // User is not logged in: Try to login user
            $openid = $response->getDisplayIdentifier();
            $esc_identity = htmlentities($openid);
            $uid = $this->GetUserId($response->identity_url);
            $this->Log("UID = ".$uid);
            $userinfo = $feu->GetUserInfo($uid);
            if ($userinfo[0]) {
                $username = $userinfo[1]['username'];
                $password = $userinfo[1]['password'];
                $this->Log("username/password : ".$username." ".$password);
                $result = $feu->Login($username, $password, '', true, true);
                $this->Log('Login message : '.$result[1]);
                if (!$result) {
                    print $this->Lang('openid.fail', $esc_identity, $esc_identity);
                } else {
                    print $this->Lang('openid.success', $esc_identity, $esc_identity, $username);
                }
            } else {
                $this->Log("Error while fetching userinfo for ".$uid." : ".$userinfo[1]);
                print $this->Lang('openid.unknown', $esc_identity, $esc_identity);
            }
            
        }

    }

?>