<?php
class UpdateSiteinfoTask implements CmsRegularTask
{
  const  LASTUPDATE_SITEPREF   = 'UpdateSiteinfo_lastexecute';
  const  UPDATESITEINFOAGE_SITEPREF = 'update_site_info_age';


  public function get_name()
  {
    return "Update Siteinfo File"; 
  }


  public function get_description()
  {
    return "Updates the siteinfo.txt file for use by SimpleSiteMgr module."; 
  }


  public function test($time = '')
  {
    $age_days = (int)get_site_preference(self::UPDATESITEINFOAGE_SITEPREF,0);
    if( $age_days == 0 ) return FALSE;

    // do we need to do this task.
    // we only do it daily.
    if( !$time ) $time = time();
    $last_execute = get_site_preference(self::LASTUPDATE_SITEPREF,0);
    if( ($time - 24*60*60) >= $last_execute )
      {
	return TRUE;
      } 
    return FALSE;
  }


  public function execute($time = '')
  {
    if( !$time ) $time = time();
	
	$mn = 'nuSOAP';
	$aon = '1';
	$aoff = '0';
	$gCms = cmsms();
    $db = $gCms->GetDb();
    $query = 'UPDATE '.cms_db_prefix().'modules SET admin_only=? WHERE module_name=' . $mn;
    $result = $db->Execute($query, array($aoff));

    // do the task.
    $age_days = (int)get_site_preference(self::UPDATESITEINFOAGE_SITEPREF,0);

    $simplesiteinfo = $gCms->modules['SimpleSiteInfo']['object'];
    $simplesiteinfo->SaveInfoFile();

    $query = 'UPDATE '.cms_db_prefix().'modules SET admin_only=? WHERE module_name=' . $mn;
    $result = $db->Execute($query, array($aon));
	
    return TRUE;
  }


  public function on_success($time = '')
  {
    if( !$time ) $time = time();
    set_site_preference(self::LASTUPDATE_SITEPREF,$time);
  }


  public function on_failure($time = '')
  {
    if( !$time ) $time = time();
    // nothing here.
  }
}

?>

