<?php 
/*
Author: Noel McGran
Email:  nmcgran@telus.net

SimpleSiteInfoClient is a CMSmadesimple module that installs a 
UDT and Event Handlers in support of the SimpleSiteInfo module. 

*/
class SimpleSiteInfo extends CMSModule{
	function GetName(){
		return 'SimpleSiteInfo';
	}
	function GetFriendlyName(){
		return $this->Lang('friendlyname');
	}
	function GetVersion(){
		return '2.0';
	}
	function GetHelp(){
		return $this->Lang('help');
	}
	function GetAuthor(){
		return 'Noel McGran';
	}
	function GetAuthorEmail(){
		return 'nmcgran@telus.net';
	}
	function GetChangeLog(){
		return $this->Lang('changelog');
	}
	function SetParameters(){
		$this->RestrictUnknownParams();
	}
	function IsPluginModule(){
		return true;
	}
	function HasAdmin(){
		return true;
	}
	function GetAdminSection(){
		return 'extensions';
	}
	function GetAdminDescription(){
		return $this->Lang('moddescription');
	}
	function VisibleToAdminUser(){
        	return $this->CheckPermission('SimpleSiteInfo: Change Password');
	}
	function GetDependencies(){
		return array();
	}
	function MinimumCMSVersion(){
		return "1.6";
	}
	function InstallPostMessage(){
		return $this->Lang('postinstall');
	}
	function UninstallPostMessage(){
		return $this->Lang('postuninstall');
	}
/*	function NB_Encryption($string, $key){
   		$TD = mcrypt_module_open('tripledes', '', 'ecb', '');
   		$IV = mcrypt_create_iv (mcrypt_enc_get_iv_size($TD), MCRYPT_RAND);
   		mcrypt_generic_init($TD, $key, $IV);
   		$encrypted_data = mcrypt_generic($TD, $string);
   		mcrypt_generic_deinit($TD);
   		mcrypt_module_close($TD);
   		return $encrypted_data;
	}
	function SaveInfoFile(){
		// Basic Setup
		$gCms = cmsms();
		global $CMS_VERSION;
		$db = $gCms->GetDb();
		$config = $gCms->GetConfig();
		$modules = array_keys($gCms->modules);
		$admin_url = $config['root_url'].'/'.$config['admin_dir'];

		// Password query
		$query = "SELECT * FROM ".cms_db_prefix()."siteprefs WHERE sitepref_name LIKE 'SimpleSiteInfo%'";
		$dbresult = $db->Execute($query);
		$row = $dbresult->FetchRow();
		$version_file_pwd = $row['sitepref_value'];


		// Output File Setup
		$create_write = @fopen(($gCms->config["root_path"] . "/tmp/siteinfo.txt"), 'w') or die("ERROR set_version_file UDT: Can't create or open version file!!");

		// Output Start
		$file_out  = "CMSMS*\n";
		$file_out .= $admin_url . "*\n"; 
		$file_out .= $CMS_VERSION . "*\n"; 

		// Module Query
		$query = "SELECT * FROM ".cms_db_prefix()."modules WHERE active=1 ORDER BY module_name ASC";
		$dbresult = $db->Execute($query);

		while($dbresult && $row = $dbresult->FetchRow()) {
   			$file_out .= $row['module_name'] . "," .$row['version'] . "|\n";
		}

		$file_enc = $this->NB_Encryption($file_out,$version_file_pwd);

		fwrite($create_write, $file_enc);
		fclose($create_write);
	} */
}
?>
