<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Lytebox module for CMSMS - A simple wrapper to the Lytebox JavaScript class.
 *
 * PHP versions 4 and 5
 *
 * LICENSE:
 * Copyright (c) 2008-2010, Carsten Wiedmann
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY AUTHOR OR CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @category   Modules
 * @package    Lytebox
 * @author     Carsten Wiedmann <carsten_sttgt@gmx.de>
 * @copyright  2008-2010 Carsten Wiedmann
 * @license    http://www.freebsd.org/copyright/freebsd-license.html FreeBSD License
 * @version    SVN: $Id: method.upgrade.php 16 2010-11-28 16:38:21Z wiedmann $
 * @link       http://dev.cmsmadesimple.org/projects/lytebox
 */

if (!isset($gCms)) {
    exit;
}

/**
 * Upgrades the Lytebox module.
 *
 * @category   Modules
 * @package    Lytebox
 * @author     Carsten Wiedmann <carsten_sttgt@gmx.de>
 * @license    http://www.freebsd.org/copyright/freebsd-license.html  FreeBSD License
 * @version    Release: 0.3.1beta1
 * @link       http://dev.cmsmadesimple.org/projects/lytebox
 * @see        Lytebox
 */
class Lytebox_Upgrade extends Lytebox
{
    /**
     * contains the version of the old module
     *
     * @var string
     * @access protected
     */
    var $oldversion;

    /**
     * contains the version of the new module
     *
     * @var string
     * @access protected
     */
    var $newversion;

    /**
     * Lytebox_Upgrade()
     *
     * @param string &$oldversion The version we are upgrading from
     * @param string &$newversion The version we are upgrading to
     *
     * @uses Lytebox()
     * @uses $oldversion
     * @uses $newversion
     *
     * @return void
     * @access public
     */
    function Lytebox_Upgrade(&$oldversion, &$newversion)
    {
        parent::Lytebox();

        $this->oldversion =& $oldversion;
        $this->newversion =& $newversion;
    }

    /**
     * DoUpgrade()
     *
     * @uses Audit()
     * @uses Lang()
     * @uses cmsms()
     * @uses GetVersion()
     * @uses $oldversion
     *
     * @return void
     * @access public
     */
    function DoUpgrade()
    {
        /*
         * make the upgrade tasks
         */
        switch ($this->oldversion) {
        case '0.2.1beta1':
            /*
             * add 'projection' to the stylesheet media type
             */
            $cssid = (int) $this->GetPreference('cssid', '-1');
            if (-1 != $cssid) {
                $stylesheetops  =& cmsms()->GetStylesheetOperations();
                $stylesheet     = $stylesheetops->LoadStylesheetByID($cssid);
                if (is_object($stylesheet)) {
                    $stylesheet->media_type     = explode(', ', $stylesheet->media_type);
                    $stylesheet->media_type[]   = 'projection';
                    $stylesheet->media_type     = array_unique($stylesheet->media_type);
                    $stylesheet->media_type     = implode(', ', $stylesheet->media_type);

                    $stylesheetops->UpdateStylesheet($stylesheet);
                }
            }
            break;
        default:
             break;
        }

        /*
         * put mention into the admin log
         */
        $this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('upgraded', $this->GetVersion()));
    }
}

$upgrade = new Lytebox_Upgrade($oldversion, $newversion);
$upgrade->DoUpgrade();

?>
