<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/* @charset=utf-8 */

/**
 * Lytebox module for CMSMS - A simple wrapper to the Lytebox JavaScript class.
 *
 * PHP versions 4 and 5
 *
 * LICENSE:
 * Copyright (c) 2008-2010, Carsten Wiedmann
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY AUTHOR OR CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @category   Modules
 * @package    Lytebox
 * @author     Carsten Wiedmann <carsten_sttgt@gmx.de>
 * @copyright  2008-2010 Carsten Wiedmann
 * @license    http://www.freebsd.org/copyright/freebsd-license.html FreeBSD License
 * @version    SVN: $Id: en_US.php 16 2010-11-28 16:38:21Z wiedmann $
 * @link       http://dev.cmsmadesimple.org/projects/lytebox
 */

$lang['friendlyname']           = 'Lytebox';
$lang['postinstall']            = 'The Lytebox module is installed. Please read the help page.';
$lang['postuninstall']          = 'The Lytebox module is uninstalled.';
$lang['really_uninstall']       = 'Are you sure you want to uninstall the Lytebox module?';
$lang['uninstalled']            = 'Module uninstalled.';
$lang['installed']              = 'Module version %s installed.';
$lang['upgraded']               = 'Module upgraded to version %s.';
$lang['admindescription']       = 'A simple wrapper to the Lytebox JavaScript class.';
$lang['moddescription']         = 'A simple wrapper to the Lytebox JavaScript class.';
$lang['changelog']              = <<<EOT
    <ul>
        <li>Version 0.3.1beta1
            <ul>
                <li>fix bug #4226 and #3356</li>
                <li>add media 'projection' to the module stylesheet</li>
                <li>module is adding its stylesheet and JavaScript itself to the page metadata</li>
                <li>remove usage of depreciated vars.
            </ul>
        </li>
        <li>Version 0.2.1beta1
            <ul>
                <li>it's now possible to use uri params for Lyteframe togehter with a wysiwyg editor</li>
                <li>add action 'getscriptlink' if you just need the link for includung the JavaScript</li>
            </ul>
        </li>
        <li>Version 0.1.0dev1
            <ul>
                <li>Initial Release</li>
                <li>Lytebox v3.22</li>
            </ul>
        </li>
    </ul>
EOT;
$lang['help']                   = <<<EOT
    <h3>What does this do?</h3>
    <p>A simple wrapper to the Lytebox JavaScript class.</p>
    <h3>How Do I Use It</h3>
    <ol>
        <li><strong>Include stylesheet (and javascript)</strong>
            <ul>
                <li>The module is adding the stylesheet &quot;Module: Lytebox&quot; and the JavaScript call itself to the page metadata.</li>
                <li>If your CMSMS versions is <1.9 or &quot;process_whole_template&quot; is set to &quot;true&quot; in your &quot;config.php&quot;, you have to:
                    <ul>
                        <li>
                            In the page where you want use this module, add this to the page metadata:<br />
                            <code>{stylesheet name='Module: Lytebox' media='projection,screen'}</code>
                        </li>
                        <li>Or you can attach the stylesheet &quot;Module: Lytebox&quot; to your template.</li>
                        <li>
                            You can put the JavaScript call also manually into the page with:<br />
                            <code>{Lytebox action='getscriptlink'}</code><br />
                            (all params for the Lytebox JS you must set in this tag, otherwise in the tag for the first image)<br />
                            Otherwise a script tag is included above the first image to load the JavaScript.
                        </li>
                    </ul>
               </li>
            </ul>
        </li>
        <li><strong>Image Content Examples</strong>
            <ul>
                <li><em>Single Image Example (put this in your page content):</em><br />
                    <code>{Lytebox href='uploads/images/image-1.jpg' title='Image Description' text='Image #1'}</code>
                </li>
                <li><em>Grouped Images Example (put this in your page content):</em><br />
                    <code>{Lytebox href='uploads/images/image-1.jpg' group='vacation' title='Mom and Dad' text='Mom and Dad'}</code><br />
                    <code>{Lytebox href='uploads/images/image-2.jpg' group='vacation' title='My Sister' text='My Sister'}</code>
                </li>
                <li><em>Slideshow Example (put this in your page content):</em><br />
                    <code>{Lytebox href='uploads/images/image-1.jpg' group='vacation' display='show' title='Mom and Dad' text='Mom and Dad'}</code><br />
                    <code>{Lytebox href='uploads/images/image-2.jpg' group='vacation' display='show' title='My Sister' text='My Sister'}</code>
                </li>
            </ul>
        </li>
        <li><strong>HTML Content Examples</strong>
            <ul>
                <li><em>Single Example (put this in your page content):</em><br />
                        <code>{Lytebox href='http://www.google.com/' display='frame' title='Search Google' text='Google Search'}</code>
                </li>
                <li><em>Grouped Example (put this in your page content):</em><br />
                    <code>{Lytebox href='catalog1.htm' group='catalog' display='frame' title='Summer Catalog' text='Summer Catalog'}</code><br />
                    <code>{Lytebox href='catalog2.htm' group='catalog' display='frame' title='Winter Catalog' text='Winter Catalog'}</code>
                </li>
            </ul>
        </li>
        <li><strong>Use thumbnails</strong>
            <ul>
                <li><em>Single Image Example (put this in your page content):</em><br />
                    <code>{Lytebox href='uploads/images/image-1.jpg' title='Image Description' text='Image #1' thumbsrc='uploads/images/image-1-thumb.jpg' alt='Image #1'}</code>
                </li>
                <li><em>Grouped Images Example (put this in your page content):</em><br />
                    <code>{Lytebox href='uploads/images/image-1.jpg' group='vacation' title='Mom and Dad' text='Mom and Dad' thumbsrc='uploads/images/image-1-thumb.jpg' thumbalt='Mom and Dad'}</code><br />
                    <code>{Lytebox href='uploads/images/image-2.jpg' group='vacation' title='My Sister' text='My Sister' thumbsrc='uploads/images/image-2-thumb.jpg' thumbalt='My Sister'}</code>
                </li>
                <li><em>Slideshow Example (put this in your page content):</em><br />
                    <code>{Lytebox href='uploads/images/image-1.jpg' group='vacation' display='show' title='Mom and Dad' text='Mom and Dad'}</code><br />
                    <code>{Lytebox href='uploads/images/image-2.jpg' group='vacation' display='show' title='My Sister' text='My Sister'}</code>
                </li>
            </ul>
        </li>
        <li><strong>Set additional parameters for the Lytebox javascript</strong>
            <ul>
                <li><em>Single Example (put this in your page content):</em><br />
                    <code>{Lytebox href='uploads/images/image-1.jpg' theme='blue'}</code>
                </li>
                <li><em>Grouped Example (put this in your page content):</em><br />
                    <code>{Lytebox href='uploads/images/image-1.jpg' group='vacation' display='show' autoEnd='0'}</code><br />
                    <code>{Lytebox href='uploads/images/image-2.jpg' group='vacation' display='show'}</code>
                </li>
            </ul>
        </li>
    </ol>
    <cite>(Description is taken from the <a href="http://dolem.com/lytebox/">Lytebox homepage</a>.)</cite>
    <h3>Support</h3>
    <p>Please read the text of the license inside the source code for the full disclaimer.</p>
    <p>For additional help you can also try to ask a question in the <a href="http://forum.cmsmadesimple.org/">CMSMS forum</a>.</p>
    <h3>Copyright and License</h3>
    <ul>
        <li><strong>Lytebox CMSMS module</strong>
            <ul>
                <li>Copyright © 2008-2010, Carsten Wiedmann &lt;<a href="mailto:carsten_sttgt@gmx.de">carsten_sttgt@gmx.de</a>&gt;. All rights reserved.</li>
                <li>This module has been released under the <a href="http://www.freebsd.org/copyright/freebsd-license.html">FreeBSD License</a>. You must agree to this license before using the module.</li>
            </ul>
        </li>
        <li><strong>Lytebox JavaScript class</strong>
            <ul>
                <li>Author: Markus F. Hay</li>
                <li>Website: <a href="http://dolem.com/lytebox/">http://dolem.com/lytebox/</a></li>
                <li>License: <a href="http://creativecommons.org/licenses/by/3.0/">Creative Commons Attribution 3.0 License</a></li>
            </ul>
        </li>
    </ul>
EOT;
$lang['help_href']              = 'this attribute indicates the URI to be loaded when the hyperlink is activated';
$lang['help_display']           = 'hyperlink(s) are showed as box, show or frame';
$lang['help_group']             = 'if you want group 2 or more hyperlink, give the group a name';
$lang['help_frameattr']         = 'controls the width, height and scrolling of the window';
$lang['help_title']             = 'this attribute suggests a title (advisory only) for the destination resource';
$lang['help_extra']             = 'any extra attribute(s) you want give the A element';
$lang['help_text']              = 'text for the hyperlink';
$lang['help_thumbsrc']          = 'indicates the URI to reference the thumbnail';
$lang['help_thumbalt']          = 'this is text to be displayed in place of an image';
$lang['help_thumbextra']        = 'any extra attribute(s) you want give the IMG element';
$lang['help_theme']             = 'themes: grey (default), red, green, blue, gold';
$lang['help_hideFlash']         = 'controls whether or not Flash objects should be hidden';
$lang['help_outerBorder']       = 'controls whether to show the outer grey (or theme) border';
$lang['help_resizeSpeed']       = 'controls the speed of the image resizing (1=slowest and 10=fastest)';
$lang['help_maxOpacity']        = 'higher opacity = darker overlay, lower opacity = lighter overlay';
$lang['help_navType']           = '1 = &quot;Prev/Next&quot; buttons on top left and left (default), 2 = &quot;&lt;&lt; prev | next &gt;&gt;&quot; links next to image number';
$lang['help_autoResize']        = 'controls whether or not images should be resized if larger than the browser window dimensions';
$lang['help_doAnimations']      = 'controls whether or not &quot;animate&quot; Lytebox, i.e. resize transition between images, fade in/out effects, etc.';
$lang['help_borderSize']        = 'if you adjust the padding in the CSS, you will need to update this variable -- otherwise, leave this alone...';
$lang['help_slideInterval']     = 'Change value (milliseconds) to increase/decrease the time between &quot;slides&quot; (10000 = 10 seconds)';
$lang['help_showNavigation']    = '1 to display Next/Prev buttons/text during slideshow, 0 to hide';
$lang['help_showClose']         = '1 to display the Close button, 0 to hide';
$lang['help_showDetails']       = '1 to display image details (caption, count), 0 to hide';
$lang['help_showPlayPause']     = '1 to display pause/play buttons next to close button, 0 to hide';
$lang['help_autoEnd']           = '1 to automatically close Lytebox after the last image is reached, 0 to keep open';
$lang['help_pauseOnNextClick']  = '1 to pause the slideshow when the &quot;Next&quot; button is clicked';
$lang['help_pauseOnPrevClick']  = '1 to pause the slideshow when the &quot;Prev&quot; button is clicked';
$lang['help_config']            = 'internal usage';

?>
