<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Lytebox module for CMSMS - A simple wrapper to the Lytebox JavaScript class.
 *
 * PHP versions 4 and 5
 *
 * LICENSE:
 * Copyright (c) 2008-2010, Carsten Wiedmann
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY AUTHOR OR CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @category   Modules
 * @package    Lytebox
 * @author     Carsten Wiedmann <carsten_sttgt@gmx.de>
 * @copyright  2008-2010 Carsten Wiedmann
 * @license    http://www.freebsd.org/copyright/freebsd-license.html FreeBSD License
 * @version    SVN: $Id: action.getscriptlink.php 16 2010-11-28 16:38:21Z wiedmann $
 * @link       http://dev.cmsmadesimple.org/projects/Lytebox
 */

if (!isset($gCms)) {
    exit;
}

/**
 * GetScriptLink action from the Lytebox module.
 *
 * Usage:
 * {Lytebox action='getscriptlink'}
 *
 * @category   Modules
 * @package    Lytebox
 * @author     Carsten Wiedmann <carsten_sttgt@gmx.de>
 * @license    http://www.freebsd.org/copyright/freebsd-license.html  FreeBSD License
 * @version    Release: 0.3.1beta1
 * @link       http://dev.cmsmadesimple.org/projects/Lytebox
 * @see        Lytebox
 */
class Lytebox_ActionGetScriptLink extends Lytebox
{
    /**
     * contains the action to perform
     *
     * @var string
     * @access protected
     */
    var $name;

    /**
     * contains the module id
     *
     * @var string
     * @access protected
     */
    var $id;

    /**
     * contains the module parameters
     *
     * @var array
     * @access protected
     */
    var $params;

    /**
     * contains the module returnid
     *
     * @var string
     * @access protected
     */
    var $returnid;

    /**
     * Lytebox_ActionGetScriptLink()
     *
     * @param string &$name     Name of the action to perform
     * @param string &$id       the id for this module
     * @param array  &$params   the parameters targeted for this module
     * @param string &$returnid the returnid for this module
     *
     * @uses Lytebox()
     * @uses $name
     * @uses $id
     * @uses $params
     * @uses $returnid
     *
     * @return void
     * @access public
     */
    function Lytebox_ActionGetScriptLink(&$name, &$id, &$params, &$returnid)
    {
        parent::Lytebox();

        $this->name     =& $name;
        $this->id       =& $id;
        $this->params   =& $params;
        $this->returnid =& $returnid;
    }

    /**
     * DoAction()
     *
     * @uses CreateFrontendLink()
     * @uses ProcessTemplateFromData()
     * @uses cmsms()
     * @uses $id
     * @uses $returnid
     * @uses $params
     * @uses $countcalls
     *
     * @return string
     * @access public
     */
    function DoAction()
    {
        $smarty =& cmsms()->GetSmarty();
        $config =& cmsms()->GetConfig();

        if (0 < $this->countcalls) {
            $smarty->clear_assign('Lytebox_loadscript');
        } else {
            /*
             * create javascript configuration
             */
            $scriptparams = array();

            /* Lytebox Global Configuration */
            $scriptparams[0] = empty($this->params['theme']) ? 'grey' : trim($this->params['theme']);
            $scriptparams[1] = !isset($this->params['hideFlash']) ? 1 : $this->params['hideFlash'];
            $scriptparams[2] = !isset($this->params['outerBorder']) ? 1 : $this->params['outerBorder'];
            $scriptparams[3] = !isset($this->params['resizeSpeed']) ? 8 : $this->params['resizeSpeed'];
            $scriptparams[4] = !isset($this->params['maxOpacity']) ? 80 : $this->params['maxOpacity'];
            $scriptparams[5] = !isset($this->params['navType']) ? 1 : $this->params['navType'];
            $scriptparams[6] = !isset($this->params['autoResize']) ? 1 : $this->params['autoResize'];
            $scriptparams[7] = !isset($this->params['doAnimations']) ? 1 : $this->params['doAnimations'];
            $scriptparams[8] = !isset($this->params['borderSize']) ? 12 : $this->params['borderSize'];

            /* Lytebox Slideshow Options */
            $scriptparams[9]  = !isset($this->params['slideInterval']) ? 4000 : $this->params['slideInterval'];
            $scriptparams[10] = !isset($this->params['showNavigation']) ? 1 : $this->params['showNavigation'];
            $scriptparams[11] = !isset($this->params['showClose']) ? 1 : $this->params['showClose'];
            $scriptparams[12] = !isset($this->params['showDetails']) ? 1 : $this->params['showDetails'];
            $scriptparams[13] = !isset($this->params['showPlayPause']) ? 1 : $this->params['showPlayPause'];
            $scriptparams[14] = !isset($this->params['autoEnd']) ? 1 : $this->params['autoEnd'];
            $scriptparams[15] = !isset($this->params['pauseOnNextClick']) ? 0 : $this->params['pauseOnNextClick'];
            $scriptparams[16] = !isset($this->params['pauseOnPrevClick']) ? 1 : $this->params['pauseOnPrevClick'];

            $scriptparams = base64_encode(implode(',', $scriptparams));
            $scriptparams = array(
                'config' => $scriptparams,
                'showtemplate' => 'false',
            );

            /*
             * create javascript link
             */
            $scriptlink   = $this->CreateFrontendLink($this->id, $this->returnid, 'getjs', '', $scriptparams, '', true, true, '', true, '');
            //$scriptlink   = ltrim(str_replace($config['root_url'], '', $scriptlink), '/');
            $smarty->assign('Lytebox_loadscript', "<script type=\"text/javascript\" src=\"{$scriptlink}\"></script>\n");
        }

        /*
         * output the hyperlink
         */
        $template = '{if isset($Lytebox_loadscript)}{$Lytebox_loadscript}{/if}';
        $output   = $this->ProcessTemplateFromData($template);

        echo $output;

        $this->countcalls++;
    }
}

$action = new Lytebox_ActionGetScriptLink($name, $id, $params, $returnid);
$action->DoAction();

?>
