{* javascript template *}
{jsmin}
<script type="text/javascript" charset="utf-8" {$map_defertxt}>{literal}
//<![CDATA[
if( typeof(jQuery) == 'undefined' ){
  alert('JQuery is required for this map to function');
}
jQuery(document).ready(function(){
{/literal}
var my_location;

{if $map->sensor}
{literal}
// a function to determine the current browser location.
// this function is asynchronous in nature.
function getGeoLocation()
{
  if(navigator.geolocation) {
    // Try W3C Geolocation (Preferred)
    navigator.geolocation.getCurrentPosition(function(position) {
      my_location = new google.maps.LatLng(position.coords.latitude,position.coords.longitude);
    });
  } else if (google.gears) {
    // Try Google Gears Geolocation
    var geo = google.gears.factory.create('beta.geolocation');
    geo.getCurrentPosition(function(position) {
      my_location = new google.maps.LatLng(position.latitude,position.longitude);
    });
  }
}
getGeoLocation();
{/literal}
{/if}

{if $generator->get_marker_count()}
{if $map->info_window}
{literal}
function handle_info_window(marker)
{
  // setup the text for the info window
  var tmp = jQuery('#cggm_infowindow_'+marker.map_id);
  jQuery(tmp).empty();
  jQuery('.cggm_infowindow_contents',marker.jq).clone().appendTo(tmp);
  tmp.find('form').append('<input type="hidden" name="map_id" value="'+marker.map_id+'"/><input type="hidden" name="marker_alias" value="'+marker.alias+'"/>');
  tmp.find('.cggm_infowindow').height({/literal}{$map->infowindow_height}{literal});
  tmp.find('.cggm_infowindow').width({/literal}{$map->infowindow_width}{literal});
  tmp.find('.cggm_infowindow').attr('id','cggm_infowindow_'+marker.map_id);
  infoWindow.setContent(tmp.html());
  infoWindow.open(mapObj,marker);

  // handle clicking on 'to here'
  jQuery('div#cggm_infowindow_'+marker.map_id+' a.cggm_dir_to').click(function() {
    var tmp = jQuery(this).closest('div.cggm_infowindow').parent();
    var map_id = tmp.find(":input[name='map_id']").val();
    var marker_alias = tmp.find(":input[name='marker_alias']").val();
    var mkr = jQuery('#map_'+map_id+'_marker_'+marker_alias).data('marker');
    jQuery(this).parent().find('a').show();
    jQuery(this).hide();
    tmp.find("span").show();
    var addr = mkr.getPosition().toString();
    tmp.find(":input[name='daddr']").val(addr);
    tmp.find('span.cggm_dirto').hide();
    if( typeof(my_location) != 'undefined' )
    {
       tmp.find(":input[name='saddr']").val(my_location.toString());
    }
    tmp.find('form').show();
  });

  // handle clicking on from here.
  jQuery('div#cggm_infowindow_'+marker.map_id+' a.cggm_dir_from').click(function() {
    var tmp = jQuery(this).closest('div.cggm_infowindow').parent();
    var map_id = tmp.find(":input[name='map_id']").val();
    var marker_alias = tmp.find(":input[name='marker_alias']").val();
    var mkr = jQuery('#map_'+map_id+'_marker_'+marker_alias).data('marker');
    jQuery(this).parent().find('a').show();
    jQuery(this).hide();
    tmp.find("span").show();
    var addr = mkr.getPosition().toString();
    tmp.find(":input[name='saddr']").val(addr);
    tmp.find("span.cggm_dirfrom").hide();
    if( typeof(my_location) != 'undefined' )
    {
       tmp.find(":input[name='daddr']").val(my_location.toString());
    }
    tmp.find('form').show();
  });

  {/literal}
  {if $map->directions_dest == 'PANEL'}
  {literal}
  // handle the submit button in the directions form.
  jQuery('div#cggm_infowindow_'+marker.map_id+' form.cggm_directions_form').submit(function() {
    var tmp = jQuery(this).closest('div.cggm_infowindow').parent();
    var src = jQuery(":input[name='saddr']",tmp).val();
    var dest = jQuery(":input[name='daddr']",tmp).val();
    var req = {
       origin: src,
       destination: dest,
       travelMode: google.maps.DirectionsTravelMode.DRIVING
    };
    directionsService.route(req, function(response,status) {
      if( status == google.maps.DirectionsStatus.OK ) {
        directionsDisplay.setMap(mapObj);
        directionsDisplay.setPanel(document.getElementById('map_directions_'+mapID));
        directionsDisplay.setDirections(response);
        jQuery('#map_directions_'+mapID).show();
      }
    });
    return false;
  });
  {/literal}
  {/if}
  {literal}

}
{/literal}
{/if}
{/if}

// setup some variables and do initial testing.
var mapID = '{$map->get_id()}';
var mapMainDiv = '#cggm_map_defn_'+mapID;
var mapElem = jQuery('#cggm_map_display_'+{$map->get_id()}).get(0);
{literal}
if( mapElem == 'undefined' || mapElem == null ) {
  alert('{/literal}{$msg_mapelem_notfound}{literal}');
  return;
}{/literal}

{if $map->category_panel}
{if isset($categories)}
var category_info = new Array();
{foreach from=$map_categories item=cat}
category_info['{$cat.name}'] = '{$cat.icon}';
{/foreach}
{/if}
{literal}
// handle category form click
jQuery('#cggm_map_defn_'+mapID+' form.category_form :checkbox.category_checkbox').click(function(){
  // hide the infowindow
  infoWindow.close();
  // for each checkbox
  var cats = new Array();
  jQuery('#cggm_map_defn_'+mapID+' form.category_form :checkbox.category_checkbox:checked').each(function(){
    // add it to the list.
    cats.push(jQuery(this).attr('name'));
  });

  // for each marker
  jQuery('#cggm_map_defn_'+mapID+' div.cggm_map_markers > div.cggm_marker').each(function(){
    // get the categories
    var mname = jQuery(":input[name='name']",this).val();
    var tmp = jQuery(":input[name='categories']",this).val().split(',');
    var meta = jQuery(":input[name='meta']",this).val();
    // check for visible categories
    var display = false;
    var firstcat = '';
    for( i = 0; i < cats.length; i++ )
    {
       if( jQuery.inArray(cats[i],tmp) != -1)
       {
          display = true;
          firstcat = cats[i];
          break;
       }
    }
    // toggle the marker
    var mkr = jQuery(this).data('marker');
    mkr.setVisible(display);
    if( !meta )
    {
      var ticon = category_info[firstcat];
      mkr.setIcon(icons[ticon]);
    }

    // for each marker info window item in this marker
    jQuery('.cggm_infowindow_item',this).each(function(){
       var tmp = jQuery(":hidden[name='categories']",this).val();
       if( typeof tmp != 'undefined' ) {
         tmp = tmp.split(',');
         display = false;
         for( i = 0; i < cats.length; i++ )
         {
            if( jQuery.inArray(cats[i],tmp) != -1)
            {
              display = true;
              break;
            }
         }
         if( display )
         {
            jQuery(this).show();
         }
         else
         {
            jQuery(this).hide();
         }
       }
    });
  });

  // foreach sidebar item
  jQuery('#cggm_map_defn_'+mapID+' li.cggm_sidebar_item').each(function(){
    // toggle the sidebar item
    var tmp = jQuery(":hidden[name='categories']",this).val().split(',');
    var display = false;
    for( i = 0; i < cats.length; i++ )
    {
       if( jQuery.inArray(cats[i],tmp) != -1)
       {
          display = true;
          break;
       }
    }
    if( display )
    {
       jQuery(this).show();
    }
    else
    {
       jQuery(this).hide();
    }
  });
});
{/literal}
{/if}

// build the map itself.
var map_options = {ldelim}
mapTypeId: google.maps.MapTypeId.{$generator->get_google_maptype()},
{if $map->nav_controls}
navigationControl: true,
navigationControlOptions: {ldelim}style: google.maps.NavigationControlStyle.{$map->nav_control_option}{rdelim},
{else}
navigationControl: false,
{/if}
{if $map->scale_controls}
scaleControl: true,
{else}
scaleControl: false,
{/if}
{if $map->sv_controls}
streetViewControl: true,
{else}
streetViewControl: false,
{/if}
{if $map->type_controls}
mapTypeControl: true,
mapTypeControlOptions: {ldelim}style: google.maps.MapTypeControlStyle.{$map->type_control_option}{rdelim},
{else}
mapTypeControl: false,
{/if}
{if $map->center_lat != '' && $map->center_lon != ''}
// center latitude and longitude set for the map
center: new google.maps.LatLng({$map->center_lat},{$map->center_lon}),
{else}
// center latitude and longitude calculated by markers.
center: new google.maps.LatLng({$generator->get_center_lat()},{$generator->get_center_lon()}),
{/if}
zoom: {$map->zoom}
{rdelim}; // map_options

var mapObj = new google.maps.Map(mapElem,map_options);
var infoWindow = new google.maps.InfoWindow();
{if $map->zoom_encompass && $generator->get_marker_count()}
  // set zoom encompass
  var minll = new google.maps.LatLng({$generator->get_min_lat()},{$generator->get_min_lon()});
  var maxll = new google.maps.LatLng({$generator->get_max_lat()},{$generator->get_max_lon()});
  var bds = new google.maps.LatLngBounds(minll,maxll);
  mapObj.fitBounds(bds);
{/if}
{if $map->directions && $generator->get_marker_count()}
var directionsService = new google.maps.DirectionsService();
var directionsDisplay = new google.maps.DirectionsRenderer();
{/if}

{if isset($icons)}
// build the icons.
var icons = new Array();
{foreach from=$icons item='icon'}
icons['{$icon.name}'] = new google.maps.MarkerImage('{$icon.url}');
{/foreach}
{/if}

{if $generator->get_marker_count()}
// build the markers
{literal}
jQuery('#cggm_map_defn_'+mapID+' div.cggm_map_markers > div.cggm_marker').each(function(){
  // create the marker object.
  var name = jQuery(":input[name='name']",this).val();
  var lat = jQuery(":input[name='latitude']",this).val();
  var lon = jQuery(":input[name='longitude']",this).val();
  var icon = jQuery(":input[name='icon']",this).val();
  var title = jQuery(":input[name='title']",this).val();
  var marker = new google.maps.Marker({
    map: mapObj,
    title: title,
    icon:  icons[icon],
    position: new google.maps.LatLng(lat,lon)
  });
  marker.map_id = mapID;
  marker.alias = name;
  marker.jq = this;
  // store the marker for later retrieval.
  jQuery(this).data('marker',marker);

  {/literal}
  {if $map->info_window && $map->info_trigger != 'none'}
  // add info window triggers.
  {literal}
  google.maps.event.addListener(marker, '{/literal}{$map->info_trigger}{literal}', function() {
    handle_info_window(marker);      
  });
  {/literal}
  {/if}
  {literal}
}); // each
{/literal}
{/if}

{if $map->sidebar}
{literal}
// handle clicking on sidebar
jQuery('a.cggm_sidebar_title_link').click(function(){
  var tmp = jQuery(this).attr('rel').split('::');
  if( tmp.length == 2 )
  {
    var mkr = jQuery('#map_'+tmp[0]+'_marker_'+tmp[1]).data('marker');
    handle_info_window(mkr);
  }
});
{/literal}
{/if}

{if $map->directions}
{literal}
// handle disabling any directions
jQuery(":button[name='hide_directions']").click(function(){
  directionsDisplay.setMap(null);
  jQuery(this).parent().hide();
});
{/literal}
{/if}

{literal}
}); // ready function.
//]]>{/literal}
</script>
{/jsmin}