<?php

class cggm_map_operations
{
  static private $_dflt_icon;
  static private $_map_tpl;
  static private $_js_tpl;
  static private $_cat_tpl;
  static private $_sidebar_tpl;
  static private $_dirform_tpl;

  public static function update_from_formdata(cggm_map& $map,$formdata)
  {
    if( !is_array($formdata) ) return;

    foreach( $formdata as $key => $value )
      {
	try
	  {
	    $map->$key = $value;
	  }
	catch( Exception $e )
	  {
	    // nothing to do.
	  }
      }
  }

  private static function map_to_row(cggm_map& $map)
  {
    $data = array();
    $data[] = $map->get_name();
    $data[] = $map->get_owner_id();
    $data[] = $map->get_data();
    return $data;
  }


  private static function row_to_map($row)
  {
    $obj = new cggm_map;

    $obj->set_id($row['map_id']);
    $obj->set_name($row['name']);
    $obj->set_owner_id($row['owner_id']);
    $obj->set_data($row['data']);
    return $obj;
  }


  private static function _init_data()
  {
    if( self::$_map_tpl != '' ) return;

    $mod = cge_utils::get_module('CGGoogleMaps');
    self::$_dflt_icon = $mod->GetPreference('default_marker','dd-end');
    self::$_map_tpl = $mod->GetTemplate(CGGM_PREF_NEWMAP_TEMPLATE);
    self::$_js_tpl = $mod->GetTemplate(CGGM_NEWJS_TEMPLATE);
    self::$_sidebar_tpl = $mod->GetTemplate(CGGM_NEWSIDEBAR_TEMPLATE);
    self::$_cat_tpl = $mod->GetTemplate(CGGM_NEWCATEGORY_TEMPLATE);
    self::$_dirform_tpl = $mod->GetTemplate(CGGM_NEWDIRFORM_TEMPLATE);
  }

  public static function build_new_map($params)
  {
    self::_init_data();

    $obj = new cggm_map;
    $obj->default_icon = self::$_dflt_icon;
    foreach( $params as $key => $value )
      {
	$obj->$key = $value;
      }
    $obj->set_map_template(self::$_map_tpl);
    $obj->set_js_template(self::$_js_tpl);
    $obj->set_sidebar_template(self::$_sidebar_tpl);
    $obj->set_category_template(self::$_cat_tpl);
    $obj->set_dirform_template(self::$_dirform_tpl);
    return $obj;
  }

  public static function load_by_id($map_id,$deep = false)
  {
    global $gCms;
    $db = $gCms->GetDb();
    $query = 'SELECT * FROM '.cms_db_prefix().'module_cggooglemaps WHERE map_id = ?';
    $row = $db->GetRow($query,array($map_id));
    if( !$row ) return FALSE;

    $obj = self::row_to_map($row);
    if( $obj && $deep )
      {
	// load points.
	cggm_marker_operations::load_markers_for_map($obj);
      }
    return $obj;
  }


  public static function load_by_name($map_name,$deep = false)
  {
    global $gCms;
    $db = $gCms->GetDb();
    $query = 'SELECT * FROM '.cms_db_prefix().'module_cggooglemaps WHERE name = ?';
    $row = $db->GetRow($query,array($map_id));
    if( !$row ) return FALSE;

    $obj = self::row_to_map($row);
    if( $obj && $deep )
      {
	// load points.
	cggm_marker_operations::load_markers_for_map($obj);
      }
    return $obj;
  }


  public static function delete(cggm_map& $map)
  {
    global $gCms;
    $db = $gCms->GetDb();
    $map_id = $map->get_id();

    $query = 'DELETE FROM '.cms_db_prefix().'module_cggooglemaps_points WHERE map_id = ?';
    $db->Execute($query,array($map_id));
    if( !$row ) return FALSE;

    $query = 'DELETE FROM '.cms_db_prefix().'module_cggooglemaps WHERE map_id = ?';
    $db->Execute($query,array($map_id));
    if( !$row ) return FALSE;

    $this->DeleteTemplate('maptemplate_'.$map_id);
    $this->DeleteTemplate('mapsidebar_'.$map_id);
    $this->DeleteTemplate('mapcategory_'.$map_id);
    $this->DeleteTemplate('mapdirform_'.$map_id);
    return TRUE;
  }


  public static function insert(cggm_map& $map,$deep = true)
  {
    $query = 'INSERT '.cms_db_prefix().'module_cggooglemaps 
               (name,owner_id,data) VALUES (?,?,?)';

    global $gCms;
    $db = $gCms->GetDb();
    $dbr = $db->Execute($query,self::map_to_row($map));
    if( !$dbr ) die($db->sql.'<br/>'.$db->ErrorMsg());
    if( !$dbr ) return FALSE;
    $map_id = $db->Insert_Id();
    $map->set_id($map_id);
    if( $deep )
      {
	for( $i = 0; $i < $map->count_markers(); $i++ )
	  {
	    $marker = $map->get_marker_by_idx($i);
	    $marker->set_map_id($map_id);
	    cggm_marker_operations::insert($marker);
	  }
      }

    $mod = cge_utils::get_module('CGGoogleMaps');
    $tmp = $map->get_map_template(true);
    if( $tmp )
      {
	$mod->SetTemplate('maptemplate_'.$map->get_id(),$tmp);
      }
    $tmp = $map->get_js_template(true);
    if( $tmp )
      {
	$mod->SetTemplate('mapjs_'.$map->get_id(),$tmp);
      }
    $tmp = $map->get_sidebar_template(true);
    if( $tmp )
      {
	$mod->SetTemplate('mapsidebar_'.$map->get_id(),$tmp);
      }
    $tmp = $map->get_category_template(true);
    if( $tmp )
      {
	$mod->SetTemplate('mapcategory_'.$map->get_id(),$tmp);
      }
    $tmp = $map->get_dirform_template(true);
    if( $tmp )
      {
	$mod->SetTemplate('mapdirform_'.$map->get_id(),$tmp);
      }
    return TRUE;
  }


  public static function update(cggm_map& $map,$deep = true)
  {
    $query = 'UPDATE '.cms_db_prefix().'module_cggooglemaps
               SET name = ?, owner_id = ?, data = ?
               WHERE map_id = ?';
    global $gCms;
    $db = $gCms->GetDb();
    $tmp = self::map_to_row($map);
    $tmp[] = $map->get_id();
    $dbr = $db->Execute($query,$tmp);
    if( !$dbr ) return FALSE;
    if( $deep )
      {
	for( $i = 0; $i < $map->count_markers(); $i++ )
	  {
	    $marker = $map->get_marker_by_idx($i);
	    $marker->set_map_id($map_id);
	    cggm_marker_operations::update($marker);
	  }
      }

    $mod = cge_utils::get_module('CGGoogleMaps');
    $tmp = $map->get_map_template(true);
    if( $tmp )
      {
	$mod->SetTemplate('maptemplate_'.$map->get_id(),$tmp);
      }
    $tmp = $map->get_js_template(true);
    if( $tmp )
      {
	$mod->SetTemplate('mapjs_'.$map->get_id(),$tmp);
      }
    $tmp = $map->get_sidebar_template(true);
    if( $tmp )
      {
	$mod->SetTemplate('mapsidebar_'.$map->get_id(),$tmp);
      }
    $tmp = $map->get_category_template(true);
    if( $tmp )
      {
	$mod->SetTemplate('mapcategory_'.$map->get_id(),$tmp);
      }
    $tmp = $map->get_dirform_template(true);
    if( $tmp )
      {
	$mod->SetTemplate('mapdirform_'.$map->get_id(),$tmp);
      }
    return TRUE;
  }

} // end of class

?>