//------------------------------------------------------------------------------
//
// Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
//          a content management tool for CMS Made Simple
//          The projects homepage is dev.cmsmadesimple.org/projects/content2
//          CMS Made Simple is (c) 2004-2010 by Ted Kulp
//          The projects homepage is: cmsmadesimple.org
// Version: 0.6.2
// File   : functions.js
// License: GPL
//
//------------------------------------------------------------------------------

AdvancedContent = new Object();

AdvancedContent.initTimeOutMin = 100;  //ms
AdvancedContent.initTimeOutMax = 300;  //ms
AdvancedContent.loadTimeOutMin = 1000; //ms
AdvancedContent.loadTimeOutMax = 3000; //ms
AdvancedContent.delayMin       = 100;  //ms
AdvancedContent.delayMax       = 300;  //ms

AdvancedContent.moduleId     = '';
AdvancedContent.initGeneral  = false;
AdvancedContent.initUI       = false;
AdvancedContent.initForm     = false;
AdvancedContent.initCalendar = false;

AdvancedContent.addBlockForm = false;

AdvancedContent.Init = function() {
	
	AdvancedContent.initTimeOutMax = eval(AdvancedContent.initTimeOutMax - AdvancedContent.initTimeOutMin);
	AdvancedContent.loadTimeOutMax = eval(AdvancedContent.loadTimeOutMax - AdvancedContent.loadTimeOutMin);
	AdvancedContent.delayMax       = eval(AdvancedContent.delayMax - AdvancedContent.delayMin);
	
	if(AdvancedContent.initTimeOutMax < 0) {
		AdvancedContent.initTimeOutMax = 0;
	}
	if(AdvancedContent.loadTimeOutMax < 0) {
		AdvancedContent.loadTimeOutMax = 0;
	}
	if(AdvancedContent.delayMax < 0) {
		AdvancedContent.delayMax = 0;
	}
	
	if (typeof jQuery == "undefined") {
		AdvancedContent.LoadJS('jQuery','../modules/AdvancedContent/js/jq.min.js', Math.floor(eval(Math.random()*AdvancedContent.initTimeOutMax + AdvancedContent.initTimeOutMin)));
	}
	else {
		if(!AdvancedContent.initGeneral) {
			AdvancedContent.initGeneral = true;
			AdvancedContent.Ready('general');
		}
		if (typeof jQuery().ajaxSubmit == "undefined") {
			AdvancedContent.LoadJS('form','../modules/AdvancedContent/js/jq.form.min.js', Math.floor(eval(Math.random()*AdvancedContent.initTimeOutMax + AdvancedContent.initTimeOutMin)));
		}
		else if(!AdvancedContent.initForm) {
			AdvancedContent.initForm = true;
			AdvancedContent.Ready('form');
		}
		if (typeof jQuery().sortable == "undefined") {
			AdvancedContent.LoadJS('ui','../modules/AdvancedContent/js/jq.ui.custom.min.js', Math.floor(eval(Math.random()*AdvancedContent.initTimeOutMax + AdvancedContent.initTimeOutMin)));
		}
		else if(!AdvancedContent.initUI) {
			AdvancedContent.initUI = true;
			AdvancedContent.Ready('ui');
		}
		if (typeof jQuery().calendar == "undefined") {
			AdvancedContent.LoadJS('calendar','../modules/AdvancedContent/js/jq.calendar.js', Math.floor(eval(Math.random()*AdvancedContent.initTimeOutMax + AdvancedContent.initTimeOutMin)));
		}
		else if(!AdvancedContent.initCalendar) {
			AdvancedContent.initCalendar = true;
			AdvancedContent.Ready('calendar');
		}
	}
}

AdvancedContent.LoadJS = function (loadType, url, timeOut, timeElapsed, urlLoaded) {
	
	if(typeof loadType == 'undefined' || loadType == '')
		return;
	
	if(typeof url == 'undefined' || url == '')
		return;
	
	if(typeof urlLoaded == 'undefined')
		var urlLoaded = false;
	
	if(typeof timeOut == 'undefined' || timeOut == 0)
		var timeOut = AdvancedContent.loadTimeOutMax;
	
	if(typeof timeElapsed == 'undefined' || timeElapsed == '')
		var timeElapsed = 0;
	
	switch(loadType) {
		
		case 'jQuery':
			if (typeof jQuery == "undefined") {
				if (timeElapsed <= timeOut) {
					var randomTime = Math.floor(eval(Math.random()*AdvancedContent.delayMax + AdvancedContent.delayMin));
					setTimeout("AdvancedContent.LoadJS('jQuery', '" + url + "', " + timeOut + ", " + eval(timeElapsed + randomTime) + ", " + false + ")",  randomTime);
				} else if (!urlLoaded && url != '') {
					AdvancedContent.LoadJS.GetScript(url);
					AdvancedContent.LoadJS('jQuery', url, Math.floor(eval(Math.random()*AdvancedContent.loadTimeOutMax + AdvancedContent.loadTimeOutMin)), 0, true);
				}
				else {
					alert("Error: Timed out while loading js '" + url + "'");
				}
			}
			else {
				if(!AdvancedContent.initGeneral) {
					AdvancedContent.initGeneral = true;
					AdvancedContent.Ready('general');
				}
				if (AdvancedContent.plugins != "") {
					AdvancedContent.Init();
				}
			}
			break;
		
		case 'form':
			if (typeof jQuery().ajaxSubmit == "undefined") {
				if (timeElapsed <= timeOut) {
					var randomTime = Math.floor(eval(Math.random()*AdvancedContent.delayMax + AdvancedContent.delayMin));
					setTimeout("AdvancedContent.LoadJS('form', '" + url + "', " + timeOut + ", " + eval(timeElapsed + randomTime) + ", " + false + ")",  randomTime);
				} else if (!urlLoaded && url != ''){
					AdvancedContent.LoadJS.GetScript(url);
					AdvancedContent.LoadJS('form', url, Math.floor(eval(Math.random()*AdvancedContent.loadTimeOutMax + AdvancedContent.loadTimeOutMin)), 0, true);
				}
				else {
					alert("Error: Timed out while loading js '" + url + "'");
				}
			}
			else if(!AdvancedContent.initForm) {
				AdvancedContent.initForm = true;
				AdvancedContent.Ready('form');
			}
			break;
		
		case 'ui':
			if (typeof jQuery().sortable == "undefined") {
				if (timeElapsed <= timeOut) {
					var randomTime = Math.floor(eval(Math.random()*AdvancedContent.delayMax + AdvancedContent.delayMin));
					setTimeout("AdvancedContent.LoadJS('ui', '" + url + "', " + timeOut + ", " + eval(timeElapsed + randomTime) + ", " + false + ")",  randomTime);
				} else if (!urlLoaded && url != ''){
					AdvancedContent.LoadJS.GetScript(url);
					AdvancedContent.LoadJS('ui', url, Math.floor(eval(Math.random()*AdvancedContent.loadTimeOutMax + AdvancedContent.loadTimeOutMin)), 0, true);
				}
				else {
					alert("Error: Timed out while loading js '" + url + "'");
				}
			}
			else if(!AdvancedContent.initUI) {
				AdvancedContent.initUI = true;
				AdvancedContent.Ready('ui');
			}
			break;
		
		case 'calendar':
			if (typeof jQuery().calendar == "undefined") {
				if (timeElapsed <= timeOut) {
					var randomTime = Math.floor(eval(Math.random()*AdvancedContent.delayMax + AdvancedContent.delayMin));
					setTimeout("AdvancedContent.LoadJS('calendar', '" + url + "', " + timeOut + ", " + eval(timeElapsed + randomTime) + ", " + false + ")",  randomTime);
				} else if (!urlLoaded && url != ''){
					AdvancedContent.LoadJS.GetScript(url);
					AdvancedContent.LoadJS('calendar', url, Math.floor(eval(Math.random()*AdvancedContent.loadTimeOutMax + AdvancedContent.loadTimeOutMin)), 0, true);
				}
				else {
					alert("Error: Timed out while loading js '" + url + "'");
				}
			}
			else if(!AdvancedContent.initCalendar) {
				AdvancedContent.initCalendar = true;
				AdvancedContent.Ready('calendar');
			}
			break;
			
		default: break;
	}
}

AdvancedContent.LoadJS.GetScript = function(url) {
	
	if(typeof url == 'undefined' || url == '')
		return;
	
	var script = document.createElement('script');
	script.setAttribute("type", "text/javascript");
	script.setAttribute("src", url);
	if (typeof script != "undefined")
		document.getElementsByTagName("head")[0].appendChild(script);
	
}

AdvancedContent.Ready = function (initType) {
	switch(initType) {
		
		case 'general':
			AdvancedContent.initGeneral = true;
			jQuery.noConflict();
			break;
			
		case 'ui':
			AdvancedContent.initUI = true;
			jQuery(document).ready(function() {
				jQuery('.sortable_wrapper').sortable({
					items: '.sortable', 
					handle: '.sortable_handler', 
					axis: 'y'
				});
				jQuery('.sortable_handler').disableSelection();
			});
			break;
			
		case 'form':
			AdvancedContent.initForm = true;
			break;
			
		case 'calendar':
			AdvancedContent.initCalendar = true;
			jQuery(document).ready(function() {
				jQuery('#AdvancedContentStartDatePickerDisplay').calendar({
					triggerElement: '#AdvancedContentStartDatePickerTrigger', 
					dateFormat: '%x', 
					closeHandler: function (calendar) {
						jQuery('#AdvancedContentStartDate').val(eval(calendar.date.getTime()/1000)); 
						calendar.container.hide();
					}
				});
				
				jQuery('#AdvancedContentEndDatePickerDisplay').calendar({
					triggerElement: '#AdvancedContentEndDatePickerTrigger', 
					dateFormat: '%x', 
					closeHandler: function (calendar) {
						jQuery('#AdvancedContentEndDate').val(eval(calendar.date.getTime()/1000)); 
						calendar.container.hide();
					}
				});
				
				if(typeof AdvancedContent.InitCalendarContentBlocks == 'function')
					AdvancedContent.InitCalendarContentBlocks();
				
			});
			break;
			
		default: break;
	}
}

AdvancedContent.ToggleBlock = function (tabId, navbar_id) {
	var navbar = document.getElementById(navbar_id);
    var tabs   = navbar.getElementsByTagName('div');
	
    for (var i = 0; i < tabs.length; i += 1) {
		//tabs[i].onmousedown = function() {
		for (var j = 0; j < tabs.length; j += 1) {
			tabs[j].className                                        = '';
			document.getElementById(tabs[j].id + "_c").style.display = 'none';
		}
		document.getElementById(tabId).className            = 'active';
		document.getElementById(tabId + "_c").style.display = 'block';
		return true;
		//}
    }
}

AdvancedContent.SubmitForm = function (button, targetId) {
	var form = jQuery(button).parents('form:first');
	if(form.length) {
		if(targetId != '' && !form.parents('#'+targetId).length) {
			jQuery('#'+targetId).html('');
		}
		var options = {
			success: function(responseText) {
				if(responseText != '' && targetId != '') {
					jQuery('#'+targetId).html(responseText);
				}
				return false;
			}
		}
		form.append('<input type="hidden" class="AdvancedContent_AjaxFields" name="disable_theme" value="1" />');
		form.append('<input type="hidden" class="AdvancedContent_AjaxFields" name="'+button.name+'" value="'+button.value+'" />');
		form.append('<input type="hidden" class="AdvancedContent_AjaxFields" name="'+AdvancedContent.moduleId+'ajax" value="1" />');
		form.ajaxSubmit(options);
	}
	return false;
}

AdvancedContent.SelectAll = function (obj) {
	if (obj.value == 1) {
		jQuery('input[name^="'+obj.id+'-"]').attr('checked','checked');
		obj.value = 0;
	}
	else {
		jQuery('input[name^="'+obj.id+'-"]').removeAttr('checked');
		obj.value = 1;
	}
}

AdvancedContent.AddContentBlock = function(blockId) {
		
	if(document.getElementById('AdvancedContent_wrapper') == null) {
		
		// create global wrapper
		jQuery('body').append('<div id="AdvancedContent_wrapper"></div>');
		
		// add content
		jQuery('#AdvancedContent_wrapper').html('<div id="AdvancedContent_background"></div><div id="AdvancedContent"><div id="AdvancedContent_titlebar"><a id="AdvancedContent_close" title="' + AdvancedContent.closeTitle + '" href="#" onclick="AdvancedContent.Close();return false;">[X]</a><h3>FilePicker</h3></div><div id="AdvancedContent_content"></div></div>');
	}
		
	// hide it first
	jQuery('#AdvancedContent_background').fadeTo('fast', 0);
	// make visible
	jQuery('#AdvancedContent_wrapper').css('opacity', 1);
	// set to front
	jQuery('#AdvancedContent_wrapper').css('z-index', 9999);
	
	// hide it first
	jQuery('#AdvancedContent').fadeTo('fast', 0);
	jQuery('#AdvancedContent_content').fadeTo('fast', 0);
	
	// set wrapper display
	jQuery('#AdvancedContent_wrapper').css('display', 'block');
	// set background display
	jQuery('#AdvancedContent_background').css('display', 'block');
	
	// fade in background
	jQuery('#AdvancedContent_background').fadeTo(300, 0.65, function () {
		// set filepicker display
		jQuery('#AdvancedContent').css('display', 'block');
		// fade in
		jQuery('#AdvancedContent').fadeTo(300, 1, function() { 
			jQuery('#AdvancedContent_loading_img').css('display','block');
		});
		AdvancedContent.addBlockForm = true;
	});
	return false;
}

AdvancedContent.Close = function () {
	jQuery('#AdvancedContent_wrapper').fadeTo(300,0,function(){
		jQuery('#AdvancedContent_wrapper').css('z-index',-9999);
		jQuery('#AdvancedContent_wrapper').css('display','none');
		jQuery('#AdvancedContent_wrapper').remove();
		AdvancedContent.addBlockForm = false;
	});
	return false;
}

AdvancedContent.RemoveContentBlock = function(blockId) {
	return false;
}