<?php
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
#          a content management tool for CMS Made Simple
#          The projects homepage is dev.cmsmadesimple.org/projects/content2/
#          CMS Made Simple is (c) 2004-2010 by Ted Kulp
#          The projects homepage is: cmsmadesimple.org
# Version: 0.6.2
# File   : action.default.php
#          This file is a modification of the default plugin {content}
# Purpose: performs the default frontend action if {AdvancedContent} is used.
# License: GPL
#
#-------------------------------------------------------------------------------

if(!isset($gCms)) exit;

if(isset($params['active']) && $this->IsFalse($params['active'])) {
	return; // don't process inactive blocks
}

$pageinfo =& cmsms()->variables['pageinfo'];
$result   = '';

$block = 'content_en';
$mainContent = true;

# MLE support
$mle = false;
global $hls, $mleblock, $mleblockfallback;
if(isset($hls))
	$mle = true;

if($mle && $mleblock != '') {
	$block = 'content'.$mleblock;
}
#---

if(isset($params['block']) && $params['block'] != $block) {
	$mainContent = false;
	$_block = preg_replace('/-+/','_',munge_string_to_url($params['block']));
	$block = $_block;
	# MLE support
	if($mle) {
		$block .= $mleblock;
	}
	#---
}

$defaultValue = '';
if(isset($params['default']))
	$defaultValue = trim($params['default']);

$doSmarty = false;
if(isset($params['smarty']) && $this->IsTrue($params['smarty']) && cmsms()->GetSmarty()->get_template_vars('content_obj')->Type() == 'content2')
	$doSmarty = true;

if($doSmarty && cmsms()->GetSmarty()->get_template_vars('content_obj')->Type() == 'content2') {
	$defaultValue = cmsms()->GetSmarty()->get_template_vars('content_obj')->DoSmarty(cmsms()->GetSmarty()->get_template_vars('content_obj')->_contentBlocks[$block]['default_value']);
}

$allowNone = true;
if(isset($params['allow_none']) && $this->IsFalse($params['allow_none']))
	$allowNone = false;

if (isset($pageinfo) && $pageinfo !== FALSE && isset($pageinfo->content_id) )
{
	$id         = '';
	$modulename = '';
	$action     = '';
	$inline     = false;
	if (isset($_REQUEST['module'])) 
		$modulename = $_REQUEST['module'];
	
	if (isset($_REQUEST['id'])) {
		$id = $_REQUEST['id'];
	}
	elseif (isset($_REQUEST['mact'])) {
		$ary        = explode(',', cms_htmlentities($_REQUEST['mact']), 4);
		$modulename = (isset($ary[0])?$ary[0]:'');
		$id         = (isset($ary[1])?$ary[1]:'');
		$action     = (isset($ary[2])?$ary[2]:'');
		$inline     = (isset($ary[3]) && $ary[3] == 1?true:false);
	}
	
	if (isset($_REQUEST[$id.'action'])) {
		$action = $_REQUEST[$id.'action'];
	}
	else if (isset($_REQUEST['action'])) {
		$action = $_REQUEST['action'];
	}
	
	if (!isset($params['block']) && ($id == 'cntnt01' || ($id != '' && $inline == false))) {
		
		$cmsmodules = &cmsms()->modules;
		
		if (isset($cmsmodules)) {
			
			foreach ($cmsmodules as $key=>$value) {
				if (strtolower($modulename) == strtolower($key)) {
					$modulename = $key; }
			}
			
			if (isset($modulename)) {
				if (isset($cmsmodules[$modulename])) {
					if (isset($cmsmodules[$modulename]['object'])
						&& $cmsmodules[$modulename]['installed'] == true
						&& $cmsmodules[$modulename]['active'] == true
						&& $cmsmodules[$modulename]['object']->IsPluginModule())
					{
						@ob_start();
						
						unset($params['label']);
						unset($params['class']);
						unset($params['id']);
						unset($params['name']);
						unset($params['width']);
						unset($params['height']);
						unset($params['alt']);
						unset($params['block']);
						unset($params['smarty']);
						unset($params['label']);
						unset($params['type']);
						unset($params['block_type']);
						unset($params['default']);
						unset($params['style']);
						unset($params['size']);
						unset($params['block_tab']);
						unset($params['page_tab']);
						unset($params['maxlength']);
						unset($params['wysiwyg']);
						unset($params['oneline']);
						unset($params['mode']);
						unset($params['start_time']);
						unset($params['end_time']);
						unset($params['date_format']);
						unset($params['start_hour']);
						unset($params['end_hour']);
						unset($params['start_minute']);
						unset($params['end_minute']);
						unset($params['start_seconds']);
						unset($params['end_seconds']);
						unset($params['show_clock']);
						unset($params['step_hours']);
						unset($params['step_minutes']);
						unset($params['step_seconds']);
						unset($params['show24h']);
						unset($params['upload']);
						unset($params['dir']);
						unset($params['allow_none']);
						unset($params['exclude_prefix']);
						unset($params['exclude_sufix']);
						unset($params['include_prefix']);
						unset($params['include_sufix']);
						unset($params['lock_input']);
						unset($params['delimiter']);
						unset($params['items']);
						unset($params['values']);
						unset($params['module']);
						unset($params['defaultModules']);
						unset($params['urlonly']);
						unset($params['feu_action']);
						unset($params['feu_access']);
						unset($params['editor_groups']);
						unset($params['editor_users']);
						unset($params['active']);
						unset($params['translate_labels']);
						unset($params['translate_values']);
						
						unset($params['inputs']);
						unset($params['input_delimiter']);
						unset($params['value_delimiter']);
						
						$params = array_merge($params, GetModuleParameters($id));
						
						// calguy1000 ... increment the modulenum 
						// if we're not in inlined mode.
						if( $id != 'cntnt01' ) {
							++cmsms()->variables["modulenum"]; 
						}
						
						$returnid = '';
						if (isset($params['returnid'])) {
							$returnid = $params['returnid'];
						}
						else {
							$returnid = $pageinfo->content_id;
						}
						$result = $cmsmodules[$modulename]['object']->DoActionBase($action, $id, $params, $returnid);
						if ($result !== FALSE) {
							echo $result;
						}
						$modresult = @ob_get_contents();
						@ob_end_clean();
						$result = $modresult;
					}
					else {
					  $result = "<!-- Not a tag module -->\n";
					}
				}
			}
		}
	}
	else {
		$oldvalue                     = cmsms()->GetSmarty()->caching;
		cmsms()->GetSmarty()->caching = false;
		$contentId                    = $pageinfo->content_id;
		
		# MLE support
		if($mle)
			$contentId .= '-'.$hls;
		#---
		
		$result = cmsms()->GetSmarty()->fetch(str_replace(' ', '_', 'content:' . $block), '', $contentId);
		
		# MLE support
		if($mle 
			&& $result == '' && $mleblockfallback != '' 
			&& $mleblockfallback != $mleblock) 
		{
			if($block != 'content'.$mleblock) {
				$block  = $_block . $mleblockfallback;
				$result = cmsms()->GetSmarty()->fetch(str_replace(' ', '_', 'content:' . $block), '', $contentId);
			}
			else {
				$block  = 'content' . $mleblockfallback;
				$result = cmsms()->GetSmarty()->fetch(str_replace(' ', '_', 'content:' . $block), '', $contentId);
			}
		}
		#---
		
		cmsms()->GetSmarty()->caching = $oldvalue;
		
		if($result == '' && !$allowNone)
			$result = $defaultValue;
		
		if (isset($params['block_type']) && strtolower($params['block_type'])=='date' && isset($params['date_format']) && $params['date_format'] != '')
			$result = strftime($params['date_format'],$result);
	}
	
	// grant page access by default
	$access = true;
	
	// only process feu_acces if there is a frontendusers module
	if( $feusers =& $this->GetModuleInstance('FrontEndUsers' ) && cmsms()->GetSmarty()->get_template_vars('content_obj')->Type() == 'content2') {
		
		$feuAccess = $this->CleanArray(explode(';',cmsms()->GetSmarty()->get_template_vars('content_obj')->Properties()->GetValue('feu_access')));
		
		// only process if we have selected anything in backend for feu access
		if(!empty($feuAccess)) {
			
			// if page has no parents but inheritance -> remove inheritance (should never happen but just in case)
			if(cmsms()->GetSmarty()->get_template_vars('content_obj')->ParentId() <= 0 && in_array("-1",$feuAccess)) {
				foreach($feuAccess as $k=>$v) {
					if($v=='-1') unset($feuAccess[$k]);
				}
			}
			
			// if there still is inheritance ...
			if(in_array('-1',$feuAccess)) {
				// ... finally inherit
				$feuAccess = cmsms()->GetSmarty()->get_template_vars('content_obj')->InheritParentProp(cmsms()->GetSmarty()->get_template_vars('content_obj')->ParentId(),'feu_access',$feuAccess);
			}
			
			// if we have access for certain feu groups only ...
			if( !empty($feuAccess) ) {
				
				// ... deny access by default now ...
				$access = false;
				// ... check if user is logged in and belongs to a group ...
				$userId = $feusers->LoggedInId();
				if($userId && $groups = $feusers->GetMemberGroupsArray($userId)) {
					// compare users groups with selected ones
					foreach($groups as $oneGroup) {
						if(in_array($oneGroup['groupid'],$feuAccess)) {
							// if match -> grant access
							$access = true;
							break;
						}
					}
				}
			}
		}
	}

	// if we have access to the page...
	if($access) {
		echo trim($result);
	}
	else {
		
		// get the page to redirect to
		$redirectPage = cmsms()->GetSmarty()->get_template_vars('content_obj')->Properties()->GetValue('redirect_page');
		if($redirectPage == '-1')
			$redirectPage = cmsms()->GetSmarty()->get_template_vars('content_obj')->InheritParentProp(cmsms()->GetSmarty()->get_template_vars('content_obj')->ParentId(),'redirect_page');
		
		// do not redirect to current page -> will result in endless recursive redirection
		if($redirectPage == $returnid || $redirectPage == $pageinfo->content_id || $redirectPage == $pageinfo->content_alias)
			$redirectPage = '';
		
		// get feu action
		$feuAction = cmsms()->GetSmarty()->get_template_vars('content_obj')->Properties()->GetValue('feu_action');
		
		if($feuAction == '-1')
			$feuAction = cmsms()->GetSmarty()->get_template_vars('content_obj')->InheritParentProp(cmsms()->GetSmarty()->get_template_vars('content_obj')->ParentId(),'feu_action');
		
		// if we still don't have a redirect page -> do feu action in current page
		if($redirectPage == '') {
			
			// if we want an action (and we have not done this before) ...
			if($feuAction && $mainContent && !cmsms()->GetSmarty()->get_template_vars('content_obj')->Properties()->GetValue('feu_action_flag')) {
				// ... set a flag that we already have a login form now (just to prevent to display it again for other content blocks) ...
				cmsms()->GetSmarty()->get_template_vars('content_obj')->AddExtraProperty("feu_action_flag");
				cmsms()->GetSmarty()->get_template_vars('content_obj')->SetPropertyValue("feu_action_flag", true);
				// ... and finally do feu action
				return $feusers->DoAction('default', 'cntnt01', array('form'=>'login'), $returnid);
			}
			else {
				// ... otherwise just return nothing
				return;
			}
			
		}
		// else if we have a redirect page ...
		else {
			// get the redirect params
			$pattern        = '/([\w]+)=(["][^"]*["]|[\'][^\']*[\']|[^\'"\s]*)/';
			$redirectParams = cmsms()->GetSmarty()->get_template_vars('content_obj')->Properties()->GetValue('redirect_params');
			$evaluateSmarty = cmsms()->GetSmarty()->get_template_vars('content_obj')->Properties()->GetValue('evaluate_smarty');
			if($evaluateSmarty)
				$redirectParams = $this->ProcessTemplateFromData($redirectParams);
			
			$matches  = array();
			$result   = preg_match_all($pattern, $redirectParams, $matches);
			$_params1 = array();
			$_params2 = array();
			for ($i = 0; $i < count($matches[1]); $i++) {
				if(startswith($matches[2][$i],'\''))
					$matches[2][$i] = trim($matches[2][$i],'\'');
				else if(startswith($matches[2][$i],'"'))
					$matches[2][$i] = trim($matches[2][$i],'"');
				
				$_params1[$matches[1][$i]] = $matches[2][$i];
				$_params2[]                = $matches[1][$i] . '=' . $matches[2][$i];
			}
			// if we want an action ...
			if($feuAction) {
				// ... redirect to the specified page and do feu action
				return $feusers->RedirectForFrontEnd('cntnt01', $redirectPage, 'default', $_params1, false);
			}
			else {
				// ... otherwise just redirect
				$manager =& cmsms()->GetHierarchyManager();
				$node    =& $manager->sureGetNodeByAlias($redirectPage);
				$content =& $node->GetContent();
				if (isset($content) && $url = $content->GetURL()) {
					$config = cmsms()->GetConfig();
					if(!empty($_params1) && !empty($_params2)) {
						if($config['url_rewriting'] == 'none') {
							if($content->DefaultContent())
								$url .= 'index.php?' . implode('&',$_params2);
							else
								$url .= '&' . implode('&',$_params2);
						}
						else if($config['url_rewriting'] == 'internal') {
							if($content->DefaultContent())
								$url .= 'index.php/' . implode('/',$_params1) . '/' . $content->Alias() . $config['page_extension'];
							else {
								$url = str_replace($config['root_url'],
									$config['root_url'] . '/'. implode('/',$_params1),
									$url);
							}
						}
						else if($config['url_rewriting'] == 'mod_rewrite') {
							$url = str_replace($config['root_url'],
								$config['root_url'] . '/'. implode('/',$_params1),
								$url);
							if($content->DefaultContent())
								$url .= $content->Alias() . $config['page_extension'];
						}
					}
					redirect($url);
				}
			}
		}
	}
}

?>
