<?php
#-------------------------------------------------------------------------------
#
# Module : AdvancedContent (c) 2010 by Georg Busch (georg.busch@gmx.net)
#          a content management tool for CMS Made Simple
#          The projects homepage is dev.cmsmadesimple.org/projects/content2/
#          CMS Made Simple is (c) 2004-2010 by Ted Kulp
#          The projects homepage is: cmsmadesimple.org
# Version: 0.6.1
# File   : contenttype.Content2.php
#          This file is a modification of the default content type "Content"
# Purpose: the content object
# License: GPL
#
#-------------------------------------------------------------------------------
/**
 * this is just a dummy class to access the module without using CMSms internals
 */
class AdvancedContentModule extends AdvancedContent 
{
	function AdvancedContentModule() 
	{
		parent::AdvancedContent();
	}
}

class Content2 extends CMSModuleContentType 
{
	/**
	 * @access private
	 * @var string
	 */
	var $_stylesheet;
	
	/**
	 * @access private
	 * @var array
	 */
	var $_contentBlocks;
	
	/**
	 * @access private
	 * @var boolean
	 */
	var $_contentBlocksLoaded;
	
	/**
	 * @access private
	 * @var array
	 */
	var $_tabIds;
	
	/**
	 * @access private
	 * @var array
	 */
	var $_pageTabs;
	
	/**
	 * @access private
	 * @var array
	 */
	var $_blockTabs;
	
	/**
	 * @access private
	 * @var array
	 */
	var $_blockGroups;
	
	/**
	 * @access private
	 * @var array
	 */
	var $_userGroups;
	
	/**
	 * @access private
	 * @var array
	 */
	var $_dateBlocks;
	
	/**
	 * @access private
	 * @var array
	 */
	var $_multiInputs;
	
	/**
	 * @access private
	 * @var boolean
	 */
	var $_isAdmin;
	
	/**
	 * MLE support
	 * @access public
	 * @var boolean
	 */
	var $mle = false;
	
	/**
	 * MLE support
	 * @access public
	 * @var string
	 */
	var $lang;
	
	/**
	 * MLE support
	 * @access public
	 * @var string
	 */
	var $blockLang;
	
	/**
	 * MLE support
	 * @access public
	 * @var string
	 */
	var $defaultBlockLang;
	
	
	/**
	 * Constructor
	 */
	function Content2() 
	{
		parent::ContentBase();
		$this->_contentBlocks       = array();
		$this->_contentBlocksLoaded = false;
		global $CMS_ADMIN_PAGE;
		if(isset($CMS_ADMIN_PAGE) && $CMS_ADMIN_PAGE == 1) 
		{
			$AdvancedContent    =& AdvancedContentModule::GetModuleInstance('AdvancedContent');
			$this->_tabIds      = array();
			$this->_dateBlocks  = array();
			$this->_blockTabs   = array();
			$this->_blockGroups = array();
			$this->_multiInputs = array();
			
			$this->_pageTabs = array(
				'main' => array(
					'tab_id'         => 'main', 
					'tab_name'       => lang('main'), 
					'block_tabs'     => array(),
					'block_groups'   => array(),
					'content_blocks' => array()));
			$this->_tabIds[] = 'main';
			
			if( check_permission(get_userid(), 'Manage All Content') ) 
			{
				$this->_pageTabs['options'] = array(
					'tab_id'         => 'options', 
					'tab_name'       => lang('options'), 
					'block_tabs'     => array(),
					'block_groups'   => array(),
					'content_blocks' => array());
				$this->_tabIds[] = 'options';
			}
			
			if( check_permission(get_userid(), 'Manage AdvancedContent Options') && $AdvancedContent->GetPreference('show_advancedcontent_options',1) ) 
			{
				$this->_pageTabs['AdvancedContent'] = array(
					'tab_id'         => 'AdvancedContent', 
					'tab_name'       => 'AdvancedContent', 
					'block_tabs'     => array(),
					'block_groups'   => array(),
					'content_blocks' => array());
				$this->_tabIds[] = 'AdvancedContent';
			}
			
			$this->_userGroups = $this->GetGroups();
			$this->_isAdmin    = cmsms()->GetUserOperations()->UserInGroup(get_userid(),1);
		}
		
		# MLE support
		global $hls, $mleblock, $mleblockfallback;
		if(isset($hls)) 
		{
			$this->mle              = true;
			$this->lang             = $hls;
			$this->blockLang        = $mleblock;
			$this->defaultBlockLang = $mleblockfallback;
		}
		#---
	}
	
	function ModuleName() 
	{
		return 'AdvancedContent';
	}
	
	function IsDefaultPossible() 
	{
		return TRUE;
	}
	
	function IsCopyable() 
	{
		return TRUE;
	}
	
	function FriendlyName() 
	{
		return $this->lang('AdvancedContent');
	}
	
	function &get_content_blocks() 
	{
		$this->parse_content_blocks('get_content_blocks');
		return $this->_contentBlocks;
	}
	
	private function &_get_block_info($wholetag)
	{
		$pattern   = '/([\w]+)=(["][^"]*["]|[\'][^\']*[\']|[^\'"\s]*)/';
		$blockInfo = array();
		$AdvancedContent =& AdvancedContent::GetModuleInstance('AdvancedContent');
		
		// get the arguments.
		$matches = array();
		$result  = preg_match_all($pattern, $wholetag, $matches);
		
		$keyval = array();
		for ($i = 0; $i < count($matches[1]); $i++) 
		{
			if(startswith($matches[2][$i],'\''))
				$matches[2][$i] = trim($matches[2][$i],'\'');
			else if(startswith($matches[2][$i],'"'))
				$matches[2][$i] = trim($matches[2][$i],'"');
			
			$keyval[strtolower($matches[1][$i])] = $matches[2][$i];
		}
		
		// block = active?
		if(isset($keyval['active']) && $this->IsFalse($keyval['active'])) 
		{
			continue; // don't process inactive blocks
		}
		
		// additional editors
		$editorGroups = '';
		if(isset($keyval['editor_groups']) && $keyval['editor_groups'] != '') 
		{
			$editorGroups = trim($keyval['editor_groups']);
		}
		$editorUsers = '';
		if(isset($keyval['editor_users']) && $keyval['editor_users'] != '') 
		{
			$editorUsers = trim($keyval['editor_users']);
		}
		
		// blocktype
		$blockType = 'text';
		if(startswith($wholetag, 'content_image')) 
		{
			$blockType = 'image';
			$defaultMode = true;
		}
		elseif(startswith($wholetag, 'content_module')) 
		{
			$blockType = 'module';
			$defaultMode = true;
		}
		elseif(isset($keyval['block_type']) && $keyval['block_type'] != '')
			$blockType = strtolower($keyval['block_type']);
		
		// blockname
		$name = 'content_en';
		# MLE support
		if($this->mle && $this->blockLang != '') 
		{
			$name = 'content'.$this->blockLang;
		}
		#---
		
		if(isset($keyval['block']) && $keyval['block'] != '')
			$name = trim($keyval['block']);
		
		// block id
		$blockId = preg_replace('/-+/','_',munge_string_to_url($name));
		
		$smarty = false;
		if(isset($keyval['smarty']) && $this->IsTrue($keyval['smarty'])) 
		{
			$smarty = true;
		}
		
		$translateLabels = false;
		if(isset($keyval['translate_labels']) && $this->IsTrue($keyval['translate_labels'])) 
		{
			$translateLabels = true;
		}
		
		$translateValues = false;
		if(isset($keyval['translate_values']) && $this->IsTrue($keyval['translate_values'])) 
		{
			$translateValues = true;
		}
		
		$label = ucwords($name);
		if(isset($keyval['label']) && $keyval['label'] != '')
			$label = trim($keyval['label']);
		
		// default content/value
		$defaultValue 	= '';
		if(isset($keyval['default']) && $keyval['default'] != '')
			$defaultValue = $keyval['default'];
		
		// backend style (e.g. to mark required fields...)
		$style = '';
		if(isset($keyval['style'])) 
		{
			$style = $keyval['style'];
		}
		
		// size of the input field
		$size = '';
		if(isset($keyval['size'])) 
		{
			$size = intval($keyval['size']);
		}
		
		$pageTab = 'main';
		if(isset($keyval['page_tab']) && trim($keyval['page_tab'] != '')) 
		{
			$pageTab = trim($keyval['page_tab']);
		}
		
		$blockTab = '';
		if(isset($keyval['block_tab']) && trim($keyval['block_tab'] != '')) 
		{
			$blockTab = trim($keyval['block_tab']);
		}
		
		$blockGroup = '';
		if(isset($keyval['block_group']) && trim($keyval['block_group'] != '')) 
		{
			$blockGroup = trim($keyval['block_group']);
		}
		
		$allowNone = true;
		if(isset($keyval['allow_none']) && $this->IsFalse($keyval['allow_none']))
			$allowNone = false;
		
		$description = '';
		if(isset($keyval['description']))
			$description = trim($keyval['description']);
		
		$collapse = !$AdvancedContent->GetPreference('collapse_block_default',1);
		if(isset($keyval['collapse']) && $this->IsTrue($keyval['collapse']))
			$collapse = trim($keyval['collapse']);
		
		if($blockType == 'text') 
		{
			
			$maxlength = '';
			if(isset($keyval['maxlength'])) 
			{
				$maxlength = $keyval['maxlength'];
			}
			
			$usewysiwyg = true;
			if(isset($keyval['wysiwyg']) && $this->IsFalse($keyval['wysiwyg'])) 
			{
				$usewysiwyg = false;
			}
			
			$oneline = false;
			if(isset($keyval['oneline']) && $this->IsTrue($keyval['oneline'])) 
			{
				$oneline = true;
			}
			
			$blockInfo['maxlength']  = $maxlength;
			$blockInfo['usewysiwyg'] = $usewysiwyg;
			$blockInfo['oneline']    = $oneline;
			$blockInfo['size']       = $size;
		}
		else if ($blockType == 'date') 
		{
			$this->_dateBlocks[] = $blockId;
			
			$showClock = true;
			if(isset($keyval['show_clock']) && $this->IsTFalse($keyval['show_clock']))
				$showClock = false;
			
			$mode = 'calendar';
			if(isset($keyval['mode']) && strtolower($keyval['mode']) == 'dropdown')
				$mode = 'dropdown';
			
			$show24h = true;
			if(isset($keyval['show24h']) && $this->IsFalse($keyval['show24h']))
				$show24h = false;
			
			$startHour = 0;
			$endHour   = 23;
			if(isset($keyval['start_hour'])) 
			{
				if(endswith($keyval['start_hour'],'pm')) 
				{
					$keyval['start_hour'] = trim(str_ireplace('pm','',$keyval['start_hour'])) + 12;
				}
				else
					$keyval['start_hour'] = trim(str_ireplace(array('am','pm'),'',$keyval['start_hour']));
					
				if($keyval['start_hour'] > 0 && $keyval['start_hour'] <= $endHour)
					$startHour = trim($keyval['start_hour']);
			}
			if(isset($keyval['end_hour'])) 
			{
				if(endswith($keyval['end_hour'],'pm')) {
					$keyval['end_hour'] = trim(str_ireplace('pm','',$keyval['end_hour'])) + 12;
				}
				else
					$keyval['end_hour'] = trim(str_ireplace(array('am','pm'),'',$keyval['end_hour']));
					
				if($keyval['end_hour'] >= 0 && $keyval['end_hour'] < $endHour)
					$endHour = trim($keyval['end_hour']);
			}
			
			if($endHour < $startHour)
				$endHour = $startHour;
			
			$startMinute = 0;
			if(isset($keyval['start_minute']) && $keyval['start_minute'] > 0 && $keyval['start_minute'] <= 59)
				$startMinute = trim($keyval['start_minute']);
			
			$endMinute = 59;
			if(isset($keyval['end_minute']) && $keyval['end_minute'] >= 0 && $keyval['end_minute'] < 59)
				$endMinute = trim($keyval['end_minute']);
			
			if($endMinute < $startMinute)
				$endMinute = $startMinute;
			
			$startSecond = 0;
			if(isset($keyval['start_second']) && $keyval['start_second'] > 0 && $keyval['start_second'] <= 59)
				$startSecond = trim($keyval['start_second']);
			
			$endSecond = 59;
			if(isset($keyval['end_second']) && $keyval['end_second'] >= 0 && $keyval['end_second'] < 59)
				$endSecond = trim($keyval['end_second']);
			
			if($endSecond < $startSecond)
				$endSecond = $startSecond;
			
			$stepHours = 1;
			if(isset($keyval['step_hours']) && $keyval['step_hours'] > 0 && $keyval['step_hours'] <= ($endHour-$startHour))
				$stepHours = trim($keyval['step_hours']);
			else if(isset($keyval['step_hours']) && $keyval['step_hours'] > 0 && $keyval['step_hours'] >= ($endHour-$startHour))
				$stepHours = $endHour-$startHour;
			
			$stepMinutes = 10;
			if(isset($keyval['step_minutes']) && $keyval['step_minutes'] > 0 && $keyval['step_minutes'] <= ($endMinute-$startMinute))
				$stepMinutes = trim($keyval['step_minutes']);
			else if(isset($keyval['step_minutes']) && $keyval['step_minutes'] > 0 && $keyval['step_minutes'] >= ($endMinute-$startMinute))
				$stepMinutes = $endMinute-$startMinute;
			
			$stepSeconds = 1;
			if(isset($keyval['step_seconds']) && $keyval['step_seconds'] > 0 && $keyval['step_seconds'] <= ($endSecond-$startSeconds))
				$stepSeconds = trim($keyval['step_seconds']);
			else if(isset($keyval['step_seconds']) && $keyval['step_seconds'] > 0 && $keyval['step_seconds'] >= ($endSecond-$startSeconds))
				$stepSeconds = $endSecond-$startSeconds;
			
			$blockInfo['show24h']      = $show24h;
			$blockInfo['mode']         = $mode;
			$blockInfo['start_hour']   = $startHour;
			$blockInfo['end_hour']     = $endHour;
			$blockInfo['start_minute'] = $startMinute;
			$blockInfo['end_minute']   = $endMinute;
			$blockInfo['start_second'] = $startSecond;
			$blockInfo['end_second']   = $endSecond;
			$blockInfo['step_hours']   = $stepHours;
			$blockInfo['step_minutes'] = $stepMinutes;
			$blockInfo['step_seconds'] = $stepSeconds;
			$blockInfo['show_clock']   = $showClock;
		}
		else if($blockType == 'dropdown' || $blockType == 'select_multiple') 
		{
			if($blockType == 'select_multiple') 
			{
				$sortable = false;
				// deprecated
				if(isset($keyval['sortable_items']) && $this->IsTrue($keyval['sortable_items'])) 
				{
					$sortable = true;
				}
				if(isset($keyval['sortable']) && $this->IsTrue($keyval['sortable'])) 
				{
					$sortable = true;
				}
				$blockInfo['sortable'] = $sortable;
			}
			
			$delimiter = '|';
			if(isset($keyval['delimiter']) && $keyval['delimiter'] != '') 
			{
				$delimiter = $keyval['delimiter'];
			}
			$items = '';
			if(isset($keyval['items']) && $keyval['items'] != '') 
			{
				$items = trim($keyval['items']);
			}
			$values = '';
			if(isset($keyval['values']) && $keyval['values'] != '') 
			{
				$values = trim($keyval['values']);
			}
			
			$blockInfo['items']     = $items;
			$blockInfo['values']    = $values;
			$blockInfo['delimiter'] = $delimiter;
			
		}
		else if($blockType == 'module') 
		{
			$module = '';
			if(isset($keyval['module']))
				$module = trim($keyval['module']);
			
			$blockInfo['module'] = $module;
			$blockInfo['params'] = $keyval;
		}
		else if($blockType == 'multi_input') 
		{
			$inputs = '';
			if(isset($keyval['inputs']))
			{
				$inputs = trim($keyval['inputs']);
			}
			
			$valueDelim = '<!-- multi_input_value_delimiter -->';
			if(isset($keyval['value_delimiter']))
			{
				$valueDelim = trim($keyval['value_delimiter']);
			}
			
			$inputDelim = '<!-- multi_input_delimiter -->';
			if(isset($keyval['input_delimiter']))
			{
				$imputDelim = trim($keyval['input_delimiter']);
			}
			$blockInfo['inputs']          = $inputs;
			$blockInfo['value_delimiter'] = $valueDelim;
			$blockInfo['input_delimiter'] = $inputDelim;
		}
		
		$blockInfo['smarty']           = $smarty;
		$blockInfo['style']            = $style;
		$blockInfo['name']             = $name;
		$blockInfo['id']               = $blockId;
		$blockInfo['block_type']       = $blockType;
		$blockInfo['type']             = $blockType;
		$blockInfo['label']            = $label;
		$blockInfo['block_tab']        = $blockTab;
		$blockInfo['page_tab']         = $pageTab;
		$blockInfo['editor_users']     = $editorUsers;
		$blockInfo['editor_groups']    = $editorGroups;
		$blockInfo['allow_none']       = $allowNone;
		$blockInfo['translate_labels'] = $translateLabels;
		$blockInfo['translate_values'] = $translateValues;
		$blockInfo['description']      = $description;
		$blockInfo['collapse']         = $collapse;
		$blockInfo['block_group']      = $blockGroup;
		$blockInfo['default_value']    = $defaultValue;
		$blockInfo['multiple']         = false;
		$blockInfo['new_block']        = false;
		return $blockInfo;
	}
	
	private function parse_content_blocks($function = '') 
	{
		if($this->_contentBlocksLoaded) 
		{
			return true;
		}
		
		if($this->mType != 'content2' && $this->mType != 'content') 
		{
			return true;
		}
		
		$config = cmsms()->GetConfig();
		$templateops =& cmsms()->GetTemplateOperations();
		
		if ($this->mTemplateId && $this->mTemplateId > -1) 
		{
			$template = $templateops->LoadTemplateByID($this->mTemplateId);
			$this->_stylesheet = '../stylesheet.php?templateid='.$this->mTemplateId;
		}
		else 
		{
			$template = $templateops->LoadDefaultTemplate();
		}
		
		$this->_contentBlocks = array();
		
		$AdvancedContent    =& AdvancedContentModule::GetModuleInstance('AdvancedContent');
		
		global $CMS_ADMIN_PAGE;
		if(isset($CMS_ADMIN_PAGE) && $CMS_ADMIN_PAGE == 1) 
		{
			$this->_tabIds      = array();
			$this->_dateBlocks  = array();
			$this->_blockTabs   = array();
			$this->_blockGroups = array();
			#$this->_multiInputs = array();
			
			$this->_pageTabs['main']['block_tabs'] = array();
			$this->_pageTabs['main']['block_groups'] = array();
			$this->_pageTabs['main']['content_blocks'] = array();
			$this->_tabIds[] = 'main';
			
			if( check_permission(get_userid(), 'Manage All Content') ) 
			{
				$this->_pageTabs['options']['block_tabs'] = array();
				$this->_pageTabs['options']['block_groups'] = array();
				$this->_pageTabs['options']['content_blocks'] = array();
				$this->_tabIds[] = 'options';
			}
			
			if( check_permission(get_userid(), 'Manage AdvancedContent Options') && $AdvancedContent->GetPreference('show_advancedcontent_options',1) ) 
			{
				$this->_pageTabs['AdvancedContent']['block_tabs'] = array();
				$this->_pageTabs['AdvancedContent']['block_groups'] = array();
				$this->_pageTabs['AdvancedContent']['content_blocks'] = array();
				$this->_tabIds[] = 'AdvancedContent';
			}
		}
		
		if($template !== false) 
		{
			if($config['debug']) 
			{
				debug_buffer('parsing template for content blocks ('.$function.')','AdvancedContent');
			}
			
			// read content blocks
			# this will search for {content} {content_image} {content_module} and {AdvancedContent} with or without params (case insensitive)
			$pattern = '/{((AdvancedContent|content(_image|_module)?)([^}]*))}/i';
			
			$matches = array();
			// get all the tags
			$result = preg_match_all($pattern, $template->content, $matches);
			
			if ($result && count($matches[1]) > 0) 
			{
				
				// get the basic content properties
				$basicAttribs = array();
				foreach( $this->_attributes as $oneAttrib ) 
				{
					$basicAttribs[] = $oneAttrib[0];
				}
				
				$j = 0;
				// foreach tag
				foreach ($matches[1] as $key=>$wholetag) 
				{
					$j++;
					
					$blockInfo =& $this->_get_block_info($wholetag);
					
					// block = active?
					if(isset($blockInfo['active']) && $this->IsFalse($blockInfo['active'])) 
					{
						continue; // don't process inactive blocks
					}
					
					if(isset($this->_contentBlocks[$blockInfo['id']])) 
					{
						$this->_contentBlocks[$blockInfo['id']]['multiple'] = true;
						continue;
					}
					
					// if this block has been added to the template after page has been created
					if(!in_array($blockInfo['id'],$this->mProperties->mPropertyNames)) 
					{
						$blockInfo['new_block'] = true;
					}
					
					$pageTab = preg_replace('/-+/','_',munge_string_to_url(strtolower(trim($blockInfo['page_tab']))));
					if(!isset($this->_pageTabs[$pageTab])) 
					{
						$this->_pageTabs[$pageTab]['tab_id']       = $pageTab;
						$this->_pageTabs[$pageTab]['tab_name']     = $blockInfo['page_tab'];
						$this->_pageTabs[$pageTab]['block_tabs']   = array();
						$this->_pageTabs[$pageTab]['block_groups'] = array();
						$blockInfo['page_tab'] = $pageTab;
					}
					$this->_pageTabs[$pageTab]['content_blocks'][$blockInfo['id']] = $blockInfo['id'];
					
					$blockTab = '';
					if($blockInfo['block_tab'] != '') 
					{
						$blockTab = $pageTab . '_' . preg_replace('/-+/','_',munge_string_to_url(strtolower(trim($blockInfo['block_tab']))));
						if(!isset($this->_blockTabs[$blockTab]))
						{
							$this->_blockTabs[$blockTab]['tab_id']       = $blockTab;
							$this->_blockTabs[$blockTab]['tab_name']     = $blockInfo['block_tab'];
							$this->_blockTabs[$blockTab]['block_groups'] = array();
						}
						$this->_blockTabs[$blockTab]['content_blocks'][$blockInfo['id']] = $blockInfo['id'];
						$this->_pageTabs[$pageTab]['block_tabs'][$blockTab]              = $blockTab;
						$blockInfo['block_tab'] = $blockTab;
					}
					
					$blockGroup = '';
					if($blockInfo['block_group'] != '') 
					{
						$blockGroup = ($blockTab?$blockTab:$pageTab) . '_' . preg_replace('/-+/','_',munge_string_to_url(strtolower(trim($blockInfo['block_group']))));
						if(!isset($this->_blockGroups[$blockGroup])) 
						{
							$this->_blockGroups[$blockGroup]['group_id']   = $blockGroup;
							$this->_blockGroups[$blockGroup]['group_name'] = $blockInfo['block_group'];
							$this->_pageTabs[$pageTab]['block_groups'][$blockGroup] = $blockGroup;
						}
						$this->_blockGroups[$blockGroup]['content_blocks'][$blockInfo['id']] = $blockInfo['id'];
						unset($this->_blockTabs[$blockTab]['content_blocks'][$blockInfo['id']]);
						if($blockTab) 
						{
							$this->_blockTabs[$blockTab]['block_groups'][$blockGroup] = $blockGroup;
						}
						else 
						{
							unset($this->_blockTabs[$blockTab]['block_groups'][$blockGroup]);
						}
						$blockInfo['block_group'] = $blockGroup;
					}
					
					// this will create an invalid block type to print out a 
					// message when using a basic content property as block name
					if(in_array($blockInfo['id'], $basicAttribs) 
					|| $blockInfo['id'] == $blockInfo['id'] . '_feu_action' 
					|| $blockInfo['id'] == $blockInfo['id'] . '_feu_action[]' 
					|| $blockInfo['id'] == $blockInfo['id'] . '_feu_access' 
					|| $blockInfo['id'] == $blockInfo['id'] . '_feu_access[]' 
					|| $blockInfo['id'] == 'AdvancedContentStartDate' 
					|| $blockInfo['id'] == 'AdvancedContentEndDate' 
					|| $blockInfo['id'] == 'AdvancedContentStartTime' 
					|| $blockInfo['id'] == 'AdvancedContentEndTime' 
					|| $blockInfo['id'] == 'start_date' 
					|| $blockInfo['id'] == 'end_date' 
					|| $blockInfo['id'] == $blockInfo['id'] . '_AdvancedContentTime' 
					|| $blockInfo['id'] == $blockInfo['id'] . '_AdvancedContentDate') 
					{
						$blockInfo['id'] = md5($blockInfo['id'] . $j);
						
						$this->_contentBlocks[$blockInfo['id']] = $blockInfo;
						$this->_contentBlocks[$blockInfo['id']]['block_type']    = '';
						$this->_contentBlocks[$blockInfo['id']]['default_value'] = $this->lang('error_basicattrib', $name);
						
						continue;
					}
					
					$this->_contentBlocks[$blockInfo['id']] = $blockInfo;
					$this->AddExtraProperty($blockInfo['id']);
				}
			}
			// force a load
			$this->mProperties->Load($this->mId);
			$this->_contentBlocksLoaded = true;
		}
		return $this->_contentBlocksLoaded;
	}
	
	function display_content_block($blockName,$blockInfo,$value,$adding = false) 
	{
		if(method_exists($this,'_display_'.$blockInfo['block_type'].'_block'))
		{
			return call_user_func(array($this,'_display_'.$blockInfo['block_type'].'_block'), $blockInfo, $value, $adding);
		}
	}
	
	function SetProperties() 
	{
		parent::SetProperties();
		
		$this->AddBaseProperty('template', 4, 0, 'int');
		$this->AddBaseProperty('pagemetadata', 20);
		
		$this->AddContentProperty('searchable', 8, 0, 'int');
		$this->AddContentProperty('pagedata', 25);
		$this->AddContentProperty('disable_wysiwyg', 60, 0, 'int');
		
		$this->AddContentProperty('feu_access', 99);
		$this->AddContentProperty('redirect_page', 100, 0, 'int');
		$this->AddContentProperty('redirect_params', 101, 0);
		$this->AddContentProperty('evaluate_smarty', 102, 0, 'int');
		$this->AddContentProperty('feu_action', 103, 0, 'int');
		
		$this->AddContentProperty('use_expire_date', 104, 0, 'int');
		$this->AddContentProperty('start_date', 105, 0, 'int');
		$this->AddContentProperty('end_date', 106, 0, 'int');
		
		$this->mPreview = true;
	}
	
	function ReadyForEdit() 
	{
		$this->parse_content_blocks('ReadyForEdit');
	}
	
	function Show($param = 'content_en') 
	{
		$this->parse_content_blocks('Show');
		
		# MLE support
		if($this->mle && $this->blockLang != '') 
		{
			if($param == 'content_en') 
			{
				$param = 'content'.$this->blockLang;
			}
			else if(!endswith($param,$this->blockLang)) 
			{
				$param .= $this->blockLang;
			}
			
			$result = $this->GetPropertyValue($param);
			
			if($result == '' && $this->defaultBlockLang != '' && $this->defaultBlockLang != $this->blockLang) 
			{
				$param = str_replace($this->blockLang, $this->defaultBlockLang, $param);
				$result = $this->GetPropertyValue($param);
			}
			
			return $result;
		}
		#---
		
		return $this->GetPropertyValue($param);
	}
	
	function TabNames() 
	{
		$tabs = array(lang('main'));
		if( check_permission(get_userid(), 'Manage All Content') ) 
		{
			$tabs[] = lang('options');
		}
		$AdvancedContent =& AdvancedContentModule::GetModuleInstance('AdvancedContent');
		if( check_permission(get_userid(), 'Manage AdvancedContent Options') && $AdvancedContent->GetPreference('show_advancedcontent_options',1)) 
		{
			$tabs[] = 'AdvancedContent';
		}
		
		$this->parse_content_blocks('TabNames');
		
		foreach($this->_pageTabs as $tab) 
		{
			if(!in_array($tab['tab_name'], $tabs)) 
			{
				$tabs[] = $tab['tab_name'];
			}
			if(!in_array($tab['tab_id'], $this->_tabIds)) 
			{
				$this->_tabIds[] = $tab['tab_id'];
			}
		}
		return $tabs;
	}
	
	function FillParams($params) 
	{
		if(isset($params['content_type'])) 
		{
			$AdvancedContent =& AdvancedContentModule::GetModuleInstance('AdvancedContent');
			
			$parameters = array('pagedata', 'searchable', 'disable_wysiwyg', 'feu_access', 'redirect_page', 'redirect_params', 'evaluate_smarty', 'feu_action', 'start_date', 'end_date', 'use_expire_date');
			
			$this->_contentBlocksLoaded = false;
			//pick up the template id before we do parameters
			if (isset($params['template_id'])) 
			{
				#if($this->mTemplateId != $params['template_id']) {
				#	$this->_contentBlocksLoaded = false;
				#}
				$this->mTemplateId = $params['template_id'];
			}
			//pick up the content type before we do parameters
			if (isset($params['content_type'])) 
			{
				#if($this->mType != $params['content_type']) {
				#	$this->_contentBlocksLoaded = false;
				#}
				$this->mType = $params['content_type'];
			}
			
			if($this->mType == 'content2' || $this->mType == 'content') 
			{
				// add content blocks
				$this->parse_content_blocks('FillParams');
				
				# added by NaN:
				$parentId = -1;
				if(isset($params['parent_id']))
				{
					$parentId = $params['parent_id'];
				}
				
				if(check_permission(get_userid(), 'Manage AdvancedContent Options') && isset($params['feu_access'])) 
				{
					if(!is_array($params['feu_access']))
					{
						$feuAccess = array();
					}
					else
					{
						$feuAccess = $params['feu_access'];
					}
					
					// if page has no parents but wants to inherit -> remove inheritance
					if($parentId <= 0 && in_array('-1', $feuAccess)) 
					{
						foreach($feuAccess as $k=>$v) 
						{
							if($v == '-1') 
							{
								unset($feuAccess[$k]);
							}
						}
					}
					
					// if there is still inheritance -> check if there actually is any feu group selected by parents
					$_feuAccess = array();
					if(in_array('-1', $feuAccess)) 
					{
						// $_feuAccess contains all feu groups (of current page as well as of all parent pages)
						$_feuAccess = $this->InheritParentProp($parentId, 'feu_access', $feuAccess);
					}
					
					// if we have selected any feu group -> disable caching and search
					if(count($_feuAccess) || (count($feuAccess) && !in_array('-1', $feuAccess))) 
					{
						$params['cachable']   = false;
						$this->mCachable      = false;
						$params['searchable'] = false;
					}
					
					$params['feu_access'] = implode(';', $feuAccess);
					
					$redirectPage = '';
					if(isset($params['redirect_page'])) 
					{
						$redirectPage = $params['redirect_page'];
					}
					// if page has no parents but wants to inherit -> remove inheritance
					if($parentId <= 0 && $redirectPage == -1) 
					{
						$redirectPage = '';
					}
					
					$feuAction = ''; 
					if(isset($params['feu_action']))
						$feuAction = $params['feu_action'];
					// if page has no parents but wants to inherit -> remove inheritance
					if($parentId <= 0 && $feuAction == -1) 
					{
						$feuAction = '';
					}
					$params['redirect_page'] = $redirectPage;
					$params['feu_action']    = $feuAction;
				}
				
				// do the content property parameters
				foreach ($parameters as $oneparam) 
				{
					if(check_permission(get_userid(), 'Manage AdvancedContent Options') && $oneparam == 'start_date' || $oneparam == 'end_date') 
					{
						$_string           = ucfirst(str_replace('_date','',$oneparam));
						$params[$oneparam] = 0;
						if(isset($params['AdvancedContent'.$_string.'Time']) && isset($params['AdvancedContent'.$_string.'Date']))
							$params[$oneparam] = $params['AdvancedContent'.$_string.'Time'] + $params['AdvancedContent'.$_string.'Date'];
					}
					if (isset($params[$oneparam])) 
					{
						$this->SetPropertyValue($oneparam, $params[$oneparam]);
					}
				}
				
				if(check_permission(get_userid(), 'Manage AdvancedContent Options') && isset($params['start_date']) && isset($params['use_expire_date']) && $params['use_expire_date'] == 1 && $params['start_date'] > time()) 
				{
					$params['active'] = false;
					$this->mActive    = false;
				}
				
				// metadata
				if (isset($params['metadata'])) 
				{
					$this->mMetadata = $params['metadata'];
				}
				
				// content blocks
				$i = 0;
				foreach($params as $paramName => $paramValue) 
				{
					$paramName = str_replace('_AdvancedContentDate', '', $paramName);
					
					if(!isset($this->_contentBlocks[$paramName]))
					{
						continue;
					}
					
					$i++;
					$value = '';
					if($this->_contentBlocks[$paramName]['block_type'] == 'select_multiple') 
					{
						if(is_array($paramValue))
							$value = implode($this->_contentBlocks[$paramName]['delimiter'], $paramValue);
						else if ($this->_contentBlocks[$paramName]['sortable']) 
						{
							$items = array();
							foreach($params as $itemName => $itemValue) // create function to loop only through the items not through all params!
							{
								if(startswith($itemName,$paramName.'_AdvancedContentSortableItem_')) 
								{
									$items[] = $itemValue;
								}
							}
							$value = implode($this->_contentBlocks[$paramName]['delimiter'], $items);
						}
					}
					else if($this->_contentBlocks[$paramName]['block_type'] == 'date' 
					&& $this->_contentBlocks[$paramName]['mode'] == 'calendar' 
					&& isset($params[$paramName . '_AdvancedContentDate'])) 
					{
						$time = 0;
						if(isset($params[$paramName . '_AdvancedContentTime']))
						{
							$time = $params[$paramName . '_AdvancedContentTime'];
						}
						#$_tmp         = explode(':', $params[$paramName . '_AdvancedContentTime']);
						#$time_seconds = (($_tmp[0] * 3600) + ($_tmp[1] * 60));
						#$value       = $time_seconds + $params[$paramName . '_AdvancedContentDate'];
						$value        = $time + $params[$paramName . '_AdvancedContentDate'];
					}
					else if($this->_contentBlocks[$paramName]['block_type'] == 'multi_input')
					{
						$multi_inputs = array();
						foreach($this->CleanArray(explode(',',$this->_contentBlocks[$paramName]['inputs'])) as $k=>$input_id)
						{
							$multi_input_values = array();
							foreach($this->_multiInputs[$input_id]['elements'] as $elm_id)
							{
								if(isset($params['multiInput-'.$paramName.'-'.$k.'-'.$elm_id]))
								{
									$multi_input_values[] = $params['multiInput-'.$paramName.'-'.$k.'-'.$elm_id];
								}
							}
							#if(!$this->IsVarEmpty($multi_input_values))
							{
								$multi_inputs[] = implode($this->_contentBlocks[$paramName]['value_delimiter'],$multi_input_values);
							}
							#else
							#{
							#	$multi_inputs[] = '';
							#}
						}
						if(!$this->IsVarEmpty($multi_inputs))
						{
							$value = implode($this->_contentBlocks[$paramName]['input_delimiter'], $multi_inputs);
						}
					}
					else
					{
						$value = trim($paramValue);
					}
					if($value == '' && !$this->_contentBlocks[$paramName]['allow_none']) 
					{
						$value = $this->_contentBlocks[$paramName]['default_value'];
						if($this->_contentBlocks[$paramName]['smarty'])
							$value = $this->DoSmarty($value);
					}
					
					# MLE support
					if($this->mle && $this->blockLang != '' && $paramName != 'content' . $this->blockLang)
						$paramName .= $this->blockLang;
					#---
					
					$this->AddExtraProperty($paramName);
					$this->SetPropertyValue($paramName, $value);
				}
			}
		}
		parent::FillParams($params);
	}
	
	function EditAsArray($adding = false, $tab = 0, $showadmin = false) 
	{
		$this->parse_content_blocks('EditAsArray');
		$ret = array();
		$tmp = array();
		if(isset($this->_tabIds[$tab])) 
		{
			$tab_id = $this->_tabIds[$tab];
		}
		else 
		{
			return array();
		}
		if($tab_id == 'main' || ($tab_id == 'options' && check_permission(get_userid(), 'Manage All Content'))) 
		{
			$tmp = $this->CleanArray($this->display_attributes($adding, $tab));
		}
		else if($tab_id == 'AdvancedContent' && check_permission(get_userid(), 'Manage AdvancedContent Options')) 
		{
			$tmp = $this->DisplayAdvancedOptions($adding);
		}
		
		foreach( $tmp as $one ) 
		{
			$ret[] = $one;
		}
		
		$AdvancedContent =& AdvancedContentModule::GetModuleInstance('AdvancedContent');
		$j = 0;
		foreach($this->_pageTabs[$tab_id]['block_groups'] as $blockGroup) 
		{
			$this->_blockGroups[$blockGroup]['display'] = $AdvancedContent->GetItemDisplay('group', $blockGroup, $this->mId, $this->mTemplateId, !$AdvancedContent->GetPreference('collapse_group_default',1));
				$this->_blockGroups[$blockGroup]['pref_url'] = str_replace('&amp;','&',
					$AdvancedContent->CreateLink('m1_', 'savePrefs', '', $this->lang('toggle_group'), 
						array('item_type'=>'group',
							'disable_theme'=>true, 
							'ajax'=>true, 
							'content_id'=>$this->mId,
							'template_id'=>$this->mTemplateId,
							'item_id'=>$blockGroup), 
						'', true));
		}
		foreach($this->_pageTabs[$tab_id]['content_blocks'] as $blockId) 
		{
			$j++;
			
			if(!$this->CheckBlockPermission($blockId))
				continue;
			
			if($this->_contentBlocks[$blockId]['block_type'] != '' && $this->_contentBlocks[$blockId]['smarty']) 
			{
				foreach($this->_contentBlocks[$blockId] as $propName=>$propValue) 
				{
					$this->_contentBlocks[$blockId][$propName] = $this->DoSmarty($propValue);
				}
			}
			# MLE support
			if($this->mle && $this->blockLang != '' && $blockId != 'content' . $this->blockLang)
			{
				$value = $this->GetPropertyValue($blockId . $this->blockLang);
			}
			else #---
			{
				$value = $this->GetPropertyValue($blockId);
			}
			# MLE support
			if($this->mle && $value == '' && $this->defaultBlockLang != '' && $this->defaultBlockLang != $this->blockLang) 
			{
				if($blockId != 'content' . $this->blockLang)
				{
					$value = $this->GetPropertyValue($blockId . $this->defaultBlockLang);
				}
				else
				{
					$value = $this->GetPropertyValue('content' . $this->defaultBlockLang);
				}
			}
			#---
			
			if(($adding && $value == '') 
			|| ($value == '' && !$this->_contentBlocks[$blockId]['allow_none']) || $this->_contentBlocks[$blockId]['new_block']) 
			{
				$value = $this->_contentBlocks[$blockId]['default_value'];
			}
			
			$this->_contentBlocks[$blockId]['content'] = cms_htmlentities($value, ENT_NOQUOTES, get_encoding(''));
			$this->_contentBlocks[$blockId]['input']   = $AdvancedContent->lang('invalid_blocktype',$this->_contentBlocks[$blockId]['block_type'],$this->_contentBlocks[$blockId]['name']);
			
			if($this->_contentBlocks[$blockId]['label'] == ucwords($this->_contentBlocks[$blockId]['name']) 
			&& ($blockId == md5('content_en'.$j) 
			|| $blockId == 'content_en' 
			|| ($this->mle && $this->blockLang != '' 
			&& ($blockId == 'content' . $this->blockLang 
			|| $blockId == md5('content' . $this->blockLang.$j)))))
			{
				$this->_contentBlocks[$blockId]['label'] = lang('content');
			}
			
			if($this->_contentBlocks[$blockId]['translate_labels'])
			{
				$this->_contentBlocks[$blockId]['label'] = $AdvancedContent->lang($blockId);
			}
			
			$blockDisplay = $AdvancedContent->GetItemDisplay('block', $blockId, $this->mId, $this->mTemplateId, !$this->_contentBlocks[$blockId]['collapse']);
			$this->_contentBlocks[$blockId]['display'] = $blockDisplay;
			$this->_contentBlocks[$blockId]['pref_url'] = str_replace('&amp;','&',
				$AdvancedContent->CreateLink('m1_', 'savePrefs', '', $this->lang('toggle_block'), 
					array('item_type'=>'block',
						'disable_theme'=>true, 
						'ajax'=>true, 
						'content_id'=>$this->mId,
						'template_id'=>$this->mTemplateId,
						'item_id'=>$blockId), 
					'', true));
			
			if($this->_contentBlocks[$blockId]['multiple'] && $AdvancedContent->GetItemDisplay('message', $blockId, $this->mId, $this->mTemplateId)) 
			{
				$hideLink = str_replace('&amp;','&',
					$AdvancedContent->CreateLink('m1_', 'savePrefs', '', $this->lang('toggle_message'), 
						array('item_type'=>'message',
							'disable_theme'=>true, 
							'ajax'=>true, 
							'content_id'=>$this->mId,
							'template_id'=>$this->mTemplateId,
							'item_id'=>$blockId,
							'item_display'=>0), 
						'', false,'','onclick="jQuery.get(this.href); jQuery(this).parent().toggle(\'fast\'); return false;"'));
					$this->_contentBlocks[$blockId]['description'] = '<p>'.$AdvancedContent->lang('notice_duplicatecontent', $this->_contentBlocks[$blockId]['name']).' ('. $hideLink .')</p>'.$this->_contentBlocks[$blockId]['description'];
			}
			
			if($this->_contentBlocks[$blockId]['block_type'] != '' && method_exists($this,'_display_'.$this->_contentBlocks[$blockId]['block_type'].'_block'))
			{
				$this->_contentBlocks[$blockId]['input'] = call_user_func(array($this,'_display_'.$this->_contentBlocks[$blockId]['block_type'].'_block'), $this->_contentBlocks[$blockId], $value, $adding);
			}
			
			if($this->_contentBlocks[$blockId]['block_tab'] != '' || $this->_contentBlocks[$blockId]['block_group'] != '') 
			{
				unset($this->_pageTabs[$tab_id]['content_blocks'][$blockId]);
			}
			if($this->_contentBlocks[$blockId]['block_tab'] != '' && $this->_contentBlocks[$blockId]['block_group'] != '') 
			{
				unset($this->_pageTabs[$tab_id]['block_groups'][$this->_contentBlocks[$blockId]['block_group']]);
			}
		}
		
		$AdvancedContent->smarty->assign('module_id', 'm1_');
		$AdvancedContent->smarty->assign_by_ref('page_tab_nr', $tab);
		$AdvancedContent->smarty->assign_by_ref('page_tab_id', $tab_id);
		$AdvancedContent->smarty->assign_by_ref('page_tabs', $this->_pageTabs);
		$AdvancedContent->smarty->assign_by_ref('block_tabs', $this->_blockTabs);
		$AdvancedContent->smarty->assign_by_ref('block_groups', $this->_blockGroups);
		$AdvancedContent->smarty->assign_by_ref('date_blocks', $this->_dateBlocks);
		$AdvancedContent->smarty->assign_by_ref('content_blocks', $this->_contentBlocks);
		$config = cmsms()->GetConfig();
		if($config['debug']) 
		{
			debug_buffer($this->_pageTabs,'AdvancedContent _pageTabs');
			debug_buffer($this->_blockTabs,'AdvancedContent _blockTabs');
			debug_buffer($this->_blockGroups,'AdvancedContent _blockGroups');
			debug_buffer($this->_contentBlocks,'AdvancedContent _contentBlocks');
			debug_buffer($this->_tabIds,'AdvancedContent _tabIds');
		}
		
		$ret[] = array('', $AdvancedContent->ProcessTemplate('contentType.tpl'));
		return $ret;
	}
	
	private function _display_text_block($blockInfo,$value = '',$adding = false)
	{
		#echo $value."<br />";
		$usewysiwyg = !$this->GetPropertyValue('disable_wysiwyg');
		if(!$usewysiwyg)
		{
			$blockInfo['usewysiwyg'] = false;
		}
		if ($blockInfo['oneline'] == false) 
		{
			return create_textarea($blockInfo['usewysiwyg'], $value, $blockInfo['id'], '', $blockInfo['id'], '', $this->_stylesheet);
		}
		else 
		{
			return '<input type="text"' . ($blockInfo['style'] != ''?'style="' . $blockInfo['style'] . ' "':'') . ($blockInfo['maxlength'] != ''?' maxlength="' . $blockInfo['maxlength'] . ' "':'') . ($blockInfo['size'] != ''?' size="' . $blockInfo['size'] . ' "':'') . ' name="' . $blockInfo['id'] . '" value="' . htmlspecialchars($value) . '" />';
		}
	}
	
	/*
	 * return the HTML to create an image dropdown in the admin console.
	 * does not include a label.
	 * taken from default contenttype (author: Calguy)
	 */
	private function _display_image_block($blockInfo,$value = '',$adding = false)
	{
		$config = cmsms()->GetConfig();
		$dir    = cms_join_path($config['uploads_path'],$blockInfo['dir']);
		$optprefix = 'uploads';
		if( !empty($blockInfo['dir']) ) $optprefix .= '/'.$blockInfo['dir'];
		$inputname = $blockInfo['id'];
		if( isset($blockInfo['inputname']) )
		{
			$inputname = $blockInfo['inputname'];
		}
		$dropdown = create_file_dropdown($inputname,$dir,$value,'jpg,jpeg,png,gif',
			$optprefix,true);
		if( $dropdown === false )
		{
			$dropdown = lang('error_retrieving_file_list');
		}
		return $dropdown;
	}
	
	private function _display_module_block($blockInfo,$value = '',$adding = false)
	{
		$AdvancedContent =& AdvancedContentModule::GetModuleInstance('AdvancedContent');
		if($blockInfo['module'] == '') 
		{
			return $AdvancedContent->lang('error_insufficient_blockparams','module',$blockInfo['name']);
		}
		if( !$module =& $AdvancedContent->GetModuleInstance($blockInfo['module'])) 
		{
			return $AdvancedContent->lang('error_loading_module',$blockInfo['module'],$blockInfo['name']);
		}
		if( !$module->HasCapability('contentblocks') ) 
		{ 
			return $AdvancedContent->lang('error_contentblock_support',$blockInfo['module'],$blockInfo['name']);
		}
		
		return $module->GetContentBlockInput($blockInfo['id'],$value,$blockInfo['params'],$adding);
	}
	
	private function _display_date_block($blockInfo,$value = '',$adding = false)
	{
		if(!$value)
		{
			$value = time();
		}
		
		$date = strftime('%x', intval($value));
		$time = '0:0';
		if($blockInfo['show_clock'])
		{
			$time = strftime('%H:%M', intval($value));
		}
		
		$_tmp        = $this->CleanArray(explode(':',$time));
		$timeSeconds = (($_tmp[0] * 3600) + ($_tmp[1] * 60));
		$dateSeconds = $value - $timeSeconds;
		
		$dateInput = '<img id="'.$blockInfo['id'].'_AdvancedContentDatePickerTrigger" src="../modules/AdvancedContent/images/calendar.png" class="calendarTrigger" />&nbsp;
			<span id="'.$blockInfo['id'].'_AdvancedContentDatePickerDisplay">'.$date.'</span>
			<input id="'.$blockInfo['id'].'_AdvancedContentDate" type="hidden" name="'.$blockInfo['id'].'_AdvancedContentDate" value="'.$dateSeconds.'" />';
			
		$suffix    = '';
		$timeInput = '';
		if($blockInfo['show_clock']) 
		{
			$timeInput = '&nbsp;&nbsp;-&nbsp;&nbsp;<select name="'.$blockInfo['id'].'_AdvancedContentTime">';
			$_i        = 0;
			for($i=$blockInfo['start_hour']; $i<=$blockInfo['end_hour']; $i += $blockInfo['step_hours']) 
			{
				if($i<12 && !$blockInfo['show24h'])
				{
					$suffix = ' am';
				}
				else if(!$blockInfo['show24h'])
				{
					$suffix = ' pm';
				}
				for($j=$blockInfo['start_minute']; $j<=$blockInfo['end_minute']; $j += $blockInfo['step_minutes']) 
				{
					$value = ($i*3600) + ($j*60);
					if(($blockInfo['end_hour'] < 23 && $value <= ($blockInfo['end_hour'] * 3600)) || $blockInfo['end_hour'] == 23)
					{
						$timeInput .= '<option value="'. $value .'"'. ($value == $timeSeconds? ' selected="selected"':'') .'>'. ($i<10?'0'.$i:(!$blockInfo['show24h'] && $i>12?$i-12:$i)) .':'. ($j<10?'0'.$j:$j) . $suffix . '</option>';
					}
				}
				$j = $blockInfo['start_minute'];
			}
			$timeInput .= '</select>';
		}
		
		return $dateInput.$timeInput;
	}
	
	private function _display_checkbox_block($blockInfo,$value = '',$adding = false)
	{
		return '<input type="hidden" name="' . $blockInfo['id'] . '" value="0" />
			<input class="pagecheckbox"' . ($blockInfo['style'] != ''?' style="' . $blockInfo['style'] . ' "':'') . ' type="checkbox" value="1" name="' . $blockInfo['id'] . '"' . ($value == 1 ? ' checked="checked"':'') . ' />';
	}
	
	private function _display_dropdown_block($blockInfo,$value = '',$adding = false)
	{
		$AdvancedContent =& AdvancedContentModule::GetModuleInstance('AdvancedContent');
		$items = array();
		if($blockInfo['items'] != '') 
		{
			foreach(explode($blockInfo['delimiter'], $blockInfo['items']) as $key => $val) 
			{
				$items[$key]['label'] = trim($val);
				if($blockInfo['translate_labels'])
				{
					$items[$key]['label'] = $AdvancedContent->lang($items[$key]['label']);
				}
				
				$items[$key]['value']    = $items[$key]['label'];
				$items[$key]['selected'] = ($value === $val);
			}
		}
		if($blockInfo['values'] != '') 
		{
			foreach(explode($blockInfo['delimiter'], $blockInfo['values']) as $key => $val) 
			{
				$items[$key]['value'] = trim($val);
				if($blockInfo['translate_values'])
				{
					$items[$key]['value'] = $AdvancedContent->lang($items[$key]['value']);
				}
				
				$items[$key]['selected'] = ($value === $items[$key]['value']);
				
				if(!isset($items[$key]['label']))
				{
					$items[$key]['label'] = $items[$key]['value'];
				}
			}
		}
		
		$input = '<select name="' . $blockInfo['id'] . '" ' . ($blockInfo['style'] != ''?'style="' . $blockInfo['style'] . ' "':'') . ' >';
		foreach($items as $item) 
		{
			$input .= '<option value="' . $item['value'] . '"';
			if($item['selected'])
			{
				$input .= ' selected="selected"';
			}
			$input .= '>' . $item['label'] . '</option>';
		}
		$input .= '</select>';
		return $input;
	}
	
	private function _display_select_multiple_block($blockInfo, $value = '',$adding = false)
	{
		$AdvancedContent =& AdvancedContentModule::GetModuleInstance('AdvancedContent');
		$selItems = array();
		foreach(explode($blockInfo['delimiter'], $value) as $key => $val) 
		{
			$selItems[$key] = trim($val);
		}
		$items = array();
		if($blockInfo['items'] != '') 
		{
			foreach(explode($blockInfo['delimiter'], $blockInfo['items']) as $key => $val) 
			{
				$items[$key]['label']    = trim($val);
				if($blockInfo['translate_labels'])
				{
					$items[$key]['label'] = $AdvancedContent->lang($items[$key]['label']);
				}
				
				$items[$key]['value']    = $items[$key]['label'];
				$items[$key]['selected'] = in_array($items[$key]['label'],$selItems);
			}
		}
		if($blockInfo['values'] != '') 
		{
			foreach(explode($blockInfo['delimiter'], $blockInfo['values']) as $key => $val) 
			{
				$items[$key]['value']    = trim($val);
				if($blockInfo['translate_values'])
				{
					$items[$key]['value'] = $AdvancedContent->lang($items[$key]['value']);
				}
				
				$items[$key]['selected'] = in_array($items[$key]['value'],$selItems);
				if(!isset($items[$key]['label']))
				{
					$items[$key]['label'] = $items[$key]['value'];
				}
			}
		}
		
		$input = '
			<input type="hidden" value="" name="' . $blockInfo['id'] . '" />';
		
		if(!$blockInfo['sortable']) 
		{
			$size = count($items);
			if(isset($blockInfo['size']))
			{
				$size = $blockInfo['size'];
			}
			$input .= '
				<select name="' . $blockInfo['id'] . '[]"' . ($blockInfo['style'] != ''?' style="' . $blockInfo['style'] . ' "':'') . '  multiple="multiple" size="'.$size.'">';
			foreach($items as $item) 
			{
				$input .= '<option value="' . $item['value'] . '"';
				if($item['selected'])
				{
					$input .= ' selected="selected"';
				}
				$input .= '>' . $item['label'] . '</option>';
			}
			$input .= '</select>';
		}
		else 
		{
			// sort the items
			$_items = array();
			foreach($selItems as $selKey => $selItem) 
			{
				reset($items);
				foreach($items as $itemKey => $item) 
				{
					if($item['value'] === $selItem) 
					{
						$_items[] = $item;
						unset($items[$itemKey]);
						unset($selItems[$selKey]);
						break;
					}
				}
			}
			
			$items = array_merge($_items,$items);
			$input .= '<div class="sortable_wrapper">';
			foreach($items as $item) 
			{
				$input .= 
				'<div class="sortable">
					<img class="sortable_handler" src="../modules/AdvancedContent/images/sort.png" />
					<input class="pagecheckbox"' . ($blockInfo['style'] != ''?' style="' . $blockInfo['style'] . ' "':'') . ' type="checkbox" value="'.$item['value'].'" name="' . $blockInfo['id'] . '_AdvancedContentSortableItem_' . munge_string_to_url($item['label']) . '"' . ($item['selected']? ' checked="checked"':'') . ' />
					'.$item['label'].'
				</div>';
			}
			$input .= '</div>';
		}
		return $input;
	}
	
	private function _display_multi_input_block($blockInfo, $value = '',$adding = false)
	{
		$AdvancedContent =& AdvancedContentModule::GetModuleInstance('AdvancedContent');
		$input_ids       = $this->CleanArray(explode(',',$blockInfo['inputs']));
		$input_values    = array();
		$multi_input     = '<input type="hidden" value="" name="' . $blockInfo['id'] . '" />';
		foreach(explode($blockInfo['input_delimiter'],$value) as $input_data)
		{
			$input_values[] = explode($blockInfo['value_delimiter'],$input_data);
		}
		foreach($input_ids as $k1=>$input_id)
		{
			if(!isset($this->_multiInputs[$input_id])) 
			{
				$this->_multiInputs = array_merge($this->_multiInputs, $AdvancedContent->GetMultiInputFull($input_ids));
				if(!isset($this->_multiInputs[$input_id]))
				{
					continue;
				}
				$this->_multiInputs[$input_id]['template'] = $AdvancedContent->GetTemplate($this->_multiInputs[$input_id]['tpl_name']);
			}
			
			$pattern = '/{((AdvancedContent|content(_image|_module)?)([^}]*))}/i';
			$matches = array();
			// get all the tags
			$result = preg_match_all($pattern, $this->_multiInputs[$input_id]['input_fields'], $matches);
			
			if ($result && count($matches[1]) > 0) 
			{
				$inputs = array();
				// foreach tag
				foreach ($matches[1] as $k2=>$wholetag) 
				{
					$inputInfo = $this->_get_block_info($wholetag);
					if($inputInfo['block_type'] == 'multi_input')
					{
						continue; // ToDo: display message?
					}
					$this->_multiInputs[$input_id]['elements'][$inputInfo['id']] = $inputInfo['id'];
					$inputInfo['id'] = 'multiInput-' . $blockInfo['id'] . '-' . $k1 . '-' . $inputInfo['id'];
					$inputs[$inputInfo['id']] = $inputInfo;
					if(method_exists($this,'_display_'.$inputInfo['block_type'].'_block'))
					{
						$inputs[$inputInfo['id']]['input'] = call_user_func(array($this, '_display_'.$inputInfo['block_type'].'_block'), $inputInfo, (isset($input_values[$k1][$k2]) ?$input_values[$k1][$k2]:''), $adding);
					}
				}
				$AdvancedContent->smarty->assign_by_ref('inputs', $inputs);
				#$multi_input .= $AdvancedContent->ProcessTemplateFromDataBase($this->_multiInputs[$input_id]['tpl_name']);
				$multi_input .= $AdvancedContent->ProcessTemplateFromData($this->_multiInputs[$input_id]['template']);
			}
		}
		return $multi_input;
	}
	
	private function _display_multi_content_block($blockInfo, $value = '',$adding = false)
	{
		$AdvancedContent      =& AdvancedContentModule::GetModuleInstance('AdvancedContent');
		$multi_content_blocks = $this->CleanArray(explode('<!-- multi_content_delimiter -->',$value));
		$contentBlocks        = array();
		foreach($multi_content_blocks as $tag)
		{
			$_blockInfo = $this->_get_block_info($tag);
			# MLE support
			$_value = $this->GetPropertyValue($_blockInfo['id'] . $this->blockLang);
			if($this->mle && $_value == '' && $this->defaultBlockLang != '' && $this->defaultBlockLang != $this->blockLang) 
			{
				$_value = $this->GetPropertyValue($_blockInfo['id'] . $this->defaultBlockLang);
			}
			#---
			
			if(($adding && $_value == '') 
			|| ($_value == '' && !$_blockInfo['allow_none'])) 
			{
				$_value = $_blockInfo['default_value'];
			}
			
			$_blockInfo['content']            = cms_htmlentities($_value, ENT_NOQUOTES, get_encoding(''));
			$_blockInfo['input']              = $AdvancedContent->lang('invalid_blocktype',$_blockInfo['block_type'],$_blockInfo['name']);
			$contentBlocks[$_blockInfo['id']] = $_blockInfo;
			
			#$this->AddExtraProperty($blockInfo['id']); // ???
			#$this->SetPropertyValue($blockInfo['id'], $_value); // ???
			
			if(method_exists($this,'_display_'.$_blockInfo['block_type'].'_block'))
			{
				// get prop value
				$contentBlocks[$_blockInfo['id']]['input'] = call_user_func(array($this, '_display_'.$_blockInfo['block_type'].'_block'), $_blockInfo, $_value, $adding);
			}
		}
		#$this->mProperties->Load($this->mId); // ???
		
		$AdvancedContent->smarty->assign_by_ref('multi_content_blocks', $contentBlocks);
		$AdvancedContent->smarty->assign('add_content_block', '<a href="#" onclick="AdvancedContent.AddContentBlock(\''.$blockInfo['id'].'\'); return false;">'.
				cmsms()->variables['admintheme']->DisplayImage('icons/system/newobject.gif', '','','','systemicon') . 
				'&nbsp;' . $this->lang('add_content_block') . '</a>');
		
		$AdvancedContent->smarty->assign('remove_content_block', '<a href="#" onclick="AdvancedContent.RemoveContentBlock(\''.$blockInfo['id'].'\'); return false;">'.
				cmsms()->variables['admintheme']->DisplayImage('icons/system/delete.gif', '','','','systemicon') . 
				'&nbsp;' . $this->lang('remove_content_block') . '</a>');
		
		return $AdvancedContent->ProcessTemplate('multiContent.tpl');
	}
	
	function ValidateData() 
	{
		$errors = parent::ValidateData();
		if( $errors === FALSE ) 
		{
			$errors = array();
		}
		
		if ($this->mTemplateId <= 0 ) 
		{
			$errors[] = lang('nofieldgiven', array(lang('template')));
			$result   = false;
		}
		
		#if ($this->GetPropertyValue('content_en') == '') {
		#	$errors[] = lang('nofieldgiven', array(lang('content')));
		#	$result   = false;
		#}
		if (check_permission(get_userid(), 'Manage AdvancedContent Options') && $this->GetPropertyValue('use_expire_date') == '1' && $this->GetPropertyValue('end_date') <= $this->GetPropertyValue('start_date')) 
		{
			$AdvancedContent =& AdvancedContentModule::GetModuleInstance('AdvancedContent');
			$errors[] = $AdvancedContent->lang('error_expiredate');
			$result   = false;
		}
		return (count($errors) > 0?$errors:FALSE);
	}
	
	function ContentPreRender($tplSource) 
	{
		$this->parse_content_blocks('ContentPreRender');
		return $tplSource;
	}
	
	function display_single_element($one, $adding) 
	{
		switch($one) 
		{
			case 'template':
				$templateops =& cmsms()->GetTemplateOperations();
				return array(lang('template') . ':', $templateops->TemplateDropdown('template_id', $this->mTemplateId, 'onchange="document.contentform.submit()"'));
			
			case 'pagemetadata':
				return array(lang('page_metadata') . ':', create_textarea(false, $this->Metadata(), 'metadata', 'pagesmalltextarea', 'metadata', '', '', '80', '6'));
			
			case 'pagedata':
				return array(lang('pagedata_codeblock') . ':', create_textarea(false, $this->GetPropertyValue('pagedata'), 'pagedata', 'pagesmalltextarea', 'pagedata', '', '', '80', '6'));
			
			case 'searchable':
				$searchable = $this->GetPropertyValue('searchable');
				if( $searchable == '' ) 
				{
					$searchable = 1;
				}
				return array(lang('searchable') . ':',
					'<div class="hidden" ><input type="hidden" name="searchable" value="0" /></div>
					<input type="checkbox" name="searchable" value="1" ' . ($searchable == 1?'checked="checked"':'') . ' />');
			
			case 'disable_wysiwyg':
				$disableWysiwyg = $this->GetPropertyValue('disable_wysiwyg');
				if( $disableWysiwyg == '' ) 
				{
					$disableWysiwyg = 0;
				}
				return array(lang('disable_wysiwyg') . ':',
					'<div class="hidden" ><input type="hidden" name="disable_wysiwyg" value="0" /></div>
					<input type="checkbox" name="disable_wysiwyg" value="1"  ' . ($disableWysiwyg == 1?'checked="checked"':'') . ' onclick="this.form.submit()" />');
			
			default:
				if($one != 'feu_access'
				&& $one != 'redirect_page'
				&& $one != 'redirect_params'
				&& $one != 'evaluate_smarty'
				&& $one != 'feu_action'
				&& $one != 'start_date'
				&& $one != 'end_date'
				&& $one != 'use_expire_date')
				{
					return parent::display_single_element($one, $adding);
				}
				break;
		}
	}

/**
 * -----------------------------------------------------------------------------
 * Custom functions
 * -----------------------------------------------------------------------------
 */
	/**
	 * function DisplayAdvancedOptions($adding)
	 * not part of the module api
	 * this is just a wrapper to process a template from data
	 *
	 * @param boolean $adding - true if page is added, false if edited
	 *
	 * @return array - array(array(prompt,imput))
	 */
	private function DisplayAdvancedOptions($adding) 
	{
		$AdvancedContent =& AdvancedContentModule::GetModuleInstance('AdvancedContent');
		$ret = array();
		
		foreach( $this->_attributes as $oneAttrib ) 
		{
			switch($oneAttrib[0]) 
			{
				
				case 'feu_access':
					if($feusers =& AdvancedContentModule::GetModuleInstance('FrontEndUsers')) 
					{
						if($adding)
							$selectedGroups = $this->CleanArray(explode(';',$AdvancedContent->GetPreference('feu_access')));
						else
							$selectedGroups = $this->CleanArray(explode(';', $this->GetPropertyValue('feu_access')));
						
						$feuAccess = array($AdvancedContent->lang('inherit_from_parent')=>-1);
						$feuAccess = array_merge($feuAccess,$feusers->GetGroupList());
						$ret[] = array($AdvancedContent->lang('frontendaccess').' : ', 
							'<input type="hidden" value="" name="feu_access" />'.
							$AdvancedContent->CreateInputSelectList('','feu_access[]',$feuAccess,$selectedGroups,count($feuAccess),'',1));
					}
					break;
				
				case 'redirect_page':
					if($feusers =& AdvancedContentModule::GetModuleInstance('FrontEndUsers')) 
					{
						if($adding)
							$selectedPage = $AdvancedContent->GetPreference('redirect_page','');
						else
							$selectedPage = $this->GetPropertyValue("redirect_page");
						
						$ret[] = array($AdvancedContent->lang('redirectpage').' : ', 
							$AdvancedContent->CreateRedirectDropdown('', 'redirect_page',$selectedPage, $this->mId));
					}
					break;
				
				case 'redirect_params':
					if($feusers =& AdvancedContentModule::GetModuleInstance('FrontEndUsers')) 
					{
						if($adding) 
						{
							$redirectParams = $AdvancedContent->GetPreference('redirect_params','');
							$evaluateSmarty = $AdvancedContent->GetPreference('evaluate_smarty','');
						}
						else 
						{
							$redirectParams = $this->GetPropertyValue("redirect_params");
							$evaluateSmarty = $this->GetPropertyValue("evaluate_smarty");
						}
							
						$ret[] = array($AdvancedContent->lang('redirectparams').' : ', 
							'<input type="text" size="32" maxlength="128" name="redirect_params" value="'.$redirectParams.'" />&nbsp;<em>(param1=value1 param2=value2 ...)</em><br />
							<input type="hidden" name="evaluate_smarty" value="0" />'.
							$AdvancedContent->lang('evaluatesmarty') . ':&nbsp;'.
							'<input type="checkbox" name="evaluate_smarty" value="1"  ' . ($evaluateSmarty == 1?'checked="checked"':'') . ' />');
					}
					break;
				
				case 'feu_action':
					if($feusers =& AdvancedContentModule::GetModuleInstance('FrontEndUsers')) 
					{
						if($adding)
							$feuAction = $AdvancedContent->GetPreference('feu_action','');
						else
							$feuAction = $this->GetPropertyValue('feu_action');
						$ret[] = array($AdvancedContent->lang('showloginform').' : ', 
							$AdvancedContent->CreateInputDropdown('','feu_action',
								array($AdvancedContent->lang('no')=>'',
									$AdvancedContent->lang('inherit_from_parent')=>-1,
									$AdvancedContent->lang('yes')=>1)
								,0,$feuAction));
					}
					break;
				
				case 'start_date':
					$startDate = $this->GetPropertyValue('start_date');
					if(!$startDate)
						$startDate = time();
					
					$date        = strftime('%x', intval($startDate));
					$time        = strftime('%H:%M', intval($startDate));
					
					$_tmp        = $this->CleanArray(explode(':',$time));
					$timeSeconds = (($_tmp[0] * 3600) + ($_tmp[1] * 60));
					$dateSeconds = $startDate - $timeSeconds;
					
					$startDateInput = '
						<img id="AdvancedContentStartDatePickerTrigger" src="../modules/AdvancedContent/images/calendar.png" class="calendarTrigger" />&nbsp;
						<span id="AdvancedContentStartDatePickerDisplay">'.$date.'</span>&nbsp;&nbsp;-&nbsp;&nbsp;
						<input id="AdvancedContentStartDate" type="hidden" name="AdvancedContentStartDate" value="'.$dateSeconds.'" />
						<select name="AdvancedContentStartTime">';
						
					for($i=0; $i<=23; $i++) 
					{
						for($j=0; $j<=59; $j++) 
						{
							$value = ($i*3600) + ($j*60);
							$startDateInput .= '<option value="'. $value .'"'. ($value == $timeSeconds? ' selected="selected"':'') .'>'. ($i<10?'0'.$i:$i) .':'. ($j<10?'0'.$j:$j) .'</option>';
						}
						$j = 0;
					}
					$startDateInput .= '</select>';
					$ret[] = array($AdvancedContent->lang('startdate').' : ', $startDateInput);
					break;
				
				case 'end_date':
					$endDate = $this->GetPropertyValue('end_date');
					if(!$endDate)
						$endDate = time();
					
					$date        = strftime('%x', intval($endDate));
					$time        = strftime('%H:%M', intval($endDate));
					
					$_tmp        = $this->CleanArray(explode(':',$time));
					$timeSeconds = (($_tmp[0] * 3600) + ($_tmp[1] * 60));
					$dateSeconds = $endDate - $timeSeconds;
					
					$endDateInput = '
						<img id="AdvancedContentEndDatePickerTrigger" src="../modules/AdvancedContent/images/calendar.png" class="calendarTrigger" />&nbsp;
						<span id="AdvancedContentEndDatePickerDisplay">'.$date.'</span>&nbsp;&nbsp;-&nbsp;&nbsp;
						<input id="AdvancedContentEndDate" type="hidden" name="AdvancedContentEndDate" value="'.$dateSeconds.'" />
						<select name="AdvancedContentEndTime">';
						
					for($i=0; $i<=23; $i++) 
					{
						for($j=0; $j<=59; $j++) 
						{
							$value = ($i*3600) + ($j*60);
							$endDateInput .= '<option value="'. $value .'"'. ($value == $timeSeconds? ' selected="selected"':'') .'>'. ($i<10?'0'.$i:$i) .':'. ($j<10?'0'.$j:$j) .'</option>';
						}
						$j = 0;
					}
					$endDateInput .= '</select>';
					$ret[] = array($AdvancedContent->lang('enddate').' : ', $endDateInput);
					break;
				
				case 'use_expire_date':
					$useExp = $this->GetPropertyValue('use_expire_date');
					if( $useExp == '' ) 
					{
						$useExp = 0;
					}
					$ret[] = array($AdvancedContent->lang('useexpiredate') . ':',
						'<div class="hidden" ><input type="hidden" name="use_expire_date" value="0" /></div>
						<input type="checkbox" name="use_expire_date" value="1"  ' . ($useExp == 1?'checked="checked"':'') . ' />');
					break;
				
				default:break;
			}
		}
		return $ret;
	}
	
	
	/**
	 * function DoSmarty($data)
	 * not part of the module api
	 * this is just a wrapper to process a template from data
	 *
	 * @param string $data - The template content to process
	 *
	 * @return string - The processed template data
	 */
	function DoSmarty($data) 
	{
		// only process smarty if there is actually something to process
		if(!is_array($data) && !is_object($data) && preg_match_all('/:::([^:]+):::/', $data, $matches)) 
		{
			$AdvancedContent =& AdvancedContentModule::GetModuleInstance('AdvancedContent');
			// TODO: do not use the CMSms internals here!
			// only do this if we did not do this before
			if(version_compare(CMS_VERSION, '1.9-beta1') < 0)
			{
				if(!isset(cmsms()->variables['pageinfo']->content_id)) 
				{
					// fake frontend rendering
					cmsms()->variables['pageinfo']                              = new stdClass();
					cmsms()->variables['pageinfo']->content_id                  = $this->mId;
					cmsms()->variables['pageinfo']->content_title               = $this->mName;
					cmsms()->variables['pageinfo']->content_alias               = $this->mAlias;
					cmsms()->variables['pageinfo']->content_menutext            = $this->mMenuText;
					cmsms()->variables['pageinfo']->content_titleattribute      = $this->mTitleAttribute;
					cmsms()->variables['pageinfo']->content_hierarchy           = $this->mHierarchy;
					cmsms()->variables['pageinfo']->content_id_hierarchy        = $this->mIdHierarchy;
					cmsms()->variables['pageinfo']->content_type                = $this->mType;
					cmsms()->variables['pageinfo']->content_props               = $this->mProperties->mPropertyNames;
					cmsms()->variables['pageinfo']->content_metadata            = $this->mMetadata;
					cmsms()->variables['pageinfo']->content_modified_date       = $this->mModifiedDate;
					cmsms()->variables['pageinfo']->content_created_date        = $this->mCreationDate;
					cmsms()->variables['pageinfo']->content_last_modified_date  = $this->mModifiedDate;
					cmsms()->variables['pageinfo']->content_last_modified_by_id = $this->mOwner;
					cmsms()->variables['pageinfo']->template_id                 = $this->mTemplateId;
					cmsms()->variables['pageinfo']->template_encoding           = get_encoding('');
					cmsms()->variables['pageinfo']->template_modified_date      = time(); // ???
					cmsms()->variables['pageinfo']->cachable                    = $this->mCachable;
					cmsms()->variables['pageinfo']->content_hierarchy_path      = $this->mHierarchyPath;
					
					cmsms()->variables['content_id']                            = $this->mId;
					cmsms()->variables['page']                                  = $this->mAlias;
					cmsms()->variables['page_id']                               = $this->mAlias;
					cmsms()->variables['page_alias']                            = $this->mAlias;
					cmsms()->variables['content_alias']                         = $this->mAlias;
					cmsms()->variables['page_name']                             = $this->mAlias;
					cmsms()->variables['position']                              = $this->mHierarchy;
					cmsms()->variables['friendly_position']                     = ContentOperations::CreateFriendlyHierarchyPosition($this->mHierarchy);
				}
			}
			
			$AdvancedContent->smarty->assign_by_ref('content_obj', $this);
			$AdvancedContent->smarty->assign_by_ref('content_id', $this->mId);
			$AdvancedContent->smarty->assign_by_ref('content_alias', $this->mAlias);
			$AdvancedContent->smarty->assign_by_ref('page', $this->mAlias);
			$AdvancedContent->smarty->assign_by_ref('page_id', $this->mAlias);
			$AdvancedContent->smarty->assign_by_ref('page_alias', $this->mAlias);
			$AdvancedContent->smarty->assign_by_ref('page_name', $this->mAlias);
			$AdvancedContent->smarty->assign_by_ref('position', $this->mHierarchy);
			$AdvancedContent->smarty->assign_by_ref('friendly_position', ContentOperations::CreateFriendlyHierarchyPosition($this->mHierarchy));
			
			$data = $AdvancedContent->ProcessTemplateFromData(preg_replace('/:::([^:]+):::/', '{$1}', $data));
		}
		return $data;
	}
	
	
	/**
	 * function InheritParentProp($parentId, $propName, $currentProp)
	 * not part of the module api
	 * inherits a property of a parent page;
	 * if parent page has also selected inheritance for that property -> do recursion
	 *
	 * @param int $parentId - The id of the parent page
	 * @param string $propName - The name of the property to inherit
	 * @param array $currentProp (optional) - If prop is an array this will be the items of the current page; So return array will contain all items of the current page and parent pages; otherwise only the parents items will be returned
	 *
	 * @return array|string - The prop of the last found parent that has no inheritance or an array of items of all parents that have inheritance
	 */
	function InheritParentProp($parentId, $propName, $currentProp = array()) 
	{
		// default return value
		// feu_access is a special case (because of multiple selections are possible)
		if($propName == 'feu_access') 
		{
			$prop = array();
			
			// this will "merge" the parents prop with the current one
			// but removing the inherit stuff; 
			// so if currentProp is set this will return an array with all props 
			// (real values only; no inherit flag)
			// including the parents ones and the current one but without duplicate values
			foreach($currentProp as $k=>$v) 
			{
				if($v != '-1')
					$prop[] = $v;
			}
		}
		else
			$prop = '';
		
		// as long as page has parents...
		while( $parentId > 0 ) 
		{
			$content = $this->GetContentProp($parentId, $propName, 'content2');
			
			if(!$content)
				return $prop;
			
			$parentId  = $content['parent_id'];
			$propValue = $content['prop_value'];
			
			// feu_access is a special case (because of multiple selections are possible)
			if($propName == 'feu_access') 
			{
				$_prop = $this->CleanArray(explode(";", $propValue));
				
				foreach($_prop as $_p) 
				{
					if(!in_array($_p, $prop) && $_p != '-1' && $_p != '') 
						$prop[] = $_p;
				}
				
				// if the current obj does not inherit its prop anymore OR has no parents 
				// but wants to inherit -> return the prop array
				if(!in_array('-1', $_prop) || ($parentId <= 0 && in_array('-1', $_prop))) 
					return $prop;
				
			}
			else 
			{
				// if content has no parents but wants to inherit -> return
				if($parentId <= 0 && $propValue == '-1') 
				{
					return;
				}
				// if no inheritance anymore -> return the prop
				else if($propertyValue != '-1') 
				{
					return $propValue;
				}
			}
		}
	}
	
	
	/**
	 * function GetContentProp($contentId, $propName, $contentType)
	 * not part of the module api
	 * gets a property of a content page
	 *
	 * @param int $contentId - The id of the content to get the property from
	 * @param string $propName - The name of the property to get the value from
	 * @param string $contentType (optional) - The type of the content
	 *
	 * @return mixed - False if not exists or array('parent_id','prop_value')
	 *
	 */
	function GetContentProp($contentId, $propName, $contentType = '') 
	{
		$db =& cmsms()->GetDb();
		$query = "SELECT CP.content, C.parent_id, C.content_alias FROM " . cms_db_prefix() . "content_props CP 
			LEFT JOIN " . cms_db_prefix() . "content C ON C.content_id = CP.content_id 
			WHERE CP.content_id = ? AND CP.prop_name = ?";
		$p = array($contentId, $propName);
		if($contentType != '') 
		{
			$query .= " AND C.type = ?";
			$p[]    = $contentType;
		}
		$query .= " LIMIT 1";
		$dbresult = $db->Execute($query, $p);
		if($dbresult && $row = $dbresult->FetchRow())
			return array('parent_id'=>$row['parent_id'], 'prop_value'=>$row['content'], 'alias'=>$row['alias']);
		
		return false;
	}
	
	
	/**
	 * function SortContentBlocks()
	 * not part of the module api
	 * simple sorting function
	 * sorts the content blocks by sequence attribute that is given in FillParams()
	 * this is only important for content blocks that are not defined in template
	 */
	function SortContentBlocks() 
	{
		$_contentBlocks = array();
		foreach($this->_contentBlocks as $blockInfo) 
		{
			$_contentBlocks['number_'.$blockInfo['sequence']] = $blockInfo;
		}
		$this->_contentBlocks = array();
		ksort($_contentBlocks);
		reset($_contentBlocks);
		foreach($_contentBlocks as $blockInfo) 
		{
			$this->_contentBlocks[$blockInfo['id']] = $blockInfo;
		}
	}
	
	function GetGroups() 
	{
		$db =& cmsms()->GetDb();
		$groups = array();
		$query = "SELECT group_id FROM ".cms_db_prefix()."user_groups WHERE user_id = ?";
		$dbresult = $db->Execute($query, array(get_userid()));
		while( $dbresult && $row = $dbresult->FetchRow() ) 
		{
			$groups[] = $row['group_id'] * -1;
		}
		return $groups;
	}
	
	private function CheckBlockPermission($blockId) 
	{
		$this->_contentBlocks[$blockId]['addt_editors'] = array();
		// check if user has permission to edit this block
		if(($this->_contentBlocks[$blockId]['editor_users'] != '' || $this->_contentBlocks[$blockId]['editor_groups'] != '') 
		&& !check_permission(get_userid(), 'Manage All AdvancedContent Blocks')) 
		{
			$userops      =& cmsms()->GetUserOperations();
			$groupops     =& cmsms()->GetGroupOperations();
			$allusers     =& $userops->LoadUsers();
			$allgroups    =& $groupops->LoadGroups();
			$editorGroups =  $this->CleanArray(explode(',',$this->_contentBlocks[$blockId]['editor_groups']));
			$editorUsers  =  $this->CleanArray(explode(',',$this->_contentBlocks[$blockId]['editor_users']));
			
			foreach ($allgroups as $oneGroup) 
			{
				if(in_array($oneGroup->name,$editorGroups))
					$this->_contentBlocks[$blockId]['addt_editors'][] = $oneGroup->id*-1;
			}
			
			foreach ($allusers as $oneUser) 
			{
				if(in_array($oneUser->username,$editorUsers))
					$this->_contentBlocks[$blockId]['addt_editors'][] = $oneUser->id;
			}
			
			if(!in_array(get_userid(),$this->_contentBlocks[$blockId]['addt_editors']) 
			&& !count(array_intersect($this->_userGroups,$this->_contentBlocks[$blockId]['addt_editors']))) 
			{
				unset($this->_contentBlocks[$blockId]);
				return false;
			}
		}
		return true;
	}
	
	
	/**
	 * function IsVarEmpty($var, $trim, $unsetEmptyIndexes)
	 * not part of the module api
	 * checks if a var is empty. if var is an array it recursivley checks all elements
	 *
	 * @param mixed $var - the var to check for empty value(s)
	 * @param boolean $trim - true to trim off spaces
	 * @param boolean $unsetEmptyIndexes - true to delete empty elements from array
	 * @return boolean - true if empty, false if not
	 */
	function IsVarEmpty(&$var, $trim = true, $unsetEmptyIndexes = false) 
	{
		if (is_array($var)) 
		{
			foreach ($var as $k=>$v) 
			{
				if (!$this->IsVarEmpty($v)) 
				{
					return false;
				}
				else 
				{
					if($unsetEmptyIndexes)
						unset($var[$k]);
					return true;
				}
			}
		}
		else if($trim && trim($var) == '') 
		{
			return true;
		}
		else if($var == '') 
		{
			return true;
		}
		return false;
	}
	
	
	/**
	 * function CleanArray($array)
	 * not part of the module api
	 * removes empty elements from an array 
	 * (can be useful when using function explode to create the array of a csv)
	 *
	 * @param array $array - the array to clean up
	 * @return array - an array without empty elements or an empty array
	 */
	function CleanArray($array) 
	{
		if (is_array($array)) 
		{
			foreach ($array as $k=>$v) 
			{
				if ($this->IsVarEmpty($v,true,true)) 
				{
					unset($array[$k]);
				}
				else 
				{
					if(is_array($v)) 
					{
						$v = $this->CleanArray($v);
						if($this->IsVarEmpty($v,true,true))
							unset($array[$k]);
						else
							$array[$k] = $v;
					}
				}
			}
			return $array;
		}
		return array();
	}
	
	
	/**
	 * function IsTrue($value)
	 * not part of the module api
	 * checks if a value is literally "true"
	 *
	 * @param mixed $value - the value to check
	 * @return bool
	 */
	function IsTrue($value) 
	{
		return (strtolower($value) === 'true' || $value === 1 || $value === '1' || $value === true);
	}
	
	
	/**
	 * function IsFalse($value)
	 * not part of the module api
	 * checks if a value is literally "false"
	 *
	 * @param mixed $value - the value to check
	 * @return bool
	 */
	function IsFalse($value) 
	{
		return (strtolower($value) === 'false' || $value === '0' || $value === 0 || $value === false || $value === '');
	}
}
?>
