<?php
#-------------------------------------------------------------------------
# Module: plFileHandler
# by Pierre-Luc Germain
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project"s homepage is: http://www.cmsmadesimple.org
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class plFileHandler extends CMSModule {

	private $has_initialized = false;

	function GetName(){					return "plFileHandler";					}
	function GetFriendlyName(){			return $this->Lang("friendlyname");		}
	function GetVersion(){				return "0.4.1";							}
	function GetHelp(){					return $this->Lang("help");				}
	function GetAuthor(){				return "Pierre-Luc Germain (plger)";	}

	function IsPluginModule(){			return false;	}

	function HasAdmin(){				return true;	}
	function GetAdminSection(){			return "extensions";					}
	function GetAdminDescription(){		return $this->Lang("admindescription");	}

	function InstallPostMessage(){		return $this->Lang("postinstall",$this->GetVersion());	}
	function UninstallPostMessage(){	return $this->Lang("postuninstall");	}

	function VisibleToAdminUser(){
		return ($this->CheckPermission("plFileHandler_admin"));
	}
	
	function Install(){
		global $gCms;
		require "method.install.php";
	}

	function Uninstall(){
		$this->DeleteTemplate("",$this->GetName());
		$this->RemovePermission("plFileHandler_admin");
		$this->RemovePermission("plFileHandler_use");
		$this->RemovePreference();
		$this->Audit( 0, $this->Lang("friendlyname"), $this->Lang("uninstalled"));
	}
	
	function SetParameters(){
		$this->CreateParameter("returnInput", "", $this->lang("phelp_returnInput"));
		$this->SetParameterType("returnInput",CLEAN_STRING);		
		$this->CreateParameter("current", "", $this->lang("phelp_current"));
		$this->SetParameterType("current",CLEAN_STRING);					
		$this->CreateParameter("method", "", $this->lang("phelp_method"));
		$this->SetParameterType("method",CLEAN_STRING);		
		$this->CreateParameter("allowedext", "", $this->lang("phelp_allowedext"));
		$this->SetParameterType("allowedext",CLEAN_STRING);		
		$this->CreateParameter("mode", "", $this->lang("phelp_mode"));
		$this->SetParameterType("mode",CLEAN_STRING);
		$this->CreateParameter("noinit", 0, $this->lang("phelp_noinit"));
		$this->SetParameterType("noinit",CLEAN_INT);				
		$this->CreateParameter("resize", "", $this->lang("phelp_resize"));
		$this->SetParameterType("resize",CLEAN_STRING);		
		$this->CreateParameter("crop", 0, $this->lang("phelp_crop"));
		$this->SetParameterType("crop",CLEAN_INT);				
		$this->CreateParameter("curdir", "", $this->lang("phelp_curdir"));
		$this->SetParameterType("curdir",CLEAN_STRING);		
		$this->CreateParameter("startdir", "", $this->lang("phelp_startdir"));
		$this->SetParameterType("startdir",CLEAN_STRING);		
		$this->CreateParameter("multiple", "", $this->lang("phelp_multiple"));
		$this->SetParameterType("multiple",CLEAN_INT);						
		$this->CreateParameter("width", "", $this->lang("phelp_width"));
		$this->SetParameterType("width",CLEAN_INT);		
		$this->CreateParameter("height", "", $this->lang("phelp_height"));
		$this->SetParameterType("height",CLEAN_INT);	
		$this->SetParameterType("baseurl",CLEAN_STRING);
		
	}
	
	function getFileContent($filename){
		// returns the content of a local file (mostly for templates)
		$filepath = dirname(__FILE__).DIRECTORY_SEPARATOR.$filename;
		if(is_readable($filepath)){
			$fhandle = fopen($filepath, 'r');
			$content = fread($fhandle, filesize($filepath));
			fclose($fhandle);
			return $content;
		}else{
			return false;
		}
	}

	function getSettings(){
		// returns preferences
		// array of array(pref_name, pref_type, default_value)
		$settings = array(
			array( "default_allowed", "text", "" ),
			array( "default_multiple", "checkbox", false ),
			array( "default_imagemode", "checkbox", true ),
			array( "default_popup_width", "number", 480 ),
			array( "default_popup_height", "number", 400 ),
			array( "clean_names", "checkbox", true ),
			array( "absolute_paths", "checkbox", false),
			array( "resize_existing", "checkbox", false ),
			array( "resize_existing_replace", "checkbox", false ),
			array( "default_crop", "checkbox", false ),
			array( "hide_thumbs", "checkbox", true ),
			array( "filename_limit", "number", 20 ),
			array( "allow_filedelete", "checkbox", true ),
			array( "create_thumbnails", "checkbox", true ),
			array( "allow_frontend", "checkbox", false),
			array( "feu_frontend", "checkbox", false)
		);
		return $settings;
	}
	
	function CheckAccess(){
		if($this->CheckPermission('plFileHandler_use')){
			return true;
		}elseif($this->GetPreference('allow_frontend', false)){
			if($this->GetPreference('feu_frontend', false)){
				$FEU = $this->GetModuleInstance('FrontEndUsers');
				return ($FEU && $FEU->LoggedIn());
			}else{
				return true;
			}
		}
		return false;
	}

	function DoAction($action, $id, $params, $returnid=-1){
		global $gCms;
		
		switch($action){
			case "edittemplate":
				require "action.edittemplate.php";
				break;
			case "defaultadmin":
				require "action.defaultadmin.php";
				break;
			case "default":
			default:
				return $this->DisplayInputs($params);
				break;
		}
	}
	
	function DisplayInputs($params){
		global $gCms;
		$output = false;
		require "action.default.php";
		return $output;
	}

	function GetReturnScript($close=true){
		return '
<script type="text/javascript">
function plFileHandler_return(returnValue, pictoshow){
	if(parent && parent.plFileHandler){
		parent.plFileHandler.do_return(returnValue, pictoshow);
	}else{
		if(plFileHandler)	plFileHandler.do_return(returnValue, pictoshow);
	}
}
'.($close?'</script>
':'');
	}




/*
 * FUNCTIONS THAT MIGHT BE USEFUL FOR OTHER MODULES TOO...
 */

	function GetFileInfo($filepath){
		// returns a bunch of informations about a file, such as size (and formatted size), image dimensions, modified date and such...
		// see function.GetFileInfo.php
		require "function.GetFileInfo.php";
		return $info;
	}

	function GetFileInfoByUrl($fileurl){
		return $this->GetFileInfo($this->get_path_from_url($fileurl));
	}

	function plResize($fullpath, $newpath, $newwidth, $newheight=false, $transparency=false, $crop=false){
		// creates (in $newpath) a version of $fullpath resized to $newwidth x $newheight
		// set $transparency to true if you want it saved
		// set $crop to true if you want to crop images that have different proportions than those specified (crop is centered)
		require "function.plresize.php";
		return $return;
	}
	
	function clean_file_name($filename){
		// returns a clean version of the file name (without spaces or weird letters)
		$extension = strtolower(strrchr($filename, "."));
		$filename = str_replace('-','_',munge_string_to_url(substr($filename,0,strlen($filename)-strlen($extension))));
		return $filename.$extension;
	}
	
	function get_path_from_url($url){
		// transform $url into a local path
		global $gCms;
		$path = $gCms->config['uploads_path'].str_replace($gCms->config['uploads_url'], '', $url);
		$path = str_replace('/',DIRECTORY_SEPARATOR, $path);
		return str_replace(DIRECTORY_SEPARATOR.DIRECTORY_SEPARATOR,DIRECTORY_SEPARATOR, $path);
	}
	
	function get_url_from_path($path){
		// transform $path into a url
		global $gCms;
		$path = str_replace(DIRECTORY_SEPARATOR.DIRECTORY_SEPARATOR,DIRECTORY_SEPARATOR, $path);		
		$url = $gCms->config['uploads_url'].str_replace($gCms->config['uploads_path'], '', $path);
		return str_replace(DIRECTORY_SEPARATOR,'/', $url);
	}
	
	function iterate_to_unique($filepath){
		// if a file of that name exists, appends number to the filename until none with that name exist
		$extension = strrchr($filepath, ".");
		$cleanfilename = str_replace($extension, "", $filepath);

		$i = 1;
		while(file_exists($filepath)){
			$filepath = $cleanfilename."_".$i.$extension;
			$i++;
		}
		return $filepath;
	}
	
	function getImage($path){
		// returns image object from $path
		if(!file_exists($path))	return false;
		$ext = strtolower(substr(strrchr($path, "."), 1));
		$img = false;
		if($ext=="jpeg" || $ext=="jpg"){
			$img = @imagecreatefromjpeg($path);
		} elseif($ext=="png"){
			$img = @imagecreatefrompng($path);
		} elseif($ext=="gif") {
			$img = @imagecreatefromgif($path);
		}
		return $img;
	}

	function saveImage($imgobj, $path, $jpegcomp=80){
		// saves image object to $path
		$ext = strtolower(substr(strrchr($path, "."), 1));
		if($ext=="jpeg" || $ext=="jpg"){
			$jpegcomp = (int) $jpegcomp;
			if(!imagejpeg($imgobj, $path, $jpegcomp))	return false;
		}elseif($ext=="png"){
			if(!imagepng($imgobj, $path))	return false;
		}elseif($ext=="gif"){
			if(!imagegif($imgobj, $path))	return false;
		}else{
			return false;
		}
		return $path;
	}
	
	function watermark($wm_path, $img_path, $dest_path='', $margin=5, $alpha=100, $position='bottom right'){
		// adds a watermark ($wm_path) to the $img_path image and saves it to $dest_path (if specified)
		// watermark is positionned according to $position, with a margin of $margin pixels and an opacity of $alpha
		// Possible positions: combinations of bottom/top left/right
		require 'function.watermark.php';
		return $return;
	}	
	
	function GetFileIcon($filename, $small=false){
		// returns an icon url that matches the file type
		// icons come from nuoveXT.2.2 Gnome icon set
		global $gCms;
		$extension = strtolower(substr(strrchr($filename, "."), 1));
		if($extension == 'pdf'){
			$icon = 'pdf';
		}elseif(in_array($extension, array('txt','asc','ascii','nfo','msg'))){
			$icon = 'text';
		}elseif(in_array($extension, array('exe','bat','sh'))){
			$icon = 'application';
		}elseif(in_array($extension, array('flv','wma','wmv','mp3','wav','midi'))){
			$icon = 'media';
		}elseif(in_array($extension, array('swf','html','htm','shtml','js','xml','css','cfm'))){
			$icon = 'html';
		}elseif(in_array($extension, array('doc','docx','xls','xlsx','ppt','odt','ods','rtf','dot','email','latex','tex','wpd'))){
			$icon = 'document';
		}elseif(in_array($extension, array('jpg','jpeg','gif','png','bmp','tiff','psd','xcf'))){
			$icon = 'image';
		}elseif(in_array($extension, array('zip','tar','jar','7zip','rar','ace','arc','arj','z','sit','bz2','tgz','gz','lha','lzh','deb','rpm'))){
			$icon = 'archive';
		}elseif(in_array($extension, array('ttf','abf','afm','dfont','eot','fi','fnt','fon','font','fot','gdr','gsf','tfm'))){
			$icon = 'font';
		}elseif(in_array($extension, array('docm','php','asp','java'))){
			$icon = 'script';
		}else{
			$icon = 'file';
		}
		return $gCms->config['root_url'].'/modules/plFileHandler/images/'.$icon.($small?'_small':'').'.png';
	}
	

}

?>
