<?php
require "class.plFileHandler_file.php";
require "functions.select.php";

$params = array_merge($_GET, $_POST);

require '../../include.php';

if(!isset($gCms->modules['plFileHandler']) || !$gCms->modules['plFileHandler']['active'])	exit('Could not find module');
$module = $gCms->modules['plFileHandler']['object'];

if(!$module->CheckAccess())	exit('Permission denied. Ask your administrator for the "plFileHandler: usage" permission.');

if(isset($params['lang']))	$params['lang'] = $str_replace('"','',$params['lang']);
if(isset($params['lang']) && file_exists('lang'.DIRECTORY_SEPARATOR.$params['lang'].'.php')){
	require 'lang'.DIRECTORY_SEPARATOR.$params['lang'].'.php';
}elseif(isset($params['lang']) && file_exists('lang'.DIRECTORY_SEPARATOR.'ext'.DIRECTORY_SEPARATOR.$params['lang'].'.php')){
	require 'lang'.DIRECTORY_SEPARATOR.'ext'.DIRECTORY_SEPARATOR.$params['lang'].'.php';
}else{
	if(isset($params['lang']))	unset($params['lang']);
	require 'lang/en_US.php';
}
function fhlang($string){
	global $lang;
	return isset($lang[$string])?$lang[$string]:'';
}


$crop = false;
$resize = false;
if(isset($params['resize'])){
	$resize = explode('x',$params['resize']);
	if(count($resize)==2 && $resize[0] > 0 && $resize[1] > 0){
		$crop = isset($params['crop'])?$params['crop']:$module->GetPreference('default_crop',false);
	}
}


$imgext = array('jpeg','jpg','png','gif');
$allowedext = isset($params['allowedext'])?$params['allowedext']:$module->GetPreference('default_allowed','');
if($allowedext && $allowedext != ''){
	$allowedext = array();
	foreach(explode(',',$params['allowedext']) as $ext){
		if($resize){
			if(in_array($ext, $imgext))	array_push($allowedext, strtolower(trim($ext)));
		}else{
			array_push($allowedext, strtolower(trim($ext)));
		}
	}
}elseif($resize){
	$allowedext = $imgext;
}else{
	$allowedext = false;
}

$absolute_paths = $module->GetPreference('absolute_paths',false);
$clean_names = $module->GetPreference('clean_names',true);
$allowmultiple = isset($params['multiple'])?$params['multiple']:$module->GetPreference('default_multiple',false);

/* PROCESS FILES */
$errors = '';
$firstpath = false;
$uploaded = array();
if(isset($params['upload_checker'])){
	foreach($_FILES as $fieldname=>$file){
		if(isset($file['name']) && $file['name'] != ""){
			$extension = strtolower(substr(strrchr($file['name'], "."),1));
			if( !$allowedext || in_array($extension, $allowedext) ){
				$filename = $file['name'];
				if($clean_names)	$filename = $module->clean_file_name($filename);
				$startdir = (isset($params['startdir'])?rtrim($params['startdir'],'/').'/':'');
				$filepath = clean_join_path($gCms->config['uploads_path'].'/'.$startdir.$filename);
				$filepath = $module->iterate_to_unique($filepath);
				if(cms_move_uploaded_file($file["tmp_name"], $filepath)){
					if(!$firstpath)	$firstpath = $filepath;
					if($resize)	$module->plResize($filepath, $filepath, $resize[0], $resize[1], true, $crop);
					$thumbpath = str_replace($filename, 'thumb_'.$filename, $filepath);
					$module->plResize($filepath, $thumbpath, 96, 96, true, false);
					$fileUrl = clean_join_url( ($absolute_paths?$gCms->config['uploads_url'].'/':'').$startdir.$filename);
					array_push($uploaded, clean_join_url($fileUrl));
				}else{
					$errors .= "<li>".$filepath.': '.fhlang('error_couldnotupload')."</li>";
				}
			}else{
				$errors = '<li>'.$file['name'].': '.fhlang('error_wrongfiletype').'</li>';
			}
		}
	}
}

if($errors != ''){
	$message = '<ul>'.$errors.'</ul>';
}elseif(count($uploaded)>0){
	$message = fhlang('message_successful');
}
$module->smarty->assign("message",isset($message)?$message:false);

if(count($uploaded) == 0){

	/* DISPLAY FORM */

	$javascript = '<script type="text/javascript">
	function show_loading(){
		var loadobj = document.getElementById("loading");
		if(loadobj)		loadobj.style.display = "block";
		var submitbtn = document.getElementById("uploadsubmit");
		if(submitbtn)	submitbtn.style.display = "none";
	}
';
	if($allowmultiple)	$javascript .= '
	var fh_nbfileinput = 1;

	function fh_addfileinput(btn){
		if(!btn.parentNode)	return false;
		var container = btn.parentNode.parentNode.getElementsByTagName("div")[0];
		if(!container) return false;
		nbfileinput++;
		var tmpinput = document.createElement("input");
		tmpinput.type = "file";
		tmpinput.name = "uploadfile"+nbfileinput;
		var thep = document.createElement("p");
		thep.appendChild(tmpinput);
		container.appendChild(thep);
		if(nbfileinput == 12)	btn.style.display = false;
		return false;
	}';
	
	$javascript .= '
	</script>';
	
	$addinput = $allowmultiple?'<a style="cursor: pointer;" onclick="fh_addfileinput(this);">'.fhlang('addfileinput').'</a>':false;

	$module->smarty->assign("title",fhlang('prompt_upload'));
	$module->smarty->assign("allowmultiple",$allowmultiple);
	$module->smarty->assign("postmaxsize", fhlang('postmaxsize').ini_get('post_max_size'));
	$module->smarty->assign("javascript",$javascript);
	$module->smarty->assign("formstart",'<form action="bg_upload.php" method="POST" onsubmit="show_loading();" enctype="multipart/form-data">');
	$module->smarty->assign("fileinput",'<div><p><input type="file" name="uploadfile1"/></p></div>');
	$module->smarty->assign("addinput",$addinput);
	$module->smarty->assign("loading", '<div id="loading" style="display: none;"><img src="'.clean_join_url($gCms->config['root_url'].'/modules/plFileHandler/images/ajax-loader.gif').'" alt=""/> '.fhlang('loading').'</div>');
	$module->smarty->assign("submit",'<input type="submit" name="uploadsubmit" id="uploadsubmit" value="'.fhlang('uploadsubmit').'"/>');
	
	$formend = '';
	foreach($params as $key=>$value)	$formend .= '<input type="hidden" name="'.$key.'" value="'.$value.'"/>';
	$formend .= '<input type="hidden" name="upload_checker" value="1"/>';
	if(isset($params['lang']))	$formend .= '<input type="hidden" name="lang" value="'.$params['lang'].'"/>';
	$module->smarty->assign("formend",$formend.'</form>');

	echo $module->ProcessTemplateFromDatabase('upload');

}elseif($errors == ''){
	// all files were uploaded
	$obj = new plFileHandler_file($firstpath, $uploaded[0], false);
	if(!$absolute_paths)	$obj->url_prefix = $gCms->config['uploads_url'].'/';
	$content = $module->GetReturnScript(false).'
plFileHandler_return("'.implode(',',$uploaded).'","'.$obj->GetPic(false).'");
</script>';
	$module->smarty->assign("content", $content);
	echo $module->ProcessTemplateFromDatabase('minimal');
	
}else{

	// files were partially uploaded
	$obj = new plFileHandler_file($firstpath, $uploaded[0], false);
	$content = $module->GetReturnScript().'
<a style="cursor: pointer;" onclick="plFileHandler_return("'.implode(',',$uploaded).'","'.$obj->GetPic(false).'");">'.fhlang('partial_proceed').'<a>';	
	$module->smarty->assign("content", $content);
	echo $module->ProcessTemplateFromDatabase('minimal');
	
}
