<?php

	/*
		This class aim to handle CMS Forms very differently.
		
		Author: Jean-Christophe Cuvelier <cybertotophe@gmail.com>
		Copyrights: Jean-Christophe Cuvelier - Morris & Chapman Belgium - 2010
		Licence: GPL		
	
	*/

class CMSForm	extends	CmsObject
{
	
	protected $module_name;
	protected $id; // The form ID
	protected $returnid;
	protected $action;	
	protected $method = 'get';
	protected $enctype;
	
	protected $widgets = array(); // The form widgets
	protected $hidden_widgets = array(); // Specific widgets shown on the begin;
	protected $fieldsets = array(); // Sub forms for fieldsets
	
	protected $labels = array(
		'submit' => 'Submit',
		'apply' => 'Apply',
		'cancel' => 'Cancel',
		'next' => 'Next',
		'previous' => 'Previous'
		);
		
	protected $active_buttons = array('submit','cancel');
	protected $form_errors = array(); 
	protected $show_priority = false;
	
	protected $templates = array(
		'widget' => '<div class="pageoverflow">
			<div class="pagetext">%LABEL%:</div>
			<div class="pageinput">%INPUT% <em>%TIPS%</em></div>
			<div class="pageinput" style="color: red;">%ERRORS%</div>
		</div>',
		'errors' => '<div style="color: red;">%ERRORS%</div>',
		'buttons' => '<p>%BUTTONS%</p>'
		);
	
	public function __construct($module_name, $id, $action, $returnid)
	{
		$this->module_name = $module_name;
		$this->id = $id;
		$this->returnid = $returnid;
		$this->action = $action;
	}
	
	public function setMultipartForm()
	{
		$this->method = 'post';
		$this->enctype = 'multipart/form-data';
	}
	
	public function process()
	{
		foreach($this->widgets as $widget)
		{
			$widget->process();
		}
		
		foreach($this->hidden_widgets as $widget)
		{
			$widget->process();
		}		
		
		foreach($this->fieldsets as $fieldset)
		{
			$fieldset->process();
		}
	}
	
	public function render()
	{
		// TODO
	}
	
	public function setTemplate($template_name, $template)
	{
		$this->templates[$template_name] = $template;
	}
	
	public function getHeaders()
	{
		global $gCms;
		if (isset($gCms->modules[$this->module_name]['object']))
		{			
			$html = $gCms->modules[$this->module_name]['object']->CreateFormStart($this->id, $this->action, $this->returnid, $this->method, $this->enctype);
			foreach($this->hidden_widgets as $widget)
			{
				$html .= $widget;
			}			
			return $html;
		}
		return null;
	}
	
	public function getFooters()
	{
		global $gCms;
		if (isset($gCms->modules[$this->module_name]['object']))
		{			
			$html = $gCms->modules[$this->module_name]['object']->CreateFormEnd();
			return $html;
		}
		return null;
	}
	
	public function setLabel($label, $title)
	{
		$this->labels[$label] = $title;
	}
	
	
	public function setButtons($buttons = array())
	{
		if (is_array($buttons))	$this->active_buttons = $buttons;
	}
	
	public function getButtons()
	{
		global $gCms;
		$html = '';
		foreach($this->active_buttons as $button)
		{
			$html .= $gCms->modules[$this->module_name]['object']->CreateInputSubmit($this->id, $button, $this->labels[$button]);
		}
		
		return $html;
	}
	
	public function setWidget($name,$type,$settings = array())
	{
		$widget = new CMSFormWidget(&$this,$this->id,$this->module_name,$name,$type,$settings);
		if ($type == 'hidden')
		{
			$this->hidden_widgets[$name] = $widget;
		}
		elseif ($type == 'file')
		{
			$this->setMultipartForm(); // If we add files, we have to be posted multipart forms...
			$this->widgets[$name] = $widget;
		}
		else
		{
			$this->widgets[$name] = $widget;
		}
	}
	
	public function getWidgets()
	{
		return $this->widgets;
	}
	
	public function getWidget($name)
	{
		if (isset($this->widgets[$name]))
		{
			return $this->widgets[$name];
		}
		elseif (isset($this->hidden_widgets[$name]))
		{
			return $this->hidden_widgets[$name];
		}
		else
		{
			return null;
		}
	}
	
	public function showWidgets($template=null)
	{
		$html = '';
		foreach($this->widgets as $widget)
		{
			$html .= $widget->show($template);
		}
		return $html;
	}
	
	public function hasErrors()
	{
		$has_errors = false;
		
		foreach($this->widgets as $widget)
		{
			if($widget->hasErrors())
			{
				$has_errors = true;
			}
		}
		
		foreach($this->hidden_widgets as $widget)
		{
			if($widget->hasErrors())
			{
				$has_errors = true;
			}
		}
		
		foreach($this->fieldsets as $fieldset)
		{
			if($fieldset->hasErrors())
			{
				$has_errors = true;
			}
		}
		
		if (count($this->form_errors) != 0)
		{
			$has_errors = true;
		}
		
		return $has_errors; 
	}
	
	public function noError()
	{
		return !$this->hasErrors();
	}
	
	public function getErrors()
	{
		return $this->form_errors;
	}
	
	public function showErrors()
	{
		$html = '';
		if(count($this->form_errors) > 0)
		{
			$html .= '<ul class="errors">';
			foreach($this->form_errors as $priority => $errors)
			{
				$html .= '<li>';
				if ($this->show_priority)	$html .= '<em class="form_error_priority">'.$priority.'</em>';
				$html .= '<ul>';
				foreach($errors as $error)
				{
					$html .= '<li>'.$error.'</li>';
				}				
				$html .= '</ul></li>';
			}
			$html .= '</ul>';
		}
		return $html;
	}
	
	public function setError($message,$priority='default')
	{
		$this->form_errors[$priority][] = $message;
	}
	
	public function isSubmitted()
	{
		if (isset($_REQUEST[$this->id.'submit']))
		{
			return true;
		}
		return false;
	}
	
	public function isApplied()
	{
		if (isset($_REQUEST[$this->id.'apply']))
		{
			return true;
		}
		return false;
	}	
	
	public function isCancelled()
	{
		if (isset($_REQUEST[$this->id.'cancel']))
		{
			return true;
		}
		return false;
	}

	public function isPosted()
	{
		// Add check for next and previous
		if ($this->isSubmitted() || $this->isApplied())
		{
			return true;
		}
		return false;
	}
	
	public function setFieldset($legend)
	{
		$this->fieldsets[$legend] = new CMSFormFieldset($this,$legend);
	}
	
	public function getFieldset($legend)
	{
		if (isset($this->fieldsets[$legend]))
		{
			return $this->fieldsets[$legend];
		}
		return null;
	}
	
	public function renderFieldsets($widget_template = null)
	{
		$html = '';
		foreach($this->fieldsets as $fieldset)
		{
			$html .= $fieldset->render($widget_template);
		}
		return $html;
	}
	
}

class CMSFormFieldset extends CMSForm
{
	protected $legend;
	
	public function __construct(&$form, $legend)
	{
		parent::__construct($form->module_name, $form->id, $form->action, $form->returnid);
		$this->legend = $legend;
	}
	
	public function render($widget_template=null)
	{
		$html = '<fieldset><legend>'.$this->legend.'</legend>';
		$html .= $this->showWidgets($widget_template);
		$html .= '</fieldset>';
		return $html;
	}
	
}
